/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.request;

import java.io.IOException;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class AbstractOssIndexRequest {
    List<Proxy> proxies = new LinkedList<Proxy>();
    private static String SCHEME;
    private static String HOST;
    private static String VERSION;
    private static String BASE_URL;
    private static int PROXY_SOCKET_TIMEOUT;
    private static int PROXY_CONNECT_TIMEOUT;
    private static int PROXY_CONNECTION_REQUEST_TIMEOUT;
    private static final String USER;
    private static final String TOKEN;

    protected String performPostRequest(String requestString, String data) throws IOException {
        HttpPost request = new HttpPost(this.getBaseUrl() + requestString);
        String json = null;
        System.err.println("POST REQUEST: " + this.proxies);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        if (this.proxies.size() > 0) {
            Proxy myProxy = this.proxies.get(0);
            HttpHost proxy = myProxy.getHttpHost();
            System.err.println("Using proxy: " + proxy);
            RequestConfig config = RequestConfig.custom().setProxy(proxy).setSocketTimeout(myProxy.getProxySocketTimeout()).setConnectTimeout(myProxy.getProxyConnectTimeout()).setConnectionRequestTimeout(myProxy.getProxyConnectionRequestTimeout()).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
            request.setConfig(config);
        }
        try {
            request.setEntity((HttpEntity)new StringEntity(data));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            int code = response.getStatusLine().getStatusCode();
            if (code < 200 || code > 299) {
                throw new ConnectException(response.getStatusLine().getReasonPhrase() + " (" + code + ")");
            }
            json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        finally {
            httpClient.close();
        }
        return json;
    }

    protected String performGetRequest(String requestString) throws IOException {
        HttpGet request = new HttpGet(this.getBaseUrl() + requestString);
        if (USER != null && !USER.isEmpty()) {
            request.setHeader("Authorization", USER + ":" + TOKEN);
        }
        String json = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            int code = response.getStatusLine().getStatusCode();
            if (code < 200 || code > 299) {
                throw new ConnectException(response.getStatusLine().getReasonPhrase() + " (" + code + ")");
            }
            json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        return json;
    }

    private String getBaseUrl() {
        return BASE_URL;
    }

    public void addProxy(String protocol, String host, int port, String username, String password) {
        Proxy proxy = new Proxy(protocol, host, port, username, password);
        this.proxies.add(proxy);
    }

    public void addProxy(String protocol, String host, int port, String username, String password, int socketTimeout, int connectTimeout, int connectionRequestTimeout) {
        Proxy proxy = new Proxy(protocol, host, port, username, password, socketTimeout, connectTimeout, connectionRequestTimeout);
        this.proxies.add(proxy);
    }

    static /* synthetic */ int access$000() {
        return PROXY_SOCKET_TIMEOUT;
    }

    static /* synthetic */ int access$100() {
        return PROXY_CONNECT_TIMEOUT;
    }

    static /* synthetic */ int access$200() {
        return PROXY_CONNECTION_REQUEST_TIMEOUT;
    }

    static {
        String version;
        String host;
        SCHEME = "https";
        HOST = "ossindex.net";
        VERSION = "v2.0";
        BASE_URL = SCHEME + "://" + HOST + "/" + VERSION + "/";
        String scheme = System.getProperty("OSSINDEX_SCHEME");
        if (scheme != null && !scheme.trim().isEmpty()) {
            SCHEME = scheme.trim();
        }
        if ((host = System.getProperty("OSSINDEX_HOST")) != null && !host.trim().isEmpty()) {
            HOST = host.trim();
        }
        if ((version = System.getProperty("OSSINDEX_VERSION")) != null && !version.trim().isEmpty()) {
            VERSION = version.trim();
        }
        BASE_URL = SCHEME + "://" + HOST + "/" + VERSION + "/";
        PROXY_SOCKET_TIMEOUT = 60000;
        PROXY_CONNECT_TIMEOUT = 10000;
        PROXY_CONNECTION_REQUEST_TIMEOUT = 10000;
        String tmp = System.getenv("OSSINDEX_PROXY_SOCKET_TIMEOUT");
        if (tmp != null && !tmp.trim().isEmpty()) {
            PROXY_SOCKET_TIMEOUT = Integer.parseInt(tmp.trim());
        }
        if ((tmp = System.getenv("OSSINDEX_PROXY_CONNECT_TIMEOUT")) != null && !tmp.trim().isEmpty()) {
            PROXY_CONNECT_TIMEOUT = Integer.parseInt(tmp.trim());
        }
        if ((tmp = System.getenv("OSSINDEX_PROXY_CONNECTION_REQUEST_TIMEOUT")) != null && !tmp.trim().isEmpty()) {
            PROXY_CONNECTION_REQUEST_TIMEOUT = Integer.parseInt(tmp.trim());
        }
        if ((tmp = System.getProperty("OSSINDEX_PROXY_SOCKET_TIMEOUT")) != null && !tmp.trim().isEmpty()) {
            PROXY_SOCKET_TIMEOUT = Integer.parseInt(tmp.trim());
        }
        if ((tmp = System.getProperty("OSSINDEX_PROXY_CONNECT_TIMEOUT")) != null && !tmp.trim().isEmpty()) {
            PROXY_CONNECT_TIMEOUT = Integer.parseInt(tmp.trim());
        }
        if ((tmp = System.getProperty("OSSINDEX_PROXY_CONNECTION_REQUEST_TIMEOUT")) != null && !tmp.trim().isEmpty()) {
            PROXY_CONNECTION_REQUEST_TIMEOUT = Integer.parseInt(tmp.trim());
        }
        USER = System.getProperty("OSSINDEX_USER");
        TOKEN = System.getProperty("OSSINDEX_TOKEN");
    }

    class Proxy {
        private String protocol;
        private String host;
        private int port;
        private String username;
        private String password;
        private int proxySocketTimeout = AbstractOssIndexRequest.access$000();
        private int proxyConnectTimeout = AbstractOssIndexRequest.access$100();
        private int proxyConnectionRequestTimeout = AbstractOssIndexRequest.access$200();

        public Proxy(String protocol, String host, int port, String username, String password) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
        }

        public int getProxyConnectionRequestTimeout() {
            return this.proxyConnectionRequestTimeout;
        }

        public int getProxyConnectTimeout() {
            return this.proxyConnectTimeout;
        }

        public int getProxySocketTimeout() {
            return this.proxySocketTimeout;
        }

        public Proxy(String protocol, String host, int port, String username, String password, int socketTimeout, int connectTimeout, int connectionRequestTimeout) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
            this.proxySocketTimeout = socketTimeout;
            this.proxyConnectTimeout = connectTimeout;
            this.proxyConnectionRequestTimeout = connectionRequestTimeout;
        }

        public HttpHost getHttpHost() {
            return new HttpHost(this.host, this.port, this.protocol);
        }
    }
}

