/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.service.manage.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.vod.v1.config.VodGlobalConfig;
import net.polyv.vod.v1.constant.VodURL;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoExamLogRequest;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoExamLogResponse;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoExamRequest;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoExamResponse;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoFirstImageRequest;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoPlayStatusRequest;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoPreviewDurationRequest;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoRequest;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoResponse;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoSizeRequest;
import net.polyv.vod.v1.entity.manage.info.VodGetVideoSizeResponse;
import net.polyv.vod.v1.entity.manage.info.VodGetVideosPlayTimesRequest;
import net.polyv.vod.v1.entity.manage.info.VodGetVideosPlayTimesResponse;
import net.polyv.vod.v1.entity.manage.info.VodGetVideosSizeRequest;
import net.polyv.vod.v1.entity.manage.info.VodGetVideosSizeResponse;
import net.polyv.vod.v1.entity.manage.info.VodGetWeChatShareVideoInfoRequest;
import net.polyv.vod.v1.entity.manage.info.VodGetWeChatShareVideoInfoResponse;
import net.polyv.vod.v1.entity.manage.info.VodListVideoKeyFrameRequest;
import net.polyv.vod.v1.entity.manage.info.VodListVideoKeyFrameResponse;
import net.polyv.vod.v1.entity.manage.info.VodQueryVideoPasswordRequest;
import net.polyv.vod.v1.entity.manage.info.VodQueryVideoPasswordResponse;
import net.polyv.vod.v1.entity.manage.info.VodQueryVideoPasswordVO;
import net.polyv.vod.v1.service.VodBaseService;
import net.polyv.vod.v1.service.manage.IVodInfoService;

public class VodInfoServiceImpl
extends VodBaseService
implements IVodInfoService {
    @Override
    public VodListVideoKeyFrameResponse listVideoKeyFrame(VodListVideoKeyFrameRequest vodListVideoKeyFrameRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/keyframe/%s", VodGlobalConfig.getUserId(), vodListVideoKeyFrameRequest.getVideoId());
        return super.getReturnOne(url, vodListVideoKeyFrameRequest, VodListVideoKeyFrameResponse.class);
    }

    @Override
    public Boolean getVideoPlayStatus(VodGetVideoPlayStatusRequest vodGetVideoPlayStatusRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/authplay-status");
        return "1".equals(super.getReturnOne(url, vodGetVideoPlayStatusRequest, String.class));
    }

    @Override
    public VodGetVideoExamLogResponse getVideoExamLog(VodGetVideoExamLogRequest vodGetVideoExamLogRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/video-exam-log");
        VodGetVideoExamLogResponse vodGetVideoExamLogResponse = new VodGetVideoExamLogResponse();
        List<VodGetVideoExamLogResponse.ExamLog> returnList = super.getReturnList(url, vodGetVideoExamLogRequest, VodGetVideoExamLogResponse.ExamLog.class);
        vodGetVideoExamLogResponse.setContents(returnList);
        return vodGetVideoExamLogResponse;
    }

    @Override
    public List<VodGetVideoSizeResponse> getVideoSize(VodGetVideoSizeRequest vodGetVideoSizeRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/getSizeByCata");
        return super.getReturnList(url, vodGetVideoSizeRequest, VodGetVideoSizeResponse.class);
    }

    @Override
    public VodGetWeChatShareVideoInfoResponse getWeChatShareVideoInfo(VodGetWeChatShareVideoInfoRequest vodGetWeChatShareVideoInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/wechat-share/%s/video-info");
        return super.getReturnOne(url, vodGetWeChatShareVideoInfoRequest, VodGetWeChatShareVideoInfoResponse.class);
    }

    @Override
    public Integer getVideoPreviewDuration(VodGetVideoPreviewDurationRequest vodGetVideoPreviewDurationRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/get-preview-duration");
        return super.getReturnOne(url, vodGetVideoPreviewDurationRequest, Integer.class);
    }

    @Override
    public VodGetVideoResponse getVideo(VodGetVideoRequest vodGetVideoRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/get-video-msg");
        List<VodGetVideoResponse> returnList = super.getReturnList(url, vodGetVideoRequest, VodGetVideoResponse.class);
        if (returnList == null || returnList.isEmpty()) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u83b7\u53d6\u5355\u4e2a\u89c6\u9891\u4fe1\u606f\u5931\u8d25\uff0c\u4e1a\u52a1\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a" + vodGetVideoRequest.getRequestId());
        }
        return returnList.get(0);
    }

    @Override
    public String getVideoFirstImage(VodGetVideoFirstImageRequest vodGetVideoFirstImageRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/get-image");
        return super.getReturnOne(url, vodGetVideoFirstImageRequest, String.class);
    }

    @Override
    public List<VodGetVideoExamResponse> getVideoExam(VodGetVideoExamRequest vodGetVideoExamRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/get-video-exam");
        return super.getReturnList(url, vodGetVideoExamRequest, VodGetVideoExamResponse.class);
    }

    @Override
    public VodQueryVideoPasswordResponse queryVideoPassword(VodQueryVideoPasswordRequest vodQueryVideoPasswordRequest) throws IOException, NoSuchAlgorithmException {
        boolean hasPassword;
        VodQueryVideoPasswordResponse vodQueryVideoPasswordResponse = new VodQueryVideoPasswordResponse();
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/video-setting-page");
        VodQueryVideoPasswordVO vodQueryVideoPasswordVO = super.getReturnOne(url, vodQueryVideoPasswordRequest, VodQueryVideoPasswordVO.class);
        if (vodQueryVideoPasswordVO == null) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u67e5\u8be2\u89c6\u9891\u5bc6\u7801\u5931\u8d25");
        }
        if (vodQueryVideoPasswordVO.getIsShowPassword() != null) {
            vodQueryVideoPasswordResponse.setIsShowPassword(vodQueryVideoPasswordVO.getIsShowPassword());
        }
        if (vodQueryVideoPasswordVO.getVideoId() != null) {
            vodQueryVideoPasswordResponse.setVideoId(vodQueryVideoPasswordVO.getVideoId());
        }
        boolean hasVideoInfo = vodQueryVideoPasswordVO.getVideoInfo() != null;
        boolean hasVideoInfoExt = hasVideoInfo && vodQueryVideoPasswordVO.getVideoInfo().getVideoInfoExt() != null;
        boolean bl = hasPassword = hasVideoInfoExt && vodQueryVideoPasswordVO.getVideoInfo().getVideoInfoExt().getPassword() != null;
        if (hasVideoInfo && vodQueryVideoPasswordVO.getVideoInfo().getTitle() != null) {
            vodQueryVideoPasswordResponse.setTitle(vodQueryVideoPasswordVO.getVideoInfo().getTitle());
        }
        if (hasPassword) {
            vodQueryVideoPasswordResponse.setPassword(vodQueryVideoPasswordVO.getVideoInfo().getVideoInfoExt().getPassword());
        }
        return vodQueryVideoPasswordResponse;
    }

    @Override
    public List<VodGetVideosSizeResponse> getVideosSize(VodGetVideosSizeRequest vodGetVideosSizeRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/info");
        return super.getReturnList(url, vodGetVideosSizeRequest, VodGetVideosSizeResponse.class);
    }

    @Override
    public List<VodGetVideosPlayTimesResponse> getVideosPlayTimes(VodGetVideosPlayTimesRequest vodGetVideosPlayTimesRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/data/%s/play-times");
        return super.getReturnList(url, vodGetVideosPlayTimesRequest, VodGetVideosPlayTimesResponse.class);
    }
}

