/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.service.upload.impl;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import net.polyv.vod.v1.constant.VodURL;
import net.polyv.vod.v1.entity.upload.VodUploadCoverImageRequest;
import net.polyv.vod.v1.entity.upload.VodUploadCoverImageUrlRequest;
import net.polyv.vod.v1.entity.upload.VodUploadHttpVideoListRequest;
import net.polyv.vod.v1.entity.upload.VodUploadPPTRequest;
import net.polyv.vod.v1.entity.upload.VodUploadWatermarkRequest;
import net.polyv.vod.v1.service.VodBaseService;
import net.polyv.vod.v1.service.upload.IVodUploadService;

public class VodUploadServiceImpl
extends VodBaseService
implements IVodUploadService {
    @Override
    public Boolean uploadCoverImage(VodUploadCoverImageRequest vodUploadCoverImageRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/uploadCoverImage");
        HashMap<String, File> fileMap = new HashMap<String, File>();
        fileMap.put("image", vodUploadCoverImageRequest.getImage());
        super.uploadOneFile(url, vodUploadCoverImageRequest, fileMap, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean uploadCoverImageUrl(VodUploadCoverImageUrlRequest vodUploadCoverImageUrlRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/uploadCoverImageUrl");
        super.postFormBodyReturnOne(url, vodUploadCoverImageUrlRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean uploadWatermark(VodUploadWatermarkRequest vodUploadWatermarkRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/watermarkSetting");
        HashMap<String, File> fileMap = new HashMap<String, File>();
        fileMap.put("image", vodUploadWatermarkRequest.getImage());
        this.uploadOneFile(url, vodUploadWatermarkRequest, fileMap, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean uploadHttpVideoList(VodUploadHttpVideoListRequest vodUploadHttpVideoListRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/grab/%s/upload/multi");
        super.postFormBodyReturnOne(url, vodUploadHttpVideoListRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean uploadPPT(VodUploadPPTRequest vodUploadPPTRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("https://api.polyv.net/v2/video/%s/uploadPPT");
        HashMap<String, File> fileMap = new HashMap<String, File>();
        fileMap.put("ppt", vodUploadPPTRequest.getPpt());
        fileMap.put("txt", vodUploadPPTRequest.getControlFile());
        super.uploadOneFile(url, vodUploadPPTRequest, fileMap, String.class);
        return Boolean.TRUE;
    }
}

