/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.stream;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONDecimal;
import net.pwall.json.JSONException;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONNumberValue;
import net.pwall.json.JSONValue;
import net.pwall.json.JSONZero;
import net.pwall.json.stream.JSONCoBuilder;
import net.pwall.json.stream.JSONCoNumberBuilder$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0003H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lnet/pwall/json/stream/JSONCoNumberBuilder;", "Lnet/pwall/json/stream/JSONCoBuilder;", "initialChar", "", "(C)V", "complete", "", "getComplete", "()Z", "floating", "number", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "result", "Lnet/pwall/json/JSONValue;", "getResult", "()Lnet/pwall/json/JSONValue;", "state", "Lnet/pwall/json/stream/JSONCoNumberBuilder$State;", "acceptChar", "ch", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "", "store", "State", "json-co-stream"})
public final class JSONCoNumberBuilder
implements JSONCoBuilder {
    private final StringBuilder number;
    private State state;
    private boolean floating;

    @Override
    public boolean getComplete() {
        return this.state == State.COMPLETE;
    }

    @Override
    @NotNull
    public JSONValue getResult() {
        JSONValue jSONValue;
        if (!this.getComplete()) {
            throw (Throwable)new JSONException("Number not complete");
        }
        if (this.number.length() == 1 && this.number.charAt(0) == '0') {
            JSONZero jSONZero = JSONZero.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)jSONZero, (String)"JSONZero.ZERO");
            jSONValue = (JSONValue)jSONZero;
        } else if (this.floating) {
            jSONValue = (JSONValue)new JSONDecimal(this.number.toString());
        } else {
            String string = this.number.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"number.toString()");
            String string2 = string;
            boolean bl = false;
            long longValue = Long.parseLong(string2);
            int intValue = (int)longValue;
            jSONValue = (JSONValue)((long)intValue == longValue ? (JSONNumberValue)new JSONInteger(intValue) : (JSONNumberValue)new JSONLong(longValue));
        }
        return jSONValue;
    }

    @Override
    @Nullable
    public Object acceptChar(int ch, @NotNull Continuation<? super Boolean> $completion) {
        switch (JSONCoNumberBuilder$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                State state;
                char c = (char)ch;
                if (c == '0') {
                    state = State.ZERO_SEEN;
                } else {
                    char c2 = c;
                    if ('1' <= c2 && '9' >= c2) {
                        state = State.INTEGER;
                    } else {
                        throw (Throwable)new JSONException("Illegal JSON number");
                    }
                }
                this.state = state;
                break;
            }
            case 2: {
                State state;
                switch ((char)ch) {
                    case '.': {
                        state = State.DOT_SEEN;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        state = State.E_SEEN;
                        break;
                    }
                    default: {
                        state = State.COMPLETE;
                    }
                }
                this.state = state;
                break;
            }
            case 3: {
                State state;
                char c = (char)ch;
                if ('0' <= c && '9' >= c) break;
                switch ((char)ch) {
                    case '.': {
                        state = State.DOT_SEEN;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        state = State.E_SEEN;
                        break;
                    }
                    default: {
                        state = State.COMPLETE;
                    }
                }
                this.state = state;
                break;
            }
            case 4: {
                this.floating = true;
                char c = (char)ch;
                if ('0' <= c && '9' >= c) {
                    this.state = State.FRACTION;
                    break;
                }
                throw (Throwable)new JSONException("Illegal JSON number");
            }
            case 5: {
                State state;
                char c = (char)ch;
                if ('0' <= c && '9' >= c) break;
                switch ((char)ch) {
                    case 'E': 
                    case 'e': {
                        state = State.E_SEEN;
                        break;
                    }
                    default: {
                        state = State.COMPLETE;
                    }
                }
                this.state = state;
                break;
            }
            case 6: {
                State state;
                this.floating = true;
                char c = (char)ch;
                if (c == '-' || c == '+') {
                    state = State.E_SIGN_SEEN;
                } else {
                    char c3 = c;
                    if ('0' <= c3 && '9' >= c3) {
                        state = State.EXPONENT;
                    } else {
                        throw (Throwable)new JSONException("Illegal JSON number");
                    }
                }
                this.state = state;
                break;
            }
            case 7: {
                char c;
                char c4 = c = (char)ch;
                if ('0' > c4 || '9' < c4) {
                    throw (Throwable)new JSONException("Illegal JSON number");
                }
                this.state = State.EXPONENT;
                break;
            }
            case 8: {
                char c = (char)ch;
                if ('0' <= c && '9' >= c) break;
                this.state = State.COMPLETE;
                break;
            }
            case 9: {
                JSONCoBuilder.Companion.checkWhitespace(ch);
                return Boxing.boxBoolean((boolean)true);
            }
        }
        if (this.getComplete()) {
            return Boxing.boxBoolean((boolean)false);
        }
        this.store((char)ch);
        return Boxing.boxBoolean((boolean)true);
    }

    @Override
    public void close() {
        switch (JSONCoNumberBuilder$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                throw (Throwable)new JSONException("Illegal JSON number");
            }
        }
        this.state = State.COMPLETE;
    }

    private final void store(char ch) {
        this.number.append(ch);
    }

    /*
     * WARNING - void declaration
     */
    public JSONCoNumberBuilder(char initialChar) {
        State state;
        void $this$apply;
        StringBuilder stringBuilder = new StringBuilder();
        char c = '\u0000';
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder;
        JSONCoNumberBuilder jSONCoNumberBuilder = this;
        boolean bl2 = false;
        $this$apply.append(initialChar);
        Unit unit = Unit.INSTANCE;
        jSONCoNumberBuilder.number = stringBuilder;
        char c2 = initialChar;
        if (c2 == '-') {
            state = State.MINUS_SEEN;
        } else if (c2 == '0') {
            state = State.ZERO_SEEN;
        } else {
            c = c2;
            if ('1' <= c && '9' >= c) {
                state = State.INTEGER;
            } else {
                throw (Throwable)new JSONException("Illegal JSON number");
            }
        }
        this.state = state;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lnet/pwall/json/stream/JSONCoNumberBuilder$State;", "", "(Ljava/lang/String;I)V", "MINUS_SEEN", "ZERO_SEEN", "INTEGER", "DOT_SEEN", "FRACTION", "E_SEEN", "E_SIGN_SEEN", "EXPONENT", "COMPLETE", "json-co-stream"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State MINUS_SEEN;
        public static final /* enum */ State ZERO_SEEN;
        public static final /* enum */ State INTEGER;
        public static final /* enum */ State DOT_SEEN;
        public static final /* enum */ State FRACTION;
        public static final /* enum */ State E_SEEN;
        public static final /* enum */ State E_SIGN_SEEN;
        public static final /* enum */ State EXPONENT;
        public static final /* enum */ State COMPLETE;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[9];
            State[] stateArray2 = stateArray;
            stateArray[0] = MINUS_SEEN = new State();
            stateArray[1] = ZERO_SEEN = new State();
            stateArray[2] = INTEGER = new State();
            stateArray[3] = DOT_SEEN = new State();
            stateArray[4] = FRACTION = new State();
            stateArray[5] = E_SEEN = new State();
            stateArray[6] = E_SIGN_SEEN = new State();
            stateArray[7] = EXPONENT = new State();
            stateArray[8] = COMPLETE = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

