/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.stream;

import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import net.pwall.json.JSONException;
import net.pwall.json.JSONString;
import net.pwall.json.stream.JSONCoBuilder;
import net.pwall.json.stream.JSONCoStringBuilder$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0019\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001bH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lnet/pwall/json/stream/JSONCoStringBuilder;", "Lnet/pwall/json/stream/JSONCoBuilder;", "()V", "complete", "", "getComplete", "()Z", "result", "Lnet/pwall/json/JSONString;", "getResult", "()Lnet/pwall/json/JSONString;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "state", "Lnet/pwall/json/stream/JSONCoStringBuilder$State;", "unicode", "", "acceptBackslash", "", "ch", "acceptChar", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "acceptNormal", "acceptUnicode", "nextState", "store", "", "Companion", "State", "json-co-stream"})
public final class JSONCoStringBuilder
implements JSONCoBuilder {
    private final StringBuilder sb = new StringBuilder();
    private State state = State.NORMAL;
    private int unicode;
    public static final int DIGIT_0 = 48;
    public static final int DIGIT_9 = 57;
    public static final int LETTER_A = 65;
    public static final int LETTER_F = 70;
    public static final int LETTER_a = 97;
    public static final int LETTER_b = 98;
    public static final int LETTER_f = 102;
    public static final int LETTER_n = 110;
    public static final int LETTER_r = 114;
    public static final int LETTER_t = 116;
    public static final int LETTER_u = 117;
    public static final int DOUBLE_QUOTE = 34;
    public static final int BACKSLASH = 92;
    public static final int SLASH = 47;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean getComplete() {
        return this.state == State.COMPLETE;
    }

    @NotNull
    public JSONString getResult() {
        if (!this.getComplete()) {
            throw (Throwable)new JSONException("Unterminated JSON string");
        }
        return new JSONString((CharSequence)this.sb);
    }

    @Override
    @Nullable
    public Object acceptChar(int ch, @NotNull Continuation<? super Boolean> $completion) {
        switch (JSONCoStringBuilder$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.acceptNormal(ch);
                break;
            }
            case 2: {
                this.acceptBackslash(ch);
                break;
            }
            case 3: {
                this.acceptUnicode(ch, State.UNICODE2);
                break;
            }
            case 4: {
                this.acceptUnicode(ch, State.UNICODE3);
                break;
            }
            case 5: {
                this.acceptUnicode(ch, State.UNICODE4);
                break;
            }
            case 6: {
                this.acceptUnicode(ch, State.NORMAL);
                this.store((char)this.unicode);
                break;
            }
            case 7: {
                JSONCoBuilder.Companion.checkWhitespace(ch);
                break;
            }
        }
        return Boxing.boxBoolean((boolean)true);
    }

    private final void acceptNormal(int ch) {
        if (ch == 34) {
            this.state = State.COMPLETE;
        } else if (ch == 92) {
            this.state = State.BACKSLASH;
        } else {
            if (ch <= 31) {
                throw (Throwable)new JSONException("Illegal character in JSON string");
            }
            if (Character.isBmpCodePoint(ch)) {
                this.sb.append((char)ch);
            } else {
                this.sb.append(Character.highSurrogate(ch));
                this.sb.append(Character.lowSurrogate(ch));
            }
        }
    }

    private final void acceptBackslash(int ch) {
        switch (ch) {
            case 34: 
            case 47: 
            case 92: {
                this.store((char)ch);
                break;
            }
            case 98: {
                this.store('\b');
                break;
            }
            case 102: {
                this.store('\f');
                break;
            }
            case 110: {
                this.store('\n');
                break;
            }
            case 114: {
                this.store('\r');
                break;
            }
            case 116: {
                this.store('\t');
                break;
            }
            case 117: {
                this.state = State.UNICODE1;
                break;
            }
            default: {
                throw (Throwable)new JSONException("Illegal escape sequence in JSON string");
            }
        }
    }

    private final void store(char ch) {
        this.sb.append(ch);
        this.state = State.NORMAL;
    }

    private final void acceptUnicode(int ch, State nextState) {
        int n;
        int n2 = ch;
        int n3 = n2;
        if (48 <= n3 && 57 >= n3) {
            n = ch - 48;
        } else {
            n3 = n2;
            if (65 <= n3 && 70 >= n3) {
                n = ch - 65 + 10;
            } else {
                n3 = n2;
                if (97 <= n3 && 102 >= n3) {
                    n = ch - 97 + 10;
                } else {
                    throw (Throwable)new JSONException("Illegal Unicode sequence in JSON string");
                }
            }
        }
        int digit = n;
        this.unicode = this.unicode << 4 | digit;
        this.state = nextState;
    }

    @Override
    public void close() {
        JSONCoBuilder.DefaultImpls.close(this);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lnet/pwall/json/stream/JSONCoStringBuilder$State;", "", "(Ljava/lang/String;I)V", "NORMAL", "BACKSLASH", "UNICODE1", "UNICODE2", "UNICODE3", "UNICODE4", "COMPLETE", "json-co-stream"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NORMAL;
        public static final /* enum */ State BACKSLASH;
        public static final /* enum */ State UNICODE1;
        public static final /* enum */ State UNICODE2;
        public static final /* enum */ State UNICODE3;
        public static final /* enum */ State UNICODE4;
        public static final /* enum */ State COMPLETE;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[7];
            State[] stateArray2 = stateArray;
            stateArray[0] = NORMAL = new State();
            stateArray[1] = BACKSLASH = new State();
            stateArray[2] = UNICODE1 = new State();
            stateArray[3] = UNICODE2 = new State();
            stateArray[4] = UNICODE3 = new State();
            stateArray[5] = UNICODE4 = new State();
            stateArray[6] = COMPLETE = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/pwall/json/stream/JSONCoStringBuilder$Companion;", "", "()V", "BACKSLASH", "", "DIGIT_0", "DIGIT_9", "DOUBLE_QUOTE", "LETTER_A", "LETTER_F", "LETTER_a", "LETTER_b", "LETTER_f", "LETTER_n", "LETTER_r", "LETTER_t", "LETTER_u", "SLASH", "json-co-stream"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

