/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.kotlin.codegen.gradle.extension;

import java.net.URI;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.kotlin.codegen.gradle.extension.SchemaExtension;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.validation.FormatValidator;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lnet/pwall/json/kotlin/codegen/gradle/extension/SchemaExtensionFormatValidation;", "Lnet/pwall/json/kotlin/codegen/gradle/extension/SchemaExtension;", "name", "", "project", "Lorg/gradle/api/Project;", "(Ljava/lang/String;Lorg/gradle/api/Project;)V", "format", "Lorg/gradle/api/provider/Property;", "getFormat", "()Lorg/gradle/api/provider/Property;", "validator", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "pointer", "Lnet/pwall/json/pointer/JSONPointer;", "json-kotlin-gradle"})
public final class SchemaExtensionFormatValidation
extends SchemaExtension {
    @Input
    @NotNull
    private final Property<String> format;

    @NotNull
    public final Property<String> getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public JSONSchema.Validator validator(@Nullable URI uri, @NotNull JSONPointer pointer) {
        FormatValidator.FormatChecker formatChecker;
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        switch ((String)this.format.get()) {
            case "date": {
                formatChecker = (FormatValidator.FormatChecker)FormatValidator.DateFormatChecker.INSTANCE;
                break;
            }
            case "date-time": {
                formatChecker = (FormatValidator.FormatChecker)FormatValidator.DateTimeFormatChecker.INSTANCE;
                break;
            }
            case "time": {
                formatChecker = (FormatValidator.FormatChecker)FormatValidator.TimeFormatChecker.INSTANCE;
                break;
            }
            case "uri": {
                formatChecker = (FormatValidator.FormatChecker)FormatValidator.URIFormatChecker.INSTANCE;
                break;
            }
            case "uri-reference": {
                formatChecker = (FormatValidator.FormatChecker)FormatValidator.URIReferenceFormatChecker.INSTANCE;
                break;
            }
            case "uuid": {
                formatChecker = (FormatValidator.FormatChecker)FormatValidator.UUIDFormatChecker.INSTANCE;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Invalid format type");
            }
        }
        return (JSONSchema.Validator)new FormatValidator(uri, pointer, formatChecker);
    }

    @Inject
    public SchemaExtensionFormatValidation(@NotNull String name, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(name, project);
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.format = property;
    }
}

