/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.validation;

import java.net.URI;
import java.time.format.DateTimeFormatter;

public class JSONValidation {
    private static final int uuidLength = 36;
    private static final int[] uuidDashLocations = new int[]{8, 13, 18, 23};

    public static boolean isDateTime(String string) {
        try {
            DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(string);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static boolean isDate(String string) {
        try {
            DateTimeFormatter.ISO_LOCAL_DATE.parse(string);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static boolean isTime(String string) {
        try {
            DateTimeFormatter.ISO_OFFSET_TIME.parse(string);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static boolean isDuration(String string) {
        char ch;
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int i = 0;
        if (string.charAt(i++) != 'P') {
            return false;
        }
        int previous = 0;
        while (true) {
            if (i == n) {
                return previous != 0;
            }
            if ((ch = string.charAt(i++)) == 'T') break;
            if (!JSONValidation.isDigit(ch)) {
                return false;
            }
            do {
                if (i != n) continue;
                return false;
            } while (JSONValidation.isDigit(ch = string.charAt(i++)));
            if (previous == 0 && ch == 'W') {
                return i == n;
            }
            if (previous == 0 && ch != 'Y' && ch != 'M' && ch != 'D' || previous == 89 && ch != 'M' || previous == 77 && ch != 'D') {
                return false;
            }
            previous = ch;
        }
        previous = 0;
        while (i != n) {
            if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
                return false;
            }
            do {
                if (i != n) continue;
                return false;
            } while (JSONValidation.isDigit(ch = string.charAt(i++)));
            if (previous == 0 && ch != 'H' && ch != 'M' && ch != 'S' || previous == 72 && ch != 'M' || previous == 77 && ch != 'S') {
                return false;
            }
            previous = ch;
        }
        return previous != 0;
    }

    public static boolean isURI(String string) {
        try {
            URI uri = new URI(string);
            if (uri.getScheme() == null) {
                return false;
            }
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static boolean isURIReference(String string) {
        URI baseURI = URI.create("http://pwall.net/schema/schema.json");
        try {
            baseURI.resolve(string);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static boolean isUUID(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() != 36) {
            return false;
        }
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            int dashLocation = uuidDashLocations[j];
            while (i < dashLocation) {
                if (JSONValidation.isHexDigit(string.charAt(i++))) continue;
                return false;
            }
            if (string.charAt(i++) == '-') continue;
            return false;
        }
        while (i < 36) {
            if (JSONValidation.isHexDigit(string.charAt(i++))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHostname(String string) {
        if (string == null) {
            return false;
        }
        return JSONValidation.isHostname(string, 0);
    }

    private static boolean isHostname(String string, int i) {
        boolean nextMayBeDashOrDot = false;
        int n = string.length();
        while (i < n) {
            char ch = string.charAt(i++);
            if (nextMayBeDashOrDot) {
                if (ch == '-' || ch == '.') {
                    nextMayBeDashOrDot = false;
                    continue;
                }
                if (JSONValidation.isLetterOrDigit(ch)) continue;
                return false;
            }
            if (!JSONValidation.isLetterOrDigit(ch)) {
                return false;
            }
            nextMayBeDashOrDot = true;
        }
        return nextMayBeDashOrDot;
    }

    public static boolean isEmail(String string) {
        if (string == null) {
            return false;
        }
        int i = 0;
        int n = string.length();
        while (i < n) {
            char ch;
            if ((ch = string.charAt(i++)) == '@') {
                return i > 0 && JSONValidation.isHostname(string, i);
            }
            if (JSONValidation.isLetterOrDigit(ch) || ch == '-' || ch == '+' || ch == '.' || ch == '_' || ch == '%') continue;
            return false;
        }
        return false;
    }

    public static boolean isIPV4(String string) {
        if (string == null) {
            return false;
        }
        return JSONValidation.isIPV4(string, 0);
    }

    private static boolean isIPV4(String string, int i) {
        int n;
        block4: {
            n = string.length();
            int j = 0;
            do {
                char ch;
                int k = 0;
                int m = 0;
                while (i < n && JSONValidation.isDigit(ch = string.charAt(i))) {
                    ++i;
                    if ((m = m * 10 + ch - 48) > 255) {
                        return false;
                    }
                    if (++k != 3) continue;
                }
                if (k == 0) {
                    return false;
                }
                if (++j == 4) break block4;
            } while (i < n && string.charAt(i++) == '.');
            return false;
        }
        return i == n;
    }

    public static boolean isIPV6(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int i = 0;
        int j = 0;
        boolean doubleColonSeen = false;
        if (string.charAt(0) == ':') {
            if (string.charAt(1) != ':') {
                return false;
            }
            if (n == 2) {
                return true;
            }
            doubleColonSeen = true;
            i = 2;
            j = 1;
        }
        while (true) {
            int k = 0;
            while (i < n && JSONValidation.isHexDigit(string.charAt(i))) {
                ++i;
                if (++k != 4) continue;
            }
            if (k == 0) {
                return false;
            }
            if (++j == 8) break;
            if (i >= n) {
                return doubleColonSeen;
            }
            char ch = string.charAt(i);
            if (ch != ':') {
                if ((j == 7 || j < 7 && doubleColonSeen) && ch == '.') {
                    while (string.charAt(--i) != ':') {
                    }
                    return JSONValidation.isIPV4(string, i + 1);
                }
                return false;
            }
            if (doubleColonSeen || ++i >= n || string.charAt(i) != ':') continue;
            if (++i == n) {
                return true;
            }
            doubleColonSeen = true;
            ++j;
        }
        return i == n;
    }

    public static boolean isJSONPointer(String string) {
        return string != null && (string.length() == 0 || string.charAt(0) == '/');
    }

    public static boolean isRelativeJSONPointer(String string) {
        char ch;
        if (string == null) {
            return false;
        }
        int i = 0;
        int n = string.length();
        if (i == n) {
            return false;
        }
        if ((ch = string.charAt(i++)) != '0') {
            if (!JSONValidation.isDigit(ch)) {
                return false;
            }
            while (i < n && JSONValidation.isDigit(string.charAt(i))) {
                ++i;
            }
        }
        if (i == n) {
            return true;
        }
        return (ch = string.charAt(i++)) == '/' || ch == '#' && i == n;
    }

    private static boolean isLetterOrDigit(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || JSONValidation.isDigit(ch);
    }

    private static boolean isHexDigit(char ch) {
        return JSONValidation.isDigit(ch) || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }
}

