/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.common;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.quedex.api.pgp.BcPrivateKey;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.pgp.PGPKeyInitialisationException;

public class Config {
    private final String marketStreamUrl;
    private final String marketDataUrl;
    private final String userStreamUrl;
    private final BcPublicKey qdxPublicKey;
    private final BcPrivateKey userPrivateKey;
    private final long accountId;
    private final int nonceGroup;

    public Config(String marketStreamUrl, String marketDataUrl, String userStreamUrl, BcPublicKey qdxPublicKey, BcPrivateKey userPrivateKey, long accountId, int nonceGroup) {
        Preconditions.checkArgument((!marketStreamUrl.isEmpty() ? 1 : 0) != 0, (Object)"Empty marketStreamUrl");
        Preconditions.checkArgument((!marketDataUrl.isEmpty() ? 1 : 0) != 0, (Object)"Empty marketDataUrl");
        Preconditions.checkArgument((!userStreamUrl.isEmpty() ? 1 : 0) != 0, (Object)"Empty userStreamUrl");
        Preconditions.checkArgument((accountId > 0L ? 1 : 0) != 0, (String)"accountId=%s <= 0", (Object[])new Object[]{accountId});
        Preconditions.checkArgument((nonceGroup >= 0 ? 1 : 0) != 0, (String)"accountId=%s < 0", (Object[])new Object[]{nonceGroup});
        this.marketStreamUrl = marketStreamUrl + "?keepalive=true";
        this.marketDataUrl = marketDataUrl;
        this.userStreamUrl = userStreamUrl + "?keepalive=true";
        this.qdxPublicKey = (BcPublicKey)Preconditions.checkNotNull((Object)qdxPublicKey, (Object)"null qdxPublicKey");
        this.userPrivateKey = (BcPrivateKey)Preconditions.checkNotNull((Object)userPrivateKey, (Object)"null userPrivateKey");
        this.accountId = accountId;
        this.nonceGroup = nonceGroup;
    }

    public static Config fromResource(String resourceName, char[] prvKeyPasspharse) {
        try {
            return Config.fromInputStream(Resources.getResource((String)resourceName).openStream(), prvKeyPasspharse);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading resource=" + resourceName, e);
        }
    }

    public static Config fromResource(char[] prvKeyPasspharse) {
        return Config.fromResource("qdxConfig.properties", prvKeyPasspharse);
    }

    public static Config fromInputStream(InputStream inputStream, char[] prvKeyPasspharse) {
        Properties props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading properties file", e);
        }
        try {
            return new Config(props.getProperty("net.quedex.client.api.marketStreamUrl"), props.getProperty("net.quedex.client.api.marketDataUrl"), props.getProperty("net.quedex.client.api.userStreamUrl"), BcPublicKey.fromArmored(props.getProperty("net.quedex.client.api.qdxPublicKey")), BcPrivateKey.fromArmored(props.getProperty("net.quedex.client.api.userPrivateKey"), prvKeyPasspharse), Long.parseLong(props.getProperty("net.quedex.client.api.accountId")), Integer.parseInt(props.getProperty("net.quedex.client.api.nonceGroup")));
        }
        catch (PGPKeyInitialisationException e) {
            throw new IllegalArgumentException("Error instantiating keys", e);
        }
    }

    public String getMarketStreamUrl() {
        return this.marketStreamUrl;
    }

    public String getInstrumentDataUrl() {
        return this.marketDataUrl + "/instrument_data";
    }

    public String getMarketDataUrl() {
        return this.marketDataUrl;
    }

    public String getUserStreamUrl() {
        return this.userStreamUrl;
    }

    public BcPublicKey getQdxPublicKey() {
        return this.qdxPublicKey;
    }

    public BcPrivateKey getUserPrivateKey() {
        return this.userPrivateKey;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public int getNonceGroup() {
        return this.nonceGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return this.accountId == config.accountId && this.nonceGroup == config.nonceGroup && Objects.equal((Object)this.marketStreamUrl, (Object)config.marketStreamUrl) && Objects.equal((Object)this.marketDataUrl, (Object)config.marketDataUrl) && Objects.equal((Object)this.userStreamUrl, (Object)config.userStreamUrl) && Objects.equal((Object)this.qdxPublicKey, (Object)config.qdxPublicKey) && Objects.equal((Object)this.userPrivateKey, (Object)config.userPrivateKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.marketStreamUrl, this.marketDataUrl, this.userStreamUrl, this.qdxPublicKey, this.userPrivateKey, this.accountId, this.nonceGroup});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("marketStreamUrl", (Object)this.marketStreamUrl).add("marketDataUrl", (Object)this.marketDataUrl).add("userStreamUrl", (Object)this.userStreamUrl).add("qdxPublicKey", (Object)this.qdxPublicKey).add("userPrivateKey", (Object)this.userPrivateKey).add("accountId", this.accountId).add("nonceGroup", this.nonceGroup).toString();
    }
}

