/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.market;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;

public final class Trade {
    private final int instrumentId;
    private final long tradeId;
    private final long timestamp;
    private final BigDecimal price;
    private final int quantity;
    private final LiquidityProvider liquidityProvider;

    @JsonCreator
    public Trade(@JsonProperty(value="instrument_id") int instrumentId, @JsonProperty(value="trade_id") long tradeId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="quantity") int quantity, @JsonProperty(value="liquidity_provider") LiquidityProvider liquidityProvider) {
        Preconditions.checkArgument((quantity >= 0 ? 1 : 0) != 0, (String)"quantity=%s < 0", (Object[])new Object[]{quantity});
        this.instrumentId = instrumentId;
        this.tradeId = tradeId;
        this.timestamp = timestamp;
        this.price = (BigDecimal)Preconditions.checkNotNull((Object)price, (Object)"null price");
        this.quantity = quantity;
        this.liquidityProvider = (LiquidityProvider)((Object)Preconditions.checkNotNull((Object)((Object)liquidityProvider), (Object)"null liquidityProvider"));
    }

    public int getInstrumentId() {
        return this.instrumentId;
    }

    public long getTradeId() {
        return this.tradeId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public LiquidityProvider getLiquidityProvider() {
        return this.liquidityProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trade trade = (Trade)o;
        return this.tradeId == trade.tradeId;
    }

    public boolean equalsFieldByField(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trade trade = (Trade)o;
        return this.instrumentId == trade.instrumentId && this.tradeId == trade.tradeId && this.timestamp == trade.timestamp && this.quantity == trade.quantity && Objects.equal((Object)this.price, (Object)trade.price) && this.liquidityProvider == trade.liquidityProvider;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tradeId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("instrumentId", this.instrumentId).add("tradeId", this.tradeId).add("price", (Object)this.price).add("quantity", this.quantity).add("liquidityProvider", (Object)this.liquidityProvider).toString();
    }

    public static enum LiquidityProvider {
        BUYER,
        SELLER,
        AUCTION,
        REFERENCE,
        SETTLEMENT;


        @JsonCreator
        private static LiquidityProvider deserialize(String value) {
            return LiquidityProvider.valueOf(value.toUpperCase());
        }
    }
}

