/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.pgp;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.pgp.PGPInvalidSignatureException;
import net.quedex.api.pgp.PGPSignatureVerificationException;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;

public final class BcSignatureVerifier {
    private final BcPublicKey publicKey;

    public BcSignatureVerifier(BcPublicKey publicKey) {
        this.publicKey = (BcPublicKey)Preconditions.checkNotNull((Object)publicKey, (Object)"null publicKey");
    }

    public String verifySignature(String message) throws PGPInvalidSignatureException, PGPSignatureVerificationException {
        try {
            int ch;
            ArmoredInputStream aIn = new ArmoredInputStream((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            while ((ch = aIn.read()) >= 0 && aIn.isClearText()) {
                bOut.write((byte)ch);
            }
            JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory((InputStream)aIn);
            PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
            Preconditions.checkState((p3 != null && p3.size() >= 1 ? 1 : 0) != 0, (Object)"No signatures");
            PGPSignature sig = p3.get(0);
            sig.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), this.publicKey.getSigningKey());
            ByteArrayOutputStream lineOut = new ByteArrayOutputStream();
            byte[] content = bOut.toByteArray();
            ByteArrayInputStream sigIn = new ByteArrayInputStream(content);
            int lookAhead = BcSignatureVerifier.readInputLine(lineOut, sigIn);
            BcSignatureVerifier.processLine(sig, lineOut.toByteArray());
            if (lookAhead != -1) {
                do {
                    lookAhead = BcSignatureVerifier.readInputLine(lineOut, lookAhead, sigIn);
                    sig.update((byte)13);
                    sig.update((byte)10);
                    BcSignatureVerifier.processLine(sig, lineOut.toByteArray());
                } while (lookAhead != -1);
            }
            if (sig.verify()) {
                return new String(content, StandardCharsets.UTF_8);
            }
            throw new PGPInvalidSignatureException("Invalid signature, received keyId=" + Long.toHexString(sig.getKeyID()).toUpperCase());
        }
        catch (IOException | PGPException e) {
            throw new PGPSignatureVerificationException("Error verifying message", e);
        }
    }

    private static void processLine(PGPSignature sig, byte[] line) throws IOException {
        int length = BcSignatureVerifier.getLengthWithoutWhiteSpace(line);
        if (length > 0) {
            sig.update(line, 0, length);
        }
    }

    private static int getLengthWithoutWhiteSpace(byte[] line) {
        int end;
        for (end = line.length - 1; end >= 0 && BcSignatureVerifier.isWhiteSpace(line[end]); --end) {
        }
        return end + 1;
    }

    private static boolean isWhiteSpace(byte b) {
        return b == 13 || b == 10 || b == 9 || b == 32;
    }

    private static int readInputLine(ByteArrayOutputStream bOut, InputStream fIn) throws IOException {
        int ch;
        bOut.reset();
        int lookAhead = -1;
        while ((ch = fIn.read()) >= 0) {
            bOut.write(ch);
            if (ch != 13 && ch != 10) continue;
            lookAhead = BcSignatureVerifier.readPassedEOL(bOut, ch, fIn);
            break;
        }
        return lookAhead;
    }

    private static int readInputLine(ByteArrayOutputStream bOut, int lookAhead, InputStream fIn) throws IOException {
        bOut.reset();
        int ch = lookAhead;
        do {
            bOut.write(ch);
            if (ch != 13 && ch != 10) continue;
            lookAhead = BcSignatureVerifier.readPassedEOL(bOut, ch, fIn);
            break;
        } while ((ch = fIn.read()) >= 0);
        return lookAhead;
    }

    private static int readPassedEOL(ByteArrayOutputStream bOut, int lastCh, InputStream fIn) throws IOException {
        int lookAhead = fIn.read();
        if (lastCh == 13 && lookAhead == 10) {
            bOut.write(lookAhead);
            lookAhead = fIn.read();
        }
        return lookAhead;
    }
}

