/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Optional;

public class OpenPosition {
    private final int instrumentId;
    private final BigDecimal pnl;
    private final BigDecimal maintenanceMargin;
    private final BigDecimal initialMargin;
    private final PositionSide side;
    private final int quantity;
    private final BigDecimal averageOpeningPrice;

    @JsonCreator
    public OpenPosition(@JsonProperty(value="instrument_id") int instrumentId, @JsonProperty(value="pnl") BigDecimal pnl, @JsonProperty(value="maintenance_margin") BigDecimal maintenanceMargin, @JsonProperty(value="initial_margin") BigDecimal initialMargin, @JsonProperty(value="side") PositionSide side, @JsonProperty(value="quantity") int quantity, @JsonProperty(value="average_opening_price") BigDecimal averageOpeningPrice) {
        Preconditions.checkArgument((instrumentId > 0 ? 1 : 0) != 0, (String)"instrumentId=%s <= 0", (Object[])new Object[]{instrumentId});
        Preconditions.checkArgument((maintenanceMargin.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"maintenanceMargin=%s < 0", (Object[])new Object[]{maintenanceMargin});
        Preconditions.checkArgument((initialMargin.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"initialMargin=%s < 0", (Object[])new Object[]{initialMargin});
        Preconditions.checkArgument((quantity >= 0 ? 1 : 0) != 0, (String)"quantity=%s < 0", (Object[])new Object[]{quantity});
        this.instrumentId = instrumentId;
        this.pnl = pnl;
        this.maintenanceMargin = maintenanceMargin;
        this.initialMargin = initialMargin;
        this.side = (PositionSide)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"null side"));
        this.quantity = quantity;
        this.averageOpeningPrice = averageOpeningPrice;
    }

    public int getInstrumentId() {
        return this.instrumentId;
    }

    public Optional<BigDecimal> getPnl() {
        return Optional.ofNullable(this.pnl);
    }

    public BigDecimal getMaintenanceMargin() {
        return this.maintenanceMargin;
    }

    public BigDecimal getInitialMargin() {
        return this.initialMargin;
    }

    public PositionSide getSide() {
        return this.side;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getQuantitySigned() {
        return this.side == PositionSide.LONG ? this.quantity : -this.quantity;
    }

    public BigDecimal getAverageOpeningPrice() {
        return this.averageOpeningPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenPosition that = (OpenPosition)o;
        return this.instrumentId == that.instrumentId && this.quantity == that.quantity && Objects.equal((Object)this.pnl, (Object)that.pnl) && Objects.equal((Object)this.maintenanceMargin, (Object)that.maintenanceMargin) && Objects.equal((Object)this.initialMargin, (Object)that.initialMargin) && this.side == that.side && Objects.equal((Object)this.averageOpeningPrice, (Object)that.averageOpeningPrice);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instrumentId, this.pnl, this.maintenanceMargin, this.initialMargin, this.side, this.quantity, this.averageOpeningPrice});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("instrumentId", this.instrumentId).add("pnl", (Object)this.pnl).add("maintenanceMargin", (Object)this.maintenanceMargin).add("initialMargin", (Object)this.initialMargin).add("side", (Object)this.side).add("quantity", this.quantity).add("averageOpeningPrice", (Object)this.averageOpeningPrice).toString();
    }

    public static enum PositionSide {
        LONG,
        SHORT;


        @JsonCreator
        private static PositionSide deserialize(String value) {
            return PositionSide.valueOf(value.toUpperCase());
        }
    }
}

