/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.pgp;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import java.util.Hashtable;
import net.quedex.api.pgp.BcPrivateKey;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.pgp.PGPEncryptionException;
import net.quedex.api.pgp.PGPKeyNotFoundException;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;

public class BcEncryptor {
    private static final int BUFFER_SIZE = 256;
    private final BcPGPDataEncryptorBuilder dataEncryptor;
    private final BcPublicKey publicKey;
    private final BcPrivateKey ourKey;

    public BcEncryptor(BcPublicKey publicKey, BcPrivateKey ourKey) {
        this.publicKey = (BcPublicKey)Preconditions.checkNotNull((Object)publicKey);
        this.ourKey = (BcPrivateKey)Preconditions.checkNotNull((Object)ourKey);
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.dataEncryptor = new BcPGPDataEncryptorBuilder(9);
        this.dataEncryptor.setWithIntegrityPacket(true);
        this.dataEncryptor.setSecureRandom(new SecureRandom());
    }

    public String encrypt(String message, boolean sign) throws PGPEncryptionException, PGPKeyNotFoundException {
        try {
            PGPSecretKey secretKey = this.ourKey.getSecretKey();
            PGPPrivateKey privateKey = this.ourKey.getPrivateKey();
            byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
            PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
            PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)this.dataEncryptor);
            encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(this.publicKey.getEncryptionKey()));
            PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(2);
            BcPGPContentSignerBuilder signerBuilder = new BcPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), 8);
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)signerBuilder);
            signatureGenerator.init(0, privateKey);
            PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
            spGen.setSignerUserID(false, (String)secretKey.getPublicKey().getUserIDs().next());
            signatureGenerator.setHashedSubpackets(spGen.generate());
            if (sign) {
                signatureGenerator.update(messageBytes);
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            Hashtable<String, String> headers = new Hashtable<String, String>();
            headers.put("Version", "QPG");
            ArmoredOutputStream armoredOut = new ArmoredOutputStream((OutputStream)bOut, headers);
            OutputStream encryptedOut = encryptedDataGenerator.open((OutputStream)armoredOut, new byte[256]);
            OutputStream compressedOut = compressedDataGenerator.open(encryptedOut);
            if (sign) {
                signatureGenerator.generateOnePassVersion(false).encode(compressedOut);
            }
            OutputStream literalOut = literalDataGenerator.open(compressedOut, 'u', "_CONSOLE", (long)messageBytes.length, new Date());
            literalOut.write(messageBytes);
            literalDataGenerator.close();
            if (sign) {
                signatureGenerator.generate().encode(compressedOut);
            }
            compressedDataGenerator.close();
            encryptedDataGenerator.close();
            armoredOut.close();
            return new String(bOut.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException | RuntimeException | PGPException e) {
            throw new PGPEncryptionException("Error encrypting message", e);
        }
    }
}

