/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;

public class InternalTransfer {
    private final long destinationAccountId;
    private final BigDecimal amount;

    public InternalTransfer(long destinationAccountId, BigDecimal amount) {
        Preconditions.checkArgument((destinationAccountId > 0L ? 1 : 0) != 0, (String)"destinationAccountId=%s <= 0", (Object[])new Object[]{destinationAccountId});
        Preconditions.checkArgument((amount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"amount=%s <= 0", (Object[])new Object[]{amount});
        this.destinationAccountId = destinationAccountId;
        this.amount = amount;
    }

    @JsonProperty(value="destination_account_id")
    public long getDestinationAccountId() {
        return this.destinationAccountId;
    }

    @JsonProperty(value="amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonProperty(value="type")
    private String getType() {
        return "internal_transfer";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTransfer that = (InternalTransfer)o;
        return this.destinationAccountId == that.destinationAccountId && Objects.equal((Object)this.amount, (Object)that.amount);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.destinationAccountId, this.amount});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("destinationAccountId", this.destinationAccountId).add("amount", (Object)this.amount).toString();
    }
}

