/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;

public class InternalTransferReceived {
    private final long sourceUserId;
    private final BigDecimal amount;

    @JsonCreator
    public InternalTransferReceived(@JsonProperty(value="source_account_id") long sourceUserId, @JsonProperty(value="amount") BigDecimal amount) {
        Preconditions.checkArgument((sourceUserId > 0L ? 1 : 0) != 0, (String)"sourceUserId=%s <= 0", (Object[])new Object[]{sourceUserId});
        Preconditions.checkArgument((amount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"amount=%s <= 0", (Object[])new Object[]{amount});
        this.sourceUserId = sourceUserId;
        this.amount = amount;
    }

    public long getSourceUserId() {
        return this.sourceUserId;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTransferReceived that = (InternalTransferReceived)o;
        return this.sourceUserId == that.sourceUserId && Objects.equal((Object)this.amount, (Object)that.amount);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sourceUserId, this.amount});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sourceUserId", this.sourceUserId).add("amount", (Object)this.amount).toString();
    }
}

