/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import net.quedex.api.user.OrderSide;
import net.quedex.api.user.OrderType;

public class OrderPlaced {
    private final long clientOrderId;
    private final int instrumentId;
    @JsonIgnore
    private final OrderType type;
    private final BigDecimal price;
    private final OrderSide side;
    private final int quantity;
    private final int initialQuantity;

    @JsonCreator
    public OrderPlaced(@JsonProperty(value="client_order_id") long clientOrderId, @JsonProperty(value="instrument_id") int instrumentId, @JsonProperty(value="limit_price") BigDecimal price, @JsonProperty(value="side") OrderSide side, @JsonProperty(value="quantity") int quantity, @JsonProperty(value="initial_quantity") int initialQuantity) {
        Preconditions.checkArgument((clientOrderId > 0L ? 1 : 0) != 0, (String)"clientOrderId=%s <= 0", (Object[])new Object[]{clientOrderId});
        Preconditions.checkArgument((instrumentId > 0 ? 1 : 0) != 0, (String)"instrumentId=%s <= 0", (Object[])new Object[]{instrumentId});
        Preconditions.checkArgument((price.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"price=%s <= 0", (Object[])new Object[]{price});
        Preconditions.checkArgument((quantity > 0 ? 1 : 0) != 0, (String)"quantity=%s <= 0", (Object[])new Object[]{quantity});
        Preconditions.checkArgument((initialQuantity > 0 ? 1 : 0) != 0, (String)"initialQuantity=%s <= 0", (Object[])new Object[]{initialQuantity});
        this.clientOrderId = clientOrderId;
        this.instrumentId = instrumentId;
        this.type = OrderType.LIMIT;
        this.price = price;
        this.side = (OrderSide)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"null side"));
        this.quantity = quantity;
        this.initialQuantity = initialQuantity;
    }

    public long getClientOrderId() {
        return this.clientOrderId;
    }

    public int getInstrumentId() {
        return this.instrumentId;
    }

    public OrderType getType() {
        return this.type;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public OrderSide getSide() {
        return this.side;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getInitialQuantity() {
        return this.initialQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderPlaced that = (OrderPlaced)o;
        return this.clientOrderId == that.clientOrderId && this.instrumentId == that.instrumentId && this.quantity == that.quantity && this.initialQuantity == that.initialQuantity && this.type == that.type && Objects.equal((Object)this.price, (Object)that.price) && this.side == that.side;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientOrderId, this.instrumentId, this.type, this.price, this.side, this.quantity, this.initialQuantity});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientOrderId", this.clientOrderId).add("instrumentId", this.instrumentId).add("type", (Object)this.type).add("price", (Object)this.price).add("side", (Object)this.side).add("quantity", this.quantity).add("initialQuantity", this.initialQuantity).toString();
    }
}

