package net.roseboy.framework.annotation;

import java.lang.annotation.*;

/**
 * 数据库列与字段绑定
 * 
 * @author roseboy
 *
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD })
public @interface ColBind {
	int length() default 0;// 字段长度

	int scale() default 0;// 小数点

	String memo() default "";// 备注

	String defaultValue() default "NULL";// 数据库默认值

	boolean nullable() default true;// 能否为空

	String ddl() default "";// 自定义语句
}
