package net.roseboy.framework.core;

import com.alibaba.druid.util.StringUtils;
import com.jfinal.core.Controller;
import com.jfinal.json.Jackson;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.*;
import net.roseboy.framework.util.ExcelUtils;
import net.roseboy.framework.util.ExceptionUtils;
import net.roseboy.framework.util.RedisUtils;
import net.roseboy.framework.util.TypeConverter;

import java.io.File;
import java.math.BigDecimal;
import java.util.*;
import java.util.Map.Entry;

/**
 * controller 基础类
 * 
 * @author roseboy
 *
 */
public abstract class KController extends Controller {

	public KController() {
		super();
		JFinalUtils.AutoBindService(this);
	}

	// 生成kpage
	public <T> KPage<T> getKPage() {
		KPage<T> kpage = new KPage<T>();
		int page = getParaToInt("page", KPage.DEFAULT_FIRST_NO);
		page = page < 1 ? 1 : page;
		int rows = getParaToInt("rows", KPage.DEFAULT_PAGE_SIZE);
		rows = rows < 1 ? 1 : rows;

		// 处理查询条件
		LinkedHashMap<String, Object> whereMap = new LinkedHashMap<String, Object>();// 查询条件<"eq.name","yourname">
		Set<String> nameSet = getParaMap().keySet();
		for (String name : nameSet) {
			String[] names = name.split("\\.");
			String value = getPara(name, "");
			if (names.length == 4 && "where".equals(names[0].toLowerCase()) && value.length() > 0) {
				if ("S".equals(names[1].toUpperCase())) {// String
					whereMap.put(names[2] + "." + names[3], getPara(name));
				} else if ("I".equals(names[1].toUpperCase())) {// Integer
					whereMap.put(names[2] + "." + names[3], getParaToInt(name));
				} else if ("L".equals(names[1].toUpperCase())) {// Long
					whereMap.put(names[2] + "." + names[3], getParaToLong(name));
				} else if ("N".equals(names[1].toUpperCase())) {// Double
					whereMap.put(names[2] + "." + names[3], Double.parseDouble(getPara(name, "0")));
				} else if ("D".equals(names[1].toUpperCase())) {// Date
					whereMap.put(names[2] + "." + names[3], getParaToDate(name));
				} else if ("B".equals(names[1].toUpperCase())) {// Boolean
					whereMap.put(names[2] + "." + names[3], getParaToBoolean(name));
				} else if ("T".equals(names[1].toUpperCase())) {// BigDecimal
					whereMap.put(names[2] + "." + names[3], new BigDecimal(getPara(name, "0")));
				} else {
					whereMap.put(names[2] + "." + names[3], getPara(name));
				}
			}
		}

		// 处理排序参数
		LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();// 排序参数<"name","desc">
		String[] sorts = getPara("sort", "").split(",");
		String[] orders = getPara("order", "").split(",");
		if (sorts.length == orders.length) {
			for (int i = 0; i < sorts.length; i++) {
				if (sorts[i] != null && !sorts[i].isEmpty()) {
					orderMap.put(sorts[i], orders[i]);
				}
			}
		}
		kpage.setPageNo(page);// 页码
		kpage.setPageSize(rows);// 页大小
		kpage.setWhere(whereMap);// 查询条件
		kpage.setOrder(orderMap);// 排序参数
		return kpage;
	}

	/**
	 * 获取参数 Long数组
	 * 
	 * @param name
	 * @return
	 */
	public Long[] getParaValuesToLong(String name) {
		String[] values = getRequest().getParameterValues(name);
		if (values == null)
			return null;
		Long[] result = new Long[values.length];
		for (int i = 0; i < result.length; i++)
			result[i] = Long.parseLong(values[i]);
		return result;
	}

	/**
	 * 导出excel
	 * 
	 * @param head
	 * @param titles
	 * @param fields
	 * @param records
	 */
	@SuppressWarnings("unchecked")
	public void renderXls(String head, List<String> titles, List<String> fields, List<?> records) {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		if (records != null && records.size() > 0) {
			if (records.get(0) instanceof Record) {// jfinal的结果集
				for (Object record : records) {
					list.add(((Record) record).getColumns());
				}
			} else if (records.get(0) instanceof Model) {// 继承jfinal model 的dao类
				for (Object obj : records) {
					Record record = ((Model<?>) obj).toRecord();
					list.add(record.getColumns());
				}
			} else if (records.get(0) instanceof Map) {// 用户自定义map
				for (Object obj : records) {
					list.add((Map<String, Object>) obj);
				}
			} else {
				ExceptionUtils.ThrowProjectException("表格数据有误");
			}
		}
		File xlsFile = ExcelUtils.exportXls(head, titles, fields, list);
		renderFile(xlsFile);
	}

	public void renderXls(String head, String[] titles, String[] fields, List<?> records) {
		renderXls(head, Arrays.asList(titles), Arrays.asList(fields), records);
	}

	public void renderXls(String head, List<String> titles, List<?> records) {
		renderXls(head, titles, titles, records);
	}

	public void renderXls(String head, String[] titles, List<?> records) {
		renderXls(head, Arrays.asList(titles), records);
	}

	public void renderXls(String head, Map<String, String> fields_titles, List<?> records) {
		List<String> fields = new ArrayList<String>();
		List<String> titles = new ArrayList<String>();
		for (Map.Entry<String, String> entry : fields_titles.entrySet()) {
			fields.add(entry.getKey());
			titles.add(entry.getValue());
		}
		renderXls(head, titles, fields, records);
	}

	public void renderJson(Object obj) {
		super.renderJson(Jackson.getJson().toJson(obj));
	}

	private static <T> T createInstance(Class<T> objClass) {
		try {
			return objClass.newInstance();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@SuppressWarnings("unchecked")
	public <T> T getForm(Class<T> modelClass) {
		String modelName = modelClass.getSimpleName();
		modelName = StrKit.firstCharToLowerCase(modelName);
		Object temp = createInstance(modelClass);
		if (temp instanceof Model == false) {
			throw new IllegalArgumentException("getModel only support class of Model, using getBean for other class.");
		}
		Model<?> model = (Model<?>) temp;
		Table table = TableMapping.me().getTable(model.getClass());
		if (table == null) {
			throw new ActiveRecordException("The Table mapping of model: " + modelClass.getName() + " not exists or the ActiveRecordPlugin not start.");
		}

		String modelNameAndDot = StrKit.notBlank(modelName) ? modelName + "." : null;
		Map<String, String[]> parasMap = getRequest().getParameterMap();

		for (Entry<String, String[]> entry : parasMap.entrySet()) {
			String paraName = entry.getKey();
			String attrName;
			if (modelNameAndDot != null) {
				if (paraName.startsWith(modelNameAndDot)) {
					attrName = paraName.substring(modelNameAndDot.length());
					attrName = JFinalUtils.toDbName(attrName);
					System.out.println(attrName);
				} else {
					continue;
				}
			} else {
				attrName = paraName;
			}

			Class<?> colType = table.getColumnType(attrName);
			if (colType == null) {
				throw new ActiveRecordException("The model attribute " + attrName + " is not exists.");
			}

			try {
				String[] paraValueArray = entry.getValue();
				String paraValue = (paraValueArray != null && paraValueArray.length > 0) ? paraValueArray[0] : null;

				Object value = paraValue != null ? TypeConverter.convert(colType, paraValue) : null;
				model.set(attrName, value);
			} catch (Exception e) {
				throw new RuntimeException("Can not convert parameter: " + paraName, e);
			}
		}

		return (T) model;
	}

	public String getToken() {
		String tokenStr = getRequest().getHeader("AppToken");
		if(StringUtils.isEmpty(tokenStr)) {
			tokenStr = getRequest().getParameter("token");
		}
		return tokenStr;
	}

	// 当前登录用户的openid
	public String getOpenId() {
		String openId = RedisUtils.getInstance().get("ddbj_token:" + getToken(), "");
		return openId;
	}
}
