package net.roseboy.framework.core;

import java.sql.*;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class KDb extends com.jfinal.plugin.activerecord.Db {
	@SuppressWarnings("rawtypes")
	private static KModel<?> kmodel = new KModel();

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static KPage findPage(KPage kpage, String sql) {
		return kmodel.findPage(kpage, sql);
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static List<Map<String, Object>> find(KPage kpage, String sql) {
		return kmodel.find(kpage, sql);
	}

	// public static <T> T findById(Class<T> cls, Object id) {
	// @SuppressWarnings("unchecked")
	// Table table = JFinalUtils.getTable(() cls);
	// Record record = findById(table.getName(), table.getPrimaryKey()[0], id);
	// T obj = ClassKits.newInstance(cls);
	// String[] names = record.getColumnNames();
	// for (String name : names) {
	//
	// }
	// return obj;
	// }

	// 关闭数据库查询操作的相关对象
	public static void closeDB(Object... param) {
		if (param != null) {
			for (Object obj : param)
				try {
					if (obj instanceof ResultSet) {
						((ResultSet) obj).close();
					}
					if (obj instanceof PreparedStatement) {
						((PreparedStatement) obj).close();
					}
					if (obj instanceof Connection) {
						((Connection) obj).close();
					}
				} catch (SQLException e) {
					e.printStackTrace();
				}
		}
	}

	/**
	 * 设置预编译上下文对象参数的方法
	 * 
	 * @param pst
	 *            预编译上下文对象
	 * @param param
	 *            传入的参数对象《该数传入的可以是单个对象也可以是数组》
	 */
	private static void setParam(PreparedStatement pst, Object... param) {
		int length = param.length;
		for (int i = 0; i < length; i++) {
			try {
				pst.setObject(i + 1, param[i]);
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}

	}

	// ResultSet转List
	private static List<Map<String, Object>> convertList(ResultSet rs) throws SQLException {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		ResultSetMetaData md = rs.getMetaData();
		int columnCount = md.getColumnCount();
		while (rs.next()) {
			Map<String, Object> rowData = new LinkedHashMap<String, Object>();
			for (int i = 1; i <= columnCount; i++) {
				rowData.put(md.getColumnName(i), rs.getObject(i));
			}
			list.add(rowData);
		}
		return list;
	}

	// 执行查询语句
	public static List<Map<String, Object>> exeQuery(Connection conn, String sql, Object... param) {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		try {
			PreparedStatement perstmp = conn.prepareStatement(sql);
			setParam(perstmp, param);
			ResultSet rs = perstmp.executeQuery();
			list = convertList(rs);
			closeDB(rs, perstmp);
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return list;
	}

	// 字段类型信息
	public static Map<String, String> getMetaData(Connection conn, String tab) {
		Map<String, String> map = new LinkedHashMap<String, String>();
		try {
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery("select * from " + tab);
			ResultSetMetaData meta = rs.getMetaData();
			String type = "";
			for (int i = 1; i <= meta.getColumnCount(); i++) {
				type = meta.getColumnClassName(i);
				type = meta.getColumnClassName(i).substring(type.lastIndexOf(".") + 1);
				if ("Timestamp".equals(type)) {
					type = "Date";
				}
				map.put(meta.getColumnName(i), type);
			}
			KDb.closeDB(rs, stmt);
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return map;
	}

}
