package net.roseboy.framework.core;

import com.jfinal.plugin.activerecord.*;
import net.roseboy.framework.util.IdKit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;

import java.util.*;

public class KModel<T extends Model<T>> extends Model<T> {

	private static final long serialVersionUID = 1L;

	/**
	 * sql条件查询组装
	 * 
	 * @param resultList
	 * @param whereMap
	 * @return
	 */
	private String makeWhereSql(List<Object> resultList, LinkedHashMap<String, Object> whereMap, Boolean checkCol) {
		StringBuffer whereSql = new StringBuffer();
		whereSql.append("WHERE 1=1");
		for (Map.Entry<String, Object> entry : whereMap.entrySet()) {
			String[] ks = entry.getKey().split("\\.");
			String k1 = ks[0];// 操作符代码
			String k2 = ks[1];// 表字段名称
			if ("EQ".equalsIgnoreCase(k1)) {// 等于
				whereSql.append(" AND (" + makeWhereSql(k2, resultList, "=", entry.getValue(), checkCol) + ")");
			} else if ("LIKE".equalsIgnoreCase(k1)) {// 包含
				whereSql.append(" AND (" + makeWhereSql(k2, resultList, "LIKE", entry.getValue(), checkCol) + ")");
			} else if ("NE".equalsIgnoreCase(k1)) {// 不等于
				whereSql.append(" AND (" + makeWhereSql(k2, resultList, "!=", entry.getValue(), checkCol) + ")");
			} else if ("LT".equalsIgnoreCase(k1)) {// 小于
				whereSql.append(" AND (" + makeWhereSql(k2, resultList, "<", entry.getValue(), checkCol) + ")");
			} else if ("GT".equalsIgnoreCase(k1)) {// 大于
				whereSql.append(" AND (" + makeWhereSql(k2, resultList, ">", entry.getValue(), checkCol) + ")");
			} else if ("LE".equalsIgnoreCase(k1)) {// 小于等于
				whereSql.append(" AND (" + makeWhereSql(k2, resultList, "<=", entry.getValue(), checkCol) + ")");
			} else if ("GE".equalsIgnoreCase(k1)) {// 大于等于
				whereSql.append(" AND (" + makeWhereSql(k2, resultList, ">=", entry.getValue(), checkCol) + ")");
			} else if ("IN".equalsIgnoreCase(k1)) {// 包含在
				whereSql.append(" AND (" + makeWhereSql(k2, resultList, "IN", entry.getValue(), checkCol) + ")");
			} else if ("NOTIN".equalsIgnoreCase(k1)) {// 包含在
				whereSql.append(" AND (" + makeWhereSql(k2, resultList, "NOT IN", entry.getValue(), checkCol) + ")");
			} else {

			}
		}
		System.out.println(resultList);
		return whereSql.toString();
	}

	/**
	 * 多字段 or 查询 sql拼接
	 * 
	 * @param where
	 * @param resultList
	 * @param eq
	 * @param value
	 * @return
	 */
	private String makeWhereSql(String where, List<Object> resultList, String eq, Object value, Boolean checkCol) {
		Table table = null;
		if (checkCol) {
			table = JFinalUtils.getTable(super.getClass());
		}

		StringBuffer whereSql = new StringBuffer();
		where = where.replace("(", "").replace(")", "");
		if (where.contains(",")) {
			String[] wheres = where.split(",");
			for (String w : wheres) {
				w = JFinalUtils.toDbName(w);
				// (不检测 列名 并且 不含注入字符) 或者 (检测 列名 并且 列名存在)
				if ((!checkCol && this.CheckSqlCol(w)) || (checkCol && table.hasColumnLabel(w))) {
					whereSql.append("OR " + w + " " + eq + " ? ");
					if ("like".equalsIgnoreCase(eq)) {// like查询需加百分号
						resultList.add("%" + value + "%");
					} else {
						resultList.add(value);
					}
				}
			}
		} else {
			where = JFinalUtils.toDbName(where);
			if (table == null || table.hasColumnLabel(where)) {// 数据表有此字段
				if ("like".equalsIgnoreCase(eq)) {// like查询需加百分号
					whereSql.append("OR " + where + " " + eq + " ? ");
					resultList.add("%" + value + "%");
				} else if ("in".equalsIgnoreCase(eq) || "not in".equalsIgnoreCase(eq)) {// like查询需加百分号
					whereSql.append("   ");
					if (value.getClass().isArray()) {
						Object[] values = (Object[]) value;
						if (values.length > 0) {
							whereSql.append(where + " " + eq + " (");
							for (Object v : values) {
								resultList.add(v);
								whereSql.append("?,");
							}
							whereSql.deleteCharAt(whereSql.length() - 1);
						} else {
							whereSql.append("(1=1");
						}
					} else if (value instanceof List) {
						@SuppressWarnings("unchecked")
						List<Object> values = (List<Object>) value;
						if (values.size() > 0) {
							whereSql.append(where + " " + eq + " (");
							for (Object v : values) {
								resultList.add(v);
								whereSql.append("?,");
							}
							whereSql.deleteCharAt(whereSql.length() - 1);
						} else {
							whereSql.append("(1=1");
						}
					} else {
						whereSql.append("(1=1");
					}
					whereSql.append(")");
				} else {
					whereSql.append("OR " + where + " " + eq + " ? ");
					resultList.add(value);
				}
			}
		}
		whereSql.delete(0, 3);
		if (StringUtils.isEmpty(whereSql.toString().trim())) {
			whereSql.append("1=1");
		}
		return whereSql.toString();
	}

	/**
	 * sql排序组装
	 * 
	 * @param orderMap
	 * @param checkCol
	 *            是否检测列名存在
	 * @return
	 */
	private String makeOrderSql(LinkedHashMap<String, String> orderMap, Boolean checkCol) {
		Table table = null;
		if (checkCol) {
			table = JFinalUtils.getTable(super.getClass());
		}

		StringBuffer orderSql = new StringBuffer();
		orderSql.append(" ");
		for (Map.Entry<String, String> entry : orderMap.entrySet()) {
			String colname = entry.getKey();
			colname = JFinalUtils.toDbName(colname);
			// (不检测 列名 并且 不含注入字符) 或者 (检测 列名 并且 列名存在)
			if ((!checkCol && this.CheckSqlCol(colname)) || (checkCol && table.hasColumnLabel(colname))) {
				// 检测 排序类型
				if ("asc".equals(entry.getValue().toLowerCase()) || "desc".equals(entry.getValue().toLowerCase())) {
					orderSql.append("`");
					orderSql.append(colname);
					orderSql.append("` ");
					orderSql.append(entry.getValue());
					orderSql.append(",");
				}
			}
		}
		orderSql.deleteCharAt(orderSql.length() - 1);
		if (orderSql.length() > 0) {
			orderSql.insert(0, " ORDER BY");
		}
		return orderSql.toString();

	}

	/**
	 * 分页条件查询
	 * 
	 * @param kpage
	 * @return
	 */
	public KPage<T> findPage(KPage<T> kpage) {
		// [1].sql条件查询组装
		List<Object> paraList = new ArrayList<Object>();
		String whereSql = makeWhereSql(paraList, kpage.getWhere(), true);
		// [2].sql排序组装
		String orderSql = makeOrderSql(kpage.getOrder(), true);

		// [3]查询
		String table = JFinalUtils.getTable(super.getClass()).getName();
		Page<T> p = this.paginate(kpage.getPageNo(), kpage.getPageSize(), "SELECT *", "FROM " + table + " " + whereSql + orderSql, paraList.toArray());
		kpage.setRows(p.getList());
		kpage.setTotal(p.getTotalRow());
		kpage.setPageCount(p.getTotalPage());
		return kpage;
	}

	/**
	 * 分页条件查询,自定义sql
	 * 
	 * @param kpage
	 * @return
	 */
	public KPage<Map<String, Object>> findPage(KPage<Map<String, Object>> kpage, String sql) {
		// [1].sql条件查询组装
		List<Object> paraList = new ArrayList<Object>();
		String whereSql = makeWhereSql(paraList, kpage.getWhere(), false);

		// [2].sql排序组装
		String orderSql = makeOrderSql(kpage.getOrder(), false);

		// [3]查询
		Page<Record> page = Db.paginate(kpage.getPageNo(), kpage.getPageSize(), "SELECT *", "FROM (" + sql + ") _tab " + whereSql + orderSql, paraList.toArray());

		// [4]将record记录转换为map
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		for (Record r : page.getList()) {
			list.add(r.getColumns());
		}

		kpage.setRows(list);
		kpage.setTotal(page.getTotalRow());
		kpage.setPageCount(page.getTotalPage());
		return kpage;
	}

	/**
	 * 条件查询部不分页
	 * 
	 * @param kpage
	 * @return
	 */
	public List<T> find(KPage<T> kpage) {
		// [1].sql条件查询组装
		List<Object> paraList = new ArrayList<Object>();
		String whereSql = makeWhereSql(paraList, kpage.getWhere(), true);

		// [2].sql排序组装
		String orderSql = makeOrderSql(kpage.getOrder(), true);

		// [3]查询
		String table = JFinalUtils.getTable(super.getClass()).getName();
		List<T> list = this.find("SELECT * FROM " + table + " " + whereSql + orderSql, paraList.toArray());
		kpage.setRows(list);
		kpage.setTotal(list.size());
		return list;
	}

	/**
	 * 条件查询部不分页,自定义sql
	 * 
	 * @param kpage
	 * @return
	 */
	public List<Map<String, Object>> find(KPage<Map<String, Object>> kpage, String sql) {
		// [1].sql条件查询组装
		List<Object> paraList = new ArrayList<Object>();
		String whereSql = makeWhereSql(paraList, kpage.getWhere(), false);

		// [2].sql排序组装
		String orderSql = makeOrderSql(kpage.getOrder(), false);

		// [3]查询
		List<Record> list = Db.find("SELECT * FROM (" + sql + ") _tab " + whereSql + orderSql, paraList.toArray());

		// [4]将record记录转换为map
		List<Map<String, Object>> rlist = new ArrayList<Map<String, Object>>();
		for (Record r : list) {
			rlist.add(r.getColumns());
		}
		kpage.setRows(rlist);
		kpage.setTotal(rlist.size());
		return rlist;
	}

	/**
	 * 查询符合条件的第一个
	 * 
	 * @param kpage
	 * @return
	 */
	public T findFirst(KPage<T> kpage) {
		// [1].sql条件查询组装
		List<Object> paraList = new ArrayList<Object>();
		String whereSql = makeWhereSql(paraList, kpage.getWhere(), true);

		// [2].sql排序组装
		String orderSql = makeOrderSql(kpage.getOrder(), true);

		// [3]查询
		String table = JFinalUtils.getTable(super.getClass()).getName();
		return this.findFirst("SELECT * FROM `" + table + "` " + whereSql + orderSql + " LIMIT 1", paraList.toArray());
	}

	/**
	 * 查询所有
	 * 
	 * @return
	 */
	public List<T> findAll() {
		String table = JFinalUtils.getTable(super.getClass()).getName();
		return this.find("SELECT * FROM " + table + "");
	}

	/**
	 * 更新或者保存 有主键就更新，没有就保存
	 *
	 * @return
	 */
	public boolean saveOrUpdate() {
		String pk = JFinalUtils.getTable(this.getClass()).getPrimaryKey()[0];
		if (null == get(pk)) {
			return this.save();
		}
		return this.update();
	}

	/**
	 * sql简单注入检测：对字段名称简单检测
	 * 
	 * @return
	 */
	private Boolean CheckSqlCol(String sql) {
		// 包含以下符号都被怀疑是sql注入
		String[] no = { " ", ",", "`", "'", "=", "select" };
		sql = (sql == null ? "" : sql);
		sql = sql.toLowerCase();
		for (String s : no) {
			if (sql.contains(s)) {
				return false;
			}
		}
		return true;
	}

	public String makeSomeChar(int count) {
		if (count <= 0) {
			return "";
		}
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < count; ++i) {
			sb.append("?,");
		}
		sb.deleteCharAt(sb.length() - 1);
		return sb.toString();
	}

	public int deleteByProperty(String property, Object value) {
		String table = JFinalUtils.getTable(super.getClass()).getName();
		String sql = "DELETE FROM " + table + " WHERE " + property + " = ?";
		return Db.update(sql, value);
	}

	public boolean saveOrUpdate2() {
		Table table = JFinalUtils.getTable(this.getClass());
		String pk = JFinalUtils.getTable(this.getClass()).getPrimaryKey()[0];
		if (null == get(pk)) {
			set(pk, IdKit.UUID());
			if (table.hasColumnLabel("create_by")) {
				set("create_date", new Date());
				set("update_date", new Date());
				set("create_by", getLoginUsername());
				set("update_by", getLoginUsername());
			}
			return this.save();
		}
		if (table.hasColumnLabel("update_date")) {
			set("update_date", new Date());
			set("update_by", getLoginUsername());
		}
		return this.update();
	}

	public static String getLoginUsername() {
		String user="";
		try {
			Session session = SecurityUtils.getSubject().getSession();
			user = (String) session.getAttribute("C_USER_NAME");
		} catch (Exception e) {

		}
		return user;
	}

}