package net.roseboy.framework.core;

import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * 分页对象
 * 
 * @author roseboy
 *
 * @param <T>
 */
public class KPage<T> implements java.io.Serializable {
    private static final long serialVersionUID = 5660756779840525838L;
    public static final int DEFAULT_PAGE_SIZE = 30;
    public static final int DEFAULT_FIRST_NO = 1;

    private int pageNo = DEFAULT_FIRST_NO; // 当前页号
    private int pageSize = DEFAULT_PAGE_SIZE; // 每页的记录数
    private int pageCount; // 总页数
    private long total; // 总记录数
    private List<T> rows = new ArrayList<T>(); // 当前页中存放的记录
    private LinkedHashMap<String, String> order = new LinkedHashMap<String, String>();// 排序键值对<排序字段,排序方式>
    private LinkedHashMap<String, Object> where = new LinkedHashMap<String, Object>();// 条件键值对<字段,值>
    private Object extData;

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageCount() {
        return pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getRows() {
        return rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public void setPageRecord(Page<Record> page) {
        List<T> list = new ArrayList<>();
        this.setTotal(page.getTotalRow());
        for (Record record : page.getList()) {
            @SuppressWarnings("unchecked")
            T m = (T)record.getColumns();
            list.add(m);
        }
        this.rows = list;
    }

    public LinkedHashMap<String, String> getOrder() {
        return order;
    }

    public void setOrder(LinkedHashMap<String, String> order) {
        this.order = order;
    }

    public LinkedHashMap<String, Object> getWhere() {
        return where;
    }

    public void setWhere(LinkedHashMap<String, Object> where) {
        this.where = where;
    }

    public Object getExtData() {
        return extData;
    }

    public void setExtData(Object extData) {
        this.extData = extData;
    }

    /**
     * 添加查询条件
     * 
     * @param field 格式：eq.name
     * @param value 值
     */
    public KPage<T> addWhere(String field, Object value) {
        this.where.put(field, value);
        return this;
    }

    /**
     * 添加排序
     * 
     * @param field 排序字段
     * @param asc asc|desc
     */
    public KPage<T> addOrder(String field, String asc) {
        this.order.put(field, asc);
        return this;
    }

}
