package net.roseboy.framework.core;

import net.roseboy.framework.util.ClassKits;
import net.roseboy.framework.util.ExceptionUtils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

/**
 * service基础类
 * 
 * @author roseboy
 *
 * @param <M>
 */
public abstract class KService<M extends KModel<M>> {

	protected M dao = null;

	@SuppressWarnings("unchecked")
	public KService() {
		Class<M> modelClass = null;
		Type t = ClassKits.getUsefulClass(getClass()).getGenericSuperclass();
		if (t instanceof ParameterizedType) {
			Type[] p = ((ParameterizedType) t).getActualTypeArguments();
			modelClass = (Class<M>) p[0];
		}
		if (modelClass == null) {
			ExceptionUtils.ThrowProjectException("can not get parameterizedType in KService");
		}
		dao = ClassKits.newInstance(modelClass).dao();
	}

	public M getDao() {
		return dao;
	}

	/**
	 * 根据id查找
	 * 
	 * @param id
	 * @return
	 */
	public M findById(Object id) {
		return dao.findById(id);
	}

	/**
	 * 查找全部数据
	 *
	 * @return
	 */
	public List<M> findAll() {
		return dao.findAll();
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	public boolean deleteById(Object id) {
		return dao.deleteById(id);
	}

	public boolean deleteByIds(String[] ids) {
		int i = 0;
		for (String id : ids) {
			if (dao.deleteById(id)) {
				i++;
			}
		}
		return ids.length == i;
	}

	public int deleteByProperty(String property, Object value) {
		return dao.deleteByProperty(property, value);
	}

	/**
	 * 删除
	 *
	 * @param model
	 * @return
	 */
	public boolean delete(M model) {
		return model.delete();
	}

	/**
	 * 保存到数据库
	 *
	 * @param model
	 * @return
	 */
	public boolean save(M model) {
		return model.save();
	}

	/**
	 * 保存或更新
	 *
	 * @param model
	 * @return
	 */
	public boolean saveOrUpdate(M model) {
		return model.saveOrUpdate();
	}

	/**
	 * 更新
	 *
	 * @param model
	 * @return
	 */
	public boolean update(M model) {
		return model.update();
	}

	/**
	 * 根据属性查询一个
	 * 
	 * @param property
	 * @param value
	 * @return
	 */
	public M findOneByProperty(String property, Object value) {
		KPage<M> kpage = new KPage<M>();
		kpage.addWhere("eq." + property, value);
		return dao.findFirst(kpage);
	}

	/**
	 * 根据属性查询一串
	 * 
	 * @param property
	 * @param value
	 * @return
	 */
	public List<M> findByProperty(String property, Object value) {
		KPage<M> kpage = new KPage<M>();
		kpage.addWhere("eq." + property, value);
		return dao.find(kpage);
	}

	/**
	 * 分页查询
	 * 
	 * @param kpage
	 * @return
	 */
	public KPage<M> findPage(KPage<M> kpage) {
		return dao.findPage(kpage);
	}

	/**
	 * 查找
	 * 
	 * @param kpage
	 * @return
	 */
	public List<M> find(KPage<M> kpage) {
		return dao.find(kpage);
	}

	// oracle保存或添加
	public boolean SAVE(M model) {
		return model.saveOrUpdate2();
	}
}
