package net.roseboy.framework.jfinal;

import net.roseboy.framework.core.JFinalUtils;
import net.roseboy.framework.core.KDb;

import java.io.*;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JfinalModelGenerator {
	public static final String user = "root";
	public static final String pass = "root";
	public static final String server = "127.0.0.1:3306";
	public static final String DbName = "test";
	public static final String PackageName = "net.roseboy.project.model";
	public static final String Path = "D:\\";

	public static void main(String[] args) {
		List<String> list = new ArrayList<String>();
		// list.add("tb_area,Area,区域Model");
		// list.add("tb_collector,Collector,采集器Model");
		// list.add("tb_radio,Radio,电台Model");
		// list.add("tb_responsible,Responsible,责任人Model");
		// list.add("tb_message_log,Message,报文记录Model");
		// list.add("tb_operate_log,Operate,报警操作记录Model");
		// list.add("tb_warning_log,Warninglog,报警记录Model");
		// list.add("tb_warning_msg,Warningmsg,报警通知Model");
		//list.add("tb_collector_log,Collectorlog,采集器上线记录Model");
		list.add("tb_planter,Planter,场区人员Model");
		go(list, true);
	}

	public static void go(List<String> list, boolean override) {
		Connection conn = getConnection();
		for (String s : list) {
			String[] ss = s.split(",");
			makeCode(conn, DbName, ss[0], ss[1], ss[2]);
		}
	}

	private static void makeCode(Connection conn, String db, String tb, String cls, String memo) {

		StringBuffer code = new StringBuffer();
		code.append("package " + PackageName + ".base;\n");
		code.append("\n");
		code.append("import java.util.Date;\n");
		code.append("import java.math.BigInteger;\n");
		code.append("import java.math.BigDecimal;\n");
		code.append("import com.jfinal.plugin.activerecord.IBean;\n");
		code.append("import net.roseboy.framework.core.KModel; \n\n");
		code.append("//自动生成，请勿更改\n");
		code.append("//" + memo + "\n");
		code.append("public abstract class Base" + cls + "<M extends Base" + cls + "<M>> extends KModel<M> implements IBean {\n");
		code.append("\tprivate static final long serialVersionUID = 1L; \n");
		code.append("\n");
		Map<String, String> mapType = KDb.getMetaData(conn, db + "." + tb);
		Map<String, String> mapRem = getRemData(conn, tb, db);

		// 属性
		for (Map.Entry<String, String> entry : mapType.entrySet()) {
			code.append("\tprivate " + entry.getValue() + " " + JFinalUtils.toJavaName(entry.getKey(), null) + ";//" + mapRem.get(entry.getKey()) + "\n");
		}

		code.append("\n");
		String ctype = "";
		String cname = "";
		// 生成getter、setter
		for (Map.Entry<String, String> entry : mapType.entrySet()) {
			cname = entry.getKey();
			ctype = entry.getValue();
			System.out.println(cname + "==>" + ctype);
			code.append("\tpublic void " + JFinalUtils.toJavaName(cname, "set") + "(" + ctype + " " + cname + "){\n");
			code.append("\t\tthis." + JFinalUtils.toJavaName(cname, null) + " = " + cname + ";\n");
			code.append("\t\tset(\"" + cname + "\",this." + JFinalUtils.toJavaName(cname, null) + ");\n");
			code.append("\t}\n");
			code.append("\n");
			String str = "";
			if ("Integer".equals(ctype)) {
				str = "getInt";
			} else if ("String".equals(ctype) || "Double".equals(ctype)) {
				str = "get";
			} else {
				str = "get" + ctype;
			}
			code.append("\tpublic " + ctype + " " + JFinalUtils.toJavaName(cname, "get") + "(){\n");
			code.append("\t\tthis." + JFinalUtils.toJavaName(cname, null) + " = " + str + "(\"" + cname + "\");\n");
			code.append("\t\treturn this." + JFinalUtils.toJavaName(cname, null) + ";\n");
			code.append("\t}\n");
			code.append("\n");
		}
		code.append("}");
		writeData(Path + "base\\", code.toString(), "Base" + cls, true);

		code = new StringBuffer();
		code.append("package " + PackageName + ";\n");
		code.append("\n");
		code.append("import net.roseboy.framework.jfinal.TableBind;\n");
		code.append("import " + PackageName + ".base.Base" + cls + ";\n");
		code.append("\n");
		code.append("//" + memo + "\n");
		code.append("@TableBind(tabName=\"" + tb + "\")\n");
		code.append("public class " + cls + " extends Base"+cls+"<"+cls+">{ \n");
		code.append("\tprivate static final long serialVersionUID = 1L; \n");
		code.append("\tpublic static " + cls + " dao = new " + cls + "();\n");
		code.append("\n\n\n\n");
		code.append("}");
		writeData(Path, code.toString(), cls, true);
	}

	// 字段注释信息
	private static Map<String, String> getRemData(Connection conn, String tab, String db) {
		Map<String, String> map = new HashMap<String, String>();
		String sql_col = "SELECT TABLE_SCHEMA,TABLE_NAME,COLUMN_NAME,COLUMN_DEFAULT,IS_NULLABLE,COLUMN_TYPE,COLUMN_KEY,COLUMN_COMMENT from columns where table_name=? AND TABLE_SCHEMA=? ORDER BY ORDINAL_POSITION";
		List<Map<String, Object>> list = KDb.exeQuery(conn, sql_col, tab, db);
		for (Map<String, Object> map2 : list) {
			map.put(map2.get("COLUMN_NAME").toString(), map2.get("COLUMN_COMMENT").toString());
		}
		return map;
	}

	/*
	 * =========================================================================
	 */

	public static void writeData(String path, String message, String className, boolean foce) {
		File fileDir = new File(path);
		if (!fileDir.exists()) {
			fileDir.mkdirs();
		}
		try {
			File f = new File(fileDir, className + ".java");
			if (f.exists() && !foce) {
				System.out.println("\"" + f.getAbsolutePath() + "\" Already Exists");
			} else {
				FileOutputStream fos = new FileOutputStream(f);
				OutputStreamWriter osw = new OutputStreamWriter(fos);
				BufferedWriter bw = new BufferedWriter(osw);
				bw.write(message);
				bw.flush();
				bw.getClass();
				osw.close();
				fos.close();
				System.out.println("\"" + f.getAbsolutePath() + "\" WriteSucess");
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	public static Connection getConnection() {
		String url = "jdbc:mysql://" + server + "/information_schema?user=" + user + "&password=" + pass + "&useUnicode=true&characterEncoding=utf-8";
		Connection conn = null;
		try {
			Class.forName("com.mysql.jdbc.Driver").newInstance();
			conn = DriverManager.getConnection(url);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return conn;
	}

}