package net.roseboy.framework.util;

import net.roseboy.framework.util.JsonUtils;

import java.util.List;
import java.util.Map;

public class JsonGet {
    private Map<String, Object> map = null;

    public static JsonGet New(Map<String, Object> map) {
        return new JsonGet(map);
    }

    public static JsonGet New(String jsonStr) {
        Map<String,Object> json= JsonUtils.decode(jsonStr,Map.class);
        return new JsonGet(json);
    }

    private JsonGet(Map<String, Object> map) {
        this.map = map;
    }

    public String get(String key) {
        Map<String, Object> map = this.map;
        if (map == null) {
            return null;
        }
        String[] keys = key.split("\\.");
        for (int i = 0; i < keys.length; i++) {
            String k = keys[i];
            if (i == keys.length - 1) {
                if (map.get(k) != null) {
                    return String.valueOf(map.get(k));
                }
            }
            String kk = k;
            if (kk.contains("[")) {
                kk = k.substring(0, k.indexOf("["));
            }
            if (map.get(kk) != null && map.get(kk) instanceof Map) {
                map = (Map<String, Object>) map.get(kk);
            } else if (map.get(kk) != null && map.get(kk) instanceof List) {
                List<Object> list = (List<Object>) map.get(kk);
                String index = k.substring(k.indexOf("[") + 1);
                index = index.replace("]", "");
                map = (Map<String, Object>) list.get(Integer.valueOf(index));
            } else {
                return null;
            }
        }
        return null;
    }

    public Object getObj(String key) {
        Map<String, Object> map = this.map;
        if (map == null) {
            return null;
        }

        String[] keys = key.split("\\.");

        for (int i = 0; i < keys.length; i++) {
            String k = keys[i];
            if (i == keys.length - 1) {
                if (map.get(k) != null) {
                    return map.get(k);
                }
            }
            String kk = k;
            if (kk.contains("[")) {
                kk = k.substring(0, k.indexOf("["));
            }
            if (map.get(kk) != null && map.get(kk) instanceof Map) {
                map = (Map<String, Object>) map.get(kk);
            } else if (map.get(kk) != null && map.get(kk) instanceof List) {
                List<Object> list = (List<Object>) map.get(kk);
                String index = k.substring(k.indexOf("[") + 1);
                index = index.replace("]", "");
                map = (Map<String, Object>) list.get(Integer.valueOf(index));
            } else {
                return null;
            }
        }
        return null;
    }

    public String get(String key, String dv) {
        String v = get(key);
        return v == null ? dv : v;
    }
}
