package net.roseboy.framework.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/**
 * 排序工具
 */
public class SortUtils {
    public static void sort(List<Map<String, Object>> list, String... names) {
        Collections.sort(list, new Comparator<Map<String, Object>>() {
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                for (String namefield : names) {
                    String name = namefield.split(",")[0];
                    String sort = namefield.split(",")[1];
                    if (o1.get(name) instanceof Integer) {
                        Integer v1 = (Integer)o1.get(name);
                        Integer v2 = (Integer)o2.get(name);
                        v1 = v1 == null ? 0 : v1;
                        v2 = v2 == null ? 0 : v2;
                        if (!v1.equals(v2)) {
                            if ("asc".equalsIgnoreCase(sort)) {
                                return v1.compareTo(v2);
                            } else {
                                return v2.compareTo(v1);
                            }
                        }
                    } else {
                        String v1 = String.valueOf(o1.get(name));
                        String v2 = String.valueOf(o2.get(name));
                        if (!v1.equals(v2)) {
                            if ("asc".equalsIgnoreCase(sort)) {
                                return v1.compareTo(v2);
                            } else {
                                return v2.compareTo(v1);
                            }
                        }
                    }

                }
                return 0;
            }
        });
    }

}
