package net.roseboy.framework.util;

import com.jfinal.kit.LogKit;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 延时任务执行
 *
 * @author Mr.K
 */
public class TaskQueue implements Runnable {
    private static Map<Long, Runnable> taskQueue = new ConcurrentHashMap<>();

    /**
     * 某个时刻运行
     *
     * @param date   时间
     * @param runjob 任务
     */
    public static void runAt(Date date, Runnable runjob) {
        put(date == null ? System.currentTimeMillis() : date.getTime(), runjob);
    }

    /**
     * 几秒之后执行
     *
     * @param millis 时间/秒
     * @param runjob 任务
     */
    public static void runAfter(int millis, Runnable runjob) {
        put(System.currentTimeMillis() + (millis * 1000), runjob);
    }

    /**
     * 添加任务
     *
     * @param millis 秒
     * @param runjob 任务
     */
    private static void put(long millis, Runnable runjob) {
        while (taskQueue.containsKey(millis)) {
            millis++;
        }
        LogKit.info("任务添加:" + millis + ":" + runjob.toString());
        taskQueue.put(millis, runjob);
    }

    /**
     * 根据标记移除任务
     *
     * @param tag 标记
     */
    public static void removeByTag(String tag) {
        if (TaskQueue.count() == 0) {
            return;
        }
        Iterator<Map.Entry<Long, Runnable>> it = taskQueue.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Runnable> entry = it.next();
            if (tag.equals(entry.getValue().toString())) {
                it.remove();
            }
        }
    }

    /**
     * 获取任务数量
     *
     * @return 任务数量
     */
    public static int count() {
        return taskQueue.size();
    }

    /**
     * 监测一下有没有要执行的任务
     */
    private void runJobs() {
        long currTime = System.currentTimeMillis();

        Iterator<Map.Entry<Long, Runnable>> it = taskQueue.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Runnable> entry = it.next();
            if (entry.getKey() - currTime <= 0) {
                try {
                    new Thread(entry.getValue()).start();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                it.remove();
            }
        }
    }

    /**
     * 启动
     */
    public static void start() {
        new Thread(new TaskQueue()).start();
    }

    /**
     * 多线程执行任务
     */
    @Override
    public void run() {
        for (; ; ) {
            try {
                Thread.sleep(1000);
            } catch (Exception e) {
            }
            runJobs();
        }
    }

    /**
     * 测试
     *
     * @param args
     */
    public static void main(String[] args) {
        TaskQueue.start();
        TaskQueue.runAfter(10, new TestJob());
    }
}

/**
 * 测试任务
 */
class TestJob implements Runnable {
    @Override
    public void run() {
        System.out.println("test......." + System.currentTimeMillis());
        TaskQueue.runAfter(5, new TestJob());
    }
}
