package net.roseboy.framework.util;

import org.apache.commons.io.FileUtils;

import java.io.*;

public class TxtUtils {
	public static String readTxtFile(String filePath) {
		return readTxtFile(filePath, "UTF-8");
	}

	public static String readTxtFile(String filePath, String encoding) {
		StringBuffer sb = new StringBuffer("");
		try {
			File file = new File(filePath);
			if (file.isFile() && file.exists()) { // 判断文件是否存在
				InputStreamReader read = new InputStreamReader(new FileInputStream(file), encoding);// 考虑到编码格式
				BufferedReader bufferedReader = new BufferedReader(read);
				String lineTxt = null;
				while ((lineTxt = bufferedReader.readLine()) != null) {
					sb.append(lineTxt);
				}
				read.close();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return sb.toString();

	}

	public static void writeTxtFile(String txt, String filePath) {
		try {
			File writename = new File(filePath);
			writename.createNewFile(); // 创建新文件
			BufferedWriter out = new BufferedWriter(new FileWriter(writename));
			out.write(txt); // \r\n即为换行
			out.flush(); // 把缓存区内容压入文件
			out.close(); // 最后记得关闭文件
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void deleteAllFilesOfDir(File path) {
		if (!path.exists())
			return;
		if (path.isFile()) {
			path.delete();
			return;
		}
		File[] files = path.listFiles();
		for (int i = 0; i < files.length; i++) {
			deleteAllFilesOfDir(files[i]);
		}
		path.delete();
	}

	public static String convertFileSize(long size) {
		long kb = 1024;
		long mb = kb * 1024;
		long gb = mb * 1024;

		if (size >= gb) {
			return String.format("%.1f GB", (float) size / gb);
		} else if (size >= mb) {
			float f = (float) size / mb;
			return String.format(f > 100 ? "%.0f MB" : "%.1f MB", f);
		} else if (size >= kb) {
			float f = (float) size / kb;
			return String.format(f > 100 ? "%.0f KB" : "%.1f KB", f);
		} else
			return String.format("%d B", size);
	}

	/**
	 * 拷贝文件夹
	 * 
	 * @param src
	 * @param des
	 */
	public static void copy(String src, String des) {
		copy(src, des, true);

	}

	/**
	 * 拷贝文件夹
	 * 
	 * @param src
	 * @param des
	 * @param override
	 *            是否覆盖
	 */
	public static void copy(String src, String des, boolean override) {
		File file1 = new File(src);
		File[] fs = file1.listFiles();
		File file2 = new File(des);
		if (!file2.exists()) {
			file2.mkdirs();
		}
		for (File f : fs) {
			if (f.isFile()) {
				fileCopy(f.getPath(), des + "\\" + f.getName(), override); // 调用文件拷贝的方法
			} else if (f.isDirectory()) {
				copy(f.getPath(), des + "\\" + f.getName(), override);
			}
		}

	}

	/**
	 * 文件拷贝的方法
	 */
	public static void fileCopy(String src, String des) {
		fileCopy(src, des, true);
	}

	public static void fileCopy(String src, String des, boolean override) {
		// 原文件不存在，直接退出
		File srcFile = new File(src);
		if (!srcFile.exists()) {
			return;
		}

		File desFile = new File(des);
		if (desFile.exists()) {// 存在
			if (!override) {// 不能覆盖
				return;
			}
		}

		try {
			FileUtils.copyFile(srcFile, desFile);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
