package net.roseboy.framework.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;

public class TypeConverter {
	private static final String timeStampPattern = "yyyy-MM-dd HH:mm:ss";
	private static final String datePattern = "yyyy-MM-dd";
	private static final int dateLen = datePattern.length();

	public static final Object convert(Class<?> type, String s) throws ParseException {
		// mysql type: varchar, char, enum, set, text, tinytext, mediumtext, longtext
		if (type == String.class) {
			return ("".equals(s) ? null : s); // 鐢ㄦ埛鍦ㄨ〃鍗曞煙涓病鏈夎緭鍏ュ唴瀹规椂灏嗘彁浜よ繃鏉� "", 鍥犱负娌℃湁杈撳叆,鎵�浠ヨ杞垚 null.
		}
		s = s.trim();
		if ("".equals(s)) { // 鍓嶉潰鐨� String璺宠繃浠ュ悗,鎵�鏈夌殑绌哄瓧绗︿覆鍏ㄩ兘杞垚 null, 杩欐槸鍚堢悊鐨�
			return null;
		}
		// 浠ヤ笂涓ょ鎯呭喌鏃犻渶杞崲,鐩存帴杩斿洖, 娉ㄦ剰, 鏈柟娉曚笉鎺ュ彈null涓� s 鍙傛暟(缁忔祴璇曟案杩滀笉鍙兘浼犳潵null,
		// 鍥犱负鏃犺緭鍏ヤ紶鏉ョ殑涔熸槸"")

		// mysql type: int, integer, tinyint(n) n > 1, smallint, mediumint
		if (type == Integer.class || type == int.class) {
			return Integer.parseInt(s);
		}

		// mysql type: bigint
		if (type == Long.class || type == long.class) {
			return Long.parseLong(s);
		}

		// java.util.Date 绫诲瀷涓撲负浼犵粺 java bean 甯︽湁璇ョ被鍨嬬殑 setter 鏂规硶杞崲鍋氬噯澶囷紝涓囦笉鍙幓鎺�
		// 缁忔祴璇� JDBC 涓嶄細杩斿洖 java.util.Data 绫诲瀷銆俲ava.sql.Date,
		// java.sql.Time,java.sql.Timestamp 鍏ㄩ儴鐩存帴缁ф壙鑷� java.util.Data, 鎵�浠�
		// getDate鍙互杩斿洖杩欎笁绫绘暟鎹�
		if (type == java.util.Date.class) {
			if (s.length() > dateLen) { // if (x < timeStampLen) 鏀圭敤 datePattern 杞崲锛屾洿鏅鸿兘
				// Timestamp format must be yyyy-mm-dd hh:mm:ss[.fffffffff]
				// return new java.util.Date(java.sql.Timestamp.valueOf(s).getTime()); // error
				// under jdk 64bit(maybe)
				return new SimpleDateFormat(timeStampPattern).parse(s);
			} else {
				// return new java.util.Date(java.sql.Date.valueOf(s).getTime()); // error under
				// jdk 64bit
				return new SimpleDateFormat(datePattern).parse(s);
			}
		}

		// mysql type: date, year
		if (type == java.sql.Date.class) {
			if (s.length() > dateLen) { // if (x < timeStampLen) 鏀圭敤 datePattern 杞崲锛屾洿鏅鸿兘
				// return new java.sql.Date(java.sql.Timestamp.valueOf(s).getTime()); // error
				// under jdk 64bit(maybe)
				return new java.sql.Date(new SimpleDateFormat(timeStampPattern).parse(s).getTime());
			} else {
				// return new java.sql.Date(java.sql.Date.valueOf(s).getTime()); // error under
				// jdk 64bit
				return new java.sql.Date(new SimpleDateFormat(datePattern).parse(s).getTime());
			}
		}

		// mysql type: time
		if (type == java.sql.Time.class) {
			return java.sql.Time.valueOf(s);
		}

		// mysql type: timestamp, datetime
		if (type == java.sql.Timestamp.class) {
			if (s.length() > dateLen) {
				return java.sql.Timestamp.valueOf(s);
			} else {
				return new java.sql.Timestamp(new SimpleDateFormat(datePattern).parse(s).getTime());
			}
		}

		// mysql type: real, double
		if (type == Double.class || type == double.class) {
			return Double.parseDouble(s);
		}

		// mysql type: float
		if (type == Float.class || type == float.class) {
			return Float.parseFloat(s);
		}

		// mysql type: bit, tinyint(1)
		if (type == Boolean.class || type == boolean.class) {
			String value = s.toLowerCase();
			if ("1".equals(value) || "true".equals(value)) {
				return Boolean.TRUE;
			} else if ("0".equals(value) || "false".equals(value)) {
				return Boolean.FALSE;
			} else {
				throw new RuntimeException("Can not parse to boolean type of value: " + s);
			}
		}

		// mysql type: decimal, numeric
		if (type == java.math.BigDecimal.class) {
			return new java.math.BigDecimal(s);
		}

		// mysql type: unsigned bigint
		if (type == java.math.BigInteger.class) {
			return new java.math.BigInteger(s);
		}

		// mysql type: binary, varbinary, tinyblob, blob, mediumblob, longblob. I have
		// not finished the test.
		if (type == byte[].class) {
			return s.getBytes();
		}

		throw new RuntimeException(
				type.getName() + " can not be converted, please use other type of attributes in your model!");
	}
}
