package net.roseboy.framework.util;

import com.jfinal.kit.PropKit;
import com.jfinal.plugin.ehcache.CacheKit;
import net.dongliu.requests.Requests;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;

public class WxKit {
	final static String ak = "wxbf6e8a67555468c0";
	final static String as = "14fb172cb981ce436fa71794a71f5cad";

	/**
	 * 获取微信js配置
	 * 
	 * @param url
	 * @return
	 */
	public static Map<String, String> getWxJsConfig(String url) {
		String accessToken = getAccessToken();
		String jsapi_ticket = getJsApiTicket(accessToken);
		Map<String, String> ret = getJsAPImap(jsapi_ticket, url);
		return ret;
	}

	// 获取accessToken
	public static String getAccessToken() {
		String token = CacheKit.get("wechat", "wx.accesstoken");
		if (token == null) {// 超时
			String appid = PropKit.get("wx.appid");
			String secret = PropKit.get("wx.appsecret");
			String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + appid + "&secret=" + secret;
			String json = Requests.get(url).send().readToText();
			System.out.println("HTTP==>" + json);
			@SuppressWarnings("unchecked")
			Map<String, Object> map = JsonUtils.decode(json, Map.class);
			if (map.get("errcode") != null && ((Integer) map.get("errcode")) > 0) {
				ExceptionUtils.ThrowProjectException("AccessToken获取失败:" + map.get("errmsg"));
			} else {
				token = (String) map.get("access_token");
				CacheKit.put("wechat", "wx.accesstoken", token);
			}
		}
		return token;
	}

	// 获取jsApiTicket
	private static String getJsApiTicket(String accesstoken) {
		String ticket = CacheKit.get("wechat", "wx.jsapiticket");
		if (ticket == null) {// 超时
			String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=" + accesstoken;
			String json = Requests.get(url).send().readToText();
			System.out.println("HTTP==>" + json);
			@SuppressWarnings("unchecked")
			Map<String, String> map = JsonUtils.decode(json, Map.class);
			if ("ok".equals(map.get("errmsg"))) {
				ticket = map.get("ticket");
				CacheKit.put("wechat", "wx.jsapiticket", ticket);
			} else {
				ExceptionUtils.ThrowProjectException("JsApiTicket获取失败:" + map.get("errmsg"));
			}
		}
		return ticket;
	}

	public static Map<String, String> getJsAPImap(String jsapi_ticket, String url) {
		Map<String, String> ret = new HashMap<String, String>();
		String nonce_str = UUID.randomUUID().toString();
		String timestamp = Long.toString(System.currentTimeMillis() / 1000);
		String string1;
		String signature = "";

		// 注意这里参数名必须全部小写，且必须有序
		string1 = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonce_str + "&timestamp=" + timestamp + "&url=" + url;

		try {
			MessageDigest crypt = MessageDigest.getInstance("SHA-1");
			crypt.reset();
			crypt.update(string1.getBytes("UTF-8"));
			signature = byteToHex(crypt.digest());
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}

		ret.put("url", url);
		ret.put("jsapi_ticket", jsapi_ticket);
		ret.put("nonceStr", nonce_str);
		ret.put("timestamp", timestamp);
		ret.put("signature", signature);
		ret.put("appid", PropKit.get("wx.appid"));
		return ret;
	}

	private static String byteToHex(final byte[] hash) {
		Formatter formatter = new Formatter();
		for (byte b : hash) {
			formatter.format("%02x", b);
		}
		String result = formatter.toString();
		formatter.close();
		return result;
	}

	/**
	 * 根据code获取accesstoken
	 * 
	 * @param code
	 * @return
	 */
	public static Map<String, String> getWebAccessToken(String code) {
		Map<String, String> rmap = new HashMap<String, String>();
		String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + PropKit.get("wx.appid") + "&secret=" + PropKit.get("wx.appsecret") + "&code=" + code + "&grant_type=authorization_code";
		String json = Requests.get(url).send().readToText();
		System.out.println("HTTP==>" + json);
		@SuppressWarnings("unchecked")
		Map<String, String> map = JsonUtils.decode(json, Map.class);
		if (map.containsKey("access_token")) {
			rmap.put("token", map.get("access_token"));
			rmap.put("opid", map.get("openid"));
			rmap.put("scope", map.get("scope"));
		} else {
			ExceptionUtils.ThrowProjectException("OpenID获取失败:" + map.get("errmsg"));
		}
		return rmap;
	}

	/**
	 * 根据accesstoken获取为新用户信息
	 * 
	 * @return
	 */
	public static Map<String, String> getWxUserInfo(String token, String opid) {
		Map<String, String> rmap = new HashMap<String, String>();
		String url = "https://api.weixin.qq.com/sns/userinfo?access_token=" + token + "&openid=" + opid + "&lang=zh_CN";
		String json = Requests.get(url).send().readToText();
		System.out.println("HTTP==>" + json);
		@SuppressWarnings("unchecked")
		Map<String, String> map = JsonUtils.decode(json, Map.class);
		if (map.containsKey("openid")) {
			rmap.put("openid", map.get("openid"));
			rmap.put("nick", map.get("nickname"));
			rmap.put("sex", String.valueOf(map.get("sex")));
			rmap.put("img", map.get("headimgurl"));
			rmap.put("country", map.get("country"));
			rmap.put("province", map.get("province"));
			rmap.put("city", map.get("city"));
		} else {
			ExceptionUtils.ThrowProjectException("用户信息获取失败:" + map.get("errmsg"));
		}
		return rmap;
	}

	/**
	 * hash加密
	 * 
	 * @param str
	 * @return
	 */
	public static String Hash(String str) {
		str += "roseboy#956992888";
		String signature = "";
		try {
			MessageDigest crypt = MessageDigest.getInstance("SHA-1");
			crypt.reset();
			crypt.update(str.getBytes("UTF-8"));
			signature = byteToHex(crypt.digest());
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return signature;
	}

	/**
	 * 发送模板消息
	 */
	public static Boolean sendTemplateMsg(String accessToken, String tplId, String openid, String url, LinkedHashMap<String, String> keyMap) {
		Map<String, Object> map = new LinkedHashMap<String, Object>();
		map.put("touser", openid);
		map.put("template_id", tplId);
		map.put("url", url);
		Map<String, Object> data = new LinkedHashMap<String, Object>();
		int i = 0;
		for (Map.Entry<String, String> entry : keyMap.entrySet()) {
			Map<String, Object> keynote = new HashMap<String, Object>();
			keynote.put("color", entry.getValue());
			keynote.put("value", entry.getKey());
			if (i == 0) {
				data.put("first", keynote);
			} else if (i == keyMap.size() - 1) {
				data.put("remark", keynote);
			} else {
				data.put("keynote" + i, keynote);
			}
			i++;
		}
		map.put("data", data);

		String json = JsonUtils.toJson(map);
		String apiurl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
		json = Requests.post(apiurl).body(json).send().readToText();
		System.out.println("HTTP==>" + json);
		@SuppressWarnings("unchecked")
		Map<String, Object> jsonmap = JsonUtils.decode(json, Map.class);
		if (jsonmap.get("errcode") != null && ((Integer) jsonmap.get("errcode")) > 0) {
			return false;
		}
		return true;
	}

	public static void main(String[] args) {
		String at = getAccessToken();

		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("优惠券到期提醒", "#f00");
		map.put("111", "#f00");
		map.put("222", "#f00");
		map.put("333", "#f00");
		map.put("最后一行", "#f00");
		boolean r = sendTemplateMsg(at, "888", "777", "http://baidu.com", map);
		System.out.println(r);
	}

}
