/*
 * Decompiled with CFR 0.152.
 */
package net.seesharpsoft.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.seesharpsoft.UnhandledSwitchCaseException;
import net.seesharpsoft.util.SharpIO;
import net.seesharpsoft.util.Tokenizer;

public class Lexer<T> {
    private final Tokenizer<T> tokenizer;
    private Set<State> states = new HashSet<State>();
    private State initialState;
    private State currentState;

    public Lexer(Tokenizer<T> tokenizer) {
        this.tokenizer = tokenizer;
        this.tokenizer.addValidator(new TokenValidator());
    }

    public Lexer() {
        this(new Tokenizer());
    }

    protected Tokenizer<T> getTokenizer() {
        return this.tokenizer;
    }

    public State addState(String name) {
        Objects.requireNonNull(name, "state name must not be null!");
        State state = new State(name);
        this.states.add(state);
        if (this.getInitialState() == null) {
            this.setInitialState(state);
        }
        return state;
    }

    public State getState(String name) {
        Objects.requireNonNull(name, "state name must not be null!");
        return this.states.stream().filter(state -> ((State)state).name.equals(name)).findFirst().orElse(null);
    }

    public void setInitialState(State state) {
        Objects.requireNonNull(state, "state must not be null!");
        if (!this.states.contains(state)) {
            throw new IllegalArgumentException(String.format("state '%s' is not defined in this Lexer instance", state.toString()));
        }
        this.initialState = state;
    }

    public State getInitialState() {
        return this.initialState;
    }

    public synchronized List<Tokenizer.TokenInfo<T>> tokenize(String input) throws ParseException {
        this.currentState = this.getInitialState();
        return this.tokenizer.tokenize(input);
    }

    public List<StateInfo<T>> parseStates(List<Tokenizer.TokenInfo<T>> tokenInfos) {
        StateInfo<T> stateInfo = new StateInfo<T>(this.getInitialState());
        ArrayList<StateInfo<T>> stateInfos = new ArrayList<StateInfo<T>>();
        stateInfos.add(stateInfo);
        for (Tokenizer.TokenInfo<T> tokenInfo : tokenInfos) {
            State state = ((StateInfo)stateInfo).state.getNextState(tokenInfo.token);
            if (!state.equals(((StateInfo)stateInfo).state)) {
                stateInfo = new StateInfo(state);
                stateInfos.add(stateInfo);
            }
            stateInfo.addToken(tokenInfo);
        }
        return stateInfos;
    }

    public List<StateInfo<T>> parse(String input) throws ParseException {
        return this.parseStates(this.tokenize(input));
    }

    public void init(InputStream is, Function<String, T> tokenResolver) throws IOException {
        String lexerStates = null;
        lexerStates = SharpIO.readAsString(is);
        Tokenizer<Integer> stateTokenizer = new Tokenizer<Integer>();
        stateTokenizer.add(0, "[a-z\\_]+:");
        stateTokenizer.add(1, "[0-9A-Z\\_]+");
        stateTokenizer.add(2, "\\|");
        stateTokenizer.add(3, ":[0-9a-z\\_]+");
        stateTokenizer.add(4, "\\n");
        stateTokenizer.add(5, "=.+?(\\n|$)");
        List tokenInfos = null;
        try {
            tokenInfos = stateTokenizer.tokenize(lexerStates);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        State lastState = null;
        String name = null;
        ArrayList<Object> currentTokens = null;
        Object currentToken = null;
        block10: for (Tokenizer.TokenInfo tokenInfo : tokenInfos) {
            switch ((Integer)tokenInfo.token) {
                case 0: {
                    name = tokenInfo.sequence.substring(0, tokenInfo.sequence.length() - 1);
                    lastState = this.getState(name);
                    if (lastState == null) {
                        lastState = this.addState(name);
                    }
                    currentTokens = new ArrayList<Object>();
                    continue block10;
                }
                case 1: {
                    currentToken = tokenResolver.apply(tokenInfo.sequence);
                    continue block10;
                }
                case 3: {
                    currentTokens.add(currentToken);
                    name = tokenInfo.sequence.substring(1);
                    State nextState = this.getState(name);
                    if (nextState == null) {
                        nextState = this.addState(name);
                    }
                    lastState.addNextState(nextState, currentTokens);
                    currentTokens = null;
                    continue block10;
                }
                case 2: {
                    currentTokens.add(currentToken);
                    continue block10;
                }
                case 4: {
                    continue block10;
                }
                case 5: {
                    this.tokenizer.add(currentToken, tokenInfo.sequence.substring(1).replaceFirst("\n$", ""));
                    continue block10;
                }
            }
            throw new UnhandledSwitchCaseException(tokenInfo.token);
        }
    }

    public void init(String fileName, boolean isResource, Function<String, T> tokenResolver) throws IOException {
        try (InputStream is = SharpIO.createInputStream(fileName, isResource);){
            this.init(is, tokenResolver);
        }
    }

    public void init(String fileName, boolean isResource) throws IOException {
        this.init(fileName, isResource, sequence -> sequence);
    }

    public void init(String fileName, Function<String, T> tokenResolver) throws IOException {
        this.init(fileName, false, tokenResolver);
    }

    public void init(String fileName) throws IOException {
        this.init(fileName, false);
    }

    private class TokenValidator
    implements Tokenizer.Validator<T> {
        private TokenValidator() {
        }

        @Override
        public boolean validate(T token, String sequence) {
            State nextState = Lexer.this.currentState.getNextState(token);
            if (nextState != null) {
                Lexer.this.currentState = nextState;
            }
            return nextState != null;
        }
    }

    public static class StateInfo<T> {
        private final State<T> state;
        private List<Tokenizer.TokenInfo<T>> tokenInfos;

        private StateInfo(State state) {
            Objects.requireNonNull(state, "state must not be null!");
            this.state = state;
            this.tokenInfos = new ArrayList<Tokenizer.TokenInfo<T>>();
        }

        public State<T> getState() {
            return this.state;
        }

        public List<Tokenizer.TokenInfo<T>> getTokenInfos() {
            return Collections.unmodifiableList(this.tokenInfos);
        }

        public void addToken(Tokenizer.TokenInfo<T> tokenInfo) {
            this.tokenInfos.add(tokenInfo);
        }

        public String toString() {
            return String.format("%s (%s)", this.state, this.tokenInfos);
        }

        public boolean equals(Object object) {
            if (!(object instanceof StateInfo)) {
                return false;
            }
            return Objects.equals(this.state, ((StateInfo)object).state) && Objects.equals(this.tokenInfos, ((StateInfo)object).tokenInfos);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.tokenInfos);
        }
    }

    public static class State<T> {
        private final String name;
        private Map<State, Set<T>> nextStates;

        private State(String name) {
            this.name = name;
            this.nextStates = new HashMap<State, Set<T>>();
        }

        protected boolean hasDuplicateTokens(List<T> tokens) {
            return this.nextStates.values().stream().anyMatch(existingTokens -> tokens.stream().anyMatch(token -> existingTokens.contains(token)));
        }

        public void addNextState(State state, List<T> tokens) {
            Objects.requireNonNull(state, "state must not be null!");
            if (this.hasDuplicateTokens(tokens)) {
                throw new IllegalArgumentException(String.format("duplicate tokenInfos: %s - %s", tokens, this.nextStates.values()));
            }
            if (this.nextStates.containsKey(state)) {
                this.nextStates.get(state).addAll(tokens);
            } else {
                this.nextStates.put(state, new HashSet<T>(tokens));
            }
        }

        public void addNextState(State state, T ... tokens) {
            this.addNextState(state, Arrays.asList(tokens));
        }

        protected State getNextState(T token) {
            for (Map.Entry<State, Set<T>> entry : this.nextStates.entrySet()) {
                if (!entry.getValue().contains(token)) continue;
                return entry.getKey();
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            if (!(object instanceof State)) {
                return false;
            }
            return Objects.equals(this.name, ((State)object).name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }
}

