/*
 * Decompiled with CFR 0.152.
 */
package net.seesharpsoft.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer<T> {
    private Map<T, Token<T>> tokenMap = new HashMap<T, Token<T>>();
    private List<Validator> validators = new ArrayList<Validator>();
    private Pattern trimPatternStart;
    private Pattern trimPatternEnd;
    private boolean caseInsensitive = false;

    public Tokenizer() {
        this.setTrimPattern("\r| ");
    }

    public boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    public Tokenizer<T> setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    protected Tokenizer<T> add(Token<T> token) {
        this.tokenMap.put(token.token, token);
        return this;
    }

    protected Token<T> createToken(T token, String regex, boolean caseInsensitive) {
        return new Token<T>(token, Pattern.compile("^(" + regex + ")", caseInsensitive ? 2 : 0));
    }

    public Tokenizer<T> add(T token, String regex, boolean caseInsensitive) {
        return this.add(this.createToken(token, regex, caseInsensitive));
    }

    public Tokenizer<T> add(T token, String regex) {
        return this.add(token, regex, this.getCaseInsensitive());
    }

    protected Token<T> getToken(T token) {
        return this.tokenMap.get(token);
    }

    public Tokenizer<T> addValidator(Validator validator) {
        Objects.requireNonNull(validator, "validator must be not null!");
        this.validators.add(validator);
        return this;
    }

    public Tokenizer<T> removeValidator(Validator validator) {
        this.validators.remove(validator);
        return this;
    }

    public boolean hasValidator(Validator validator) {
        return this.validators.contains(validator);
    }

    protected List<Validator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    protected <T> boolean isValid(T token, String sequence) {
        return this.validators.isEmpty() || this.validators.stream().anyMatch(validator -> validator.validate(token, sequence));
    }

    public Tokenizer<T> setTrimPattern(String regexTrimPattern) {
        if (regexTrimPattern == null || regexTrimPattern.isEmpty()) {
            this.trimPatternStart = null;
            this.trimPatternEnd = null;
        } else {
            this.trimPatternStart = Pattern.compile(String.format("^(%s)*", regexTrimPattern));
            this.trimPatternEnd = Pattern.compile(String.format("(%s)*$", regexTrimPattern));
        }
        return this;
    }

    protected String trim(String input) {
        if (input == null) {
            return "";
        }
        if (this.trimPatternStart != null) {
            input = this.trimPatternStart.matcher(input).replaceFirst("");
        }
        if (this.trimPatternEnd != null) {
            input = this.trimPatternEnd.matcher(input).replaceFirst("");
        }
        return input;
    }

    protected <T> List<TokenInfo<T>> tokenize(String str, Collection<Token<T>> tokenCollection) throws ParseException {
        LinkedList<TokenInfo<T>> tokenInfos = new LinkedList<TokenInfo<T>>();
        String trimmedString = this.trim(str == null ? null : str.replaceAll("\r\n", "\n"));
        while (!trimmedString.equals("")) {
            boolean match = false;
            for (Token<T> info : tokenCollection) {
                String sequence;
                Matcher matcher = info.regex.matcher(trimmedString);
                if (!matcher.find() || !this.isValid(info.token, sequence = this.trim(matcher.group()))) continue;
                match = true;
                trimmedString = this.trim(matcher.replaceFirst(""));
                tokenInfos.add(new TokenInfo(info.token, sequence));
                break;
            }
            if (match) continue;
            throw new ParseException("Unexpected character in input: " + trimmedString, 0);
        }
        return tokenInfos;
    }

    public List<TokenInfo<T>> tokenize(String str) throws ParseException {
        return this.tokenize(str, this.tokenMap.values());
    }

    public static class TokenInfo<T> {
        public final T token;
        public final String sequence;

        public TokenInfo(T token, String sequence) {
            this.token = token;
            this.sequence = sequence;
        }

        public String toString() {
            return String.format("%s:%s", this.token, this.sequence);
        }

        public boolean equals(Object other) {
            if (!(other instanceof TokenInfo)) {
                return false;
            }
            TokenInfo otherTokenInfo = (TokenInfo)other;
            return Objects.equals(this.token, otherTokenInfo.token) && Objects.equals(this.sequence, otherTokenInfo.sequence);
        }

        public int hashCode() {
            return Objects.hash(this.token, this.sequence);
        }
    }

    protected static class Token<T> {
        public final Pattern regex;
        public final T token;

        public Token(T token, Pattern regex) {
            Objects.requireNonNull(token, "token must be not null!");
            Objects.requireNonNull(regex, "regex must be not null!");
            this.regex = regex;
            this.token = token;
        }

        public String toString() {
            return String.format("%s=%s (%s)", this.token, this.regex.pattern(), this.regex.flags());
        }

        public boolean equals(Object other) {
            if (!(other instanceof Token)) {
                return false;
            }
            Token otherToken = (Token)other;
            return Objects.equals(this.token, otherToken.token) && Objects.equals(this.regex.pattern(), otherToken.regex.pattern()) && Objects.equals(this.regex.flags(), otherToken.regex.flags());
        }

        public int hashCode() {
            return Objects.hash(this.token, this.regex.pattern(), this.regex.flags());
        }
    }

    public static interface Validator<T> {
        public boolean validate(T var1, String var2);
    }
}

