/*
 * Decompiled with CFR 0.152.
 */
package net.seesharpsoft.spring.multipart.batch;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.seesharpsoft.spring.util.ByteArrayServletInputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MimeType;

public class BatchHttpServletRequest
extends HttpServletRequestWrapper {
    private byte[] content;
    private URI uri;
    private HttpMethod method;
    private HttpHeaders headers;
    private Map<String, String[]> parameters;
    private Map<String, Object> attributes;
    private MimeType mimeType;

    private Map<String, String[]> resolveParameters(URI uri) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        String query = uri.getQuery();
        if (query != null && !query.isEmpty()) {
            String[] parameters;
            for (String parameter : parameters = query.split("&")) {
                String[] keyValue = parameter.split("=");
                String key = keyValue[0];
                String[] values = (String[])result.get(key);
                values = values == null ? new String[1] : Arrays.copyOf(values, values.length + 1);
                values[values.length - 1] = keyValue.length > 1 ? keyValue[1] : "";
                result.put(key, values);
            }
        }
        return result;
    }

    private void initAdditionalRequestInformation(URI uri, HttpServletRequest request, HttpHeaders headers) {
        this.parameters = this.resolveParameters(uri);
        this.attributes = new HashMap<String, Object>();
        this.headers = new HttpHeaders();
        this.headers.putAll((Map)headers);
    }

    public BatchHttpServletRequest(HttpServletRequest request, URI uri, HttpMethod method, HttpHeaders headers, byte[] body, MimeType mimeType) {
        super(request);
        this.initAdditionalRequestInformation(uri, request, headers);
        this.uri = uri;
        this.method = method;
        this.content = body;
        this.mimeType = mimeType;
    }

    public String getMethod() {
        return this.method.toString();
    }

    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.headers.get((Object)name) == null ? Collections.emptyEnumeration() : Collections.enumeration(this.headers.get((Object)name));
    }

    public long getDateHeader(String name) {
        return this.headers.getFirstDate(name);
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getServerName() {
        return this.uri.getHost();
    }

    public int getServerPort() {
        return this.uri.getPort();
    }

    public String getContextPath() {
        return "";
    }

    public String getServletPath() {
        return "";
    }

    public String getPathInfo() {
        return this.uri.getPath();
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.uri.getQuery();
    }

    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath() + this.getPathInfo();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getScheme()).append("://").append(this.getServerName()).append(':').append(this.getServerPort()).append(this.getRequestURI());
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public ServletInputStream getInputStream() {
        return new ByteArrayServletInputStream(this.content);
    }

    public int getContentLength() {
        return this.content == null ? 0 : this.content.length;
    }

    public String getContentType() {
        return this.mimeType.toString();
    }
}

