/*
 * Decompiled with CFR 0.152.
 */
package net.seesharpsoft.spring.multipart.batch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpServerErrorException;

public class BatchHttpServletResponse
implements HttpServletResponse {
    private PrintWriter writer;
    private ByteArrayServletOutputStream outputStream;
    private HttpHeaders headers;
    private String contentType;
    private int status;
    private String charset;
    private Locale locale;

    private void initAdditionalRequestInformation(HttpServletResponse response) {
        this.headers = new HttpHeaders();
        Collection headerNames = response.getHeaderNames();
        for (String header : headerNames) {
            this.headers.put(header, new ArrayList(response.getHeaders(header)));
        }
        this.charset = response.getCharacterEncoding();
        this.locale = response.getLocale();
    }

    public BatchHttpServletResponse(HttpServletResponse response) {
        this.initAdditionalRequestInformation(response);
        this.status = 200;
    }

    public void addCookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    public void setStatus(int statusCode) {
        this.status = statusCode;
    }

    public void setStatus(int sc, String sm) {
        throw new UnsupportedOperationException("deprecated");
    }

    public int getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaderObject() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.headers.get((Object)name);
    }

    public void setHeader(String name, String value) {
        this.headers.set(name, value);
    }

    public void setDateHeader(String name, long date) {
        this.headers.setDate(name, date);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void addHeader(String name, String value) {
        this.headers.add(name, value);
    }

    public void addDateHeader(String name, long date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.addHeader(name, dateFormat.format(new Date(date)));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public Collection getHeaderNames() {
        return this.headers.keySet();
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey((Object)name);
    }

    public String encodeURL(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeUrl(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeRedirectUrl(String url) {
        throw new UnsupportedOperationException();
    }

    public void sendError(int sc, String msg) throws IOException {
        this.status = sc;
        throw new HttpServerErrorException(HttpStatus.valueOf((int)this.status), msg);
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, HttpStatus.valueOf((int)sc).getReasonPhrase());
    }

    public void sendRedirect(String location) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayServletOutputStream();
        }
        return this.outputStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public String getCharacterEncoding() {
        return this.charset;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((OutputStream)this.getOutputStream());
        }
        return this.writer;
    }

    public void setContentLength(int length) {
        this.headers.setContentLength((long)length);
    }

    public void setContentLengthLong(long length) {
        this.headers.setContentLength(length);
    }

    public void resetBuffer() {
        this.writer.close();
        this.writer = null;
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.outputStream = null;
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
        this.getOutputStream().flush();
    }

    public boolean isCommitted() {
        return this.status != 0;
    }

    public void reset() {
        this.headers.clear();
        this.resetBuffer();
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public byte[] getContent() throws IOException {
        return ((ByteArrayServletOutputStream)this.getOutputStream()).toByteArray();
    }

    private static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener listener) {
            throw new RuntimeException("Not implemented");
        }

        public void write(int b) throws IOException {
            this.buffer.write(b);
        }

        public byte[] toByteArray() {
            return this.buffer.toByteArray();
        }
    }
}

