/*
 * Decompiled with CFR 0.152.
 */
package net.seesharpsoft.spring.multipart.batch;

import java.io.IOException;
import java.io.OutputStreamWriter;
import net.seesharpsoft.spring.multipart.MultipartEntity;
import net.seesharpsoft.spring.multipart.MultipartMessage;
import net.seesharpsoft.spring.multipart.MultipartRfc2046MessageConverter;
import net.seesharpsoft.spring.multipart.batch.BatchRequest;
import net.seesharpsoft.spring.multipart.batch.BatchResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

public class BatchMessageConverter
extends MultipartRfc2046MessageConverter {
    @Override
    public boolean canRead(Class clazz, MediaType mediaType) {
        return BatchRequest.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean canWrite(Class clazz, MediaType mediaType) {
        return BatchResponse.class.isAssignableFrom(clazz);
    }

    @Override
    protected MultipartMessage createMultipartMessage() {
        return new BatchRequest();
    }

    @Override
    protected MultipartEntity createMultipartEntity() {
        return new BatchRequest.Entity();
    }

    @Override
    protected void applyEntityBody(MultipartEntity entity, String part) {
        int headerContentSplitIndex = part.indexOf("\r\n\r\n");
        boolean hasBody = headerContentSplitIndex != -1;
        String headerPart = !hasBody ? part : part.substring(0, headerContentSplitIndex);
        String bodyPart = !hasBody ? "" : part.substring(headerContentSplitIndex + "\r\n\r\n".length(), part.length());
        this.applyBodyHeader((BatchRequest.Entity)entity, headerPart);
        super.applyEntityBody(entity, bodyPart);
    }

    protected void applyBodyHeader(BatchRequest.Entity entity, String content) {
        int headerContentSplitIndex = content.indexOf("\r\n");
        boolean hasHeader = headerContentSplitIndex != -1;
        String urlPart = hasHeader ? content.substring(0, headerContentSplitIndex) : content;
        String[] targetUrlParts = urlPart.split(" ");
        entity.setMethod(HttpMethod.resolve((String)targetUrlParts[0]));
        entity.setUrl(targetUrlParts[1]);
        this.applyEntityHeaders(entity, hasHeader ? content.substring(headerContentSplitIndex, content.length()) : null);
    }

    @Override
    protected void writePartContent(OutputStreamWriter writer, MultipartEntity entry) throws IOException {
        this.writeResponseStatus(writer, (BatchResponse.Entity)entry);
        byte[] body = entry.getBody();
        if (body != null) {
            this.writePartContentHeader(writer, entry.getHeaders(), body.length);
            writer.write("\r\n");
            writer.write(new String(body, DEFAULT_CHARSET));
            writer.write("\r\n");
        }
    }

    private void writeResponseStatus(OutputStreamWriter writer, BatchResponse.Entity entry) throws IOException {
        writer.write("HTTP/1.1 ");
        writer.write(entry.getStatus().value() + "");
        writer.write(" ");
        writer.write(entry.getStatus().getReasonPhrase());
        writer.write("\r\n");
    }

    private void writePartContentHeader(OutputStreamWriter writer, HttpHeaders headers, int contentLength) throws IOException {
        writer.write("Content-Type");
        writer.write(": ");
        writer.write(headers.getContentType().toString());
        writer.write("\r\n");
        writer.write("Content-Length");
        writer.write(": ");
        writer.write(contentLength + "");
        writer.write("\r\n");
    }
}

