/*
 * Decompiled with CFR 0.152.
 */
package net.seesharpsoft.spring.multipart.batch;

import javax.servlet.http.HttpServletRequest;
import net.seesharpsoft.spring.multipart.batch.BatchMediaType;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

public class BatchMultipartResolver
implements MultipartResolver {
    private MultipartResolver multipartResolver;
    private static final String EXCLUDED_MEDIA_TYPE_VALUE = BatchMediaType.MULTIPART_BATCH.getType().toLowerCase() + '/' + BatchMediaType.MULTIPART_BATCH.getSubtype().toLowerCase();

    public BatchMultipartResolver(MultipartResolver resolver) {
        this.multipartResolver = resolver;
    }

    public BatchMultipartResolver() {
        this((MultipartResolver)new StandardServletMultipartResolver());
    }

    public boolean isMultipart(HttpServletRequest request) {
        String contentType = request.getContentType();
        return this.multipartResolver.isMultipart(request) && contentType != null && !contentType.toLowerCase().startsWith(EXCLUDED_MEDIA_TYPE_VALUE);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest httpServletRequest) throws MultipartException {
        return this.multipartResolver.resolveMultipart(httpServletRequest);
    }

    public void cleanupMultipart(MultipartHttpServletRequest multipartHttpServletRequest) {
        this.multipartResolver.cleanupMultipart(multipartHttpServletRequest);
    }
}

