/*
 * Decompiled with CFR 0.152.
 */
package net.seesharpsoft.spring.multipart.batch.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.seesharpsoft.spring.multipart.batch.BatchMediaType;
import net.seesharpsoft.spring.multipart.batch.BatchRequest;
import net.seesharpsoft.spring.multipart.batch.BatchResponse;
import net.seesharpsoft.spring.multipart.batch.services.BatchRequestProperties;
import net.seesharpsoft.spring.multipart.batch.services.BatchRequestService;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class BatchRequestServiceBase
implements BatchRequestService {
    @Override
    public BatchResponse process(BatchRequest batchRequest, BatchRequestProperties properties, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        BatchResponse batchResponse = new BatchResponse();
        for (BatchRequest.Entity singleRequest : batchRequest.getParts()) {
            HttpHeaders httpHeaders = new HttpHeaders();
            if (properties != null && properties.getIncludeOriginalHeader()) {
                Enumeration headerNames = servletRequest.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String header = (String)headerNames.nextElement();
                    httpHeaders.put(header, Collections.list(servletRequest.getHeaders(header)));
                }
            }
            httpHeaders.putAll((Map)singleRequest.getHeaders());
            BatchResponse.Entity singleResponse = this.processSingleRequest(this.getSingleRequestUri(singleRequest, servletRequest), singleRequest.getMethod(), httpHeaders, singleRequest.getBody(), servletRequest, servletResponse);
            batchResponse.addPart(singleResponse);
        }
        servletResponse.setHeader("Content-Type", BatchMediaType.MULTIPART_BATCH_VALUE);
        return batchResponse;
    }

    protected abstract BatchResponse.Entity processSingleRequest(URI var1, HttpMethod var2, HttpHeaders var3, byte[] var4, HttpServletRequest var5, HttpServletResponse var6) throws ServletException, IOException;

    protected URI getSingleRequestUri(BatchRequest.Entity singleRequest, HttpServletRequest servletRequest) throws MalformedURLException {
        String url = singleRequest.getUrl();
        String uriString = null;
        if (url.startsWith("/")) {
            int queryIndex = url.indexOf(63);
            String path = queryIndex == -1 ? url : url.substring(0, queryIndex);
            String query = queryIndex == -1 ? "" : url.substring(queryIndex + 1);
            UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
            uriString = builder.scheme(servletRequest.getScheme()).host(servletRequest.getServerName()).port(servletRequest.getServerPort()).path(path).query(query).toUriString();
        } else {
            uriString = UriComponentsBuilder.fromHttpUrl((String)url).toUriString();
        }
        return URI.create(uriString);
    }
}

