package net.sf.gluebooster.demos.pojo;

import java.lang.reflect.Method;

import javax.swing.JOptionPane;

import net.sf.gluebooster.demos.pojo.clock.DigitalClockDemo;
import net.sf.gluebooster.demos.pojo.flashcards.FlashcardDemo;
import net.sf.gluebooster.demos.pojo.languages.chinese.ChineseDemo;
import net.sf.gluebooster.demos.pojo.wiki.WikiAuthors;

/**
 * Starts the demo applications.
 * 
 * @author cbauer
 *
 */
public class DemoApplications {

	/**
	 * Start a chosen application.
	 * 
	 * @param args
	 *            args[0] = chosen index; no args: input dialog is displayed.
	 */
	public static void main(String[] args) throws Exception {
		Integer chosen = null;
		if (args != null && args.length > 0) {
			chosen = Integer.valueOf(args[0]);
		}

		Class[] mainClasses = { FlashcardDemo.class, ChineseDemo.class, DigitalClockDemo.class, WikiAuthors.class };

		if (chosen == null) {
			StringBuilder options = new StringBuilder();
			for (int i = 0; i < mainClasses.length; i++) {
				options.append(i).append("=").append(mainClasses[i].getSimpleName()).append("; ");
			}
			chosen = Integer.valueOf(JOptionPane.showInputDialog(options));
			// chosen = JOptionPane.showInputDialog("1 = Flashcards, 2 = Digital clock in foreground, 3= WikiAuthors, 4= Chinese");
		}

		Method mainMethod = mainClasses[chosen].getMethod("main", String[].class);
		mainMethod.invoke(null, new Object[] { null });// the object array is interpreted as varargs, so the null is interpreted as the String[]

	}

}
