package net.sf.gluebooster.demos.pojo.clock;

import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Map;

import net.sf.gluebooster.java.booster.basic.mvc.AppDefinition;
import net.sf.gluebooster.java.booster.basic.mvc.AppDisplayBySwingBorderLayout;
import net.sf.gluebooster.java.booster.basic.mvc.Layer;
import net.sf.gluebooster.java.booster.basic.transformation.CallableByRepeating;
import net.sf.gluebooster.java.booster.basic.transformation.CallableChain;
import net.sf.gluebooster.java.booster.basic.transformation.CallableFactory;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.meta.objects.DisplayConfiguration;
import net.sf.gluebooster.java.booster.essentials.utils.Constants;
import net.sf.gluebooster.java.booster.essentials.utils.ContainerBoostUtils;

/**
 * A small digital clock displayed in the foreground.
 * 
 * <img src="doc-files/examples/images/digitalClock.png"/><br/>
 * 
 * @author cbauer
 *
 */
public class DigitalClockDemo {

	/**
	 * Starts the demo
	 * 
	 * @param ignored
	 *            the parameters are ignored
	 */
	public static void main(String[] ignored) throws Exception {
		startDemo();
	}

	public static Frame startDemo() throws Exception {

		AppDefinition appDefinition = new AppDefinition();
		appDefinition.setTitle("Clock");

		// -------------------------------------------------------------

		Layer controller = new Layer("clock contoller");
		Layer view = new Layer("clock view");// new DigitalClockAppView(appDefinition);
		view.setBackend(controller);

		DisplayConfiguration displayConfiguration = new DisplayConfiguration("clock display");
		displayConfiguration.setAlwaysOnTop(true);
		displayConfiguration.setPreferredSize(new Rectangle(200, 35));

		AppDisplayBySwingBorderLayout display = new AppDisplayBySwingBorderLayout(displayConfiguration, view, appDefinition);
		display.setBackend(view);
		Map displayModel = display.getModelOfBackendLayer();

		// ------------------------
		// ------------------------
		// CONTROLLER
		// ------------------------
		// ------------------------



		CallableChain<Void, Boolean> dateChain = new CallableChain<Void, Boolean>("put current date into FIELD_TIME",
				// ignored
				CallableFactory.currentDate(),
				// Date now
				CallableFactory.simpleDateFormat("HH:mm:ss"),
				// String HH:mm:ss
				ContainerBoostUtils.putIntoMap("put time into model", view.getModelOfBackendLayer(), DigitalClockDemo.FIELD_TIME, null),
				// there is only one view, the model does not change, so this method can be used

				true
		);

		controller.setCommandCallable(DigitalClockDemo.COMMAND_GET_TIME, dateChain);

		// ------------------------
		// ------------------------
		// VIEW
		// ------------------------
		// ------------------------



		// ------------------------
		// View commands
		// ------------------------

		view.setStartStopCallable(new CallableByRepeating("repeatedly get the time and put it into the display model", 200,
				new CallableChain("putTimeFromControllerIntoDisplay",
						// void
						controller.createExecuteCommandCallable(COMMAND_GET_TIME, null, view.getModelOfBackendLayer()),
						// model with updated time
						view.copyIntoModel(displayModel, FIELD_TIME)
				// display model with updated time
				)));
		// repeater.setBreakpoint(new NoOp());

		// view.setCommandCallable(Constants.START, repeater);//start repeater
		// view.setCommandCallable(Constants.STOP, repeater);//stop repeater


		// ------------------------
		// Display configuration and start
		// ------------------------

		display.putComponentIntoDisplayModel(FIELD_TIME, display.getFrame());

		display.call(Constants.START);

		return display.getFrame();
	}

	/**
	 * The command to get the current time.
	 */
	public static final String COMMAND_GET_TIME = "Get time";
	/**
	 * The field that displays the time
	 */
	public static final String FIELD_TIME = "time";

}
