package net.sf.gluebooster.demos.pojo.dev;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFrame;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

import net.sf.gluebooster.java.booster.basic.gui.DialogConfiguration;
import net.sf.gluebooster.java.booster.basic.gui.swing.SwingBoostUtils;
import net.sf.gluebooster.java.booster.basic.gui.swing.UserInteractionWithSwing;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Converts data between different formats.
 * 
 * @author cbauer
 *
 */
public class ConversionTool implements ActionListener {

	/**
	 * The frame of this application.
	 */
	private JFrame frame;

	private TextField original = new TextField(50);
	private TextField result = new TextField(50);
	private Button base64ToByte = new Button("Base 64 to byte");

	public static void main(String[] args) {
		new ConversionTool();
	}

	public ConversionTool() {
		frame = new SwingBoostUtils().createFrame("Conversion", 1000, 600, true, new BorderLayout());

		frame.getContentPane().add(original, BorderLayout.WEST);
		frame.getContentPane().add(result, BorderLayout.EAST);
		frame.getContentPane().add(base64ToByte, BorderLayout.SOUTH);

		base64ToByte.addActionListener(this);

		frame.setVisible(true);
	}

	@Override
	public void actionPerformed(ActionEvent event) {
		try {
			if (base64ToByte.equals(event.getSource())) {
				DialogConfiguration config = DialogConfiguration.chooseFile("Result file", false);
				File file = (File) new UserInteractionWithSwing().call(config);
				if (file != null) {
					FileUtils.writeByteArrayToFile(file, Base64.decodeBase64(original.getText().trim()));
				}
			}
		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}


}
