package net.sf.gluebooster.demos.pojo.flashcards;

import java.awt.Font;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JLabel;

import net.sf.gluebooster.demos.pojo.languages.VocabularyEntry;
import net.sf.gluebooster.java.booster.basic.mvc.AppDefinition;
import net.sf.gluebooster.java.booster.basic.mvc.AppDisplayBySwingBorderLayout;
import net.sf.gluebooster.java.booster.basic.mvc.Layer;
import net.sf.gluebooster.java.booster.basic.transformation.CallableByCalling;
import net.sf.gluebooster.java.booster.basic.transformation.CallableByCopying;
import net.sf.gluebooster.java.booster.basic.transformation.CallableChain;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.MultiListener;
import net.sf.gluebooster.java.booster.essentials.meta.CommentImpl;
import net.sf.gluebooster.java.booster.essentials.meta.objects.DisplayConfiguration;
import net.sf.gluebooster.java.booster.essentials.utils.Constants;
import net.sf.gluebooster.java.booster.essentials.utils.ContainerBoostUtils;

/**
 * {@Feature}An demo application to learn with flashcards.{@FeatureEnd}
 * 
 * @author cbauer
 *
 */
public class FlashcardDemo {

	/**
	 * create a demo instance with some chinese flashcards.
	 * 
	 * @return demo model
	 */
	public static Map<Object, Object> createChineseDemoModel() throws Exception {
		List/* <VocabularyEntry> */ cards = Arrays.asList(new VocabularyEntry("〇", "ling2", "zero"), new VocabularyEntry("一", "yi1", "one"),
				new VocabularyEntry("下", "xia", "below"));
		Flashcards<Object> flashcards = new Flashcards<Object>();
		flashcards.setCardsAtLevel0(cards);
		flashcards.setNames(ContainerBoostUtils.createMap(0, "Chinese", 1, "Pinyin", 2, "English"));
		flashcards.setFrontSideIndices(new int[] { 0 });
		flashcards.setBackSideIndices(new int[] { 0, 1, 2 });
	
		HashMap<Object, Object> model = new HashMap();
		model.put(AppDefinition.FIELD_TITLE, "Chinese Vocabulary");
		model.put(FIELD_ALL_FLASHCARDS, flashcards);
	
		return model;
	
	}

	/**
	 * Starts the demo
	 * 
	 * @param ignored
	 *            the parameters are ignored
	 */
	public static void main(String[] ignored) throws Exception {
		startSimpleSwingDemo(null);
	}

	/**
	 * Creates a swing layout of the application
	 * 
	 * @param view
	 *            the view of the application
	 * @return the created layout
	 */
	private static AppDisplayBySwingBorderLayout createSwingLayout(FlashcardsAppView view, AppDefinition appDefinition) throws Exception {

		DisplayConfiguration displayConfiguration = new DisplayConfiguration("display");
		AppDisplayBySwingBorderLayout result = new AppDisplayBySwingBorderLayout(displayConfiguration, view, appDefinition);

		CallableByCalling displayModelAppender = new CallableByCalling("call view", view, new Object[] { null, null, result.getModelOfBackendLayer() });
		MultiListener mouseListener = MultiListener.createMouseListener(false, true, displayModelAppender);

		// new MultiListener(displayModelAppender);
		// mouseListener.setDelegateMouseEvents(false);
		// mouseListener.setDelegateMouseClicked(true);
		JLabel label = new JLabel();
		label.setFont(new Font(label.getFont().getName(), Font.PLAIN, 36));
		label.addMouseListener(mouseListener);
		result.putComponentIntoDisplayModel(FIELD_DISPLAYED_FLASHCARD_SIDE, label);
		// getDisplayModel().put(FlashcardAppDefinition.FIELD_DISPLAYED_FLASHCARD_SIDE, new ComponentHolder(label));
		result.setCentral(label);

		result.setNorth(result.putComponentIntoDisplayModel(FIELD_FLASHCARDS_STATISTICS,
				new JLabel("no cards loaded yet, only demo cards available")));

		result.addToMenuBar(
				result.createMenu("Flashcards", "Save", COMMAND_SAVE_CARDS, "Load", COMMAND_LOAD_CARDS));
		result.setCommandCallable(COMMAND_LOAD_CARDS, result.passTo(view, true));
		result.setCommandCallable(COMMAND_SAVE_CARDS, result.passTo(view, true));
		// TODO the display should do the file dialog, not the view
		return result;
	}

	/**
	 * Creates a swing demo with some chinese flashcards if no model is provided
	 * 
	 * @param optionalModel
	 *            an initial model (optional) of the application.
	 * @return the view of the demo.
	 */
	public static AppDisplayBySwingBorderLayout startSimpleSwingDemo(Map optionalModel) throws Exception {
		if (optionalModel == null) {
			optionalModel = createChineseDemoModel();
		}

		AppDefinition appDefinition = new AppDefinition();
		appDefinition.setTitle("Flashcards");

		// FlashcardsAppController<Object> controller = new FlashcardsAppController<Object>();
		Layer controller = new Layer("controller");
		controller.noStartNecessary();
		controller.noStopNecessary();

		controller.setCommandCallable(FlashcardDemo.COMMAND_SAVE_CARDS, controller.serializeModelField("save flashcards", FlashcardDemo.FIELD_ALL_FLASHCARDS));

		controller.setCommandCallable(FlashcardDemo.COMMAND_LOAD_CARDS,
				controller.deserializeIntoModelField("load flashcards", FlashcardDemo.FIELD_ALL_FLASHCARDS));

		controller.setCommandCallable(FlashcardDemo.COMMAND_NEXT_CARD, new CallableAbstraction() {

			@Override
			protected Object callImpl(Object... parameters) throws Exception {
				Object commandName = parameters[0];
				Object parameter = parameters[1];
				Map model = (Map) parameters[2];

				// CallableAbstraction allFlashcardsAndParameter = new CallableByCalling("flashcards and parameter known", new
				// Callable[]{selectModelField(FlashcardDemo.FIELD_ALL_FLASHCARDS), selectParameters()});
				//
				// CallableByCalling actions = new CallableByCalling("flashcards actions", new Callable[]{//
				// new CallableByReflection("getNextCard", null, "getNextCard", Constants.REPLACE), //
				// new CallableChain("put frontside string", new CallableByReflection<>("getCurrentFrontsideString", null, "getCurrentFrontsideString"))
				// // TODO not yet correct
				// });

				Flashcards<Object> flashcards = (Flashcards<Object>) model.get(FlashcardDemo.FIELD_ALL_FLASHCARDS);
				flashcards.getNextCard((Boolean) parameter);
				model.put(FlashcardDemo.FIELD_DISPLAYED_FLASHCARD_SIDE, flashcards.getCurrentFrontsideString());
				model.put(FlashcardDemo.FIELD_FLASHCARDS_STATISTICS, flashcards.getSizeInfo().toString());

				return true;

			}
		});

		// VIEW

		FlashcardsAppView view = new FlashcardsAppView();
		view.setBackend(controller);
		view.setModelOfBackendLayer(optionalModel);

		CallableAbstraction titleSetter = new CallableChain("set title when starting", //
				new CommentImpl("command, ignored parameter, displayModel"), //
				view.selectModel(),
				new CallableByCopying("set title", appDefinition.getTitle(), null, AppDefinition.FIELD_TITLE));

		view.setCommandCallable(Constants.START,
				new CallableByCalling("set title and pass to controller", new Object[] { titleSetter, view.passTo(controller, true) }));


		AppDisplayBySwingBorderLayout display = createSwingLayout(view, appDefinition);
		display.setBackend(view);
		display.call(Constants.START);
		return display;

	}

	/**
	 * The command to load the cards.
	 */
	public static final String COMMAND_LOAD_CARDS = "Load cards";
	/**
	 * The command to put the current card into the right compartment. Parameter is whether the current card is known (true), not known (false) or no info about
	 * the current card (null)
	 */
	public static final String COMMAND_NEXT_CARD = "Next card";
	/**
	 * The command to save the cards.
	 */
	public static final String COMMAND_SAVE_CARDS = "Save cards";
	public static final String FIELD_ALL_FLASHCARDS = "All flashcards";
	public static final String FIELD_DISPLAYED_FLASHCARD_SIDE = "Displayed flashcard side";
	public static final String FIELD_FLASHCARDS_STATISTICS = "Flashcard statistics";

}
