package net.sf.gluebooster.demos.pojo.flashcards;

import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Map;

import javax.swing.JOptionPane;

import net.sf.gluebooster.java.booster.basic.container.CopyBoostUtils;
import net.sf.gluebooster.java.booster.basic.gui.DialogConfiguration;
import net.sf.gluebooster.java.booster.basic.gui.UserInteraction;
import net.sf.gluebooster.java.booster.basic.gui.UserInteractionBoostUtils;
import net.sf.gluebooster.java.booster.basic.mvc.AppDefinition;
import net.sf.gluebooster.java.booster.basic.mvc.Layer;
import net.sf.gluebooster.java.booster.basic.transformation.CallableByCalling;
import net.sf.gluebooster.java.booster.basic.transformation.CallableBySelecting;
import net.sf.gluebooster.java.booster.basic.transformation.CallableChain;
import net.sf.gluebooster.java.booster.basic.transformation.CallableToBoolean;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.Callable;
import net.sf.gluebooster.java.booster.essentials.utils.Constants;
import net.sf.gluebooster.java.booster.essentials.utils.SwingBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * View logic without gui.
 * 
 * @author cbauer
 *
 */
public class FlashcardsAppView<CardElement> extends Layer {

	/**
	 * The state that a frontside word of the flashcard is displayed. TODO make private
	 */
	static final int STATE_DISPLAYING_WORD = 1;
	/**
	 * The state that the backside translation of the word of the flashcard is displayed.
	 * 
	 * TODO make private
	 */
	static final int STATE_DISPLAYING_TRANSLATION = 2;

	/**
	 * The initial state of the view.
	 */
	protected static final int STATE_INITIAL = 0;

	/**
	 * The current state of this view.
	 */
	protected int state = STATE_INITIAL;


	public FlashcardsAppView() throws Exception {
		super("view");
		// setIgnoreUnknownCommands(true);// ignore most mouse event
		noStartNecessary();
		noStopNecessary();

	}


	/**
	 * Lets the controller execute a command.
	 * 
	 * @param command
	 *            the command to execute
	 * @param parameter
	 *            parameter of the command
	 * @return the result of the command
	 */
	private Map<Object, Object> controllerExecute(Object command, Object parameter) throws Exception {
		Layer controller = getBackend();
		return controller.call(command, parameter, getModelOfBackendLayer());

	}

	@Override
	public boolean exec(Object commandName, Object parameter, Map displayModel) throws Exception {
		UserInteraction user = (UserInteraction) displayModel.get(AppDefinition.USER_INTERACTION);

		Callable selectSaveFile = UserInteractionBoostUtils.displayDialog("Save configuration", selectModelField(AppDefinition.USER_INTERACTION),
				DialogConfiguration.chooseFile("Save configuration in", false), false, File.class);

		DialogConfiguration overwrite = DialogConfiguration.okCancel("Overwrite cards", "File exists. Overwrite?");
		
		// CallableChain saveCards = new CallableChain("save cards", //
		//
		// selectSaveFile, //
		// CallableByCalling.doIf("save only if file is not null", CallableToBoolean.notNull("file must not be null"),
		// new Callable[] { CallableByCalling.doIf("if file exists ask to overwrite", CallableToBoolean.exists("if file exists"),
		// new Callable[] { new CallableBySelecting("select file", 0)
		//
		// }) }));
		//
		// Object saveResult = saveCards.call(commandName, parameter, displayModel);
		//
		boolean resultValue = true;
		// TODO display feedback
		if (FlashcardDemo.COMMAND_SAVE_CARDS.equals(commandName)) {
			File result = (File) selectSaveFile.call(commandName, parameter, displayModel); // SwingBoostUtils.chooseFile("Save configuration in", false);
			if (result != null) {
				if (result.exists()) {
					if (Integer.valueOf(JOptionPane.YES_OPTION).equals(((UserInteraction) displayModel.get(AppDefinition.USER_INTERACTION)).call(overwrite))) {
						result.delete();
					} else {
						return false;

					}
				}
				getBackend().call(FlashcardDemo.COMMAND_SAVE_CARDS, result, getModelOfBackendLayer());
			}
			// return result;
		} else if (FlashcardDemo.COMMAND_LOAD_CARDS.equals(commandName)) {
			File result = SwingBoostUtils.chooseFile("Load configuration from", false);
			if (result != null && result.exists()) {
				getBackend().call(FlashcardDemo.COMMAND_LOAD_CARDS, result, getModelOfBackendLayer());
				// TODO display feedback
				displayNextCard(null, displayModel);
			}
			// return result;
		} else if (Constants.MOUSE_CLICKED.equals(commandName)) {
			mouseClicked((MouseEvent) parameter, displayModel);
		} else {
			resultValue = false;
		}


		return resultValue;

	}

	/**
	 * Lets the controller choose the next card and puts the result into the display model.
	 * 
	 * @param currentCardKnown
	 *            has the current card been known
	 */
	private void displayNextCard(Boolean currentCardKnown, Map<Object, Object> displayModel) throws Exception {

		Map<Object, Object> model = controllerExecute(FlashcardDemo.COMMAND_NEXT_CARD, currentCardKnown);
		CopyBoostUtils.copyEntries(model, displayModel, FlashcardDemo.FIELD_DISPLAYED_FLASHCARD_SIDE, FlashcardDemo.FIELD_FLASHCARDS_STATISTICS);
		state = STATE_DISPLAYING_WORD;
	}

	private void mouseClicked(MouseEvent event, Map<Object, Object> displayModel) {
		try {
			Map model;
			Boolean currentCardKnown = null;
			switch (state) {
			case STATE_DISPLAYING_TRANSLATION:
				currentCardKnown = (event.getButton() == MouseEvent.BUTTON1);
				// true = known = button 1 ; false = not known = other button
				// continue
			case STATE_INITIAL:
				displayNextCard(currentCardKnown, displayModel);
				break;
			case STATE_DISPLAYING_WORD:
				model = getModelOfBackendLayer();// controllerExecute(AppDefinition.COMMAND_GET_MODEL, null);
				displayModel.put(FlashcardDemo.FIELD_DISPLAYED_FLASHCARD_SIDE,
						((Flashcards<CardElement>) model.get(FlashcardDemo.FIELD_ALL_FLASHCARDS)).getCurrentBacksideString());
				state = STATE_DISPLAYING_TRANSLATION;
				break;
			default:
				throw new IllegalStateException("event not supported in state " + state);
			}

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}


}
