package net.sf.gluebooster.demos.pojo.languages;

import net.sf.gluebooster.java.booster.essentials.objects.BoostedObject;

/**
 * May be one word, an entry of a declension table, etc.
 * 
 * @author cbauer
 *
 */
public class LanguageEntry extends BoostedObject {

	/**
	 * The key to identify the group this entry belongs to. May just be the ending of the stem of the word.
	 */
	public static final String KEY_GROUP_IDENTIFIER = "group identifier";

	/**
	 * The key for the ending of the word.
	 */
	public static final String KEY_ENDING = "ending";

	/**
	 * The key for the type of the word: Adjective, gender, ...
	 */
	public static final String KEY_TYPE = "type";

	/**
	 * Is the word something special in the context.
	 */
	private boolean emphasized = false;

	public LanguageEntry() {
	}

	public LanguageEntry(Case grammaticalCase, Number number, Gender gender, String groupIdentifier, String ending) throws Exception {
		setCase(grammaticalCase);
		setNumber(number);
		setGender(gender);
		setGroupIdentifier(groupIdentifier);
		setEnding(ending);
	}

	public void setCase(Case caseValue) throws Exception {
		setAttribute(Case.class, caseValue);
	}

	public Case getCase() throws Exception {
		return getAttribute(Case.class);
	}

	public void setNumber(Number numberValue) throws Exception {
		setAttribute(Number.class, numberValue);
	}

	public Number getNumber() throws Exception {
		return getAttribute(Number.class);
	}

	public void setGender(Gender genderValue) throws Exception {
		setAttribute(Gender.class, genderValue);
	}

	public Gender getGender() throws Exception {
		return getAttribute(Gender.class);
	}

	public void setEnding(Object ending) throws Exception {
		setAttribute(KEY_ENDING, ending);
	}

	public <Result> Result getEnding() throws Exception {
		return (Result) getAttribute(KEY_ENDING);
	}

	public void setGroupIdentifier(Object identifier) throws Exception {
		setAttribute(KEY_GROUP_IDENTIFIER, identifier);
	}

	public <Result> Result getGroupIdentifier() throws Exception {
		return (Result) getAttribute(KEY_GROUP_IDENTIFIER);
	}

	public void setType(Object type) throws Exception {
		setAttribute(KEY_TYPE, type);
	}

	public <Result> Result getType() throws Exception {
		return (Result) getAttribute(KEY_TYPE);
	}

	public boolean isEmphasized() {
		return emphasized;
	}

	public void setEmphasized(boolean emphasized) {
		this.emphasized = emphasized;
	}

}
