package net.sf.gluebooster.demos.pojo.languages;

import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * One entry (word) of a vocabulary. It contains the word, its pronounciation
 * and translations. It is a List of (word,pronounciation, translations).
 * 
 */
public class VocabularyEntry extends AbstractList<Object> implements
		Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * The word in the original language.
	 */
	private String word;

	/**
	 * The pronounciation of the word.
	 */
	private String pronounciation;

	/**
	 * The translations of the word.
	 */
	private List<String> translations;


	public VocabularyEntry() {

	}

	/**
	 * 
	 * @param translation
	 *            the translation of the word.
	 */
	public VocabularyEntry(String word, String pronounciation,
			String translation) {
		setWord(word);
		setPronounciation(pronounciation);
		setTranslations(new ArrayList<String>(Arrays.asList(translation)));

		// make an arraylist, because it is saveable with
		// XmlBoostUtils.writeAsUtf8Xml
	}

	public final String getWord() {
		return word;
	}

	public final void setWord(String word) {
		this.word = word;
	}

	public final String getPronounciation() {
		return pronounciation;
	}

	public final void setPronounciation(String pronounciation) {
		this.pronounciation = pronounciation;
	}

	public final List<String> getTranslations() {
		return translations;
	}

	public final void setTranslations(List<String> translations) {
		this.translations = translations;
	}

	@Override
	public Object get(int index) {
		switch (index) {
		case 0:
			return word;
		case 1:
			return pronounciation;
		case 2:
			return translations;
		default:
			throw new InvalidParameterException(
					"The index must be 0, 1 or 2. It is " + index);
		}
	}

	@Override
	public Object set(int index, Object element) {
		Object result = get(index);
		switch (index) {
		case 0:
			word = (String) element;
			break;
		case 1:
			pronounciation = (String) element;
			break;
		case 2:
			translations = (List<String>) element;
			break;
		default:
			throw new InvalidParameterException(
					"The index must be 0, 1 or 2. It is " + index);
		}
		return result;
	}

	@Override
	public int size() {

		return 3;
	}


}
