package net.sf.gluebooster.demos.pojo.languages.chinese;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.swing.table.DefaultTableModel;

import org.apache.commons.io.FileUtils;

import net.sf.gluebooster.java.booster.basic.container.ConfigurationBoostUtils;
import net.sf.gluebooster.java.booster.basic.mvc.AppDefinition;
import net.sf.gluebooster.java.booster.basic.mvc.Layer;
import net.sf.gluebooster.java.booster.essentials.utils.IoBoostUtils;

/**
 * Controller of the chinese app. Not yet implemented.
 * 
 * @author CBauer
 * 
 */
public class ChineseAppController extends Layer {

	public static final String ACTION_SORT_TEXT_INTO_VOCABULARY = "Sort text into vocabulary";
	
	/**
	 * The definition of the application.
	 */
	private AppDefinition appDefinition;

	/**
	 * Contains the logic of the commands.
	 */
	private ChineseHelper helper = new ChineseHelper();

	
	public ChineseAppController(AppDefinition appDefinition) throws Exception {
		super("controller");
		this.appDefinition = appDefinition;
	}


	@Override
	protected boolean exec(Object commandName, Object parameter, Map model) throws Exception {
		// first let the super class do what is abstract
		boolean result = super.exec(commandName, parameter, model);

			// TODO: the model should not save or load.
			if (ChineseDemo.COMMAND_CHANGE_TRADITIONAL_TO_SIMPLIFIED.equals(commandName)) {
				String traditional = getSingleParameter(parameter);
				model.put(ChineseDemo.FIELD_ORIGINAL_TEXT, traditional);
				model.put(ChineseDemo.FIELD_TRANSFORMED_TEXT, helper.changeTraditionalToSimplified(traditional));
			result = true;
			} else if (ChineseDemo.COMMAND_EXTRACT_CHARACTERS.equals(commandName)) {
				String chineseText = getSingleParameter(parameter);
				model.put(ChineseDemo.FIELD_ORIGINAL_TEXT, chineseText);

				chineseText = chineseText.replaceAll("[\\u0000-\\u33FF]", "");
				chineseText = chineseText.replaceAll("[\\uA000-\\uFFFF]", "");
				HashSet<String> set = new HashSet<String>();
				for (int i = chineseText.length(); i > 0; i--)
					set.add(chineseText.substring(i - 1, i));
				StringBuilder unique = new StringBuilder();
				for (String character : set) {
					unique.append(character);
				}
				chineseText = unique.toString();
				model.put(ChineseDemo.FIELD_TRANSFORMED_TEXT, chineseText);
			result = true;

			} else if (ChineseDemo.COMMAND_CREATE_VOCABULARY.equals(commandName)) {
				String chineseText = getSingleParameter(parameter);
				model.put(ChineseDemo.FIELD_ORIGINAL_TEXT, chineseText);
				DefaultTableModel vocabularyTable = helper.createChineseVocabulary(chineseText);
				String guiText = displaySaveVocabulary(vocabularyTable, model);
				model.put(ChineseDemo.FIELD_TRANSFORMED_TEXT, guiText);
			result = true;
			} else if (ChineseDemo.COMMAND_SORT_TEXT.equals(commandName)) {

				Object[] vocAndText = (Object[]) parameter;
				String vocabularyText = (String) vocAndText[0];
				String toSortText = (String) vocAndText[1];
				String sortedText = ChineseHelper.sortTextIntoVocabulary(vocabularyText, toSortText).toString();
			// model.put(ChineseDemo.FIELD_ORIGINAL_TEXT, vocabularyText);
				model.put(ChineseDemo.FIELD_TRANSFORMED_TEXT, sortedText);
			result = true;

			} else if (AppDefinition.COMMAND_EDITED_CONFIGURATION.equals(commandName)) {
				Object filename = model.get(ChineseDemo.CONFIGURATION_FIELD_CHINESE_LANGUAGE1_FILE);
				Collection<ChineseVocabularyEntry> dictionary = null;
				if (filename == null) {
					// dictionary stays null
				} else {
					File file = new File(filename.toString());
					if (file.exists()) {
					dictionary = CeDictParser.parseDictionary(new FileReader(file), false);
					} else {
						// dictionary stays null
					}

				}
				helper.setDictionary(dictionary);

				filename = model.get(ChineseDemo.CONFIGURATION_FIELD_CHARACTER_COMPONENTS_FILE);
				Map<String, List<String>> components = null;
				if (filename == null) {
					// components stays null
				} else {
					File file = new File(filename.toString());
					if (file.exists()) {
						String text = FileUtils.readFileToString(file);
						components = helper.parseWikipediaTextToCharacterComponents(text);
					} else {
						// components stays null
					}
				}
				helper.setCharacterComponents(components);
			result = true;
		} else if (AppDefinition.COMMAND_SAVE_CONFIGURATION.equals(commandName)) {
			// File file = getSingleParameter(parameter);
			// ConfigurationBoostUtils.saveConfiguration(model, getAppDefinition().getConfigurationFields(), new FileOutputStream(file), true);
			return true;

			}
		return result;
	}
		
	/**
	 * Converts a vocabulary table and puts it into the model. If a default result file is configured the table is written into the file, too.
	 * 
	 * @param vocabularyTable
	 *            the entries to display
	 * @return the table as text
	 */
	private String displaySaveVocabulary(DefaultTableModel vocabularyTable, Map<Object, Object> model) throws Exception {
		if (vocabularyTable != null) {
			String result = toCSVString(vocabularyTable);
			
			Object resultFilename = model.get(ChineseDemo.CONFIGURATION_FIELD_DEFAULT_RESULT_FILE);
			if (resultFilename != null){
			   File resultFile = new File(resultFilename.toString());
				if (resultFile.getName().endsWith(".ods")) {
					// SpreadSheet sheet = SpreadSheet
					// .createEmpty(vocabularyTable);
					//
					// // if rows have only one cell extend it over all
					// // columns
					// Vector rows = vocabularyTable.getDataVector();
					//
					// final int numberOfColumns = 4;
					// for (int i = 0; i < rows.size(); i++) {
					// Vector rowVector = (Vector) rows.get(i);
					// if (rowVector.size() == numberOfColumns
					// && rowVector.get(0) != null
					// && rowVector.get(1) == null
					// && rowVector.get(2) == null
					// && rowVector.get(3) == null) {
					// Object original = rowVector.get(0);
					// MutableCell<SpreadSheet> cell = sheet
					// .getFirstSheet().getCellAt(0, i + 1);
					// String text = cell.getTextValue();
					// if (!text.equals(original))
					// throw new IllegalStateException("texts differ "
					// + original + " : " + text);
					//
					// cell.getElement().setAttribute(
					// "number-columns-spanned",
					// "" + numberOfColumns,
					// cell.getODDocument().getVersion()
					// .getTABLE());
					//
					// if (numberOfColumns != cell.getColumnsSpanned())
					// throw new IllegalStateException(
					// "wrong col span");
					// }
					//
					// }
					//
					// sheet.saveAs(resultFile);
				} else if (resultFile.getName().endsWith(".wiki")) {
					StringBuilder resultBuilder = new StringBuilder();
					resultBuilder.append("{| class=\"wikitable\"\r\n|-\r\n! Zeichen !! Pinyin !! Übersetzung\r\n");
			
					Vector rows = vocabularyTable.getDataVector();
			
					for (int i = 0; i < rows.size(); i++) {
						Vector rowVector = (Vector) rows.get(i);
						Object chinese = rowVector.get(0);
						Object pinyin = rowVector.get(1);
						Object translation = rowVector.get(2);

						if (pinyin == null || (translation != null && !"".equals(translation.toString().trim()))) {
							// display only lines with german or pure chinese
							// text without translation

							resultBuilder.append("|-\r\n");
							if (pinyin == null) {
								resultBuilder.append("| colspan=\"3\" ");
							}
					
							resultBuilder.append("| {{:Vokabeltexte_Chinesisch/ Vorlage:Chinesisch |").append(chinese).append("}} ");

							if (pinyin != null) {
								resultBuilder.append(" || ").append(pinyin);
								resultBuilder.append(" || ").append(translation);
							}

							resultBuilder.append("\r\n");
						}
					 }

					resultBuilder.append("|}");
			
					FileUtils.write(resultFile, resultBuilder, IoBoostUtils.UTF_8);
			
				} else { // any other file ending
					FileUtils.write(resultFile, result);
				}
				return result;
			}
		}
		return null;
	}
		
	/**
	 * Converts a table into a string using tabs as separators. TODO refactor this method into a general csv class.
	 * 
	 * @param vocabulary
	 *            the table to convert
	 * @return the created string.
	 */
	public String toCSVString(DefaultTableModel vocabulary) {

		StringBuilder result = new StringBuilder();
		for (Object row : vocabulary.getDataVector()) {
			for (Object element : ((Vector) row).toArray()) {
				result.append(element).append("\t");
			}
			result.append("\n");

		}

		return result.toString();

	}

	public AppDefinition getAppDefinition() {
		return appDefinition;
	}

}
