package net.sf.gluebooster.demos.pojo.languages.chinese;

import java.io.File;
import java.util.Map;

import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;

import net.sf.gluebooster.java.booster.basic.container.ConfigurationBoostUtils;
import net.sf.gluebooster.java.booster.basic.gui.DialogConfiguration;
import net.sf.gluebooster.java.booster.basic.gui.UserInteractionBoostUtils;
import net.sf.gluebooster.java.booster.basic.gui.swing.SwingBoostUtils;
import net.sf.gluebooster.java.booster.basic.mvc.AppDefinition;
import net.sf.gluebooster.java.booster.basic.mvc.AppDisplayBySwingBorderLayout;
import net.sf.gluebooster.java.booster.basic.mvc.Layer;
import net.sf.gluebooster.java.booster.basic.transformation.CallableByCalling;
import net.sf.gluebooster.java.booster.basic.transformation.CallableByCopying;
import net.sf.gluebooster.java.booster.basic.transformation.CallableBySelecting;
import net.sf.gluebooster.java.booster.basic.transformation.CallableChain;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.Callable;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.meta.CommentImpl;
import net.sf.gluebooster.java.booster.essentials.meta.objects.DisplayConfiguration;
import net.sf.gluebooster.java.booster.essentials.meta.objects.ObjectDescription;
import net.sf.gluebooster.java.booster.essentials.utils.Constants;
import net.sf.gluebooster.java.booster.essentials.utils.IoBoostUtils;

/**
 * {@Feature}A demo application to support learning chinese.{@FeatureEnd}
 * 
 * TODO: Refactor the commands and fields, so that they contain help text what the constant means.
 * 
 * @author cbauer
 *
 */
public class ChineseDemo {

	/**
	 * Starts the application
	 * 
	 * @param ignored
	 *            parameters are ignored
	 */
	public static void main(String[] ignored) throws Exception {
		startSampleApp();
	}

	/**
	 * Starts the application
	 * 
	 * @return the view of the application
	 */
	public static AppDisplayBySwingBorderLayout startSampleApp() throws Exception {

		AppDefinition appDefinition = createAppDefinition();

		// AbstractAppView.startApplication(ChineseAppController.class, null, ChineseAppView.class, ChineseAppDisplaySwing.class);
		ChineseAppController controller = new ChineseAppController(appDefinition);
		Layer view = createView(appDefinition, controller);// new ChineseAppView(appDefinition, controller);
		// view.setBackend(controller);
		ChineseDemo demo = new ChineseDemo();
		AppDisplayBySwingBorderLayout display = demo.createSwingLayout(view, appDefinition);
		display.setBackend(view);

		// -------------- view configuration
		Map displayModel = display.getModelOfBackendLayer();

		// -----------------------------
		// FlashcardsAppDisplaySwing display = new FlashcardsAppDisplaySwing(view);
		display.call(Constants.START);
		return display;
	}

	private static AppDefinition createAppDefinition() {
		AppDefinition result = new AppDefinition();

		result.setTitle("Chinese");

		DefaultMutableTreeNode configurationRoot = new DefaultMutableTreeNode();
		configurationRoot.add(new DefaultMutableTreeNode(ChineseDemo.CONFIGURATION_FIELD_CHINESE_LANGUAGE1_FILE));
		configurationRoot.add(new DefaultMutableTreeNode(ChineseDemo.CONFIGURATION_FIELD_CHARACTER_COMPONENTS_FILE));
		configurationRoot.add(new DefaultMutableTreeNode(ChineseDemo.CONFIGURATION_FIELD_VOCABULARY_FOR_EACH_LINE));
		configurationRoot.add(new DefaultMutableTreeNode(ChineseDemo.CONFIGURATION_FIELD_DEFAULT_RESULT_FILE));
		result.setConfiguration(configurationRoot);

		return result;
	}

	/**
	 * The singleton instance. No instanciation yet, because the other static constants are not yet defined;
	 */
	// public static final TransformerToConstant<ChineseAppDefinition> singleton = TransformerToConstant
	// .createWithInitializer(TransformerByInvoking.createNewInstanceInvokingTransformer(ChineseAppDefinition.class));
	
	/**
	 * The command to convert traditional chinese characters into their simplified form.
	 */
	public static final String COMMAND_CHANGE_TRADITIONAL_TO_SIMPLIFIED = "Traditional -> Simplified";
	/**
	 * The command to create the vocabulary from a given text.
	 */
	public static final String COMMAND_CREATE_VOCABULARY = "Create vocabulary";
	/**
	 * The command to extract the chinese characters from a given text.
	 */
	public static final String COMMAND_EXTRACT_CHARACTERS = "Extract characters";
	/**
	 * The command to sort the lines of a given text into another. Each line at the position where all characters are known
	 */
	public static final String COMMAND_SORT_TEXT = "Sort text";
	/**
	 * Description of the corresponding configuration field.
	 */
	public static final ObjectDescription CONFIGURATION_FIELD_CHARACTER_COMPONENTS_FILE = new ObjectDescription("Character Components File",
			"The file that contains the character components composition", File.class);
	/**
	 * Description of the corresponding configuration field.
	 */
	// public static final ObjectDescription CONFIGURATION_FIELD_CHINESE_FRENCH_FILE = ObjectDescriptionBoostUtils.create("Chinese French Dictionary File",
	// "The file that contains the chinese french dictionary", File.class);
	/**
	 * Description of the corresponding configuration field.
	 */
	public static final ObjectDescription CONFIGURATION_FIELD_CHINESE_LANGUAGE1_FILE = new ObjectDescription("Chinese Language 1 Dictionary File",
			"The file that contains the chinese dictionary into language 1", File.class);
	/**
	 * Description of the corresponding configuration field.
	 */
	public static final ObjectDescription CONFIGURATION_FIELD_DEFAULT_RESULT_FILE = new ObjectDescription("Default file for results",
			"The content of the right side will be written into this file", File.class);
	/**
	 * Description of the corresponding configuration field.
	 */
	// public static final ObjectDescription CONFIGURATION_FIELD_CHINESE_TEXT_FILE = ObjectDescriptionBoostUtils.create("Chinese Text File",
	// "The file that contains the chinese text", File.class);
	/**
	 * Description of the corresponding configuration field.
	 */
	public static final ObjectDescription CONFIGURATION_FIELD_VOCABULARY_FOR_EACH_LINE = new ObjectDescription("Vocabulary for each line",
			"Should the vocabulary created for each line (instead for the whole text)", Boolean.class);
	/**
	 * The name of the field of the original text that will be transformed
	 */
	public static final String FIELD_ORIGINAL_TEXT = "Original Text";
	/**
	 * The name of the field with the transformed text
	 */
	public static final String FIELD_TRANSFORMED_TEXT = "Transformed Text";

	/**
	 * Creates a layout of the application with swing components.
	 * 
	 * @param view
	 *            the view of the application
	 * @return the created layout
	 */
	private AppDisplayBySwingBorderLayout createSwingLayout(Layer view, AppDefinition appDefinition) throws Exception {

		DisplayConfiguration displayConfiguration = new DisplayConfiguration("display");
		AppDisplayBySwingBorderLayout result = new AppDisplayBySwingBorderLayout(displayConfiguration, view, appDefinition);

		result.setSouth(SwingBoostUtils.createPanel(
				result.createButton("Traditional (left) -> Simplified (right)", COMMAND_CHANGE_TRADITIONAL_TO_SIMPLIFIED), //
				result.createButton("Create Vocabulary from Text", COMMAND_CREATE_VOCABULARY), //
				result.createButton("Extract characters", COMMAND_EXTRACT_CHARACTERS), //
				result.createButton("Sort", COMMAND_SORT_TEXT)));
		result.setCommandCallable(COMMAND_CHANGE_TRADITIONAL_TO_SIMPLIFIED, result.passTo(view, true));
		result.setCommandCallable(COMMAND_CREATE_VOCABULARY, result.passTo(view, true));
		result.setCommandCallable(COMMAND_EXTRACT_CHARACTERS, result.passTo(view, true));
		result.setCommandCallable(COMMAND_SORT_TEXT, result.passTo(view, true));

		result.setWest(result.putComponentIntoDisplayModel(ChineseDemo.FIELD_ORIGINAL_TEXT, new JTextArea(100, 50)));

		result.setEast(result.putComponentIntoDisplayModel(ChineseDemo.FIELD_TRANSFORMED_TEXT, new JTextArea(100, 50)));

		// result.addToMenuBar(result.createMenu("Options", "Change dictionary", ChineseAppDefinition.COMMAND_LOAD_DICTIONARY));
		result.addMenuConfiguration(view);
		result.setCommandCallable(AppDefinition.COMMAND_EDITED_CONFIGURATION, result.passTo(view, true));

		return result;
	}

	private static Layer createView(AppDefinition appDefinition, ChineseAppController backend) throws Exception {

		Layer view = new Layer("view");
		view.setBackend(backend);

		view.noStopNecessary();

		CallableChain callBackendAndCopyToClipboard = new CallableChain<>("call backend with original text and copy the result into the clipboard", //
				new CommentImpl("command, ignored parameter, displayModel"), //
				new CallableByCalling<>("extract command and original text",
						new Callable[] { view.selectCommand(), // new CallableBySelecting("select command", 0), // command
								view.selectModelField(ChineseDemo.FIELD_ORIGINAL_TEXT), view.selectModel() }), //
				new CommentImpl("command, displayModel.get(ChineseDemo.FIELD_ORIGINAL_TEXT), display model"), //
				view.passTo(backend, false), //
				new CommentImpl("display model"), //
				new CallableBySelecting("select transformed text", ChineseDemo.FIELD_TRANSFORMED_TEXT), //
				IoBoostUtils.copyToClipboard()

		);
		// callBackendAndCopyToClipboard.setBreakpoint(new CallableByConstant("breakpoint"));
		view.setCommandCallable(ChineseDemo.COMMAND_CHANGE_TRADITIONAL_TO_SIMPLIFIED, callBackendAndCopyToClipboard);
		view.setCommandCallable(ChineseDemo.COMMAND_CREATE_VOCABULARY, callBackendAndCopyToClipboard);
		view.setCommandCallable(ChineseDemo.COMMAND_EXTRACT_CHARACTERS, callBackendAndCopyToClipboard);

		CallableChain sortText = new CallableChain("sort text", //
				new CommentImpl("command, ignored parameter, displayModel"), //
				new CallableByCalling("extract command, vocabularyText and text to sort, displayModel",
						new Callable[] { //
								view.selectCommand(), // new CallableBySelecting("select command", 0), // command
								new CallableByCalling("extract vocabularyText and text to sort",
										new Callable[] { //
												view.selectModelField(ChineseDemo.FIELD_ORIGINAL_TEXT),
												view.selectModelField(ChineseDemo.FIELD_TRANSFORMED_TEXT)

										}), // [ vocabulary, text to sort]
								view.selectModel()

						}), //
				new CommentImpl("command, [vocabulary, text to sort], displayModel"), //
				view.passTo(backend, false), //
				new CommentImpl("display model"), //
				new CallableBySelecting("select transformed text", ChineseDemo.FIELD_TRANSFORMED_TEXT), //
				IoBoostUtils.copyToClipboard());
		view.setCommandCallable(ChineseDemo.COMMAND_SORT_TEXT, sortText);

		CallableAbstraction passToBackendWithout = view.passTo(backend, false);
		// passToBackendWithout.setBreakpoint(new CallableByConstant("breakpoint"));
		view.setCommandCallable(AppDefinition.COMMAND_EDITED_CONFIGURATION, passToBackendWithout);

		Callable start = new CallableChain("set title when starting", //
				new CommentImpl("command, ignored parameter, displayModel"), //
				view.selectModel(), new CallableByCopying("set title", appDefinition.getTitle(), null, AppDefinition.FIELD_TITLE));

		view.setCommandCallable(Constants.START, start);

		// if (AppDefinition.COMMAND_SAVE_CONFIGURATION.equals(commandName)) {
		//
		DialogConfiguration dialog = DialogConfiguration.chooseFile("Save configuration to", false);

		CallableChain saveConfiguration = new CallableChain("save configuration", //
				new CommentImpl("command, ignored parameter, displayModel"), //

				new CallableByCalling("determine file and prepare parameters",
						new Object[] { Constants.SAVE, view.selectModel(), appDefinition.getConfigurationFields(),
								UserInteractionBoostUtils.displayDialog("save configuration", view.selectModelField(AppDefinition.USER_INTERACTION), dialog,
										false, null)
						}), //
				new CommentImpl("SAVE, displayModel, configuration fields, file"), //
				new ConfigurationBoostUtils()// saves the configuration
		// file or null: Missing feedback whether saved or not

		);
		view.setCommandCallable(AppDefinition.COMMAND_SAVE_CONFIGURATION, saveConfiguration);

		return view;
	}
}
