package net.sf.gluebooster.demos.pojo.languages.chinese;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

/**
 * One entry in the CC-CEDICT format.
 * 
 * http://cc-cedict.org/wiki/format:syntax
 * 
 * @author CBauer
 *
 */
public class ChineseVocabularyEntry {

	/**
	 * The traditional notation.
	 */
	private String traditional;
	/**
	 * The simplified notation.
	 */
	private String simplified;

	/**
	 * The different pinyin transcriptions and the corresponding translations.
	 */
	private List<Pair<String, List<String>>> pinyinTranslations;

	private List<String> authors;

	public ChineseVocabularyEntry() {

	}

	public ChineseVocabularyEntry(String simplified, String author) {
		this.simplified = simplified;
		addAuthor(author);

	}

	public String getTraditional() {
		return traditional;
	}

	public void setTraditional(String traditional) {
		this.traditional = traditional;
	}

	public String getSimplified() {
		return simplified;
	}

	public void setSimplified(String simplified) {
		this.simplified = simplified;
	}

	public List<Pair<String, List<String>>> getPinyinTranslations() {
		return pinyinTranslations;
	}

	public void setPinyinTranslations(
			List<Pair<String, List<String>>> pinyinTranslations) {
		this.pinyinTranslations = pinyinTranslations;
	}

	public boolean hasPinyinTranslations() {
		return pinyinTranslations != null && !pinyinTranslations.isEmpty();
	}

	@Override
	public String toString() {

		return "" + traditional + " " + simplified + " " + pinyinTranslations;
	}

	public void addAuthor(String author) {
		if (authors == null) {
			authors = new ArrayList<String>();
		}
		if (!authors.contains(author)) {
			authors.add(author);
		}
	}

	public void addTranslation(String translation) {

		if (pinyinTranslations == null) {
			pinyinTranslations = new ArrayList<Pair<String, List<String>>>();
			pinyinTranslations.add(new MutablePair<String, List<String>>(null, new ArrayList<String>()));
		}

		List<String> translations = pinyinTranslations.get(0).getRight();
		if (!translations.contains(translation)) {
			translations.add(translation);
		}
	}

	public void addTranslation(String translation, String author) {
		if (author != null) {
			addAuthor(author);
		}

		addTranslation(translation);
	}

	public void addTranslations(List<Pair<String, List<String>>> pinyinTranslations, List<String> authors) {
		if (authors != null) {
			for (String author : authors) {
				addAuthor(author);
			}
		}
		if (pinyinTranslations != null) {
			for (Pair<String, List<String>> pinyinTranslation : pinyinTranslations) {
				List<String> translations = pinyinTranslation.getRight();
				if (translations != null) {
					for (String translation : translations) {
						addTranslation(translation);
					}
				}
			}
		}
	}

	public List<String> getAuthors() {
		return authors;
	}

	public void setAuthors(List<String> authors) {
		this.authors = authors;
	}

}
