package net.sf.gluebooster.demos.pojo.languages.sanskrit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.tuple.Pair;

import net.sf.gluebooster.demos.pojo.languages.Case;
import net.sf.gluebooster.demos.pojo.languages.Gender;
import net.sf.gluebooster.demos.pojo.languages.LanguageEntry;
import net.sf.gluebooster.demos.pojo.languages.Number;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Suche: sanskritdictionary.com/?q=ekatraya&iencoding=&lang=
 * 
 * Verweise auf Wörterbücher:
 * 
 * Beispiel:
 * 
 * <b>त</b>
 * 
 * <a rel="nofollow" class="external text" href="http://www.sanskrit-lexicon.uni-koeln.de/scans/PWGScan/disp1/index.php?key=ta">BR</a>
 * 
 * <a rel="nofollow" class="external text" href="http://www.sanskrit-lexicon.uni-koeln.de/monier/indexcaller.php?key=ta">MW</a>
 * 
 * <a rel="nofollow" class=
 * "external text" href="http://spokensanskrit.de/index.php?script=DI&amp;country_ID=&amp;trans=Translate&amp;direction=SE&amp;tinput=त">SP</a>
 * 
 * <a rel="nofollow" class="external text" href="http://dsal.uchicago.edu/cgi-bin/romadict.pl?display=utf8&amp;table=macdonell&amp;query=त">MD</a>
 * 
 * @author cbauer
 *
 */
public class Sanskrit {

	public static Sanskrit SINGLETON = new Sanskrit();

	private List<SanskritWord> words = new ArrayList<SanskritWord>();
	private Map<String, SanskritWord> unicodeWord = new HashMap<String, SanskritWord>();

	private List<LanguageEntry> declension = new ArrayList<LanguageEntry>();

	public Sanskrit() {
		try {
			addWord(new SanskritWord("अ", "a", "a", "Präfix", "nicht", "''Gegenteil''", null, Arrays.asList()));
			addWord(new SanskritWord("अकरण", "akaraṇa", "akaraNa", "adj", "kunstlos, natürlich", null, null, Arrays.asList()));
			addWord(new SanskritWord("अकल्पित", "akalpita", "akalpita", "adj", "nicht hergestellt, nicht künstlich", "natürlich", null, Arrays.asList()));
			addWord(new SanskritWord("अकुसीद", "akusīda", "akusIda", "adj", "ohne Interesse,", "ohne Gewinn", null, Arrays.asList()));
			addWord(new SanskritWord("अक्रम", "akrama", "akrama", "m", "Unordnung, Verwirrung", null, null, Arrays.asList()));
			addWord(new SanskritWord("अक्लिष्ट", "akliṣṭa", "akliSTa", "adj", "nicht unangenehm, nicht mit Leid verbunden", "angenehm, ungestört", null,
					Arrays.asList("a", "kliṣṭa")));
			addWord(new SanskritWord("अक्ष", "akṣa", "akSa", "m", "Achse, Rad, Auge", "Sinnesorgan", null, Arrays.asList()));
			addWord(new SanskritWord("अङ्ग", "aṅga", "aGga", "n", "Glied eines Körpers", "Teil eines Ganzen", null, Arrays.asList()));
			addWord(new SanskritWord("अङ्गमेजयत्व", "aṅgamejayatva", "aGgamajayatva", "n", "Zittern der Glieder", "Nervosität", null,
					Arrays.asList("aṅga", "ejayatva")));
			addWord(new SanskritWord("अज्ञात", "ajñāta", "ajJAta", "adj", "unbekannt", null, null, Arrays.asList()));
			addWord(new SanskritWord("अज्ञान", "ajñāna", "ajJAna", "n", "Unwissenheit, Nichtwissenheit", null, null, Arrays.asList("a", "jñāna")));
			addWord(new SanskritWord("अञ्ज्", "añj", "aJj", "v", "salben, bestreichen, schmücken", null, null, Arrays.asList()));
			addWord(new SanskritWord("अञ्जन", "añjana", "aJjana", "n", "Salben, Salbe", null, null, Arrays.asList("añj")));
			addWord(new SanskritWord("अणु", "aṇu", "aNu", "a", "fein, dünn, schmal, sehr klein", null, null, Arrays.asList()));
			addWord(new SanskritWord("अतद्रूप", "atadrūpa", "atadrUpa", "adj", "nicht diese Form", null, null, Arrays.asList("a", "tadrūpa")));
			addWord(new SanskritWord("अति", "ati", "ati", "adv. undekl.", "über, hinaus", null, null, Arrays.asList()));
			addWord(new SanskritWord("अतीत", "atīta", "atIta", "adj", "vergangen", "zurückgelassen", null, Arrays.asList()));
			addWord(new SanskritWord("अतिप्रसण्ग", "atiprasaṅga", "atiprasaNga", "m", "Überflüssigkeit, ad absurdum führen", null, null, Arrays.asList()));
			addWord(new SanskritWord("अतिशय", "atiśaya", "atizaya", "m", "Vorrang, Vorzug, hervorragend", null, null, Arrays.asList("ati", "zaya")));
			addWord(new SanskritWord("अत्यन्त", "atyanta", "atyanta", "adj", "über das Ende/die Grenze hinausreichend", "fortwährend, auf immer, beständig",
					null, Arrays.asList()));
			addWord(new SanskritWord("अथ", "atha", "atha", "undekl.", "(am Buch- oder Kapitelbeginn) jetzt kommt",
					"dann, da, ferner; doch, dagegen; wenn aber", "oft als Partikel, die einen Anfang anzeigt", Arrays.asList()));
			addWord(new SanskritWord("अदृष्ट", "adṛṣṭa", "adRSTa", "adj", "nicht gesehen", "unbemerkt, unsichtbar", null, Arrays.asList("a", "dṛṣṭa")));
			addWord(new SanskritWord("अधि", "adhi", "adhi", "adv, präp", "auf, über", "mit Vorrang", null, Arrays.asList()));
			addWord(
					new SanskritWord("अधिगम", "adhigama", "adhigama", "m", "Erreichen, Erlangen", "Gewinn, Erkenntnisse", null, Arrays.asList("adhi", "gama")));
			addWord(new SanskritWord("अधिमात्र", "adhimātra", "adhimAtra", "adj", "stark, intensiv", null, null, Arrays.asList("adhi", "mātra")));
			addWord(new SanskritWord("अधिष्ठातृ", "adhiṣṭhātṛ", "adhiSThAtR", "adj", "herrschen, leiten", null, null, Arrays.asList()));
			addWord(new SanskritWord("अध्यात्म", "adhyātma", "adhyAtma", "n", "der höchste Geist", null, null, Arrays.asList("adhi", "ātma")));
			addWord(new SanskritWord("अध्यास", "adhyāsa", "adhyAsa", "m", "Aufsetzen, Aufstellen", "Anhang, Zusatz, Übertragung", null, Arrays.asList()));
			addWord(new SanskritWord("अध्वन्", "adhvan", "adhvan", "m", "Weg, Entfernung", "Zeit", null, Arrays.asList()));
			addWord(new SanskritWord("अन्", "an", "an", null, "atmen", "negierendes Partikel am Wortanfang", null, Arrays.asList()));
			addWord(new SanskritWord("अनादि", "anādi", "anAdi", "adj", "ohne Anfang", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनन्त", "ananta", "ananta", "adj", "unendlich", "'ein Name'", null, Arrays.asList()));
			addWord(new SanskritWord("अनन्त्य", "anantya", "anantya", "n", "Unendlichkeit", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनभिघात", "anabhighāta", "anabhighAta", "m", "Nichtangriff", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनवच्छिन्ना", "anavacchinnā", "anavacchinnA", null, "nicht unterbrochen, nicht gestört", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनवच्छेद", "anavaccheda", "anavaccheda", "m", "Nichtbestimmtsein", null, null, Arrays.asList("a", "avaccheda")));
			addWord(new SanskritWord("अनवस्थित", "anavasthita", "anavasthita", "adj.", "unstetig, instablil", null, null, Arrays.asList("a", "avasthā")));
			addWord(new SanskritWord("अनवस्थितत्वानि", "anavasthitatvāni", "anavasthitatvAni", null, "Unstetigkeit, Unbeständigkeit", null, null,
					Arrays.asList("anavasthita")));
			addWord(new SanskritWord("अनष्ट", "anaṣṭa", "anaSTa", "adj", "nicht umgekommen, nicht verloren gegangen", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनागत", "anāgata", "anAgata", "adj", "noch nicht angekommen", "zukünftig, bevorstehend", null, Arrays.asList()));
			addWord(new SanskritWord("अनित्य", "anitya", "anitya", "adj", "nicht ewig dauernd, nicht beständig", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनिष्ट", "aniṣṭa", "aniSTa", "adj", "unangenehm, schädlich", "verboten", null, Arrays.asList()));
			addWord(new SanskritWord("अन्यता", "anyatā", "anyatA", "f", "Verschiedenheit, Unterschied", null, null, Arrays.asList()));
			addWord(
					new SanskritWord("अणिमन्", "aṇiman", "aNiman", "m", "Dünne, Feinheit", "die Kunst, sich unendlich klein zu machen", null, Arrays.asList()));
			addWord(new SanskritWord("अनु", "anu", "anu", "undekl.", "entsprechend, gemäß, nahe, eins nach dem anderen, methodisch", null, null,
					Arrays.asList()));
			addWord(new SanskritWord("अनुकार", "anukāra", "anukAra", "m", "Nachahmung, Gleichheit", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनुगम", "anugama", "anugama", "m", "Nachgehen, Folgen, Eindringen", null, null, Arrays.asList("anu", "gama")));
			addWord(new SanskritWord("अनुगुण", "anuguṇa", "anuguNa", "adj", "von entsprechenden Eigenschaften, entsprechend, gleichartig", null, null,
					Arrays.asList()));
			addWord(new SanskritWord("अनुत्तम", "anuttama", "anuttama", "m", "der höchste, vorzüglichste", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनुपश्य", "anupaśya", "anupazya", "adj", "erschauend", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनुपात", "anupāta", "anupAta", "m", "eines fällt nach dem nächsten herab", "folgend, Nachfolge", null,
					Arrays.asList("anu", "pāta")));
			addWord(new SanskritWord("अनुपातिन्", "anupātin", "anupAtin", "adj", "folgend", null, null, Arrays.asList("anu", "pātin")));
			addWord(new SanskritWord("अनुभूत", "anubhūta", "anubhUta", "adj", "wahrgenommen, verstanden", null, null, Arrays.asList("anu", "bhūta")));
			addWord(new SanskritWord("अनुमान", "anumāna", "anumAna", "n",
					"Schluss, Schlussfolgerung; Anzeichen, insofern auf dasselbe ein Schluss gegründet wird", "Analogie, Gemässheit", null,
					Arrays.asList("anu", "māna")));
			addWord(new SanskritWord("अनुमोदित", "anumodita", "anumodita", "adj", "gefallen, zugestimmt, gebilligt", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनुलोम", "anuloma", "anuloma", "adj", "nach dem Haarwuchs,mit dem Strich", "in der natürlichen Richtung", null,
					Arrays.asList("anu", "loman")));
			addWord(new SanskritWord("अनुष्ठान", "anuṣṭhāna", "anuSThAna", "n", "Beginnen, Vollbringen, Handlung (f)", null, null, Arrays.asList()));
			addWord(new SanskritWord("अनुशयिन्", "anuśayin", "anuzayin", "adj", "treu anhängend, verbunden mit", "hat zur Folge", null, Arrays.asList()));
			addWord(new SanskritWord("अनुशासन", "anuśāsana", "anuzAsana", "n", "Anweisung, Belehrung", "Name einer Literaturgattung", null,
					Arrays.asList("anu", "śāsana")));
			addWord(new SanskritWord("अनेक", "aneka", "aneka", "adj", "nicht ein", "mehr als ein", null, Arrays.asList()));
			addWord(new SanskritWord("अन्त", "anta", "anta", "m", "Rand, Ende", "Nähe", null, Arrays.asList()));
			addWord(new SanskritWord("अन्तर्", "antar", "antar", "adv undekl.", "innen, zwischen", null, null, Arrays.asList("anta")));
			addWord(new SanskritWord("अन्तर", "antara", "antara", "adj", "innen, angrenzend, nahe", "nahe stehend, verschiedenvon", null, Arrays.asList()));
			addWord(new SanskritWord("अन्तराय", "antarāya", "antarAya", "adj", "dazwischen tretend", "Hindernis", null, Arrays.asList("antar", "āya")));
			addWord(new SanskritWord("अन्तर्धान", "antardhāna", "antardhAna", "n", "Verschwinden", "Unsichtbarkeit", null, Arrays.asList()));
			addWord(new SanskritWord("अन्तर्य", "antarya", "antarya", "adj", "innerlich, inneres", null, null, Arrays.asList("antar")));
			addWord(new SanskritWord("अन्य", "anya", "anya", "adj m", "verschieden, ein anderer", null, null, Arrays.asList()));
			addWord(new SanskritWord("अन्यत्व", "anyatva", "anyatva", "n", "Unterschied, Verschiedenheit", null, null, Arrays.asList()));
			addWord(new SanskritWord("अन्वय", "anvaya", "anvaya", "m", "Nachfolge, Nachkommenschaft, Familie, Geschlecht",
					"Rücktritt, Verbindung, Zusammenhang der Dinge", null, Arrays.asList()));
			addWord(new SanskritWord("अपर", "apara", "apara", "adj", "ohne Überlegenen, ohne Rivalen, der hintere, der spätere", "entfernt", null,
					Arrays.asList("a", "para")));
			addWord(
					new SanskritWord("अपरान्त", "aparānta", "aparAnta", "m", "an der westlichen Grenze gelegen", "der zukünftige Tod", null, Arrays.asList()));
			addWord(new SanskritWord("अपरामृष्ट", "aparāmṛṣṭa", "aparAmRSTa", null, "völlig unberührt", null, null, Arrays.asList("apara", "ṛṣṭa")));
			addWord(new SanskritWord("अपरिग्रह", "aparigraha", "aparigraha", "m", "Entblössung", "Armut, Besitzlosigkeit", null, Arrays.asList()));
			addWord(new SanskritWord("अपरिणामिन्", "apariṇāmin", "apariNAmin", "adj", "nicht wechselnd", null, null, Arrays.asList()));
			addWord(new SanskritWord("अपवर्ग", "apavarga", "apavarga", "m", "Abschluss, Ende, Ausnahme", "Befreiung der Seele", null, Arrays.asList()));
			addWord(new SanskritWord("अपि", "api", "api", "undekl.", "auch, selbst, sogar", null, null, Arrays.asList()));
			addWord(new SanskritWord("अपुण्य", "apuṇya", "apuNya", "adj", "nicht wohlriechend, nicht verdienstvoll", "unrein, schlecht", null,
					Arrays.asList("a", "puṇya")));
			addWord(new SanskritWord("अपेक्षिन्", "apekṣin", "apekSin", "adj", "berücksichtigend, erwartend", null, null, Arrays.asList()));
			addWord(new SanskritWord("अपेत", "apeta", "apeta", "adj", "entflohen, frei von", null, null, Arrays.asList()));
			addWord(new SanskritWord("अप्रति", "aprati", "aprati", "adj", "unwiderstehlich", null, null, Arrays.asList()));
			addWord(new SanskritWord("अप्रमाण", "apramāṇa", "apramANa", "adj", "ohne Maß, ohne Gewicht", "ohne Autorität", null, Arrays.asList()));
			addWord(new SanskritWord("अप्रयोजक", "aprayojaka", "aprayojaka", "adj", "nicht hingehörig", "zwecklos", null, Arrays.asList()));
			addWord(new SanskritWord("अभाव", "abhāva", "abhAva", "m", "Abwesenheit", "Nicht-Existenz, Vernichtung, Tod", null, Arrays.asList("a", "bhāva")));
			addWord(new SanskritWord("अभि", "abhi", "abhi", "undekl.", "herein, hin zu, oben, über", "Überlegenheit", null, Arrays.asList()));
			addWord(new SanskritWord("अभिघात", "abhighāta", "abhighAta", "m", "Schlag, Angriff", "Anstoss (beim Aussprechen von Lauten)", null,
					Arrays.asList()));
			addWord(new SanskritWord("अभिमत", "abhimata", "abhimata", "n adj", "Wunsch, gewünscht, verlangt", null, null, Arrays.asList("abhi", "mata")));
			addWord(new SanskritWord("अभिभव", "abhibhava", "abhibhava", "m", "Hinzukommen, Dazukommen",
					"Übermacht, Überwältigung, Demütigung, Beschämung, Verschwinden, Unsichtbarwerden", null, Arrays.asList()));
			addWord(new SanskritWord("अभिजात", "abhijāta", "abhijAta", "adj", "geboren, von edler Herkunft", null, null, Arrays.asList("abhi", "jāta")));
			addWord(new SanskritWord("अभिनिवेश", "abhiniveśa", "abhiniveza", "m", "Hingabe, Neigung, Vorhaben, Anhaften", "Anhaften am Leben", null,
					Arrays.asList()));
			addWord(new SanskritWord("अभिव्यक्ति", "abhivyakti", "abhivyakti", "f", "Erscheinung, Offenbarwerdung", null, null, Arrays.asList()));
			addWord(new SanskritWord("अभ्यन्तर", "abhyantara", "abhyantara", "n", "das Innere, Zwischenraum", null, null, Arrays.asList()));
			addWord(new SanskritWord("अभ्यास", "abhyāsa", "abhyAsa", "m", "etwas hinzufügen", "Verdopplung, Wiederholung, Übung", null,
					Arrays.asList("abhi", "as")));
			addWord(new SanskritWord("अम्", "am", "am", "√", "gehen, schnell", null, null, Arrays.asList()));
			addWord(new SanskritWord("अय", "aya", "aya", "m", "Gang, gehen", "Umlauf, Periode, Zahl 4", null, Arrays.asList()));
			addWord(new SanskritWord("अरिष्ट", "ariṣṭa", "ariSTa", "n", "unversehrt, vollkommen, sicher",
					"Unglück bringend, ungünstiges Symbol, Anzeichen des Todes", null, Arrays.asList()));
			addWord(new SanskritWord("अर्थ", "artha", "artha", "m", "Ziel, Zweck, Grund, Sache, Objekt", null, null, Arrays.asList()));
			addWord(new SanskritWord("अर्थ", "arthatva", "arthatva", null, "benützen, zu Dienste machen", null, null, Arrays.asList("artha")));
			addWord(new SanskritWord("अर्थवत्त्व", "arthavattva", "arthavattva", "n", "Bedeutsamkeit", null, null, Arrays.asList()));
			addWord(new SanskritWord("अर्ध", "ardha", "ardha", "m", "Seite, Teil", "adj halb, hälftig, Platz, Region", null, Arrays.asList()));
			addWord(new SanskritWord("अलब्ध", "alabdha", "alabdha", null, "nicht erreichen, nicht erhalten", null, null, Arrays.asList("a", "labdha")));
			addWord(new SanskritWord("अलिङ्ग", "aliṅga", "aliGga", "adj", "ohne Bezeichnung, ohne Unterschied", null, null, Arrays.asList("a", "liṅga")));
			addWord(new SanskritWord("अल्प", "alpa", "alpa", "adj", "klein, wenig", null, null, Arrays.asList()));
			addWord(new SanskritWord("अव", "ava", "ava", "undekl.", "weg, unten", null, null, Arrays.asList()));
			addWord(new SanskritWord("अवच्छेद", "avaccheda", "avaccheda", "m", "Abgeschnittenes, Abschnitt, Trennung", null, null,
					Arrays.asList("ava", "chid")));
			addWord(new SanskritWord("अवधारण", "avadhāraṇa", "avadhAraNa", "n", "Bestätigung, Bejahung, genaues Bestimmen", null, null, Arrays.asList()));
			addWord(new SanskritWord("अवस्था", "avasthā", "avasthA", "f", "hinuntergehen, hineingehen, bleiben",
					"in einem Zustand bleiben, Art und Weise, einnehmen, Situation", null, Arrays.asList("ava", "sthā")));
			addWord(new SanskritWord("अवस्थान", "avasthāna", "avasthAna", "n",
					"das auf - Etwas - Stehen oder sich - Stellen, Sichbefinden, Wohnen, Verbleiben, Verharren, Aufenthalt", "Standort, Lage; Bestand", null,
					Arrays.asList("avasthā")));
			addWord(new SanskritWord("अविद्य", "avidya", "avidya", "adj", "ungelernt, unwissend", null, null, Arrays.asList()));
			addWord(new SanskritWord("अविद्द्या", "avidyā", "avidyA", "f", "Unwissenheit", "Illusion, spirituelle Unwissenheit", null, Arrays.asList()));
			addWord(new SanskritWord("अविप्लव", "aviplava", "aviplava", "adj", "ununterbrochen", "unbeschädigt, rein", null, Arrays.asList()));
			addWord(
					new SanskritWord("अविरति", "avirati", "avirati", "f", "Unenthaltsamkeit", "Hängen an Sinnesobjekten", null, Arrays.asList("a", "virati")));
			addWord(new SanskritWord("अविशेष", "aviśeṣa", "avizeSa", "m", "Ununterschiedenheit", null, null, Arrays.asList()));
			addWord(new SanskritWord("अविषयीभूत", "aviṣayībhūta", "aviSayIbhUta", "adj", "nicht die Herrschaft erhalten über", null, null, Arrays.asList()));
			addWord(new SanskritWord("अव्यपदेश्य", "avyapadeśya", "avyapadezya", "adj", "undefinierbar, unbenennbar", null, null, Arrays.asList()));
			addWord(new SanskritWord("अशुचि", "aśuci", "azuci", null, "nicht strahlend", "unrein", "a", Arrays.asList("śuci")));
			addWord(new SanskritWord("अशुद्धि", "aśuddhi", "azuddhi", "f", "Unreinheit", null, null, Arrays.asList()));
			addWord(new SanskritWord("अष्ट", "aṣṭa", "aSTa", null, "acht", null, null, Arrays.asList()));
			addWord(new SanskritWord("अस्", "as", "as", "√", "sein, werfen", "jemand", null, Arrays.asList()));
			addWord(new SanskritWord("असन", "asana", "asana", "n", "Schleudern", "Schießen, Schuss", null, Arrays.asList()));
			addWord(new SanskritWord("असन", "asaṃkīrṇa", "asaMkIrNa", "n", "nicht dicht bevölkert, nicht gemischt", null, null,
					Arrays.asList("a", "saṃkīrṇa")));
			addWord(new SanskritWord("असंख्य", "asaṃkhya", "asaMkhya", "adj", "ohne Zahl, unzählbar", null, "a", Arrays.asList("saṃkhya")));
			addWord(new SanskritWord("असंप्रमोष", "asaṃpramoṣa", "asaMpramoSa", "m", "nicht Verschwunden", "das Nichtvergessen", null,
					Arrays.asList("a", "sampramoṣa")));
			addWord(new SanskritWord("असंप्रयोग", "asaṃprayoga", "asaMprayoga", "m", "Nicht-Verbindung", null, null, Arrays.asList()));
			addWord(new SanskritWord("असंसर्ग", "asaṃsarga", "asaMsarga", null, "fehlender Umgang, Nicht-Berühren", null, null, Arrays.asList()));
			addWord(new SanskritWord("असङ्ग", "asaṅga", "asaGga", "m", "nicht hängen bleiben (adj), Nicht-Anhängen, Nicht-Anhaften", null, null,
					Arrays.asList()));
			addWord(new SanskritWord("अस्तेय", "asteya", "asteya", "n", "Nichtstehlen", null, null, Arrays.asList()));
			addWord(new SanskritWord("अस्मि", "asmi", "asmi", null, "ich bin", null, "1. Person Singular", Arrays.asList("as")));
			addWord(new SanskritWord("अस्मिता", "asmitā", "asmitA", "f", "Ichbinsein; Selbstsucht", "Ichbewußtsein", null, Arrays.asList("asmi", "tā")));
			addWord(new SanskritWord("अहिंसा", "ahiṃsā", "ahiMsA", "f", "Nicht verletzen", "Gewaltlosigkeit", null, Arrays.asList()));

			addWord(new SanskritWord("आ", "ā", "A", "undekl.", "nahe, bis", "hinzu, Steigerung, ''Erinnerung''", null, Arrays.asList()));
			addWord(new SanskritWord("आकार", "ākāra", "AkAra", "m", "Form, Gestalt, äußere Erscheinung", null, null, Arrays.asList()));
			addWord(new SanskritWord("आकाश", "ākāśa", "AkAza", "n", "Licht, Helle, Raum", null, null, Arrays.asList()));
			addWord(new SanskritWord("आक्षेपिन्", "ākṣepin", "AkSepin", "adj", "betreffend, befassend", "hindeutend", null, Arrays.asList()));
			addWord(new SanskritWord("आत्मभाव", "ātmabhāva", "AtmabhAva", "m", "das Sein, sas Selbst", null, null, Arrays.asList()));
			addWord(new SanskritWord("आगम", "āgama", "Agama", "m", "überlieferte Lehre, Vorschrift; Sammlung von solchen Lehren oder Vorschriften, Lehrbuch",
					"Ankunft, Erscheinen; Hinzutritt, Zusatz u.a.", null, Arrays.asList("ā", "gama")));
			addWord(new SanskritWord("आणाम्", "āṇām", "ANAm", null, null, null, null, Arrays.asList()));
			addWord(new SanskritWord("आत्म", "ātma", "Atma", "m", "Seele, Selbst", null, null, Arrays.asList("ātman")));
			addWord(new SanskritWord("आत्मक", "ātmaka", "Atmaka", "f", "Wesen, Natur", "zum Wesen gehörend (adj)", null, Arrays.asList("ātman")));
			addWord(new SanskritWord("आत्मदर्शन", "ātmadarśana", "Atmadarzana", "n", "das Sich-Selbst-Sehen", null, null, Arrays.asList()));
			addWord(new SanskritWord("आत्म", "ātman", "Atman", "m", "Hauch,Seele, Selbst, Essenz", null, null, Arrays.asList()));
			addWord(new SanskritWord("आदर", "ādara", "Adara", "m", "Respekt, sorgfältig, gespannt, mit großer Erwartung", null, null,
					Arrays.asList("ā", "dar")));
			addWord(new SanskritWord("आदर्श", "ādarśa", "Adarza", "m", "Erblicken", "Spiegel, Kopie", null, Arrays.asList()));
			addWord(new SanskritWord("आदि", "ādi", "Adi", "m", "Anfang, Beginn", null, null, Arrays.asList()));
			addWord(new SanskritWord("आधि", "ādhi", "Adhi", "m", "Standort, Gedanke, Wunsch", "Reflektion", null, Arrays.asList("ā", "dhi")));
			addWord(new SanskritWord("आनन्द", "ānanda", "Ananda", "m", "Lust, Wonne, Glückseeligkeit", null,
					"Eines der drei Attribute des ātman in der Vedanta Philosophie", Arrays.asList("ā", "nanda")));
			addWord(new SanskritWord("आनुश्रविक", "ānuśravika", "Anuzravika", "adj", "gemäß dem Gehörten", "basierend auf Überlieferung", null,
					Arrays.asList("anu", "śrava")));
			addWord(new SanskritWord("आनन्तर्य", "ānantarya", "Anantarya", "n", "unmittelbare Folge", null, null, Arrays.asList()));
			addWord(new SanskritWord("आनन्त्य", "ānantya", "Anantya", "n", "Endlosigkeit, Ewigkeit", null, null, Arrays.asList()));
			addWord(new SanskritWord("आपत्ति", "āpatti", "Apatti", "f", "Eintreten in ein Verhältnis, Umwandlung", "Unfall, Fehler, Versehen", null,
					Arrays.asList()));
			addWord(new SanskritWord("आपद्", "āpad", "Apad", null, "näher kommen, eintreten", "passieren, harte Zeit (f)", null, Arrays.asList("ā", "pad")));
			addWord(new SanskritWord("आपूर", "āpūra", "ApUra", "adj", "fluten, überfluten", "sich füllend", null, Arrays.asList()));
			addWord(new SanskritWord("आभास", "ābhāsa", "AbhAsa", "m", "Glanz, Licht, Farbe", "Aussehen", null, Arrays.asList()));
			addWord(new SanskritWord("आभिमत", "ābhimata", "Abhimata", "n", "Wunsch, Verlangen, gewünscht", null, null, Arrays.asList()));
			addWord(new SanskritWord("आभ्य", "ābhya", "Abhya", null, null, null, null, Arrays.asList()));
			addWord(new SanskritWord("आय", "āya", "Aya", "m", "hinzutreten, eintreffen, Einkommen", null, null, Arrays.asList("ā", "i")));
			addWord(new SanskritWord("आयु", "āyu", "Ayu", "m", "Mensch, lebendes Wesen, Sohn, Nachkomme", "Lebenszeit, Leben", null, Arrays.asList()));
			addWord(new SanskritWord("आरूढ", "ārūḍha", "ArUDha", "adj", "bestiegen", "erreicht", null, Arrays.asList()));
			addWord(new SanskritWord("आर्थ", "ārtha", "Artha", "adj", "betreffend, beruhend auf", null, null, Arrays.asList()));
			addWord(new SanskritWord("आवरण", "āvaraṇa", "AvaraNa", "n", "Verdeckung, Verhüllung, Hülle", null, null, Arrays.asList()));
			addWord(new SanskritWord("आवेश", "āveśa", "Aveza", "m", "Anschließen, Anfügen, Hineingehen, Eindringen",
					"Eindringen böser Geister, Besessenheit, Stolz, Hochmut", null, Arrays.asList()));
			addWord(new SanskritWord("आलम्बन", "ālambana", "Alambana", "n", "Stütze, Erhalten", "Grundlage, Basis, abhängen von", null,
					Arrays.asList("ā", "lambana")));
			addWord(new SanskritWord("आलस्य", "ālasya", "Alasya", "n", "Schlaffheit", "Mangel an Energie", null, Arrays.asList()));
			addWord(new SanskritWord("आलोक", "āloka", "Aloka", "m", "das Sehen, Erblicken", "Licht, heller Schein, Lobpreis, Schmeichelei", null,
					Arrays.asList()));
			addWord(new SanskritWord("आशय", "āśaya", "Azaya", "m", "Ort, Sitz, Lagerstelle", "Im Herzen ruhender Gedanke, Denkweise", null, Arrays.asList()));
			addWord(new SanskritWord("आशिस्", "āśis", "Azis", "f", "Bitte, Wunsch", null, null, Arrays.asList()));
			addWord(new SanskritWord("आश्रय", "āśraya", "Azraya", "m", "Sitz, Standort", "Behälter, Anhaften, Anschließen, Zuflucht, Verbindung", null,
					Arrays.asList()));
			addWord(new SanskritWord("आस्", "ās", "As", "√", "sitzen", null, null, Arrays.asList()));
			addWord(new SanskritWord("आस", "āsa", "Asa", "m", "Sitz, Gesäß", null, null, Arrays.asList("ās")));
			addWord(new SanskritWord("आसन", "āsana", "Asana", "n", "Sitzen, Sitz", "Stellung im Yoga", null, Arrays.asList()));
			addWord(new SanskritWord("आसन्न", "āsanna", "Asanna", "n", "Nähe, sitzend", null, null, Arrays.asList("ā", "sad")));
			addWord(new SanskritWord("आसेवित", "āsevita", "Asevita", null, "häufig", null, null, Arrays.asList("ā", "sevita")));
			addWord(new SanskritWord("आस्वाद", "āsvāda", "AsvAda", "m", "Genuß, das Kosten, Geschmack einer Sache", null, null, Arrays.asList()));

			addWord(new SanskritWord("इ", "i", "i", "√", "es, gehen", null, null, Arrays.asList()));
			addWord(new SanskritWord("इतर", "itara", "itara", "pron adj", "das Andere (von zwei)", "Komparativ von 'es',", null, Arrays.asList("i", "tara")));
			addWord(new SanskritWord("इतरत्र", "itaratra", "itaratra", "undekl.", "adv. im andern, beim andern; bei Andern, sonst", null, null,
					Arrays.asList("itara", "tra")));
			addWord(new SanskritWord("इतरेतर", "itaretara", "itaretara", "pron adj", "einer dem anderen, gegenseitig", null, null,
					Arrays.asList("itara", "tara")));
			addWord(new SanskritWord("इतरेषा", "itareṣā", "itareSA", null, "andere suchen", "für andere", null, Arrays.asList("itara", "eṣa")));
			addWord(new SanskritWord("इति", "iti", "iti", "so", "auf etwas Gesprochenes/Gedachtes hinweisen", null, null, Arrays.asList()));
			addWord(new SanskritWord("इन्द्रिय", "indriya", "indriya", "n", "Vermögen, Kraft", "Sinnesorgan", null, Arrays.asList()));
			addWord(new SanskritWord("इव", "iva", "iva", "undekl.", "gleichsam, gleichwie", null, null, Arrays.asList()));
			addWord(new SanskritWord("इश्वर", "iśvara", "izvara", null, null, null, null, Arrays.asList()));
			addWord(new SanskritWord("इष्ट", "iṣṭa", "iSTa", "n", "Wunsch, Verlangen, erwünscht (adj)", null, null, Arrays.asList()));
			addWord(new SanskritWord("इष्टदेवता", "iṣṭadevatā", "iSTadevatA", "f", "Lieblingsgottheit", "Schutzgottheit", null, Arrays.asList()));

			addWord(new SanskritWord("ईक्ष्", "īkś", "IkS", "√", "sehen, hinsehen", null, null, Arrays.asList()));
			addWord(new SanskritWord("ईश्वर", "īśvara", "Izvara", "adj m", "vermögend, fähig", "Gebieter, Gottheit , Gott", null, Arrays.asList()));

			addWord(new SanskritWord("उक्त", "ukta", "ukta", "adj", "das Gesagtwordensein", null, "vac", Arrays.asList()));
			addWord(new SanskritWord("उत्क्रान्ति", "utkrānti", "utkrAnti", "f", "Hinaufschreiten, Hinaustreten", "Aufgang", null, Arrays.asList()));
			addWord(new SanskritWord("उत्पन्न", "utpanna", "utpanna", "adj", "auftreten, produzieren, erheben, erhöhen, nach oben gehen", "Produkt (n)", null,
					Arrays.asList("ud", "pad")));
			addWord(new SanskritWord("उत्तर", "uttara", "uttara", "adj", "der obere, höhere", "spätere, nördlich", null, Arrays.asList()));
			addWord(new SanskritWord("उद्", "ud", "ud", "Präfix", "hinauf, benetzen", null, null, Arrays.asList()));
			addWord(new SanskritWord("उदान", "udāna", "udAna", "m", "Einatmen, Atemzug", null,
					"Eine der 5 Windarten im Körper, die von der Kehle zum Kopf aufsteigt.", Arrays.asList()));
			addWord(new SanskritWord("उदय", "udaya", "udaya", "m", "Aufgang, Ausgang, Hervortreten", "Folge, Erfolg, Gewinn", null, Arrays.asList()));
			addWord(new SanskritWord("उदार", "udāra", "udAra", "adj", "erhaben, edel, aktiv", null, null, Arrays.asList()));
			addWord(new SanskritWord("उदित", "udita", "udita", "adj", "aufkommen, aufsteigen", null, null, Arrays.asList()));
			addWord(new SanskritWord("उप", "upa", "upa", "undekl. Präfix", "hinzu, in der Nähe", null, null, Arrays.asList()));
			addWord(new SanskritWord("उपराग", "uparāga", "uparAga", "m", "Verfärbung", "Finsternis, Unfall", null, Arrays.asList()));
			addWord(new SanskritWord("उपनिमन्त्रण", "upanimantraṇa", "upanimantraNa", "n", "das Einladen", null, null, Arrays.asList()));
			addWord(new SanskritWord("उपसर्ग", "upasarga", "upasarga", "m", "Unfall, Widerwärtigkeit", "Krankheitserscheinung, störende Erscheinung", null,
					Arrays.asList()));
			addWord(new SanskritWord("उपाय", "upāya", "upAya", "m", "Herbeikunft", "Mittel", null, Arrays.asList()));
			addWord(new SanskritWord("उपलब्धि", "upalabdhi", "upalabdhi", "f", "Erlangung, Auffassung, Wahrnehmung, das in Erfahrung Bringen", null, null,
					Arrays.asList()));
			addWord(new SanskritWord("उपस्थान", "upasthāna", "upasthAna", "n", "Dabeistehen, Gegenwart, Hinzutreten, Erscheinen", "Aufenthalt, Versammlung",
					null, Arrays.asList()));
			addWord(
					new SanskritWord("उपेक्ष्", "upekṣ", "upekS", null, "wahrnehmen, geduldig warten, erwarten, vernachlässigen", null, null, Arrays.asList()));
			addWord(new SanskritWord("उभय", "ubhaya", "ubhaya", "adj", "beide", null, null, Arrays.asList()));

			addWord(new SanskritWord("ऋत", "ṛta", "Rta", "adj", "rechtschaffen, richtig", null, null, Arrays.asList()));
			addWord(new SanskritWord("ऋष्ट", "ṛṣṭa", "RSTa", null, "stoßen, Lanze", null, null, Arrays.asList()));

			addWord(new SanskritWord("एक", "eka", "eka", "adj", "eins, einer, einzig, einzeln", null, null, Arrays.asList()));
			addWord(new SanskritWord("एकाग्र", "ekāgra", "ekAgra", "adj", "auf einen Gegenstand gerichtet, auf einen Punkt gerichtet", null, null,
					Arrays.asList()));
			addWord(
					new SanskritWord("एकाग्रता", "ekāgratā", "ekAgratA", "f", "Einpünktigkeit", null, "Abstraktum von ekāgra", Arrays.asList("ekāgra", "ta")));
			addWord(new SanskritWord("एकाग्र्य", "ekāgrya", "ekAgrya", "adj", "einpünktig", null, null, Arrays.asList()));
			addWord(new SanskritWord("एकाग्र्य", "ekāgrya", "ekAgrya", "adj", "einpünktig", null, null, Arrays.asList()));
			addWord(new SanskritWord("एकात्मता", "ekātmatā", "ekAtmatA", "f", "Einheit, Einssein", null, null, Arrays.asList()));
			addWord(new SanskritWord("एकत्र", "ekatra", "ekatra", "adv", "an einem Ort, auf einer Stelle, vereinigt", null, null, Arrays.asList()));
			addWord(new SanskritWord("एजय", "ejaya", "ejaya", null, "erzittern, in Bewegung setzen", null, null, Arrays.asList()));
			addWord(new SanskritWord("एजयत्व", "ejayatva", "ejayatva", null, "Zittern", null, null, Arrays.asList("ejaya")));
			addWord(new SanskritWord("एतया", "etayā", "etayA", null, "(durch diese??)", null, null, Arrays.asList()));
			addWord(new SanskritWord("एतद्", "etad", "etad", "adv", "so, auf diese Weise", null, null, Arrays.asList()));
			addWord(new SanskritWord("एव", "eva", "eva", "undekl.", "so, allerdings, wohl, wirklich", null, "hebt das davorstehende Wort hervor",
					Arrays.asList()));
			addWord(new SanskritWord("एष", "eṣa", "eSa", "m f", "suchen, Wunsch", null, null, Arrays.asList()));
			addWord(new SanskritWord("एषाः", "eṣāḥ", "eSaH", "pron.", "dies eṣāḥ m,etat n, eṣā f", null, null, Arrays.asList()));

			addWord(new SanskritWord("ओषधि", "oṣadhi", "oSadhi", "f", "Pflanze", "medizinische Pflanze, Heilmittel", null, Arrays.asList()));

			addWord(new SanskritWord("क", "ka", "ka", "adj", "wer, was", null, null, Arrays.asList()));
			addWord(new SanskritWord("कथंता", "kathaṃtā", "kathaMtA", "f", "das Wie", null, null, Arrays.asList()));
			addWord(new SanskritWord("कण्ठ", "kaṇṭha", "kaNTha", "m", "Hals, Kehle", "unmittelbare Nähe", null, Arrays.asList()));
			addWord(new SanskritWord("कण्टक", "kaṇṭaka", "kaNTaka", "m/n", "Spitze",
					"Dorn, Stachel, Fingernagel, Dorn für die Mitmenschen, Staatsfeind, stechender Schmerz", null, Arrays.asList()));
			addWord(new SanskritWord("कर्", "kar", "kar", null, "machen, holen, heraustreiben", null, null, Arrays.asList()));
			addWord(new SanskritWord("करण", "karaṇa", "karaNa", "n", "Machen, Bewirken, Hervorbringen", "Helfer (m)", null, Arrays.asList()));
			addWord(new SanskritWord("कर्म", "karma", "karma", "n", "Handlung, Tat", null, "In zusammengesetzten Wörter anstelle von कर्मन",
					Arrays.asList("karman")));
			addWord(new SanskritWord("कर्मन्", "karman", "karman", "n", "Handlung, Tat", null, null, Arrays.asList(null, "kṛ")));
			addWord(new SanskritWord("करुण", "karuṇa", "karuNa", "adj", "kläglich, Mitleid (m)", null, null, Arrays.asList()));
			addWord(new SanskritWord("कल्प", "kalpa", "kalpa", "adj", "praktikabel, möglich, klein, geringfügig", "Periode, Epoche (m)", null,
					Arrays.asList()));
			addWord(new SanskritWord("काय", "kāya", "kAya", "m", "Leib, Körper", "Masse, Menge, Wohnung", null, Arrays.asList()));
			addWord(new SanskritWord("कार", "kāra", "kAra", "m", "machen, Macher, Handlung", null, null, Arrays.asList("kṛ")));
			addWord(new SanskritWord("कारण", "kāraṇa", "kAraNa", "n", "Ursache, Grund, Veranlassung", null, null, Arrays.asList()));
			addWord(new SanskritWord("कारित", "kārita", "kArita", "adj", "veranlasst, hervorgerufen", null, null, Arrays.asList()));
			addWord(new SanskritWord("काल", "kāla", "kAla", "m", "Zeitpunkt, Zeit", null, null, Arrays.asList()));
			addWord(new SanskritWord("कीर्ण", "kīrṇa", "kIrna", null, "geworfen, zerstreut", null, null, Arrays.asList("kṝ")));
			addWord(new SanskritWord("कूप", "kūpa", "kUpa", "m", "Grube, Höhle, Fels oder Baumstamm im Fluß, Nabel (f)",
					"Brunnen, ein Pfosten, an dem ein Boot angebunden wird", null, Arrays.asList()));
			addWord(new SanskritWord("कूर्म", "kūrma", "kUrma", "m", "Schildkröte", "wie der Rücken einer Schildkröte gewölbt", null, Arrays.asList()));
			addWord(new SanskritWord("कृ", "kṛ", "kR", "√", "machen", null, null, Arrays.asList()));
			addWord(new SanskritWord("कृत", "kṛta", "kRta", "adj", "gemacht, getan", "zweckmäßig", null, Arrays.asList()));
			addWord(new SanskritWord("कृतार्थ", "kṛtārtha", "kRtArtha", "adj", "Ziel erreicht, Absicht erreicht", null, null, Arrays.asList()));
			addWord(new SanskritWord("कृष्ण", "kṛṣṇa", "kRSNa", "adj", "dunkel, schwarz", null, null, Arrays.asList()));
			addWord(new SanskritWord("कॄ", "kṝ", "kRR", "√", "werfen", null, null, Arrays.asList()));
			addWord(new SanskritWord("कैवल्य", "kaivalya", "kaivalya", "n", "vollständige Isolation", "Zustand absoluter Glückseligkeit, Totalität", null,
					Arrays.asList()));
			addWord(new SanskritWord("क्रम", "krama", "krama", "m", "Schritt", "Gang, Abfolge, Verfahren, Reihenfolge, angehen, Absicht", null,
					Arrays.asList()));
			addWord(new SanskritWord("क्रिया", "kriyā", "kriyA", "f", "Ausführung, Handlung", null, null, Arrays.asList()));
			addWord(new SanskritWord("क्रोध", "krodha", "krodha", "m", "Zorn", null, null, Arrays.asList()));
			addWord(new SanskritWord("क्लिष्ट", "kliṣṭa", "kliSTa", "adj", "mit Beschwerden --, mit Leiden verbunden",
					"mitgenommen, verletzt, versehrt, in einen schlechten Zustand versetzt, abgenutzt, verbraucht, zu Schanden gemacht", null,
					Arrays.asList()));
			addWord(new SanskritWord("क्लेश", "kleśa", "kleza", "m", "Schmerzen, Leid", null, null, Arrays.asList()));
			addWord(new SanskritWord("क्षण", "kṣaṇa", "kSaNa", "m", "Augenblick", "geeigneter Zeitpunkt, freier Augenblick, Muse", null, Arrays.asList()));
			addWord(new SanskritWord("क्षय", "kṣaya", "kSaya", "m", "Wohnung, Aufenthalt, Abnahme, Verminderung, Verlust, Untergang", "Auszehrung", null,
					Arrays.asList()));
			addWord(new SanskritWord("क्षि", "kṣi", "kSi", "f", "Zerstörung, Verlust, vermindert, erschöpft", null, null, Arrays.asList()));
			addWord(new SanskritWord("क्षिप्", "kṣip", "kSip", "√", "schleudern, stoßen, verstoßen, schmähen", null, null, Arrays.asList()));
			addWord(new SanskritWord("क्षी", "kṣī", "kSI", "f", "Zerstörung, Verlust, vermindert, erschöpft", null, null, Arrays.asList()));
			addWord(new SanskritWord("क्षुध्", "kṣudh", "kSudh", "f", "Hunger", null, null, Arrays.asList()));
			addWord(new SanskritWord("क्षेत्र", "kṣetra", "kSetra", "n", "Feld, Ort", "Sitz der Seele, Ursprung", null, Arrays.asList()));
			addWord(new SanskritWord("क्षेत्रिक", "kṣetrika", "kSetrika", "m", "Besitzer eines Feldes", "Ehemann", null, Arrays.asList()));

			addWord(new SanskritWord("ख्या", "khyā", "khyA", "√", "schauen", "überschauen, bekannt sein/machen", null, Arrays.asList()));
			addWord(new SanskritWord("ख्याति", "khyāti", "khyAti", "f", "Bekanntsein, Ruf",
					"Begriff, Vorstellung, Meinung, Idee, Ruhm (m), Pracht (m), Ansehn(m), Erkenntnis, Einsicht", null, Arrays.asList("khyā")));

			addWord(new SanskritWord("गति", "gati", "gati", "f", "Gang", "Weg, Erreichen, Fortschritt", null, Arrays.asList()));
			addWord(new SanskritWord("गम्", "gam", "gam", "√", "gehen, bewegen", null, null, Arrays.asList()));
			addWord(new SanskritWord("गम", "gama", "gama", "m", "Gang, gehen, gegangen", null, null, Arrays.asList("gam")));
			addWord(new SanskritWord("गमन", "gamana", "gamana", "n", "das Gehen, Fortgehen", "Weg, Eingehen in einen Zustand", null, Arrays.asList("gam")));
			addWord(new SanskritWord("गुण", "guṇa", "guNa", "m", "Faden", "Teil, -fach, Grundeigenschaft (raja, sattva, tamas)", null, Arrays.asList()));
			addWord(new SanskritWord("गुरु", "guru", "guru", "adj", "schwer, groß, gewichtig", "Respektsperson (m)", null, Arrays.asList()));
			addWord(new SanskritWord("ग्रह्", "grah", "grah", "√", "ergreifen", null, null, Arrays.asList()));
			addWord(new SanskritWord("ग्रहण", "grahaṇa", "grahaNa", "n", "Hand, halten, ergreifen", "Sinnesorgan", null, Arrays.asList("grah")));
			addWord(new SanskritWord("ग्रहीतृ", "grahītṛ", "grahItR", "m", "Nehmender, Greifender", null, null, Arrays.asList("grah")));
			addWord(new SanskritWord("ग्राह्य", "grāhya", "grAhya", "adj", "ergriffen, greifen", "begreifen", null, Arrays.asList("grah")));

			addWord(new SanskritWord("च", "ca", "ca", "undekl.", "und, auch", null, null, Arrays.asList()));
			addWord(new SanskritWord("चक्षु", "cakṣu", "cakSu", null, "Auge", null, null, Arrays.asList()));
			addWord(new SanskritWord("चक्षुस्", "cakṣus", "cakSus", "adj.", "sehend", null, null, Arrays.asList()));
			addWord(new SanskritWord("चतुर्थ", "caturtha", "caturtha", "adj.", "der vierte", "der vierte Teil, der vierte Tag im Halbmonat, der vierte Laut",
					null, Arrays.asList()));
			addWord(new SanskritWord("चन्द्र", "candra", "candra", "m", "Mond", null, null, Arrays.asList()));
			addWord(new SanskritWord("चर्", "car", "car", "√", "bewegen, durchwandern", null, null, Arrays.asList()));
			addWord(new SanskritWord("चार", "cāra", "cAra", "m", "Bewegung", "Kundschafter, Verfahren, Betreiben", null, Arrays.asList("car")));
			addWord(new SanskritWord("चित्", "cit", "cit", "adj, √", "wahrnehmen(d), be(ob)achten(d)", "erscheinen, sich zeigen; verstehen; begehren", null,
					Arrays.asList()));
			addWord(new SanskritWord("चिति", "citi", "citi", "f", "Schicht, Masse", "Verständnis, der denkende Geist.", null, Arrays.asList()));
			addWord(new SanskritWord("चित्त", "citta", "citta", "n", "Denken, Bewusstsein, Vernunft, Geist", "Absicht, Wille; Herz, Gemüt; Wahrnehmen",
					"im philos. System Bezeichnung für das 'innere Werkzeug' im Unterschied zum äußeren, dem Körper", Arrays.asList("cit")));
			addWord(new SanskritWord("चित्तवृत्ति", "cittavṛtti", "cittavRtti", "f", "Denktätigkeit",
					"Gemütsverfassung, Denken, Vorstellen, genauer Gedankenlauf, insbes. der ungezwungene Gedankenprozess im Gegens. zur Konzentration des Geistes",
					"Wenn man erst mal in einem Gedanken nachhängt, ist es - wie bei einem Strudel - schwer, wieder herauszukommen",
					Arrays.asList("citta", "vṛtti")));
			addWord(new SanskritWord("चित्र", "citra", "citra", "adj", "augenfällig, sichtbar", "hell, bunt, vernehmlich", null, Arrays.asList()));
			addWord(
					new SanskritWord("चेतन", "cetana", "cetana", "adj", "augenfällig, wahrnehmend, Wahrnehmung (n)", "Seele (m)", null, Arrays.asList("cit")));
			addWord(new SanskritWord("चेतन", "cetana", "cetana", null, "wie ca: aneinanderreihend,  auch, sogar", null, null, Arrays.asList()));
			addWord(new SanskritWord("चेद्", "ced", "ced", "undekl.", "wie ca: aneinanderreihend,  auch, sogar", null, null, Arrays.asList("ca", "id")));

			addWord(new SanskritWord("छिद्", "chid", "chid", "√", "abschneiden, trennen", null, null, Arrays.asList()));
			addWord(new SanskritWord("छिद्र", "chidra", "chidra", "n", "Loch, Öffnung", "Unterbrechung, Mangel, Gebrechen, Schwäche", null, Arrays.asList()));

			addWord(new SanskritWord("ज", "ja", "ja", "adj", "geboren", null, null, Arrays.asList()));
			addWord(new SanskritWord("जन्", "jan", "jan", "verb", "zeugen, gebären, hervorbringen", "machen, schaffen", null, Arrays.asList()));
			addWord(new SanskritWord("जन्म", "janma", "janma", "n", "Geburt", "Existenz, Leben", null, Arrays.asList()));
			addWord(new SanskritWord("जप्", "jap", "jap", "√", "halblaut, flüstern, murmeln", null, null, Arrays.asList()));
			addWord(new SanskritWord("जप", "japa", "japa", "m", "das flüsternde Aufsagen eines Gebetes, Liedes u.s.w.",
					"ein auf diese Weise hergesagtes Gebet", null, Arrays.asList("jap")));
			addWord(new SanskritWord("जय", "jaya", "jaya", "m", "Sieg", "Gewinn", null, Arrays.asList()));
			addWord(new SanskritWord("जल", "jala", "jala", "n", "Wasser, Nass", null, null, Arrays.asList()));
			addWord(new SanskritWord("जात", "jāta", "jAta", "adj", "geboren", null, null, Arrays.asList("ja")));
			addWord(new SanskritWord("जाति", "jāti", "jAti", "f", "Geburt", "durch die Geburt bestimmte Stellung im Staate, Stand, Rang, Kaste", null,
					Arrays.asList()));
			addWord(new SanskritWord("जुगुप्सा", "jugupsā", "jugupsA", "f", "Abscheu, Widerwille", null, null, Arrays.asList()));
			addWord(new SanskritWord("ज्ञा", "jñā", "jJA", "v",
					"kennen, wissen, eine Kenntnis von Etwas oder Jmd haben; erkennen, innewerden, merken, kennen lernen, erfahren",
					"anerkennen; gutheißen, billigen; als das seinige anerkennen, in Besitz nehmen; u.a.", null, Arrays.asList()));
			addWord(new SanskritWord("ज्ञात", "jñāta", "jJAta", null, "bekannt", null, null, Arrays.asList()));
			addWord(new SanskritWord("ज्ञातृ", "jñātṛ", "jJAtR", null, "Wissender, Gewissheit", null, null, Arrays.asList()));
			addWord(new SanskritWord("ज्ञान", "jñāna", "jJAna", "n",
					"das Kennen, Erkennen, Verstehen von, Kennenlernen, Kunde; Kenntnis, Wissen, Wissenschaft; insbes. die Erkenntnis der höheren Wahrheiten auf dem Gebiete der Religion und Philosophie",
					"Besinnung, Bewusstsein; Erkenntnisorgan, Sinnesorgan", null, Arrays.asList("jñā")));
			addWord(new SanskritWord("ज्ञेय", "jñeya", "jJeya", "adj", "erforschen", null, null, Arrays.asList()));
			addWord(new SanskritWord("ज्योति", "jyoti", "jyoti", "m", "Licht, Helle", "Lichtwelt", "Lokativ von jyotis", Arrays.asList("jyotis")));
			addWord(new SanskritWord("ज्योतिस्", "jyotis", "jyotis", "n", "Licht, Helle", "Lichtwelt", null, Arrays.asList()));
			addWord(new SanskritWord("ज्योतिष्मती", "jyotiṣmatī", "jyotiSmatI", "adj", "hell, scheinend", "himmlisch, zur Welt des Lichts gehörend", null,
					Arrays.asList("jyotis", "mad")));

			addWord(new SanskritWord("त", "ta", "ta", null, "der, die, das", null,
					"Am Ende eines zusammengesetzten Wortes bezeichnet es auch ein Abstraktum.", Arrays.asList()));
			addWord(new SanskritWord("तत्", "tat", "tat", "undekl.", "dann (then)", null,
					"Adverb von tan, (Auch möglich: Nom. oder Akk. Singular Neutrum von ta: dieses)", Arrays.asList("tan")));
			addWord(new SanskritWord("तत", "tata", "tata", "m", "Vater, Wind", null, null, Arrays.asList()));
			addWord(new SanskritWord("ततस्", "tatas", "tatas", null, "Ablativ von ta", "daraus", null, Arrays.asList("ta")));
			addWord(new SanskritWord("तत्त्व", "tattva", "tattva", "n", "Wesen, Natur", "die wahre Natur", null, Arrays.asList("tad")));
			addWord(new SanskritWord("तत्र", "tatra", "tatra", "undekl.", "dort, dann", "darin, bei dem Anlass", "Lokativ von त", Arrays.asList("ta")));
			addWord(new SanskritWord("तत्स्थ", "tatstha", "tatstha", "m f n", "darauf sein, darin sein", null, null, Arrays.asList("tat", "stha")));
			addWord(new SanskritWord("तथा", "tathā", "tathA", "adv", "so, auf diese Weise", null, null, Arrays.asList()));
			addWord(new SanskritWord("तद्", "tad", "tad", "adv.", "er, sie, es, dies,da, dahin, damals, auf diese Weise", null, "Nom. Akk. Singular n von त",
					Arrays.asList("ta")));
			addWord(new SanskritWord("तदा", "tadā", "tadA", "undekl.", "zu/ab dem Zeitpunkt, dann", null, null, Arrays.asList("ta")));
			addWord(new SanskritWord("तदञ्जनता", "tadañjanatā", "tadaJjanatA", null, null, null, null, Arrays.asList()));
			addWord(
					new SanskritWord("तद्रूप", "tadrūpa", "tadrUpa", "adj.", "diese Form", "so geformt, gleiche Qualität", null, Arrays.asList("tad", "rūpa")));
			addWord(new SanskritWord("तन्", "tan", "tan", "√", "dehnen", "erreichen, ausbreiten, Ausbreitung, Nachfolge, Folge (f)", null, Arrays.asList()));
			addWord(new SanskritWord("तनु", "tanu", "tanu", "adj.", "dünn, schlank, fein", null, null, Arrays.asList()));
			addWord(new SanskritWord("तन्त्र", "tantra", "tantra", "n f", "Grundordnung, Grundlage (n), Sehne (f)", "Beschwörung", null, Arrays.asList()));
			addWord(new SanskritWord("तमस्", "tamas", "tamas", "n", "Dunkelheit, Verdunkelung", "Eine der drei Qualitäten (Raja, Sattva, Tamas)", null,
					Arrays.asList()));
			addWord(new SanskritWord("तय", "taya", "taya", "m", "Teil", null, null, Arrays.asList()));
			addWord(new SanskritWord("तर", "tar", "tar", null, "hinübergelangen, übersetzen", null, null, Arrays.asList()));
			addWord(new SanskritWord("तदा", "tara", "tara", "Affix", "hinübertragen, übertreffen", "''Komparativ, Vergleich, Intensivierung''", null,
					Arrays.asList("tar")));
			addWord(new SanskritWord("तर्क्", "tark", "tark", "√", "vermuten, scheinen", null, null, Arrays.asList()));
			addWord(new SanskritWord("तर्क", "tarka", "tarka", "m", "Vermutung, Erwägung, Wunsch", null, null, Arrays.asList("tark")));
			addWord(new SanskritWord("तस्मिन्", "tasmin", "tasmin", null, null, "Form von tad (dieses)", null, Arrays.asList()));
			addWord(new SanskritWord("तस्य", "tasya", "tasya", null, "dessen", null, "Genitiv Sing. Mask. von ta: dieser", Arrays.asList()));
			addWord(new SanskritWord("तपस्", "tapas", "tapas", "n", "Wärme, Plage", "Selbstpeinigung, Askese", null, Arrays.asList()));
			addWord(new SanskritWord("ताप", "tāpa", "tApa", "m", "Hitze", "Schmerz, Weh, Qual", null, Arrays.asList()));
			addWord(new SanskritWord("तान", "tāna", "tAna", "m", "Faden, Faser", "ausgedehnter musikalischer Ton, Ausdehnung (n), Erkenntnisobjekt (n)", null,
					Arrays.asList()));
			addWord(new SanskritWord("तार", "tāra", "tAra", "adj", "hoch, laut, funkelnd", "Stern, Sternschnuppe", null, Arrays.asList()));
			addWord(new SanskritWord("तारक", "tāraka", "tAraka", "adj", "hinüberbringen, Boot", "retten, erlösen, transzendieren", null, Arrays.asList()));
			addWord(new SanskritWord("तीव्र", "tīvra", "tIvra", "adj", "scharf, Schärfe, stechend", "intensiv, stark, ernsthaft", null, Arrays.asList()));
			addWord(new SanskritWord("तु", "tu", "tu", "√", "stark sein", "Autorität haben, jetzt, dann", null, Arrays.asList()));
			addWord(new SanskritWord("तूल", "tūla", "tUla", "n", "Luft, Rispe, Büschel, Schilf, Baumwolle (f, m)", "Docht", null, Arrays.asList()));
			addWord(new SanskritWord("तुल्य", "tulya", "tulya", "adj", "gleich, gleichartig", null, null, Arrays.asList()));
			addWord(new SanskritWord("तृष्", "tṛṣ", "tRS", "√ f", "Durst", "Verlangen, Begier", null, Arrays.asList()));
			addWord(new SanskritWord("ते", "te", "te", "m pl.", "sie", null, null, Arrays.asList()));
			addWord(new SanskritWord("त्याग", "tyāga", "tyAga", "m", "Verlassen", "Aufopfern, Entlassen", null, Arrays.asList()));
			addWord(new SanskritWord("त्र", "tra", "tra", null, "drei, schützend", null, null, Arrays.asList()));
			addWord(new SanskritWord("त्त्रय", "traya", "traya", "f", "Dreifach, dreigeteilt, Drei", null, null, Arrays.asList()));
			addWord(new SanskritWord("त्रिविध", "trividha", "trividha", "adj", "dreierlei, von drei Arten", null, null, Arrays.asList()));
			addWord(new SanskritWord("त्व", "tva", "tva", "adj", "Du, dein", null, "Basis des zweiten Personalpronomens, Marker für abstrakte Nomina",
					Arrays.asList()));
			addWord(new SanskritWord("त्वान्तो", "tvānto", "tvAnto", null, null, null, null, Arrays.asList()));

			addWord(new SanskritWord("दौर्", "daur", "daur", null, null, null, "vṛddhi von dur", Arrays.asList("dur")));
			addWord(new SanskritWord("दौर्मनस्य", "daurmanasya", "daurmanasya", null, "Niedergeschlagenheit, Traurigkeit", null, null,
					Arrays.asList("daur", "manas")));
			addWord(new SanskritWord("दर्श्", "dar", "dar", null, "Rücksicht nehmen, beachten", null, null, Arrays.asList()));
			addWord(new SanskritWord("दर्श्", "darś", "darz", null, "sehen", "sehen lassen, sichtbar machen", null, Arrays.asList()));
			addWord(new SanskritWord("दर्शन", "darśana", "darzana", "adj", "sehend, Sehen (n)", null, null, Arrays.asList("darś")));
			addWord(new SanskritWord("दर्शिन्", "darśin", "darzin", "adj", "sehend, schauend", "Einsicht haben", "darś", Arrays.asList()));
			addWord(new SanskritWord("दिव्य", "divya", "divya", "adj", "himmlisch", null, null, Arrays.asList()));
			addWord(new SanskritWord("दीप्ति", "dīpti", "dIpti", "f", "Flammen", "heller Glanz", null, Arrays.asList()));
			addWord(new SanskritWord("दीर्घ", "dīrgha", "dIrgha", "m f n", "lange, hoch, groß", null, null, Arrays.asList()));
			addWord(new SanskritWord("दुःख", "duḥkha", "duHkha", "n", "Unbehagen, Schmerz", null, null, Arrays.asList()));
			addWord(new SanskritWord("दुर्", "dur", "dur", "n", "großes Verbrechen, schlecht", null, null, Arrays.asList("dus")));
			addWord(new SanskritWord("दुस्", "dus", "dus", "undekl.", "schlecht, kaum, schlechter, hart", null, null, Arrays.asList()));
			addWord(new SanskritWord("दृग्", "dṛg", "dRg", null, null, "in Zusammensetzungen anstelle von dṛś", "dṛś", Arrays.asList()));
			addWord(new SanskritWord("दृढ", "dṛḍha", "dRDha", "adj", "fest, stark", null, null, Arrays.asList()));
			addWord(new SanskritWord("दृश्", "dṛś", "dRz", "f", "Sehen, Schauen", "Erkennen", null, Arrays.asList()));
			addWord(new SanskritWord("दृशि", "dṛśi", "dRzi", "f", "Sehen, Erschauen", null, null, Arrays.asList()));
			addWord(new SanskritWord("दृश्य", "dṛśya", "dRzya", "adj", "sichtbar", "anzublicken", null, Arrays.asList()));
			addWord(new SanskritWord("दृष्ट", "dṛṣṭa", "dRSTa", "adj", "gesehen, wahrgenommen", "zuversichtlich", null, Arrays.asList("darś")));
			addWord(new SanskritWord("देश", "deśa", "deza", "m", "Ort", null, null, Arrays.asList()));
			addWord(new SanskritWord("द्देह", "deha", "deha", "m n", "Körper", null, null, Arrays.asList()));
			addWord(new SanskritWord("दोष", "doṣa", "doSa", "m", "Dunkelheit,Schaden, Mangel, Fehler", "Sündhaftigkeit, Grundstoffe des Körpers", null,
					Arrays.asList()));
			addWord(new SanskritWord("द्रा", "drā", "drA", "√", "schlafen, rennen", null, null, Arrays.asList()));
			addWord(new SanskritWord("द्रष्टृ", "draṣṭṛ", "draSTR", "m", "der Sehende", null, null, Arrays.asList("darś")));
			addWord(new SanskritWord("द्वंद्व", "dvaṃdva", "dvaMdva", "n", "Paar", "Zweikampf, Gegensatzpaar", null, Arrays.asList()));
			addWord(new SanskritWord("द्वेष", "dveṣa", "dveza", "m", "Hass, Abneigung", null, null, Arrays.asList()));

			addWord(new SanskritWord("धर्म", "dharma", "dharma", "n", "Satzung, Ordnung",
					"Sitte, Brauch, Recht, Pflicht, Gesetz, Natur, Art und Weise eines Dings", null, Arrays.asList()));
			addWord(new SanskritWord("धर्मन्", "dharman", "dharman", "n", "Stütze, Halt, Unterlage", "Gesetz, Brauch, Art und Weise, Träger (m)", null,
					Arrays.asList()));
			addWord(new SanskritWord("धर्मिन्", "dharmin", "dharmin", "adj", "das Gesetz kennend, Pflichten befolgend", "Art und Weise", null,
					Arrays.asList()));
			addWord(new SanskritWord("धि", "dhi", "dhi", "√", "halten, enthalten, nähren, erfreuen", null, null, Arrays.asList()));
			addWord(new SanskritWord("धा", "dhā", "dhA", "√", "machen, geben", "in einen Zustand versetzen", null, Arrays.asList()));
			addWord(new SanskritWord("धारणा", "dhāraṇā", "dhAraNA", "f", "Halten, Festigkeit", "Konzentration", null, Arrays.asList()));
			addWord(new SanskritWord("धारण", "dhāraṇa", "dhAraNa", "f", "tragen, bewahren (adj)",
					"gutes Gedächtnis, unverwandte Konzentration auf einen Gegenstand", null, Arrays.asList()));
			addWord(new SanskritWord("ध्यान", "dhyāna", "dhyAna", "n", "das Nachsinnen", "tiefe Mediation", null, Arrays.asList()));
			addWord(new SanskritWord("ध्रुव", "dhruva", "dhruva", "m", "am Ort verharrend",
					"feststehend, bleibend, dauernd, beständig, sicher, gewiß, Polarstern, Himmelspol", null, Arrays.asList()));

			addWord(new SanskritWord("न", "na", "na", "undekl.", "nicht", null, null, Arrays.asList()));
			addWord(new SanskritWord("नन्द", "nanda", "nanda", "m", "Lust", null, null, Arrays.asList()));
			addWord(new SanskritWord("नाभिचक्र", "nābhicakra", "nAbhicakra", "n", "Nabelkreis", null, null, Arrays.asList()));
			addWord(new SanskritWord("नष्ट", "naṣṭa", "naSTa", "adj", "verloren, zerstört", null, null, Arrays.asList()));
			addWord(new SanskritWord("नाडी", "nāḍī", "nADI", "f", "Röhre, Kanal", "Pfeife, Puls", null, Arrays.asList()));
			addWord(new SanskritWord("नैर्", "nair", "nair", null, "weg von", null, "vṛddhi Form von निर् in Komposita", Arrays.asList("nir")));
			addWord(new SanskritWord("नैरन्तर्य", "nairantarya", "nairantarya", "n", "ununterbrochen", null, null, Arrays.asList("nair", "antarya")));
			addWord(new SanskritWord("नि", "ni", "ni", "undekl.", "hinein, hinunter", "ohne, ''Verneinung''", null, Arrays.asList()));
			addWord(new SanskritWord("नित्य", "nitya", "nitya", "adj.", "ständig, immerwährend", null, null, Arrays.asList()));
			addWord(new SanskritWord("निद्रा", "nidrā", "nidrA", "f", "Schlaf", null, null, Arrays.asList("ni", "drā")));
			addWord(new SanskritWord("निमित्त", "nimitta", "nimitta", "n", "Ursache, das Bestimmende, Vorzeichen, Ziel", null, null, Arrays.asList()));
			addWord(new SanskritWord("निम्न", "nimna", "nimna", "n", "Tiefe, Niederung, Vertiefung", null, null, Arrays.asList()));
			addWord(new SanskritWord("निबन्धन", "nibandhana", "nibandhana", "adj", "gebunden, Band (f), Fessel, das Anbinden (n)", null, null,
					Arrays.asList("ni", "bandhana")));
			addWord(new SanskritWord("नियम", "niyama", "niyama", "m", "Bändigung", "Regel, Beschränkung,", "eine Beschränkung die man sich auflegt",
					Arrays.asList()));
			addWord(new SanskritWord("निवृत्ति", "nivṛtti", "nivRtti", "f", "Verschwinden",
					"Rückkehr, Aufhören, Entsagen, Entrinnen, Nicht-Handeln, Untätig sein", null, Arrays.asList()));
			addWord(new SanskritWord("निर्", "nir", "nir", null, "weg von, ohne", null, "anstelle निस vor Vokalen und weichen Konsonanten",
					Arrays.asList("nis")));
			addWord(new SanskritWord("निरतिशय", "niratiśaya", "niratizaya", "adj", "worüber nichts mehr geht, das Höchste", null, null,
					Arrays.asList("nir", "atizaya")));
			addWord(new SanskritWord("निरुपक्रम", "nirupakrama", "nirupakrama", "adj", "wozu man nichts tut, anfangslos", null, null, Arrays.asList()));
			addWord(new SanskritWord("निरोध", "nirodha", "nirodha", "m", "Beherrschung, Unterdrückung, Verdrängung, Kontrolle, Hemmung",
					"Versperrung, Verschluss, Verdeckung; Einschließung, Belagerung; Vernichtung, Tod", null, Arrays.asList("ni", "rodha")));
			addWord(new SanskritWord("निर्ग्राह्य", "nirgrāhya", "nirgrAhya", "adj", "unter anderen herausfinden", "erkennen", null, Arrays.asList()));
			addWord(new SanskritWord("निर्बीज", "nirbīja", "nirbIja", "adj", "ohne Samen", null, null, Arrays.asList("nir", "bīja")));
			addWord(new SanskritWord("निर्भास", "nirbhāsa", "nirbhAsa", null, "Schein (m), das Klarmachen (n)", null, null, Arrays.asList("nir", "bhās")));
			addWord(new SanskritWord("निर्माण", "nirmāṇa", "nirmANa", "n", "Messung, Bilden, Schaffen", null, null, Arrays.asList()));
			addWord(new SanskritWord("निर्वीज", "nirvīja", "nirvIja", "adj", "ohne Samen", null, null, Arrays.asList("nir", "vīja")));
			addWord(new SanskritWord("निर्विचार", "nirvicāra", "nirvicAra", "adj", "nicht überlegend, ohne lange nachzudenken", null, null,
					Arrays.asList("nir", "vicāra")));
			addWord(new SanskritWord("निर्वितर्क", "nirvitarka", "nirvitarka", "adj", "nicht erwägend", null, null, Arrays.asList("nir", "vitarka")));
			addWord(new SanskritWord("निस्", "nis", "nis", "undekl.", "weg von, ohne", null, null, Arrays.asList()));
			addWord(new SanskritWord("नु", "nu", "nu", "√", "brummen, summen, brüllen, preisen, bewegen", null, null, Arrays.asList()));
			addWord(new SanskritWord("न्यास", "nyāsa", "nyAsa", "m", "Hinsetzen, Niedersetzen, Niederlegen",
					"Entsagung, Zeichnen, Auftragen mystischer Zeichen", null, Arrays.asList()));

			addWord(new SanskritWord("पच्", "pac", "pac", "√", "kochen, backen, reifen", null, null, Arrays.asList()));
			addWord(new SanskritWord("पञ्च", "pañca", "paJca", "adj", "ausgestreckt, gespreizt", "fünf", "Eine gespreizte Hand zeigt 5 Finger",
					Arrays.asList()));
			addWord(new SanskritWord("पञ्चतय", "pañcataya", "paJcataya", "adj", "fünf Teile", null, null, Arrays.asList("pañca", "taya")));
			addWord(new SanskritWord("पतञ्जलि", "patañjali", "pataJjali", "m", "''Name''", "Autor des Yoga Sutra", null, Arrays.asList()));
			addWord(new SanskritWord("पत्ति", "patti", "patti", "m", "Fußgänger", "Infantrist, Heeresabteilung", null, Arrays.asList("pad")));
			addWord(new SanskritWord("पथ्", "path", "path", null, "gehen, Pfad", null, null, Arrays.asList()));
			addWord(new SanskritWord("पद्", "pad", "pad", "√", "zu Fall kommen, sich wenden, erhalten", null, null, Arrays.asList()));
			addWord(new SanskritWord("पद", "pada", "pada", "m", "Fuß", null, "Fuß eines Menschen, Tieres, Baumes, Berges", Arrays.asList("pad")));
			addWord(new SanskritWord("पङ्क", "paṅka", "paGka", "m/n", "Schlamm, Schmutz", "Kot, aufgeweichter Lehm, Salbe, Sünde", null, Arrays.asList()));
			addWord(
					new SanskritWord("परं", "para", "para", "adj", "weiter hinaus, höchstes,", "vergangen, früher, fremd, ein anderer", null, Arrays.asList()));
			addWord(new SanskritWord("परम", "parama", "parama", "adj", "das Fernste, Äußerste, Höchste", "Beste", "Superlativ von para",
					Arrays.asList("para")));
			addWord(new SanskritWord("परि", "pari", "pari", "undekl.", "herum, außerhalb, herumfliegen, herumlaufen", null, null, Arrays.asList()));
			addWord(new SanskritWord("परिताप", "paritāpa", "paritApa", "m", "Glut, Hitze, Seelenschmerz, Trauer, Betrübnis", null, null, Arrays.asList()));
			addWord(new SanskritWord("परिदृश्", "paridṛś", "paridRz", null, "sehen, betrachten, herausfinden, sichtbar werden", null, null, Arrays.asList()));
			addWord(new SanskritWord("परिणाम", "pariṇāma", "pariNAma", "m", "Veränderung, Umwandlung", "Entwicklung zu", null, Arrays.asList()));
			addWord(new SanskritWord("परिशुध्", "pariśudh", "parizudh", "adj", "abgewaschen, gereinigt", null, null, Arrays.asList("pari", "śudh")));
			addWord(new SanskritWord("पर्यय", "paryaya", "paryaya", "m", "Umlauf, Ablauf einer Zeitperiode, Gegenteil, Abweichung, Konfusion", null, null,
					Arrays.asList("pari", "aya")));
			addWord(new SanskritWord("पर्यवसान", "paryavasāna", "paryavasAna", "n", "Schluss, Ende", null, null, Arrays.asList()));
			addWord(new SanskritWord("पर्वन्", "parvan", "parvan", "n", "Knoten, Gelenk, Glied", "Abschnitt, Zeitabschnitt", null, Arrays.asList()));
			addWord(new SanskritWord("पा", "pā", "pA", "√", "bewachen, schützen, trinken", null, null, Arrays.asList()));
			addWord(new SanskritWord("पात", "pāta", "pAta", "m", "fliegen, fallen", null, null, Arrays.asList("pā")));
			addWord(new SanskritWord("पाद्", "pād", "pAd", "√", "gehen, wenden, fallen", null, "starker Kasus von पद्", Arrays.asList("pad")));
			addWord(new SanskritWord("पाद", "pāda", "pAda", "m", "Fuß", "Viertel, Ein Kapitel (von 4)", "Tiere haben 4 Füße", Arrays.asList("pada", "pād")));
			addWord(new SanskritWord("पिपासा", "pipāsā", "pipAsA", "f", "Durst", null, null, Arrays.asList()));
			addWord(new SanskritWord("पुण्य", "puṇya", "puNya", "n", "Verdienst, wohlriechend", "Erfolg, günstig, verdienstvoll", null, Arrays.asList()));
			addWord(new SanskritWord("पुनर्", "punar", "punar", "adv", "von neuem, wieder", null, null, Arrays.asList()));
			addWord(new SanskritWord("पुरुष", "puruṣa", "puruSa", "m", "Bewohner, Mensch", "Das beseelende im Menschen, Seele,", null, Arrays.asList()));
			addWord(new SanskritWord("पुरुषार्थ", "puruṣārtha", "puruSArtha", "m", "Angelegenheit", "Ziel des Menschen, Seele, menschliches Bemühen", null,
					Arrays.asList()));
			addWord(new SanskritWord("पूर्व", "pūrva", "pUrva", "adj", "das Vordere, früher", "begleitet von, verbunden mit (am Ende von Komposita)", null,
					Arrays.asList()));
			addWord(new SanskritWord("पूर्वक", "pūrvaka", "pUrvaka", "n", "frühere Zeit, der Erste", "begleited von, verbunden mit", null,
					Arrays.asList("pūrva")));
			addWord(new SanskritWord("पूर्वजाति", "pūrvajāti", "pUrvajAti", "f", "eine frühere Geburt, ein früheres Leben", null, null, Arrays.asList()));
			addWord(new SanskritWord("प्र", "pra", "pra", "undekl.", "vor, entfernt, sehr, groß", null, null, Arrays.asList()));
			addWord(new SanskritWord("प्रकाश", "prakāśa", "prakAza", "m", "Licht, Helle, hell, leuchtend", "öffentlich, bekannt, berühmt", null,
					Arrays.asList()));
			addWord(
					new SanskritWord("प्रकृति", "prakṛti", "prakRti", "f", "Natur, natürliche Form", "ursprüngliche Form", null, Arrays.asList("pra", "kar")));
			addWord(new SanskritWord("प्रचार", "pracāra", "pracAra", "m", "das Hervortreten, Erscheinen", "Wandeln, Verfahren, Betragen", null,
					Arrays.asList()));
			addWord(new SanskritWord("प्रच्छर्दन", "pracchardana", "pracchardana", "n", "das Ausstoßen", "Brechmittel", null, Arrays.asList()));
			addWord(new SanskritWord("प्रज्ञा", "prajñā", "prajJA", "f", "Unterscheidung, Urteilskraft, Einsicht, Verstand",
					"das Sichzurechtfinden; Auskunft; Vorsatz, Entschluss", null, Arrays.asList("pra", "jñā")));
			addWord(new SanskritWord("प्रज्वलन", "prajvalana", "prajvalana", "n", "Aufflammen, Auflodern", null, null, Arrays.asList()));
			addWord(new SanskritWord("प्रति", "prati", "prati", "undekl.", "nahe", "ähnlich, vergleichbar", "zurück", Arrays.asList("pra")));
			addWord(new SanskritWord("प्रतिपक्ष", "pratipakṣa", "pratipakSa", "m", "die entgegengesetzte Seite", "Opposition", null, Arrays.asList()));
			addWord(new SanskritWord("प्रतिपत्ति", "pratipatti", "pratipatti", "f", "Erlangen, Gewinnung, Beginnen", "Erkenntnis, Einsicht", null,
					Arrays.asList()));
			addWord(new SanskritWord("प्रतिप्रसव", "pratiprasava", "pratiprasava", "m", "Gegenbefehl",
					"Aufhebung eines Befehls/Verbots, entgegengesetzte Wirkung", null, Arrays.asList()));
			addWord(new SanskritWord("प्रतिबन्ध", "pratibandha", "pratibandha", "m", "Verbindung, Umknüpfung", "Belagerung, Widerstand", null,
					Arrays.asList("prati", "bandha")));
			addWord(new SanskritWord("प्रतिबन्धि", "pratibandhi", "pratibandhi", "m", "Widerspruch, Einspruch", null, null, Arrays.asList("prati", "bandh")));
			addWord(new SanskritWord("प्रतियोगिन्", "pratiyogin", "pratiyogin", null, "in Beziehung stehend", null, null, Arrays.asList()));
			addWord(new SanskritWord("प्रतिषेध", "pratiṣedha", "pratiSedha", "m", "Abhaltung, Zurückhaltung, Abwehr", "Verbot", null, Arrays.asList()));
			addWord(new SanskritWord("प्रतिष्ठ", "pratiṣṭha", "pratiSTha", "adj", "nahe stehen", "fest stehen ,felsenfest, verwurzelt", null,
					Arrays.asList("prati", "ṣṭha")));
			addWord(new SanskritWord("प्रतिष्ठा", "pratiṣṭhā", "pratiSThA", "f", "Stehenbleiben,", "Standort, Stütze, Zustand der Ruhe", null,
					Arrays.asList("prati", "ṣṭha")));
			addWord(new SanskritWord("प्रत्यक्ष", "pratyakṣa", "pratyakSa", "n",
					"Augenfälligkeit, unmittelbare Deutlichkeit; Ausdrücklichkeit; in der Philosophie Sinnesempfindung, Wahrnehmung, perceptio, Intuition",
					"augenfällig so v. a. deutlich, keinem Zweifel unterworfen, ausdrücklich, wirklich", null, Arrays.asList("prati", "akṣa")));
			addWord(new SanskritWord("प्रत्यच्", "pratyac", "pratyac", null, null, null, null, Arrays.asList()));
			addWord(new SanskritWord("प्रत्यय", "pratyaya", "pratyaya", "m", "Wahrnehmung, Vorstellung, Begriff",
					"Glaube, Beweis, Intellekt, Annahme, Verständnis, Idee, Grund, Ursache", null, Arrays.asList("prati", "aya")));
			addWord(
					new SanskritWord("प्रत्याहार", "pratyāhāra", "pratyAhAra", "m", "Zurückziehen, Rückzug", "Zurückziehen der Sinne", null, Arrays.asList()));
			addWord(new SanskritWord("प्रधान", "pradhāna", "pradhAna", "n", "Hauptsache, Urmaterie, Verstand", "das Wichtigste", null, Arrays.asList()));
			addWord(new SanskritWord("प्रविभाग", "pravibhāga", "pravibhAga", "m", "Teilung", "Einteilung", null, Arrays.asList()));
			addWord(new SanskritWord("प्रणव", "praṇava", "praNava", "m", "eine kleine Trommel", "Heilige Silbe Aum", null, Arrays.asList("praṇu")));
			addWord(new SanskritWord("प्रनिधान", "praṇidhāna", "praNidhAna", "n", "Bemühung, Anwendung", "Vertiefung, Gebet, Verehrung", null,
					Arrays.asList("dhā")));
			addWord(new SanskritWord("प्रणु", "praṇu", "praNu", null, "Klang, tönen", null, null, Arrays.asList("pra", "nu")));
			addWord(new SanskritWord("प्रान्त", "prānta", "prAnta", "m, n", "Rand, Saum, Ende, Spitze", null, null, Arrays.asList()));
			addWord(new SanskritWord("प्रभु", "prabhu", "prabhu", "adj", "hervorragend, übertreffend, mächtig", "Herr, Gebieter (m)", null, Arrays.asList()));
			addWord(new SanskritWord("प्रमाण", "pramāṇa", "pramANa", "n",
					"Maß, Maßstab, Größe, Umfang, Länge, Gewicht, Menge, Zeitdauer; Norm, Richtschnur; Autorität",
					"Mittel zu richtigem Wissen, Erkenntnismittel, Beweismittel",
					"In der Terminologie des philosoph. Systems bezeichnet Pramana die Mittel zur Erlangung gültigen Wissens.", Arrays.asList("pra", "mā")));
			addWord(new SanskritWord("प्रमाद", "pramāda", "pramAda", "m", "Rausch, Trunkenheit", "Fahrlässigkeit, Nachlässigkeit", null,
					Arrays.asList("pra", "mad")));
			addWord(new SanskritWord("प्रमोष", "pramoṣa", "pramoSa", "m", "stehlen, wegnehmen", null, null, Arrays.asList("muṣ")));
			addWord(new SanskritWord("प्रयत्न", "prayatna", "prayatna", "m", "Willenstätigkeit, Bestrebung, Bemühung", null, null, Arrays.asList()));
			addWord(new SanskritWord("प्रयोजक", "prayojaka", "prayojaka", null, "veranlassend, bewirkend", "Urheber", null, Arrays.asList()));
			addWord(new SanskritWord("प्रवृत्ति", "pravṛtti", "pravRtti", "f", "Fortschreiten, Hervorkommen, Tätigkeit", null, null,
					Arrays.asList("pra", "vṛtti")));
			addWord(new SanskritWord("प्रशान्त", "praśānta", "prazAnta", "adj", "ruhig, gleichgültig, gleichmütig", null, null, Arrays.asList()));
			addWord(new SanskritWord("प्रश्वास", "praśvāsa", "prazvAsa", "m", "Einatmen", null, null, Arrays.asList("pra", "śvās")));
			addWord(new SanskritWord("प्रसङ्ग", "prasaṅga", "prasaGga", "adj", "Neigung, Hang, Gegebensein einer Möglichkeit, Eintritt eines Falles", null,
					null, Arrays.asList()));
			addWord(new SanskritWord("प्रसंख्यान", "prasaṃkhyāna", "prasaMkhyAna", "n", "Aufzählen", "Nachdenken", null, Arrays.asList()));
			addWord(new SanskritWord("प्रसव", "prasava", "prasava", "m", "Antrieb, Anregung, Belebung", "Betrieb, Erwerb, Geburt, Ursprung", null,
					Arrays.asList()));
			addWord(new SanskritWord("प्रसाद", "prasāda", "prasAda", "m", "Klarheit", "Gnadengeschenk", null, Arrays.asList("pra", "sad")));
			addWord(new SanskritWord("प्रसादन", "prasādana", "prasAdana", "adj", "klärend, klar machen", "beruhigen", null, Arrays.asList("pra", "sad")));
			addWord(new SanskritWord("प्रसुप्त", "prasupta", "prasupta", "f", "Schläfrigkeit", null, null, Arrays.asList()));
			addWord(new SanskritWord("प्रा", "prā", "prA", "√", "füllen", null, null, Arrays.asList()));
			addWord(new SanskritWord("प्राग्भार", "prāgbhāra", "prAgbhAra", "m", "Berggipfel, Menge, Masse, Neigung", null, null, Arrays.asList()));
			addWord(new SanskritWord("प्रादुर्भाव", "prādurbhāva", "prAdurbhAva", "m", "Zum Vorschein Kommen", "Erscheinung, Erscheinen", null,
					Arrays.asList()));
			addWord(new SanskritWord("प्राण", "prāṇa", "prANa", "m", "Hauch, Atem", "Lebenshauch, Lebensgeist", null, Arrays.asList("prā")));
			addWord(new SanskritWord("प्राणायाम", "prāṇāyāma", "prANAyAma", "m", "Atemausdehnung", "Das Anhalten des Atems", "Atemübung",
					Arrays.asList("prāṇā", "āyāma")));
			addWord(new SanskritWord("प्रातिभ", "prātibha", "prAtibha", "adj", "intuitiv, divinatorisch, göttlich", null, null, Arrays.asList()));

			addWord(new SanskritWord("फल", "phala", "phala", "n", "Frucht", "Erfolg", null, Arrays.asList()));

			addWord(new SanskritWord("बन्ध्", "bandh", "bandh", "√", "binden, fesseln", null, null, Arrays.asList()));
			addWord(new SanskritWord("बन्ध", "bandha", "bandha", "m", "Bindung, Verbindung, Damm", null, null, Arrays.asList("bandh")));
			addWord(new SanskritWord("बन्धन", "bandhana", "bandhana", "adj", "bindend, Binden, Verband", null, null, Arrays.asList("bandh")));
			addWord(new SanskritWord("बहिरङ्ग", "bahiraṅga", "bahiraGga", "adj", "äußerlich, unwesentlich", null, null, Arrays.asList()));
			addWord(new SanskritWord("बहिस्", "bahis", "bahis", "adv", "außen, , draußen", null, null, Arrays.asList()));
			addWord(new SanskritWord("बल", "bala", "bala", "m", "Gewalt, Wucht, Stärke, Kraft", "Heer, Heeresmacht, Form, Gestalt", null, Arrays.asList()));
			addWord(new SanskritWord("बाधन", "bādhana", "bAdhana", "n", "Belästigung, Peinigung", "Hindernis, Entfernen", null, Arrays.asList()));
			addWord(new SanskritWord("बाह्य", "bāhya", "bAhya", "adj", "außen, draußen", null, null, Arrays.asList()));
			addWord(new SanskritWord("बीज", "bīja", "bIja", "n", "Same, Keim", null, null, Arrays.asList()));
			addWord(new SanskritWord("बुद्धि", "buddhi", "buddhi", "f", "Einsicht, Verstand, Intellekt", null, null, Arrays.asList()));
			addWord(new SanskritWord("ब्रह्मचर्य", "brahmacarya", "brahmacarya", "n", "heiliges Studium",
					"Lebensweise eines Brahmanenschülers, Keuschheit, Enthaltsamkeit", null, Arrays.asList()));

			addWord(new SanskritWord("भर्", "bhar", "bhar", null, "tragen, besitzen", null, null, Arrays.asList()));
			addWord(new SanskritWord("भर", "bhara", "bhara", "adj", "tragend, verleihend", "das Nehmen (m)", null, Arrays.asList("bhar")));
			addWord(new SanskritWord("भव", "bhava", "bhava", "m", "Geburt, Dasein", null, null, Arrays.asList("bhū")));
			addWord(new SanskritWord("भाव", "bhāva", "bhAva", "m", "sein, existieren, werden", null, null, Arrays.asList("bhū")));
			addWord(new SanskritWord("भावन", "bhāvana", "bhAvana", "adj", "bewirken", "fördern, lehren", null, Arrays.asList("bhAva")));
			addWord(new SanskritWord("भावनात", "bhāvanāta", "bhAvanAta", null, "Entwicklung", null, null, Arrays.asList("bhāvana")));
			addWord(new SanskritWord("भास्", "bhās", "bhAs", "(n) f", "Schein, Licht, Glanz", null, null, Arrays.asList()));
			addWord(new SanskritWord("भुवन", "bhuvana", "bhuvana", "n", "Wesen, Ding", "Welt, Ort der Existenz", null, Arrays.asList()));
			addWord(new SanskritWord("भू", "bhū", "bhU", "√", "werden,entstehen", null, null, Arrays.asList()));
			addWord(new SanskritWord("भूत", "bhūta", "bhUta", "adj", "werden,sein, gewesen sein",
					"Vergangenheit (n), Element (physisch, aber auch feinstofflich) (n)", null, Arrays.asList("bhū")));
			addWord(new SanskritWord("भूमि", "bhūmi", "bhUmi", "f", "Erde, Boden", "Basis, Stockwerk, Stufe", null, Arrays.asList("bhū")));
			addWord(new SanskritWord("भूमिका", "bhūmikā", "bhUmikA", "f", "Erde, Boden,", "Platz, Niveau", null, Arrays.asList("bhūmi")));
			addWord(new SanskritWord("भूमिकत्व", "bhūmikatva", "bhUmikatva", null, "(gewünschter Zustand ??)", null, null, Arrays.asList()));
			addWord(new SanskritWord("भोग", "bhoga", "bhoga", "m", "Besitz, Verbrauch, Genuß", "Nutzung, Verwendung, Erfahrung, Wahrnehmung", null,
					Arrays.asList()));
			addWord(new SanskritWord("भ्रान्ति", "bhrānti", "bhrAnti", "f", "Drehung, Umdrehung, Umherfliegen", "Verwirrung, Unsicherheit", null,
					Arrays.asList()));
			addWord(new SanskritWord("भेद", "bheda", "bheda", "m", "Zerbrechen, Zerspalten", "Trennung, Unterscheidung, Verschiedenheit", null,
					Arrays.asList()));

			addWord(new SanskritWord("मैत्री", "maitrī", "maitrI", "n", "Wohlwollen, Freundlichkeit", null, null, Arrays.asList()));
			addWord(new SanskritWord("मत", "mata", "mata", "adj", "gewünscht, respektiert", null, null, Arrays.asList("mad")));
			addWord(new SanskritWord("मद्", "mad", "mad", "√", "genießen, darin schwelgen, vergnügen", null, null, Arrays.asList()));
			addWord(new SanskritWord("मध्य", "madhya", "madhya", "n", "Mitte, in mitten, dazwischen", "neutral", null, Arrays.asList()));
			addWord(new SanskritWord("मन्", "man", "man", "√", "meinen, glauben, denken", null, null, Arrays.asList()));
			addWord(new SanskritWord("मनस्", "manas", "manas", "n", "Sinn, Denken", null, null, Arrays.asList("man")));
			addWord(new SanskritWord("मनोजवित्व", "manojavitva", "manojavitva", null, "Geistesschnelligkeit", null, null, Arrays.asList("manas", "java")));
			addWord(new SanskritWord("मन्त्र", "mantra", "mantra", "m", "Spruch, Gedicht", "Zauberspruch, vedischer Spruch", null, Arrays.asList()));
			addWord(new SanskritWord("मणि", "maṇi", "maNi", "m", "Perle, Kristall", null, null, Arrays.asList()));
			addWord(new SanskritWord("मल", "mala", "mala", "n", "Schmutz, Unrat", null, null, Arrays.asList()));
			addWord(new SanskritWord("मह", "maha", "maha", "adj", "groß", "Feier (m)", null, Arrays.asList()));
			addWord(new SanskritWord("महत्त्व", "mahattva", "mahattva", "n", "Größe", null, null, Arrays.asList("maha")));
			addWord(new SanskritWord("महा", "mahā", "mahA", null, "sehr", null, null, Arrays.asList()));
			addWord(new SanskritWord("महाव्रत", "mahāvrata", "mahAvrata", "n", "große Pflicht", "Grundpflicht", null, Arrays.asList()));
			addWord(new SanskritWord("मा", "mā", "mA", "√", "messen, austauschen, brüllen", null, null, Arrays.asList()));
			addWord(new SanskritWord("मात्र", "mātra", "mAtra", "n", "Maß", "nichts außer, nur", null, Arrays.asList("mā")));
			addWord(new SanskritWord("मान", "māna", "mAna", "m", "Gedanke, Meinung, Konzept", null, null, Arrays.asList("man", "mā")));
			addWord(new SanskritWord("मिथु", "mithu", "mithu", "adv undekl.", "verwechselt", "falsch, verkehrt", null, Arrays.asList()));
			addWord(new SanskritWord("मिथुया", "mithuyā", "mithuyA", "adv", "verkehrt, falsch, unrichtig", null, null, Arrays.asList("mithy")));
			addWord(new SanskritWord("मिथ्या", "mithyā", "mithyA", "undekl.", "verkehrt, falsch, unrichtig", null,
					"(jüngere Form von mithuyā); Substantiviert und personifiziert ist Mithyā die Gattin Adharma's", Arrays.asList("mithuyā")));
			addWord(new SanskritWord("मुदित", "mudita", "mudita", "f", "Freude, Fröhlichkeit, freudig", null, null, Arrays.asList()));
			addWord(new SanskritWord("मूर्धन्", "mūrdhan", "mUrdhan", "m", "Stirn, Vorderkopf", "Schädel, der vorderste/höchste/überragendste Teil", null,
					Arrays.asList()));
			addWord(new SanskritWord("मुष्", "muṣ", "muS", "√", "wegnehmen, rauben, stehlen", null, null, Arrays.asList()));
			addWord(new SanskritWord("मूल", "mūla", "mUla", "n", "Wurzel", "Grundlage", null, Arrays.asList()));
			addWord(new SanskritWord("मृद्", "mṛd", "mRd", "√ f", "Erde, Lehm, Ton", null, null, Arrays.asList()));
			addWord(new SanskritWord("मृदु", "mṛdu", "mRdu", "adj", "weich, geschmeidig, mild", null, null, Arrays.asList("mṛd")));
			addWord(new SanskritWord("मेघ", "megha", "megha", "m", "Wolke", null, null, Arrays.asList()));
			addWord(new SanskritWord("मोष", "moṣa", "moSa", "m", "Dieb, gestohlenes Gut", null, null, Arrays.asList("muṣ")));
			addWord(new SanskritWord("मोह", "moha", "moha", "m", "Verlust an Besinnung", "Verblendung, Irrtum", null, Arrays.asList()));

			addWord(new SanskritWord("य", "ya", "ya", null, "wer", null, null, Arrays.asList()));
			addWord(new SanskritWord("यथा", "yathā", "yathA", "undekl.", "wie, so dass", null, null, Arrays.asList("ya")));
			addWord(new SanskritWord("यत्", "yat", "yat", "√", "anschließen, verbinden", "Anschluß suchen, streben nach", null, Arrays.asList()));
			addWord(new SanskritWord("यत्न", "yatna", "yatna", "m", "Willensanstrengung, Bemühung", null, null, Arrays.asList("yat")));
			addWord(new SanskritWord("यम", "yama", "yama", "m", "Hemmen", "allgemeines Sittengesetz", null, Arrays.asList()));
			addWord(new SanskritWord("युज्", "yuj", "yuj", "√", "schirren, anspannen", "verbinden, zusammenbringen", null, Arrays.asList()));
			addWord(new SanskritWord("योग", "yoga", "yoga", "m", "das Anschirren, Joch, Verbindung", "sehr viele andere Bedeutungen (S. WB)",
					"Yoga als Bezeichnung für ein philosophisches System, das von Patanjali in den Sutras näher erläutert wird", Arrays.asList("yuj")));
			addWord(new SanskritWord("योगिन्", "yogin", "yogin", "adj", "verbunden mit", "verbunden mit übernatürlichen Kräften, Magier, Yogi (m)", null,
					Arrays.asList()));
			addWord(new SanskritWord("योग्य", "yogya", "yogya", "adj", "Zugtier (m)", "brauchbar, angemessen, passend", null, Arrays.asList()));
			addWord(new SanskritWord("योग्यता", "yogyatā", "yogyatA", "f", "Eignung, Fähigkeit", null, null, Arrays.asList()));

			addWord(new SanskritWord("रक्त", "rakta", "rakta", "adj", "gefärbt", "lieblich, aufgeregt", null, Arrays.asList()));
			addWord(new SanskritWord("राग", "rāga", "rAga", "m", "Das Färben,Farbe, Röte", "Verlangen, Reiz, musikalische Weise, Mögen, Zuneigung", null,
					Arrays.asList("raj")));
			addWord(new SanskritWord("रज्", "raj", "raj", "√", "färben, röten", "erfreuen, freudige Aufregung", null, Arrays.asList()));
			addWord(new SanskritWord("रत्न", "ratna", "ratna", "n", "Habe, Besitz", "Kleinod", null, Arrays.asList()));
			addWord(new SanskritWord("रम्", "ram", "ram", "√", "still stehen, bleiben", null, null, Arrays.asList()));
			addWord(new SanskritWord("रस", "rasa", "rasa", "m", "Saft", "das Feinste, Essenz", null, Arrays.asList()));
			addWord(new SanskritWord("रुत", "ruta", "ruta", "n", "Ton, Gesang, Schrei", "zerbrochen, geteilt", null, Arrays.asList()));
			addWord(new SanskritWord("रूढ", "rūḍha", "rUDha", "adj", "bestiegen, erhöht, aufgeladen", null, null, Arrays.asList()));
			addWord(new SanskritWord("रुध्", "rudh", "rudh", "√", "zurückhalten, anhalten, hemmen, unterdrücken", null, null, Arrays.asList()));
			addWord(new SanskritWord("रोध", "rodha", "rodha", "m", "wachsen, zurückhalten, unterdrücken, Damm", "aufsteigen", null, Arrays.asList("rudh")));
			addWord(new SanskritWord("रूप", "rūpa", "rUpa", "n", "äussere Erscheinung, sowohl Farbe als Gestalt, Form; Wesen",
					"Bild, Bildnis; eine schöne Gestalt, Schönheit; Naturerscheinung, Erscheinung, Symptom; u.a. (S. WB)", null, Arrays.asList()));
			addWord(new SanskritWord("रूपय्", "rūpay", "rUpay", null, "Gestalt verleihen, betrachten, hinsehen", null, null, Arrays.asList("rūpa")));
			addWord(new SanskritWord("रूप्य", "rūpya", "rUpya", "n", "gesehen als, definiert als", "Erscheinung", null, Arrays.asList("rūpay")));

			addWord(new SanskritWord("लक्षण", "lakṣaṇa", "lakSaNa", "f", "Merkmal, Zeichen, Attribut", null, null, Arrays.asList()));
			addWord(new SanskritWord("लघु", "laghu", "laghu", "adj", "rasch, schnell, behende, leicht", "unbedeutend", null, Arrays.asList()));
			addWord(new SanskritWord("लब्ध", "labdha", "labdha", "adj", "genommen, erhalten, bekommen", null, null, Arrays.asList("labh")));
			addWord(new SanskritWord("लभ्", "labh", "labh", "√", "halten, fangen", "besitzen", null, Arrays.asList()));
			addWord(new SanskritWord("लाभ", "lābha", "lAbha", "m", "Finden, Antreffen", "Erlangen, Gewinn", null, Arrays.asList()));
			addWord(new SanskritWord("लम्ब्", "lamb", "lamb", "√", "hängen", "zurückbleiben", null, Arrays.asList()));
			addWord(new SanskritWord("लम्बन", "lambana", "lambana", "adj", "herabhängen", null, null, Arrays.asList("lamb")));
			addWord(new SanskritWord("लय", "laya", "laya", "m", "das Anheften, ankleben, verschwinden", null, null, Arrays.asList()));
			addWord(new SanskritWord("लयन", "layana", "layana", "n", "Akt des klebens, daran kleben", null, null, Arrays.asList("laya")));
			addWord(new SanskritWord("लावण्य", "lāvaṇya", "lAvaNya", "n", "Salzigkeit, Anmut, Schönheit", null, null, Arrays.asList()));
			addWord(new SanskritWord("लिङ्ग", "liṅga", "liGga", "n", "Merkmal, Symbol", null, null, Arrays.asList()));
			addWord(new SanskritWord("लोभ", "lobha", "lobha", "m", "Gier, Habsucht, Verlangen", null, null, Arrays.asList()));
			addWord(new SanskritWord("लोमन्", "loman", "loman", "n", "Körperhaar (kein Kopf-, Barthaar, Schweif)", "entwickelt aus 'roman'", null,
					Arrays.asList()));

			addWord(new SanskritWord("वत्", "vat", "vat", "affix", "Ähnlichkeit mit, vergleichbar mit", "'wie'", null, Arrays.asList()));
			addWord(new SanskritWord("वती", "vatī", "vatI", null, "blasen", null, null, Arrays.asList()));
			addWord(new SanskritWord("वच्", "vac", "vac", "√", "sagen, berichten", null, null, Arrays.asList()));
			addWord(new SanskritWord("वज्र", "vajra", "vajra", "m", "Diamant,Donnerkeil", null, null, Arrays.asList()));
			addWord(new SanskritWord("वरण", "varaṇa", "varaNa", "m", "Wall", "verhindern", null, Arrays.asList()));
			addWord(new SanskritWord("वश्", "vaś", "vaz", "√", "wollen, verlangen", null, null, Arrays.asList()));
			addWord(new SanskritWord("वश", "vaśa", "vaza", "m", "Wunsch, Kontrolle", null, null, Arrays.asList("vaś")));
			addWord(new SanskritWord("वशीकर", "vaśīkara", "vazIkara", "adj", "in die Gewalt bekommen, bezwingen", null, null, Arrays.asList("vaśa", "kar")));
			addWord(new SanskritWord("वशीकार", "vaśīkāra", "vazIkAra", "m", "in die Gewalt bekommen, bezwingen, Kontrolle der Handlung", null, null,
					Arrays.asList("vaśīkara", "vaśa", "kāra")));
			addWord(new SanskritWord("वश्य", "vaśya", "vazya", "n", "Macht, Gewalt", "in jemandes Gewalt stehen", null, Arrays.asList()));
			addWord(new SanskritWord("वस्", "vas", "vas", "√", "aufleuchten", null, null, Arrays.asList()));
			addWord(new SanskritWord("वस्तु", "vastu", "vastu", "n", "Ding, Gegenstand, Platz, Morgen", null, null, Arrays.asList("vas")));
			addWord(new SanskritWord("वहिन्", "vahin", "vahin", "adj", "am Joch gehend, zuggewohnt", null, null, Arrays.asList()));
			addWord(new SanskritWord("वा", "vā", "vA", "undekl.", "oder", null, null, Arrays.asList()));
			addWord(new SanskritWord("वाचक", "vācaka", "vAcaka", "adj", "sprechend, bezeichnend, Sprecher (m), Bote", null, null, Arrays.asList("vac")));
			addWord(new SanskritWord("वात्", "vāt", "vAt", "undekl.", "oder, umfassen, voll von, fächern", null, null, Arrays.asList()));
			addWord(new SanskritWord("वार्त्ता", "vārttā", "vArttA", "adj", "Geruch, gewöhnlich",
					"wertlos, gesund, Beruf (f), Geschäft (Geruch: siehe Boehtlink-Roth Originalseite)", null, Arrays.asList()));
			addWord(new SanskritWord("वासन", "vāsana", "vAsana", "n", "Gewand, Kleid", "Hülle, Umschlag", null, Arrays.asList()));
			addWord(new SanskritWord("वासना", "vāsanā", "vAsanA", "f", "Vorstellung, Idee, Wunsch, Neigung", null, null, Arrays.asList()));
			addWord(new SanskritWord("वाहिन्", "vāhin", "vAhin", "adj", "fahrend, fließend", null, null, Arrays.asList()));
			addWord(new SanskritWord("वाहिता", "vāhitā", "vAhitA", "f", "Fluß, Strom", null, null, Arrays.asList()));
			addWord(new SanskritWord("वि", "vi", "vi", "undekl.", "''zweiter (=dvi)''", "getrennt von, ''Gegenteil von'', hindurch, durch", null,
					Arrays.asList()));
			addWord(new SanskritWord("विकरण", "vikaraṇa", "vikaraNa", "n", "Verändern, Einwirken", null, null, Arrays.asList()));
			addWord(new SanskritWord("विकल्प", "vikalpa", "vikalpa", "m", "falsche Vorstellung, Einbildung",
					"Wechsel, Wahl zwischen Zweien oder Mehreren; Verschiedenheit in der Auffassung, Unterscheidung; Unschlüssigkeit, Unentschlossenheit, Zweifel",
					null, Arrays.asList("vi", "kalpa")));
			addWord(
					new SanskritWord("विक्षेप", "vikṣepa", "vikSepa", "m", "Hinwerfen, Gehenlassen", "Schmähung, Mitleid", null, Arrays.asList("vi", "kṣip")));
			addWord(new SanskritWord("विचार", "vicāra", "vicAra", "m", "Überlegung, Erwägung, in-Betracht-Ziehung, Prüfung, Untersuchung",
					"Verfahren; Wechsel der Stelle; wahrscheinliche Vermutung", null, Arrays.asList("vi", "cāra")));
			addWord(new SanskritWord("विच्छिन्न", "vicchinna", "vicchinna", "f", "Auseinandergerissenheit, unterbrochen, beendet (adj)", null, null,
					Arrays.asList()));
			addWord(new SanskritWord("विच्छेद", "viccheda", "viccheda", "m", "Zerspalten, Trennen", "Ausrotten, Unterschied", null, Arrays.asList()));
			addWord(new SanskritWord("विज्", "vij", "vij", "√", "emporschießen, schnellen, davoneilen", null, null, Arrays.asList()));
			addWord(new SanskritWord("वीत", "vita", "vita", null, "verschwinden, fehlen", null, null, Arrays.asList()));
			addWord(new SanskritWord("वितर्क", "vitarka", "vitarka", "m", "Vermutung, Erwägung, Zweifel", null, null, Arrays.asList("vi", "tarka")));
			addWord(
					new SanskritWord("वितृष्न", "vitṛṣṇa", "vitRSNa", "adj", "getrennt von Durst, durstlos", "begierdelos", null, Arrays.asList("vi", "tṛṣ")));
			addWord(new SanskritWord("विदुस्", "vidus", "vidus", "adj", "aufmerksam, sich merkend", "weise", null, Arrays.asList()));
			addWord(new SanskritWord("विदेह", "videha", "videha", "adj", "körperlos, vom Körper befreit", "verstorben", null, Arrays.asList("vi", "deha")));
			addWord(new SanskritWord("विधारण", "vidhāraṇa", "vidhAraNa", "adj", "scheiden, trennen, anhalten, unterdrücken", "das Trennen (n)", null,
					Arrays.asList()));
			addWord(new SanskritWord("विनियोग", "viniyoga", "viniyoga", "m", "Verteilung, Verwendung", "Beauftragung, Anwendung, Gebrauch", null,
					Arrays.asList()));
			addWord(new SanskritWord("विपाक", "vipāka", "vipAka", "adj", "reif, reifen", "kochen, verdauen, das Kochen/Reifen (m)", null,
					Arrays.asList("vi", "pac")));
			addWord(new SanskritWord("विपर्यय", "viparyaya", "viparyaya", "m", "verkehrte Ansicht, falsche Auffassung, Irrtum",
					"in umgekehrtem Verhältnis stehend; Umstellung, Vertauschung, Wechsel; umgekehrtes Verhältnis, Gegenteil; Verschlimmerung; u.a.", null,
					Arrays.asList("vi", "paryaya")));
			addWord(new SanskritWord("विप्रकृष्ट", "viprakṛṣṭa", "viprakRSTa", "adj", "auseinandergezogen, entfernt,", null, null, Arrays.asList()));
			addWord(new SanskritWord("विभूति", "vibhūti", "vibhUti", "f", "Entfaltung, reiche Fülle, Machtmanifestation, reichlich, durchdringend",
					"Wohlergehen", null, Arrays.asList()));
			addWord(new SanskritWord("विराग", "virāga", "virAga", "m", "Verlust der Röte", "entfärben", null, Arrays.asList(null, "vi", "raj")));
			addWord(new SanskritWord("विरति", "virati", "virati", "f", "Aufhören, Ende, Entsagen, Enthalten", null, null, Arrays.asList("vi", "ram")));
			addWord(new SanskritWord("विराम", "virāma", "virAma", "m", "Aufhören, Schluß, Ende", null, null, Arrays.asList("vi", "ram")));
			addWord(new SanskritWord("विरोध", "virodha", "virodha", "m", "feindseliges Auftreten", "Widerspruch, Widerstreit", null, Arrays.asList()));
			addWord(new SanskritWord("विवेक", "viveka", "viveka", "m", "Unterscheidung, Trennung", "richtige Unterscheidung", null, Arrays.asList()));
			addWord(new SanskritWord("विवेकिन्", "vivekin", "vivekin", "adj", "scheidend, getrennt", "unterscheidend, klug, weise", null, Arrays.asList()));
			addWord(new SanskritWord("वीत", "vīta", "vIta", null, "beliebt, vergangen, verborgen", null, null, Arrays.asList()));
			addWord(new SanskritWord("वीतराग", "vītarāga", "vItarAga", null, "frei von aller Leidenschaft", null, null, Arrays.asList("vita", "rāga")));
			addWord(new SanskritWord("वीर", "vīra", "vIra", "m", "Mann, tapferer Mann, Held", null, null, Arrays.asList()));
			addWord(new SanskritWord("वीर्य", "vīrya", "vIrya", "n", "Männlichkeit, Tapferkeit", "Kraft, Energie", null, Arrays.asList("vīra")));
			addWord(new SanskritWord("विशेष", "viśeṣa", "vizeSa", "m", "Unterschied, Besonderheit",
					"Eigentümlichkeit, Art, Individuum, eine spezifische Eigenschaft", null, Arrays.asList("vi", "śeṣa")));
			addWord(new SanskritWord("विष्", "viṣ", "viS", "√", "wirken, tun", "dienen", null, Arrays.asList()));
			addWord(new SanskritWord("विषय", "viṣaya", "viSaya", "m", "etwas mit den Sinnen Wahrnehmbares",
					"Objekt der Sinneswahrnehmung, Gebiet, Region, Territorium,Fach", null, Arrays.asList("viṣ")));
			addWord(new SanskritWord("विषयत्व", "viṣayatva", "viSayatva", "n", "das Objekt sein", null, null, Arrays.asList("viṣaya")));
			addWord(new SanskritWord("विषयान", "viṣayāna", "viSayAna", null, "(Situation, Ziel ??)", null, null, Arrays.asList()));
			addWord(new SanskritWord("विशोक", "viśoka", "vizoka", "m", "ohne Kummer, Weichen des Kummers", null, null, Arrays.asList("vi", "śoka")));
			addWord(new SanskritWord("वृत्ति", "vṛtti", "vRtti", "f", "Art und Weise des Verhaltens; Wesen, Natur, Art; Funktion, Tätigkeit, Aktivität",
					"viele andere Bedeutungen (S. WB); u.a. Rollen von Tränen; Lebensunterhalt...", null, Arrays.asList()));
			addWord(new SanskritWord("वेग", "vega", "vega", "m", "schnelle Bewegung, Ungestüm Vehemenz", null, null, Arrays.asList("vij")));
			addWord(new SanskritWord("वेदन", "vedana", "vedana", "n", "Empfindung", "Erkenntnis, Schmerz", null, Arrays.asList()));
			addWord(new SanskritWord("वेदनीय", "vedanīya", "vedanIya", "adj", "empfunden werden, bezeichnet, ausgedrückt", null, null, Arrays.asList()));
			addWord(new SanskritWord("वैतृष्ण्य", "vaitṛṣṇya", "vaitRSNya", "n", "Befreiung von Durst", null, "siehe vitṛṣṇa", Arrays.asList("vitṛṣṇa")));
			addWord(new SanskritWord("वैर", "vaira", "vaira", "n", "Feindschaft, feindselig", null, null, Arrays.asList()));
			addWord(new SanskritWord("वैराग्य", "vairāgya", "vairAgya", "n", "bleich werden", "Abneigung, Gleichmut, Indifferenz", null,
					Arrays.asList("virāga")));
			addWord(new SanskritWord("वैशारद्य", "vaiśāradya", "vaizAradya", "n", "Erfahrenheit, Kundigsein", null, null, Arrays.asList()));
			addWord(new SanskritWord("विभक्त", "vibhakta", "vibhakta", null, "Schnitt", "glatt getrennt, Wunde", null, Arrays.asList()));
			addWord(new SanskritWord("विविच्", "vivic", "vivic", null, "unterscheiden", null, null, Arrays.asList()));
			addWord(new SanskritWord("व्यक्त", "vyakta", "vyakta", "adj", "herausgeputzt", "offenbar, wahrnehmbar", null, Arrays.asList()));
			addWord(new SanskritWord("व्यवधा", "vyavadhā", "vyavadhA", "f", "Verhüllung", null, null, Arrays.asList()));
			addWord(new SanskritWord("व्यवहित", "vyavahita", "vyavahita", "adj", "getrennt, entfernt", "verborgen, versteckt, getan, übertroffen", null,
					Arrays.asList()));
			addWord(new SanskritWord("व्या", "vyā", "vyA", null, "umwickeln, umhüllen", null, null, Arrays.asList()));
			addWord(new SanskritWord("व्याख्या", "vyākhyā", "vyAkhyA", "f", "Erklärung, Beschreibung", null, null, Arrays.asList("vyā", "khyā")));
			addWord(new SanskritWord("व्याधि", "vyādhi", "vyAdhi", "m", "Krankheit", null, null, Arrays.asList("vyā", "dhā")));
			addWord(new SanskritWord("व्युत्थान", "vyutthāna", "vyutthAna", "n", "Pflichtversäumnis", "Nachgeben, Erwachen, Wachsen", null, Arrays.asList()));
			addWord(new SanskritWord("व्यूह", "vyūha", "vyUha", "m", "Verschiebung, Verrückung",
					"Auseinanderrückung, Verteilung, Aufstellung eines Heeres, Gesamtheit, Teil, Kapitel", null, Arrays.asList()));
			addWord(new SanskritWord("व्रत", "vrata", "vrata", "n", "Wille, Gebot, Dienst, Gebiet, Beruf, Gelübde", null, null, Arrays.asList()));

			addWord(new SanskritWord("शक्ति", "śakti", "zakti", "f", "Kraft, Können", "Fähigkeit, Geschick", null, Arrays.asList()));
			addWord(new SanskritWord("शब्द", "śabda", "zabda", "m", "Klang, Geräusch", "Wort", null, Arrays.asList()));
			addWord(new SanskritWord("शब्दार्थ", "śabdārtha", "zabdArtha", "m", "Bedeutung eines Wortes, einer mündlichen Mitteilung", null, null,
					Arrays.asList()));
			addWord(new SanskritWord("शान्त", "śānta", "zAnta", "adj.", "beruhigt, erloschen, nachgelassen", null, null, Arrays.asList()));
			addWord(new SanskritWord("शय", "śaya", "zaya", "m", "Schlaf", null, null, Arrays.asList("śī")));
			addWord(new SanskritWord("शरीर", "śarīra", "zarIra", null, "Leib, Knochengerüst, Körper", null, null, Arrays.asList()));
			addWord(new SanskritWord("शास्", "śās", "zAs", "√", "herrschen, anweisen, tadeln, strafen", null, null, Arrays.asList()));
			addWord(new SanskritWord("शासन", "śāsana", "zAsana", "n", "Auftrag, Befehl, Richtung,",
					"Regel,Unterricht, Autorität, Werk mit Autorität, Herrschaft, Bestrafung", null, Arrays.asList("śās")));
			addWord(new SanskritWord("शिष्", "śiṣ", "ziS", "√", "übrig bleiben, übrig lassen", "unterscheiden, auszeichnen", null, Arrays.asList()));
			addWord(new SanskritWord("शी", "śī", "zI", "√, f", "schlafen, liegen, weichen, schwinden", "Schlaf, Ruhe", null, Arrays.asList()));
			addWord(new SanskritWord("शील", "śīla", "zIla", "n", "Gewohnheit, Natur, Wesen", null, null, Arrays.asList()));
			addWord(new SanskritWord("शुक्ल", "śukla", "zukla", "adj", "hell, weiß", null, null, Arrays.asList()));
			addWord(new SanskritWord("शुच्", "śuc", "zuc", "√", "glühen, brennen", null, null, Arrays.asList()));
			addWord(new SanskritWord("शुचि", "śuci", "zuci", "adj", "strahlend, glühend", "rein, Reinheit (m), Ehrlichkeit (m)", null, Arrays.asList()));
			addWord(new SanskritWord("शुद्ध", "śuddha", "zuddha", "adj", "rein, hell", "lauter, fehlerfrei, ganz, vollständig, abgeschlossen", null,
					Arrays.asList()));
			addWord(new SanskritWord("शुद्धि", "śuddhi", "zuddhi", "f", "Läuterung, das Reinwerden, Klarheit", "genaue Kenntnis", null, Arrays.asList()));
			addWord(new SanskritWord("शुध्", "śudh", "zudh", "√", "reinigen, abwaschen", null, null, Arrays.asList()));
			addWord(new SanskritWord("शून", "śūna", "zUna", "n", "Leere, Abwesenheit", "Mangel", null, Arrays.asList()));
			addWord(new SanskritWord("शून्य", "śūnya", "zUnya", "adj", "leer", null, null, Arrays.asList("śūna")));
			addWord(new SanskritWord("शेष", "śeṣa", "zeSa", "m/n", "Rest, übriges", null, null, Arrays.asList("śiṣ")));
			addWord(new SanskritWord("शैथिल्य", "śaithilya", "zaithilya", "n", "Lockerheit, Schlaffheit", null, null, Arrays.asList()));
			addWord(new SanskritWord("शोक", "śoka", "zoka", "m", "Glut,Flamme, Qual, Kummer", null, null, Arrays.asList("śuc")));
			addWord(new SanskritWord("शौच", "śauca", "zauca", "n", "Reinigung, Reinheit", null, null, Arrays.asList()));
			addWord(new SanskritWord("श्रत्", "śrat", "zrat", "undekl.", "vertrauen, glauben, gutheißen, sich einverstanden erklären", null, null,
					Arrays.asList()));
			addWord(new SanskritWord("श्रद्धा", "śraddhā", "zraddhA", "f", "Vertrauen", "Glaube", null, Arrays.asList("śrat", "dhā")));
			addWord(new SanskritWord("श्रव", "śrava", "zrava", "m", "das Hören, tönend", null, null, Arrays.asList("śru")));
			addWord(new SanskritWord("श्रवण", "śrāvaṇa", "zravaNa", "m/n", "das Ohr (m), das Hören (n)", "Leumund, guter Ruf (n)", null, Arrays.asList()));
			addWord(new SanskritWord("श्रु", "śru", "zru", "√", "hören", "achten", null, Arrays.asList()));
			addWord(new SanskritWord("श्रुत", "śruta", "zruta", "n", "Gehörtes", "Gelerntes, Überliefertes", null, Arrays.asList("śru")));
			addWord(new SanskritWord("श्रुत", "śrotra", "zrotra", "n", "Ohr, Gehör", null, null, Arrays.asList()));
			addWord(new SanskritWord("श्वस्", "śvās", "zvAs", null, "blasen, zischen, seufzen", null, null, Arrays.asList()));
			addWord(new SanskritWord("श्वास", "śvāsa", "zvAsa", "m", "Gezisch", "Atmen, Einatmung, Seufzen", null, Arrays.asList("śvās")));

			addWord(new SanskritWord("ष्ठ", "ṣṭha", "STha", null, "stehen", null, null, Arrays.asList()));

			addWord(new SanskritWord("स", "sa", "sa", "undekl.", "ähnlich, mit, zusammen mit", null, null, Arrays.asList()));
			addWord(new SanskritWord("साक्षात्करण", "sākṣātkaraṇa", "sAkSAtkaraNa", "n", "das Schauen", null, null, Arrays.asList()));
			addWord(new SanskritWord("सदा", "sadā", "sadA", "adv", "allezeit, immer", null, null, Arrays.asList()));
			addWord(new SanskritWord("संतोष", "saṃtoṣa", "saMtoSa", "m", "Befriedigung, Zufriedenheit, Genügsamkeit", null, null, Arrays.asList()));
			addWord(new SanskritWord("संप्रमोष", "saṃpramoṣa", "saMpramoSa", "m", "Schwund", null, null, Arrays.asList()));
			addWord(new SanskritWord("संकर", "saṃkara", "saMkara", "m", "Vermengung, Vermischung", null, null, Arrays.asList()));
			addWord(new SanskritWord("संकीर्ण", "saṃkīrṇa", "saMkIrNa", "adj", "gemischt", null, null, Arrays.asList("sam", "kīrṇa")));
			addWord(new SanskritWord("संक्रम", "saṃkrama", "saMkrama", "m", "Gang, Lauf", "Zusammentritt, Übergehen, Brücke über Wasser", null,
					Arrays.asList()));
			addWord(new SanskritWord("संख्या", "saṃkhyā", "saMkhyA", "f", "Zahl, Berechnung", "Überlegung, Intellekt, Summe, Gesamtzahl", null,
					Arrays.asList()));
			addWord(new SanskritWord("संग्रह", "saṃgraha", "saMgraha", "m", "Ergreifen", "Zusammenbringen,Sammlung", null, Arrays.asList()));
			addWord(new SanskritWord("संगृहीत", "saṃgṛhīta", "saMgRhIta", null, "erfasst, gefasst, gesammelt", null, null, Arrays.asList()));
			addWord(new SanskritWord("संज्ञा", "saṃjñā", "saMjJA", "f", "mit Wissen", "Bewußtsein, Einverständnis, klares Wissen", null,
					Arrays.asList("sam", "jñā")));
			addWord(new SanskritWord("संपद्", "saṃpad", "saMpad", "f", "Übereinkommen, Handelsabschluss", "Gelingen, Erfolg", null,
					Arrays.asList("sam", "pad")));
			addWord(new SanskritWord("संप्रज्ञात", "saṃprajñāta", "saMpraJAta", null, "mit Erkenntnis, mit Unterscheidung", null,
					"Samprajnāta wird die untere Stufe des Samādhi genannt. Es ist ein Samādhi mit Bewußtsein, im Unterschied zum überbewußten (asamprajnāta) Samādhi.",
					Arrays.asList("sam", "prajñā")));
			addWord(new SanskritWord("संप्रयोग", "saṃprayoga", "saMprayoga", "m", "Verbindung, Vereinigung, Befestigung, Ausübung", "Zauberei", null,
					Arrays.asList()));
			addWord(new SanskritWord("संबोध", "saṃbodha", "saMbodha", "m", "Erkenntnis, Verständnis", null, null, Arrays.asList()));
			addWord(new SanskritWord("संबन्ध", "saṃbandha", "saMbandha", "m", "Sammlung, Beziehung, Verhältnis", null, null, Arrays.asList()));
			addWord(new SanskritWord("संनिधि", "saṃnidhi", "saMnidhi", "m", "Nebeneinanderstellung", "Nähe, Gegenwart, Anwesenheit", null, Arrays.asList()));
			addWord(new SanskritWord("संयम", "saṃyama", "saMyama", "m", "Fesselung, Zusammenbinden", "Bändigung der Sinne, Selbstbeherrschung", null,
					Arrays.asList()));
			addWord(new SanskritWord("संयोग", "saṃyoga", "saMyoga", "m", "Verbindung, Zusammenhang", null, null, Arrays.asList()));
			addWord(new SanskritWord("संवेग", "saṃvega", "saMvega", "m", "heftige Gemütsbewegung", "hoher Grad, Intensität", null,
					Arrays.asList("sam", "vega")));
			addWord(new SanskritWord("संवेद", "saṃveda", "saMveda", "m", "Empfindung", null, null, Arrays.asList()));
			addWord(
					new SanskritWord("संवेदन", "saṃvedana", "saMvedana", "n", "Erkennen, Bewußtwerden, Empfinden", "Melden, Verkünden", null, Arrays.asList()));
			addWord(new SanskritWord("संशय", "saṃśaya", "saMzaya", "m", "Zweifel, Untentschlossenheit", null, null, Arrays.asList("sam", "śī")));
			addWord(new SanskritWord("संस्कार", "saṃskāra", "saMskAra", "m", "Zubereitung, Reinigung, Zusammenfügen",
					"Fehlerfreiheit, Bildung, geistiger Eindruck, Erziehung, Training", null, Arrays.asList()));
			addWord(new SanskritWord("संहन्", "saṃhan", "saMhan", "adj", "verbinden, zusammenfügen", "schließen (Augen)", null, Arrays.asList()));
			addWord(new SanskritWord("संहनन", "saṃhanana", "saMhanana", "adj", "gedrungen, verhärtet", null, null, Arrays.asList()));
			addWord(new SanskritWord("सत्", "sat", "sat", "m", "existieren, geschehen, Geschöpf, in Gegenwart von", null, null, Arrays.asList()));
			addWord(new SanskritWord("सति", "sati", "sati", null, null, "Form von as (sein)", null, Arrays.asList()));
			addWord(new SanskritWord("सत्कार", "satkāra", "satkAra", "m", "Achtung, Sorgfalt", null, null, Arrays.asList("sat", "kāra")));
			addWord(new SanskritWord("सत्त्व", "sattva", "sattva", "n", "Sein, Existenz, Wesen, Charakter",
					"das absolut gute Wesen, eines der drei Gunas (Qualitäten)", null, Arrays.asList()));
			addWord(new SanskritWord("सत्य", "satya", "satya", "adj", "wirklich, wahr, echt, Wahrheit, Wahrhaftigkeit (n)", null, null, Arrays.asList()));
			addWord(new SanskritWord("सद्", "sad", "sad", "√", "sitzen", "belagern", null, Arrays.asList()));
			addWord(new SanskritWord("सधन", "sadhana", "sadhana", "n", "gemeinsame Habe", null, null, Arrays.asList()));
			addWord(new SanskritWord("सङ्ग", "saṅga", "saGga", "m", "Hängenbleiben, Haften", null, null, Arrays.asList()));
			addWord(new SanskritWord("सप्तधा", "saptadhā", "saptadhA", "adj", "siebenfach, in 7 Teilen", null, null, Arrays.asList()));
			addWord(new SanskritWord("सबीज", "sabīja", "sabIja", "adj", "Keime enthaltend", null, null, Arrays.asList("sa", "bīja")));
			addWord(new SanskritWord("सम्", "sam", "sam", "undekl.", "mit", "intensiv", null, Arrays.asList("sa")));
			addWord(new SanskritWord("समय", "samaya", "samaya", "m", "Zusammentreffen", "Verkehr, Übereinkommen, Bedingung, Umstand", null, Arrays.asList()));
			addWord(new SanskritWord("समा", "samā", "samA", null, "Sommer", "Jahreszeit, (Halb)jahr", null, Arrays.asList()));
			addWord(new SanskritWord("समाधय", "samādhaya", "samAdhaya", null, null, null, null, Arrays.asList()));
			addWord(new SanskritWord("समाधि", "samādhi", "samAdhi", "m", "Zusammensetzung, Zusammenfügung;Verbindung, Vereinigung, ein Ganzes",
					"das Bringen in Harmonie, in Übereinstimmung; Aufmerksamkeit; Meditation", "meditativer Bewusstseinszustand",
					Arrays.asList("sam", "ādhi")));
			addWord(new SanskritWord("समान", "samāna", "samAna", "adj", "gleich, derselbe, der mittlere", "eine der Prana-Arten", null, Arrays.asList()));
			addWord(new SanskritWord("समापद्", "samāpad", "samApad", null, "beenden, erreichen, attackieren", null, null, Arrays.asList("sam", "āpad")));
			addWord(new SanskritWord("समापत्ति", "samāpatti", "samApatti", null, "Zusammentreffen", "Erreichen, Vollenden", null, Arrays.asList("samāpad")));
			addWord(new SanskritWord("समाप्ति", "samāpti", "samApti", "f", "Ende, Vollendung, Abschluss", null, null, Arrays.asList()));
			addWord(
					new SanskritWord("संविद्", "saṃvid", "saMvid", "f", "Empfindung", "Bewusstsein, Erkenntnis, Einverständnis, Sitte", null, Arrays.asList()));
			addWord(new SanskritWord("सम्बन्ध", "sambandha", "sambandha", "m", "Verbindung", "Beziehung, Relation, Erfolg", null, Arrays.asList()));
			addWord(new SanskritWord("सर्व", "sarva", "sarva", "adj", "alles, ganz", null, null, Arrays.asList()));
			addWord(new SanskritWord("सर्वथा", "sarvathā", "sarvathA", "adv", "in allen Fällen, auf jegliche Weise", null, null, Arrays.asList()));
			addWord(new SanskritWord("सर्वथाविषय", "sarvathāviṣaya", "sarvathAviSaya", "adj", "in welchem Weg auch immer erscheinend", null, null,
					Arrays.asList()));
			addWord(new SanskritWord("साम्य", "sāmya", "sAmya", "n", "Übereinstimmung, Gleichheit", null, null, Arrays.asList()));
			addWord(new SanskritWord("सालम्बन", "sālambana", "sAlambana", "adj", "gehören zu bzw. verbunden mit einer geistigen Übung", null, null,
					Arrays.asList()));
			addWord(new SanskritWord("सविचार", "savicāra", "savicAra", "adj", "von Erwägungen begleitet", null, null, Arrays.asList("sa", "vicāra")));
			addWord(new SanskritWord("सवितर्क", "savitarka", "savitarka", "adj", "von Nachdenken begleitet", null, null, Arrays.asList("sa", "vitarka")));
			addWord(new SanskritWord("सह", "saha", "saha", "undekl.", "zusammen, gleichzeitig, mächtig", null, null, Arrays.asList()));
			addWord(new SanskritWord("सहभुव", "sahabhuva", "sahabhuva", null, "(Begleiterscheinung??)", null, null, Arrays.asList("saha")));
			addWord(new SanskritWord("सहस्", "sahas", "sahas", "n", "Gewalt, gewaltig", "plötzlich, sofort", null, Arrays.asList("saha")));
			addWord(new SanskritWord("साधन", "sādhana", "sAdhana", "m", "Ausführen, Mittel, Erlangen", "sorgfältige Praxis", null, Arrays.asList()));
			addWord(new SanskritWord("साधारण", "sādhāraṇa", "sAdhAraNa", "adj", "gemeinsam, gemeinschaftlich", null, null, Arrays.asList()));
			addWord(new SanskritWord("सार्व", "sārva", "sArva", "adj", "generell, universell", "gut für alle", null, Arrays.asList()));
			addWord(new SanskritWord("सार्वभौम", "sārvabhauma", "sArvabhauma", "adj", "auf der ganzen Erde bekannt/verbreitet", null, null, Arrays.asList()));
			addWord(new SanskritWord("सारूप्यम्", "sārūpya", "sArUpya", "n", "gleiches Aussehen, Aehnlichkeit, Gleichartigkeit, Uebereinstimmung",
					"in der Dramatik ein Fehler/Versehen aufgrund einer Verwechselung zweier ähnlich aussehender Personen", null,
					Arrays.asList("sa", "rūpya")));
			addWord(new SanskritWord("सिद्ध", "siddha", "siddha", "m", "erreicht, erworben, erfüllt, verschreckt, verscheucht", "Meister, heilige Person",
					null, Arrays.asList()));
			addWord(new SanskritWord("सिद्धि", "siddhi", "siddhi", null, "Erfolg", "Zauberkraft", null, Arrays.asList()));
			addWord(new SanskritWord("सु", "su", "su", "√", "gut, angenehm, keltern, erzeugen", "sehr, zum Vorschein bringen", null, Arrays.asList()));
			addWord(new SanskritWord("सुख", "sukha", "sukha", "n", "Wohlbefinden, Genuß, Freude, angenehm (adj)", null, null, Arrays.asList("su")));
			addWord(new SanskritWord("सूक्ष्म", "sūkṣma", "sUkSma", "adj", "fein, schmall, dünn", "unfassbar", null, Arrays.asList()));
			addWord(new SanskritWord("सूत्र", "sūtra", "sUtra", "n", "Faden", "Leitfaden, Aphorismus, kurzer Satz", null, Arrays.asList()));
			addWord(new SanskritWord("सूर्य", "sūrya", "sUrya", "m", "Sonne", null, null, Arrays.asList()));
			addWord(new SanskritWord("सेवित", "sevita", "sevita", "adj", "besucht, frequentiert", null, null, Arrays.asList()));
			addWord(new SanskritWord("सोपक्रम", "sopakrama", "sopakrama", "adj", "wozu man etwas tut, unterstützt", null, null, Arrays.asList()));
			addWord(new SanskritWord("सौमनस्य", "saumanasya", "saumanasya", "n", "Frohsinn, richtiges Verständnis", null, null, Arrays.asList()));
			addWord(new SanskritWord("स्त्या", "styā", "styA", null, "gerinnen", "verdichten", null, Arrays.asList()));
			addWord(new SanskritWord("स्त्यान", "styāna", "styAna", "n", "Gerinnung, Verdichtung,  geronnen", "verdichtet,Intensität", null,
					Arrays.asList("styā")));
			addWord(new SanskritWord("स्थ", "stha", "stha", "adj", "stehend, sitzend, befindend", null, null, Arrays.asList("sthā")));
			addWord(new SanskritWord("स्तम्भ", "stambha", "stambha", "f", "Kräftigung, Unterstützung", "Pfosten, Pfeiler, Säule, Erstarrung, Hemmung", null,
					Arrays.asList()));
			addWord(new SanskritWord("स्था", "sthā", "sthA", "√", "stehen, bestehen, bleiben", null, null, Arrays.asList()));
			addWord(new SanskritWord("स्थान", "sthāna", "sthAna", "n", "(fest) stehen", null, null, Arrays.asList("sthā")));
			addWord(new SanskritWord("स्थानिन्", "sthānin", "sthAnin", "adj", "hohe Stellung einnehmend, was ursprünglich dagestanden hat", "das Primitive",
					null, Arrays.asList()));
			addWord(new SanskritWord("स्थित", "sthita", "sthita", "adj", "stehen, bleiben", "beschäftigt mit, beständig", null, Arrays.asList("stha")));
			addWord(new SanskritWord("स्थिति", "sthiti", "sthiti", "f", "Stehen, Bleiben, Standort", "Aufbewahrung", null, Arrays.asList("stha")));
			addWord(new SanskritWord("स्थिर", "sthira", "sthira", "adj", "hart, fest", null, null, Arrays.asList()));
			addWord(new SanskritWord("स्थूल", "sthūla", "sthUla", "adj", "grob, dick, feist, massiv", "der grobstoffliche (wahrnehmbare) Körper (n)", null,
					Arrays.asList()));
			addWord(new SanskritWord("स्थैर्य", "sthairya", "sthairya", "n", "Festigkeit,Härte, Unbeweglichkeit", null, null, Arrays.asList()));
			addWord(new SanskritWord("स्मय", "smaya", "smaya", "m", "Staunen, Verwunderung, Stolz, Hochmut", null, null, Arrays.asList()));
			addWord(new SanskritWord("स्मृ", "smṛ", "smR", "√", "erinnern", null, null, Arrays.asList()));
			addWord(new SanskritWord("स्मृति", "smṛti", "smRti", "f", "Erinnerung, Gedächtnis", null, null, Arrays.asList("smṛ")));
			addWord(new SanskritWord("स्यात्", "syāt", "syAt", null, "es könnte sein (3. Person potent. von as)", "vielleicht", null, Arrays.asList()));
			addWord(new SanskritWord("स्व", "sva", "sva", "adj", "eigen", null, null, Arrays.asList()));
			addWord(new SanskritWord("स्वप्", "svap", "svap", "√", "schlafen", null, null, Arrays.asList()));
			addWord(new SanskritWord("स्वप्न", "svapna", "svapna", "m", "Schlaf, Traum, Schlaflosigkeit", null, null, Arrays.asList("svap")));
			addWord(new SanskritWord("स्वरूप", "svarūpa", "svarUpa", "n", "eigene Form, eigene Natur,", "Realität", null, Arrays.asList("sva", "rūpa")));
			addWord(new SanskritWord("स्वाध्याय", "svādhyāya", "svAdhyAya", "m", "Lesen, Studium", null, null, Arrays.asList()));
			addWord(
					new SanskritWord("स्वामिन्", "svāmin", "svAmin", "m", "Eigentümer, Herr, Gebieter, Herrin (f)", "Gottesstandbild", null, Arrays.asList()));

			addWord(new SanskritWord("हस्तिन्", "hastin", "hastin", "adj", "mit Händen versehen", "geschickt mit der Hand, mit Rüssel, Elefant", null,
					Arrays.asList()));
			addWord(new SanskritWord("हान", "hāna", "hAna", "n", "Verlassen, Aufgeben, Befreiung von", "Das Aufhören", null, Arrays.asList()));
			addWord(new SanskritWord("हिंसा", "hiṃsā", "hiMsA", "f", "Schädigung, Leid zufügen", null, null, Arrays.asList()));
			addWord(new SanskritWord("हृदय", "hṛdaya", "hRdaya", "n", "Herz", "Inneres", null, Arrays.asList()));
			addWord(new SanskritWord("हेय", "heya", "heya", "adj", "lassen", "meiden", null, Arrays.asList()));
			addWord(new SanskritWord("ह्लाद", "hlāda", "hlAda", "m", "Erfrischung, Erquickung", null, null, Arrays.asList()));
			addWord(new SanskritWord("हेतु", "hetu", "hetu", null, "Veranlassung, Mittel, Ursache", null, null, Arrays.asList()));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.m, "a", "aḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.m, "a", "am"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.m, "a", "ena"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.m, "a", "eṇa"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.m, "a", "āya"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.m, "a", "āt"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.m, "a", "asya"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.m, "a", "e"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.m, "a", "a"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.m, "a", "au"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.m, "a", "au"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.m, "a", "ābhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.m, "a", "ābhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.m, "a", "ābhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.m, "a", "ayoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.m, "a", "ayoḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.m, "a", "au"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.m, "a", "āḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.m, "a", "ān"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.m, "a", "aiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.m, "a", "ebhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.m, "a", "ebhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.m, "a", "ānām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.m, "a", "āṇām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.m, "a", "eṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.m, "a", "āḥ"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.f, "a", "ā"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.f, "a", "ām"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.f, "a", "ayā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.f, "a", "āyai"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.f, "a", "āyāḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.f, "a", "āyāḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.f, "a", "āyām"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.f, "a", "e"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.f, "a", "e"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.f, "a", "e"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.f, "a", "ābhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.f, "a", "ābhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.f, "a", "ābhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.f, "a", "ayoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.f, "a", "ayoḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.f, "a", "e"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.f, "a", "āḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.f, "a", "āḥ"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.f, "a", "ābhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.f, "a", "abhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.f, "a", "abhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.f, "a", "ānām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.f, "a", "āsu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.f, "a", "āḥ"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.n, "a", "am"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.n, "a", "am"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.n, "a", "ena"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.n, "a", "āya"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.n, "a", "āt"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.n, "a", "asya"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.n, "a", "e"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.n, "a", "a"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.n, "a", "e"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.n, "a", "e"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.n, "a", "ābhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.n, "a", "ābhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.n, "a", "ābhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.n, "a", "ayoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.n, "a", "ayoḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.n, "a", "e"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.n, "a", "āni"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.n, "a", "āni"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.n, "a", "aiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.n, "a", "ebhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.n, "a", "ebhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.n, "a", "ānām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.n, "a", "āṇām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.n, "a", "eṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.n, "a", "āni"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.m, "ta", "saḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.m, "ta", "tam"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.m, "ta", "tena"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.m, "ta", "tasmai"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.m, "ta", "tasmāt"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.m, "ta", "tasya"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.m, "ta", "tasmin"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.m, "ta", "tau"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.m, "ta", "tau"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.m, "ta", "tābhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.m, "ta", "tābhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.m, "ta", "tābhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.m, "ta", "tayoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.m, "ta", "tayoḥ"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.m, "ta", "te"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.m, "ta", "tān"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.m, "ta", "taiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.m, "ta", "tebhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.m, "ta", "tebhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.m, "ta", "teṣām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.m, "ta", "teṣu"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.f, "ta", "sā"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.f, "ta", "tām"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.f, "ta", "tayā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.f, "ta", "tasyai"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.f, "ta", "tasyāḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.f, "ta", "tasyāḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.f, "ta", "tasyām"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.f, "ta", "te"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.f, "ta", "te"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.f, "ta", "tābhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.f, "ta", "tābhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.f, "ta", "tābhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.f, "ta", "tayoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.f, "ta", "tayoḥ"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.f, "ta", "tāḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.f, "ta", "tāḥ"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.f, "ta", "tābhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.f, "ta", "tābhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.f, "ta", "tābhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.f, "ta", "tāsām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.f, "ta", "tāsu"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.n, "ta", "tat"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.n, "ta", "tat"));
			declension.add(new LanguageEntry(null, null, Gender.n, "ta", "tat"));// Attributives Adverb
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.n, "ta", "tena"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.n, "ta", "tasmai"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.n, "ta", "tasmāt"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.n, "ta", "tasya"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.n, "ta", "tasmin"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.n, "ta", "te"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.n, "ta", "te"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.n, "ta", "tābhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.n, "ta", "tābhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.n, "ta", "tābhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.n, "ta", "tayoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.n, "ta", "tayoḥ"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.n, "ta", "tāni"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.n, "ta", "tāni"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.n, "ta", "taiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.n, "ta", "tebhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.n, "ta", "tebhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.n, "ta", "teṣām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.n, "ta", "teṣu"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.f, "ā", "ā"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.f, "ā", "ām"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.f, "ā", "ayā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.f, "ā", "āyai"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.f, "ā", "āyāḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.f, "ā", "āyāḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.f, "ā", "āyām"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.f, "ā", "e"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.f, "ā", "e"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.f, "ā", "e"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.f, "ā", "ābhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.f, "ā", "ābhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.f, "ā", "ābhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.f, "ā", "ayoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.f, "ā", "ayoḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.f, "ā", "e"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.f, "ā", "āḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.f, "ā", "āḥ"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.f, "ā", "ābhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.f, "ā", "abhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.f, "ā", "abhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.f, "ā", "ānām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.f, "ā", "āsu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.f, "ā", "āḥ"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.m, "i", "iḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.m, "i", "im"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.m, "i", "inā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.m, "i", "aye"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.m, "i", "eḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.m, "i", "eḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.m, "i", "au"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.m, "i", "e"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.m, "i", "ī"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.m, "i", "ī"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.m, "i", "ibhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.m, "i", "ibhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.m, "i", "ibhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.m, "i", "oḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.m, "i", "oḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.m, "i", "ī"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.m, "i", "ayaḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.m, "i", "īn"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.m, "i", "ibhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.m, "i", "ibhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.m, "i", "ibhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.m, "i", "īnām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.m, "i", "iṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.m, "i", "ayaḥ"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.f, "i", "iḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.f, "i", "im"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.f, "i", "yā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.f, "i", "yai"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.f, "i", "yaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.f, "i", "yaḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.f, "i", "yām"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.f, "i", "e"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.f, "i", "ī"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.f, "i", "ī"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.f, "i", "ibhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.f, "i", "ibhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.f, "i", "ibhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.f, "i", "yoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.f, "i", "yoḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.f, "i", "ī"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.f, "i", "ayaḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.f, "i", "īḥ"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.f, "i", "ibhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.f, "i", "ibhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.f, "i", "ibhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.f, "i", "īnām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.f, "i", "iṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.f, "i", "ayaḥ"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.n, "i", "i"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.n, "i", "i"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.n, "i", "inā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.n, "i", "ine"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.n, "i", "inaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.n, "i", "inaḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.n, "i", "ini"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.n, "i", "i"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.n, "i", "inī"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.n, "i", "inī"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.n, "i", "ibhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.n, "i", "ibhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.n, "i", "ibhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.n, "i", "inoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.n, "i", "inoḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.n, "i", "inī"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.n, "i", "īni"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.n, "i", "īni"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.n, "i", "ibhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.n, "i", "ibhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.n, "i", "ibhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.n, "i", "īnām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.n, "i", "iṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.n, "i", "īni"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.m, "in", "ī"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.m, "in", "inam"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.m, "in", "inā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.m, "in", "ine"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.m, "in", "inaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.m, "in", "inaḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.m, "in", "ini"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.m, "in", "in"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.m, "in", "inau"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.m, "in", "inau"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.m, "in", "ibhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.m, "in", "ibhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.m, "in", "ibhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.m, "in", "inoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.m, "in", "inoḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.m, "in", "inau"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.m, "in", "inaḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.m, "in", "inaḥ"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.m, "in", "ibhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.m, "in", "ibhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.m, "in", "ibhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.m, "in", "inām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.m, "in", "iṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.m, "in", "inaḥ"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.n, "in", "i"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.n, "in", "i"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.n, "in", "inā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.n, "in", "ine"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.n, "in", "inaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.n, "in", "inaḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.n, "in", "ini"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.n, "in", "i"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.n, "in", "inī"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.n, "in", "inī"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.n, "in", "ibhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.n, "in", "ibhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.n, "in", "ibhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.n, "in", "inoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.n, "in", "inoḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.n, "in", "inī"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.n, "in", "īni"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.n, "in", "īni"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.n, "in", "ibhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.n, "in", "ibhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.n, "in", "ibhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.n, "in", "inām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.n, "in", "iṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.n, "in", "īni"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.m, "u", "uḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.m, "u", "um"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.m, "u", "unā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.m, "u", "ave"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.m, "u", "oḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.m, "u", "oḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.m, "u", "au"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.m, "u", "o"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.m, "u", "ū"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.m, "u", "ū"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.m, "u", "ubhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.m, "u", "ubhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.m, "u", "ubhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.m, "u", "voḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.m, "u", "voḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.m, "u", "ū"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.m, "u", "avaḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.m, "u", "ūn"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.m, "u", "ubhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.m, "u", "ubhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.m, "u", "ubhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.m, "u", "ūnām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.m, "u", "uṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.m, "u", "avaḥ"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.f, "u", "uḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.f, "u", "um"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.f, "u", "vā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.f, "u", "vai"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.f, "u", "vāḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.f, "u", "vāḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.f, "u", "vām"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.f, "u", "o"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.f, "u", "ū"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.f, "u", "ū"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.f, "u", "ubhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.f, "u", "ubhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.f, "u", "ubhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.f, "u", "voḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.f, "u", "voḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.f, "u", "ū"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.f, "u", "avaḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.f, "u", "ūḥ"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.f, "u", "ubhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.f, "u", "ubhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.f, "u", "ubhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.f, "u", "ūnām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.f, "u", "uṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.f, "u", "avaḥ"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.n, "u", "u"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.n, "u", "u"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.n, "u", "unā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.n, "u", "une"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.n, "u", "unaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.n, "u", "unaḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.n, "u", "uni"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.n, "u", "u"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.n, "u", "unī"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.n, "u", "unī"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.n, "u", "ubhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.n, "u", "ubhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.n, "u", "ubhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.n, "u", "unoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.n, "u", "unoḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.n, "u", "unī"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.n, "u", "ūni"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.n, "u", "ūni"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.n, "u", "ubhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.n, "u", "ubhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.n, "u", "ubhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.n, "u", "ūnām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.n, "u", "uṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.n, "u", "ūni"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.m, "ṛ", "ā"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.m, "ṛ", "āram"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.m, "ṛ", "rā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.m, "ṛ", "re"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.m, "ṛ", "uḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.m, "ṛ", "uḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.m, "ṛ", "ari"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.m, "ṛ", "ar"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.m, "ṛ", "ārau"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.m, "ṛ", "ārau"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.m, "ṛ", "ṛbhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.m, "ṛ", "ṛbhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.m, "ṛ", "ṛbhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.m, "ṛ", "roḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.m, "ṛ", "roḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.m, "ṛ", "ārau"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.m, "ṛ", "āraḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.m, "ṛ", "ṝn"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.m, "ṛ", "ṛbhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.m, "ṛ", "ṛbhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.m, "ṛ", "ṛbhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.m, "ṛ", "ṝṇām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.m, "ṛ", "ṛṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.m, "ṛ", "āraḥ"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.f, "ṛ", "ā"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.f, "ṛ", "āram"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.f, "ṛ", "rā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.f, "ṛ", "re"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.f, "ṛ", "uḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.f, "ṛ", "uḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.f, "ṛ", "ari"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.f, "ṛ", "ar"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.f, "ṛ", "ārau"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.f, "ṛ", "ārau"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.f, "ṛ", "ṛbhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.f, "ṛ", "ṛbhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.f, "ṛ", "ṛbhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.f, "ṛ", "roḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.f, "ṛ", "roḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.f, "ṛ", "ārau"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.f, "ṛ", "āraḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.f, "ṛ", "ṝn"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.f, "ṛ", "ṛbhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.f, "ṛ", "ṛbhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.f, "ṛ", "ṛbhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.f, "ṛ", "ṝṇām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.f, "ṛ", "ṛṣu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.f, "ṛ", "āraḥ"));

			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.SINGULAR, Gender.n, "as", "aḥ"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.SINGULAR, Gender.n, "as", "aḥ"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.SINGULAR, Gender.n, "as", "asā"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.SINGULAR, Gender.n, "as", "ase"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.SINGULAR, Gender.n, "as", "asaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.SINGULAR, Gender.n, "as", "asaḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.SINGULAR, Gender.n, "as", "asi"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.SINGULAR, Gender.n, "as", "aḥ"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.DUAL, Gender.n, "as", "asī"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.DUAL, Gender.n, "as", "asī"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.DUAL, Gender.n, "as", "obhyām"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.DUAL, Gender.n, "as", "obhyām"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.DUAL, Gender.n, "as", "obhyām"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.DUAL, Gender.n, "as", "asoḥ"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.DUAL, Gender.n, "as", "asoḥ"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.DUAL, Gender.n, "as", "asī"));
			declension.add(new LanguageEntry(Case.NOMINATIVE, Number.PLURAL, Gender.n, "as", "āṃsi"));
			declension.add(new LanguageEntry(Case.ACCUSATIVE, Number.PLURAL, Gender.n, "as", "āṃsi"));
			declension.add(new LanguageEntry(Case.INSTRUMENTAL, Number.PLURAL, Gender.n, "as", "obhiḥ"));
			declension.add(new LanguageEntry(Case.DATIVE, Number.PLURAL, Gender.n, "as", "obhyaḥ"));
			declension.add(new LanguageEntry(Case.ABLATIVE, Number.PLURAL, Gender.n, "as", "obhyaḥ"));
			declension.add(new LanguageEntry(Case.GENITIVE, Number.PLURAL, Gender.n, "as", "asām"));
			declension.add(new LanguageEntry(Case.LOCATIVE, Number.PLURAL, Gender.n, "as", "aḥsu"));
			declension.add(new LanguageEntry(Case.VOCATIVE, Number.PLURAL, Gender.n, "as", "āṃsi"));
		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}

	private void addWord(SanskritWord word) throws Exception {
		words.add(word);
		unicodeWord.put(word.getUnicode(), word);
	}

	public SanskritWord getWordForUnicode(String unicodeTransliteration, String errorHint, boolean throwExceptionIfNotFound) throws Exception {
		if (!unicodeWord.containsKey(unicodeTransliteration)) {
			if (throwExceptionIfNotFound) {
				throw new IllegalStateException("Word not found: " + unicodeTransliteration + " : " + errorHint);
			} else {
				return null;
			}
		} else {
			return unicodeWord.get(unicodeTransliteration);
		}
	}

	/**
	 * The words of the dictionary are returned. Do not change them unintentionally.
	 */
	public void getWordsForUnicode(Collection<String> unicodeTransliterations, String errorHint, boolean includingSubwords, List<SanskritWord> result,
			Set<String> alreadyUsedUnicode, boolean throwExceptionIfNotFound) throws Exception {
		for (String unicode : unicodeTransliterations) {
			if (!alreadyUsedUnicode.contains(unicode)) {
				SanskritWord word = getWordForUnicode(unicode, errorHint, throwExceptionIfNotFound);
				if (word != null) {
					alreadyUsedUnicode.add(unicode);
					if (includingSubwords) {
						getWordsForUnicode(word.getUnicodeSubwords(), errorHint, includingSubwords, result, alreadyUsedUnicode, false);
					}
					result.add(word);
				}
			}
		}

	}

	public List<String> analysis(Pair<String, String> wordAndInflection) throws Exception {
		ArrayList<String> result = new ArrayList<String>();
		for (LanguageEntry entry : getDeclension(wordAndInflection.getLeft())) {
			if (wordAndInflection.getRight().endsWith(entry.getEnding().toString())) {
				result.add("" + entry.getCase() + " " + entry.getNumber() + " " + entry.getGender());
			}
		}

		return result;
	}

	private List<LanguageEntry> getDeclension(String unicode) throws Exception {
		// SanskritWord word = getWordForUnicode(unicode, null, true);

		ArrayList<LanguageEntry> result = new ArrayList<LanguageEntry>();
		int groupIdentifierLength = 0;

		for (LanguageEntry entry : declension) {
			String groupEnding = entry.getGroupIdentifier();
			if (unicode.endsWith(groupEnding)) {
				// use only best fitting groups
				if (groupEnding.length() > groupIdentifierLength) {
					result.clear();
					groupIdentifierLength = groupEnding.length();
				}

				result.add(entry);
			}
		}

		return result;
	}

}
