package net.sf.gluebooster.demos.pojo.languages.sanskrit;

import java.util.List;

import net.sf.gluebooster.demos.pojo.languages.LanguageEntry;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class SanskritWord extends LanguageEntry {

	private static final String KEY_DEVANAGARI = "devanagari";
	private static final String KEY_UNICODE = "unicode";
	private static final String KEY_HARVARD_KYOTO = "harvardKyoto";

	/**
	 * Basic meaning (Word by word) (german translation)
	 */
	private static final String KEY_GERMAN_BASIC = "germanBasic";

	/**
	 * Extended meaning (german translation)
	 */
	private static final String KEY_GERMAN_EXTENDED = "germanExtended";

	private static final String KEY_GERMAN_COMMENT = "germanComment";

	private static final String KEY_SUBWORDS_UNICODE = "subwords unicode";

	public SanskritWord(String devanagari, String unicode, String harvardKyoto, String type, String germanBasic, String germanExtended, String germanComment,
			List/* <String> */ unicodeSubwords) throws Exception {
		super();
		setDevanagari(devanagari);
		setUnicode(unicode);
		setHarvardKyoto(harvardKyoto);
		setType(type);
		setGermanBasic(germanBasic);
		setGermanExtended(germanExtended);
		setGermanComment(germanComment);
		setUnicodeSubwords(unicodeSubwords);
	}

	public String getDevanagari() throws Exception {
		return getAttribute(KEY_DEVANAGARI);
	}

	public void setDevanagari(String devanagari) throws Exception {
		setAttribute(KEY_DEVANAGARI, devanagari);
	}

	public String getUnicode() throws Exception {
		return getAttribute(KEY_UNICODE);
	}

	public void setUnicode(String unicode) throws Exception {
		setAttribute(KEY_UNICODE, unicode);
	}

	public String getHarvardKyoto() throws Exception {
		return getAttribute(KEY_HARVARD_KYOTO);
	}

	public void setHarvardKyoto(String harvardKyoto) throws Exception {
		setAttribute(KEY_HARVARD_KYOTO, harvardKyoto);
	}


	public String getGermanBasic() throws Exception {
		return getAttribute(KEY_GERMAN_BASIC);
	}

	public void setGermanBasic(String germanBasic) throws Exception {
		setAttribute(KEY_GERMAN_BASIC, germanBasic);
	}

	public String getGermanExtended() throws Exception {
		return getAttribute(KEY_GERMAN_EXTENDED);
	}

	public void setGermanExtended(String germanExtended) throws Exception {
		setAttribute(KEY_GERMAN_EXTENDED, germanExtended);
	}

	public String getGermanComment() {
		return getAttribute(KEY_GERMAN_COMMENT);
	}

	public void setGermanComment(String germanComment) throws Exception {
		setAttribute(KEY_GERMAN_COMMENT, germanComment);
	}

	public List<String> getUnicodeSubwords() {
		return getAttribute(KEY_SUBWORDS_UNICODE);
	}

	public void setUnicodeSubwords(List<String> unicodeSubwords) throws Exception {
		setAttribute(KEY_SUBWORDS_UNICODE, unicodeSubwords);
	}

	@Override
	public String toString() {

		try {
			return "" + getUnicode() + " " + getDevanagari();
		} catch (Exception e) {
			throw ThrowableBoostUtils.toRuntimeException(e);
		}
	}

}
