package net.sf.gluebooster.demos.pojo.languages.sanskrit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;

import net.sf.gluebooster.demos.pojo.languages.LanguageEntry;
import net.sf.gluebooster.java.booster.essentials.utils.TextBoostUtils;

public class YogaSutras {


	private List<Sutra> samadhiPada = new ArrayList();
	private List<Sutra> sadhanaPada = new ArrayList();
	private List<Sutra> vibhutiPada = new ArrayList();
	private List<Sutra> kaivalyaPada = new ArrayList();

	public YogaSutras() {


		Sutra sutra;

		// --------------------------------------------
		sutra = new Sutra("समाधिपाद", "", "samādhipāda", "", "samādhi pāda", "");

		sutra.addInflectedWord("samādhi", "samādhi");
		sutra.addInflectedWord("pāda", "pāda");

		sutra.setSyntaxTranslationDE("Bewußtseinszustand-Kapitel");
		sutra.setSemanticTranslationDE("Erstes Kapitel: Bewußtseinszustände");

		samadhiPada.add(sutra);


		// --------------------------------------------

		sutra = new Sutra("अथ योगानुशासनम्", "", "atha yogānuśāsanam", "", "atha yoga-anuśāsanam", "");

		sutra.addInflectedWord("yoga", "yoga");
		sutra.addInflectedWord("anuśāsana", "anuśāsanam");
		sutra.addInflectedWord("atha", "atha");

		sutra.setSyntaxTranslationDE("Jetzt eine Yogabelehrung.");
		sutra.setSemanticTranslationDE("Es folgen Instruktionen im Yoga.");
		sutra.setCommentContentDE("Die Einleitung für die restlichen Sutras des Kapitels.");
		sutra.setCommentStructureDE(
				"Mit diesem Sutra wird klar gestellt, '''worum''' es geht, um  Yoga; im nächsten wird die Frage beantwortet, '''was''' Yoga ist. ");

		sutra.addUsedTerm("yoga");
		samadhiPada.add(sutra);


		// --------------------------------------------
		sutra = new Sutra("योगश्चित्तवृत्तिनिरोधः", "", "yogaścittavṛttinirodhaḥ", "", "yogaḥ cittavṛtti-nirodhaḥ", "");

		sutra.addInflectedWord("yoga", "yogaḥ");
		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("vṛtti", "vṛtti");
		sutra.addInflectedWord("nirodha", "nirodhaḥ");
		sutra.addInflectedWord("cittavṛtti", "cittavṛtti");

		sutra.setSyntaxTranslationDE("Yoga, die Denktätigkeitshemmung.");
		sutra.setSemanticTranslationDE("Yoga ist die Hemmung der eigenen Gedanken.");
		sutra.setCommentContentDE(
				"Die Übersetzung des Wortes nirodha ist die schwierigste. Die aktive Bedeutung 'Kontrolle/Beherrschung' scheint im Rahmen der letzten Sutras des Kapitels nicht zu passen. Die 'Vernichtung' passt wiederum nicht zu Sutra 12. Die Übersetzung 'Hemmung' liegt zwischen diesen beiden Extremen und macht an beiden Stellen Sinn.");
		sutra.setCommentStructureDE(
				"Hiermit ist Yoga definiert. Selbst wenn man den Rest des Kapitels nicht mehr liest, bzw. wenn ein Erzähler den Rest vergessen hat, hat man mit diesem Sutra bereits die Essenz des Buches erfahren. Mit diesem Sutra beginnt der große Bogen des ersten Kapitels. Erst wird das Ziel von Yoga vorgestellt, dann kommen die Instruktionen wie es zu erreichen ist. Im letzten Sutra werden die Leitwörter nirodha und samadhi (aus der Kapitelüberschrift) wieder aufgegriffen und so umformuliert, dass man (endlich) am Ziel angekommen ist. ");

		sutra.addDefinedTerm("yoga");

		sutra.addUsedTerm("(citta)vṛtti");
		sutra.addUsedTerm("nirodha");
		samadhiPada.add(sutra);


		// 3
		sutra = new Sutra("तदा द्रष्टुः स्वरूपेऽवस्थानम्", "", "tadā draṣṭuḥ svarūpe'vasthānam", "", "tadā draṣṭuḥ svarūpe avasthānam", "");

		sutra.addInflectedWord("draṣṭṛ", "draṣṭuḥ");
		sutra.addInflectedWord("svarūpa", "svarūpe");
		sutra.addInflectedWord("avasthāna", "avasthānam");
		sutra.addInflectedWord("tadā", "tadā");

		sutra.setSyntaxTranslationDE("Dann ist des Sehenden Befinden in der eigenen Form.");
		sutra.setSemanticTranslationDE("Dann befindet sich der Wahrnehmende in der Realität.");
		sutra.setCommentContentDE(
				"Erst dann ist man also in der Wirklichkeit angekommen. Vorher nimmt man die Dinge und sich selbst zwar wahr, ist aber noch nicht bis zum eigentlichen Kern vorgedrungen.");
		sutra.setCommentStructureDE(
				"Die Sutren 2 bis 4 bilden eine Einheit. In Sutra 2 wird definiert, '''was''' für ein Bewusstseinszustand im Yoga vorliegt, hier erfolgt die Begründung '''warum''' der Zustand anzustreben ist, im nächsten Sutra wird erläutert, was '''ansonsten''' in einem vorgeht. ");
		samadhiPada.add(sutra);


		// 4
		sutra = new Sutra("वृत्तिसारूप्यमितरत्र", "", "vṛttisārūpyamitaratra", "", "vṛtti-sārūpyam itaratra", "");

		sutra.addInflectedWord("vṛtti", "vṛtti");
		sutra.addInflectedWord("sārūpya", "sārūpyam");
		sutra.addInflectedWord("itaratra", "itaratra");

		sutra.setSyntaxTranslationDE("Sonst eine  vṛtti-Verwechslung.");
		sutra.setSemanticTranslationDE("Sonst liegt eine Verwechslung mit den vṛtti vor.");
		sutra.setCommentContentDE(
				"Andernfalls gibt es (nur) eine Identifikation (des Sehers) mit den vṛttis, den Gedankentätigkeiten. Man leidet also unter einer 'Wahrnehmungsstörung' und verwechselt die Realität mit den eigenen Gedanken darüber.");
		sutra.setCommentStructureDE(
				"Nachdem der Begriff vṛtti mehrmals aufgetaucht ist, hier noch mal zu Beginn des Sutra, geht es ab dem nächsten Sutra mit der Erklärung dieses Begriffes weiter. Zum leichteren Auswendiglernen beginnt auch das folgende Sutra ebenfalls mit diesem Wort.  ");

		sutra.addUsedTerm("vṛtti");
		samadhiPada.add(sutra);

		// 5
		sutra = new Sutra("वृत्तयः पञ्चतय्यः क्लिष्टाक्लिष्टाः", "", "vṛttayaḥ pañcatayyaḥ kliṣṭākliṣṭāḥ", "", "vṛttayaḥ pañcatayyaḥ kliṣṭa-akliṣṭāḥ", "");

		sutra.addInflectedWord("vṛtti", "vṛttayaḥ");
		sutra.addInflectedWord("pañcataya", "pañcatayyaḥ");
		sutra.addInflectedWord("kliṣṭa", "kliṣṭa");
		sutra.addInflectedWord("akliṣṭa", "akliṣṭāḥ");
		sutra.addInflectedWord("pañcataya", "pañcataya");

		sutra.setSyntaxTranslationDE("(Denk-)Tätigkeiten sind fünfteilig, mit Leid verbunden(oder) nicht mit Leid verbunden.");
		sutra.setSemanticTranslationDE("Es gibt fünf Arten (von Gedanken). Jeweils entweder schmerzhaft oder nicht.");
		sutra.setCommentContentDE(
				"Der unspezifische Begriff eines Gedanken/einer Denktätigkeit wird genauer unterteilt.  Die für das eigene, subjektive Empfinden wichtige Unterscheidung in schmerzliche und freudige Gedanken liegt jedoch außerhalb dieser Kategorisierung. Gedanken jeder Kategorie können schmerzhaft oder freudig sein.");
		sutra.setCommentStructureDE(
				"In den nächsten 6 Sutras werden die Arten aufgezählt und pro Sutra wird eine davon beschrieben. Die Sutras 5 bis 11 bilden somit den nächsten zusammengehörigen Abschnitt.  Didaktisch ist es auch geschickt, die Anzahl an vṛttis explizit zu erwähnen. Dadurch muss man auf die Frage, wieviele es gibt, nicht erst überlegen und durchzählen, sondern kann direkt dieses Sutra zitieren.  Ob es wohl Absicht war, im fünften Sutra die Zahl fünf vorkommen zu lassen?  ");

		sutra.addDefinedTerm("vṛtti");

		samadhiPada.add(sutra);

		// 6
		sutra = new Sutra("प्रमाणविपर्ययविकल्पनिद्रास्मृतयः", "", "pramāṇaviparyayavikalpanidrāsmṛtayaḥ", "", "pramāṇa-viparyaya-vikalpa-nidrā-smṛtayaḥ", "");

		sutra.addInflectedWord("pramāṇa", "pramāṇa");
		sutra.addInflectedWord("viparyaya", "viparyaya");
		sutra.addInflectedWord("vikalpa", "vikalpa");
		sutra.addInflectedWord("nidrā", "nidrā");
		sutra.addInflectedWord("smṛti", "smṛtayaḥ");

		sutra.setSyntaxTranslationDE("Mittel zu richtigem Wissen, falsche Auffassung, Vorstellung, Schlaf (und) Erinnerung.");
		sutra.setSemanticTranslationDE(
				"Es sind Denktätigkeiten, die zu richtigem Wissen führen oder zu falschen Auffassungen, zu Vorstellungen, Schlaf oder Erinnerung.");
		sutra.setCommentContentDE("Eine sehr differenzierte Unterscheidung.");
		sutra.setCommentStructureDE(
				"Aufzählung der fünf vṛtti. Durch dieses Sutra lernt man die ganze Aufzählung am Stück und kann sie somit bei Bedarf - ohne zu überlegen - wiedergeben.  In jedem der folgenden Sutras wird ein Begriff dieser Aufzählung erläutert.  ");

		sutra.addUsedTerm("pramāṇa");
		sutra.addUsedTerm("viparyaya");
		sutra.addUsedTerm("vikalpa");
		sutra.addUsedTerm("nidrā");
		sutra.addUsedTerm("smṛti");
		samadhiPada.add(sutra);

		// 7
		sutra = new Sutra("प्रत्यक्षानुमानागमाः प्रमाणानि", "", "pratyakṣānumānāgamāḥ pramāṇāni", "", "pratyakṣa-anumāna-āgamāḥ pramāṇāni", "");

		sutra.addInflectedWord("pratyakṣa", "pratyakṣa");
		sutra.addInflectedWord("anumāna", "anumāna");
		sutra.addInflectedWord("āgama", "āgamāḥ");
		sutra.addInflectedWord("pramāṇa", "pramāṇāni");

		sutra.setSyntaxTranslationDE("Wahrnehmung, Schlußfolgerung (und) überlieferte Lehre (sind) Mittel zu richtiger Erkenntnis.");
		sutra.setSemanticTranslationDE("---");
		sutra.setCommentContentDE(
				"Damit sind alle Möglichkeiten genannt, wie man zu richtigen Ergebnissen kommen kann. Man kann sie entweder direkt wahrnehmen, sie mittels Logik aus bekannten Tatsachen erschließen oder ist auf Lehrwerke angewiesen. Die Reihenfolge spiegelt auch den Zuverlässigkeitsgrad wieder. Am zuverlässigsten ist, was sich direkt beobachten läßt. Bei Schlußfolgerungen kann man schon Fehler machen und in Lehrwerken können noch mehr Denkfehler verborgen sein.");
		sutra.setCommentStructureDE("Die drei Begriffe pratyakṣa, anumāna, āgama werden nicht mehr genauer definiert.  ");

		sutra.addDefinedTerm("pramāṇa");
		samadhiPada.add(sutra);

		// 8
		sutra = new Sutra("विपर्ययो मिथ्याज्ञानमतद्रूपप्रतिष्ठम्", "", "viparyayo mithyājñānamatadrūpapratiṣṭham", "",
				"viparyayaḥ mithyā-jñānam atadrūpa-pratiṣṭham", "");

		sutra.addInflectedWord("viparyaya", "viparyayaḥ");
		sutra.addInflectedWord("mithyā", "mithyā");
		sutra.addInflectedWord("jñāna", "jñānam");
		sutra.addInflectedWord("atadrūpa", "atadrūpa");
		sutra.addInflectedWord("pratiṣṭha", "pratiṣṭham");

		sutra.setSyntaxTranslationDE("Falsche Auffassung ist unrichtiges Wissen, nicht der Form nahestehend.");
		sutra.setSemanticTranslationDE("Falsche Auffassung ist unrichtiges Wissen, abweichend vom eigentlichen Tatbestand.");

		sutra.setCommentStructureDE("");

		sutra.addDefinedTerm("viparyaya");
		samadhiPada.add(sutra);

		// 9
		sutra = new Sutra("शब्दज्ञानानुपाती वस्तुशून्यो विकल्पः", "", "śabdajñānānupātī vastuśūnyo vikalpaḥ", "", "śabda-jñāna-anupātī vastu-śūnyaḥ vikalpaḥ",
				"");

		sutra.addInflectedWord("śabda", "śabda");
		sutra.addInflectedWord("jñāna", "jñāna");
		sutra.addInflectedWord("anupātin", "anupātī");
		sutra.addInflectedWord("vastu", "vastu");
		sutra.addInflectedWord("śūnya", "śūnyaḥ");
		sutra.addInflectedWord("vikalpa", "vikalpaḥ");

		sutra.setSyntaxTranslationDE("Eine Wortwissensabfolge, gegenstandslos, ist Vorstellung.");
		sutra.setSemanticTranslationDE(
				"Auf Worten beruhendes Wissen, frei von (konkreten) Dingen ist Vorstellung.<br/> Vorstellungen sind Gedankenspiele ohne Anspruch auf Realität.");
		sutra.setCommentContentDE("Hierunter fallen zum Beispiel Tagträumereien oder 'Was wäre, wenn'-Überlegungen.");
		sutra.setCommentStructureDE(
				"Im Gegensatz zu den beiden vorherigen Begriffen, die sich mit der Realität auseinandersetzen (sei es richtig oder falsch), ist bei der Vorstellung kein Bezug zu realen Situationen mehr nötig.  ");

		sutra.addDefinedTerm("vikalpa");
		samadhiPada.add(sutra);


		// 10
		sutra = new Sutra("अभावप्रत्ययालम्बना तमोवृत्तिर्निद्रा", "अभावप्रत्ययालम्बना वृत्तिर्निद्रा", "abhāvapratyayālambanā tamovṛttirnidrā",
				"abhāvapratyayālambanā vṛttirnidrā", "abhāva-pratyaya-ālambanā tamas-vṛttiḥ nidrā", "");

		sutra.addInflectedWord("abhāva", "abhāva");
		sutra.addInflectedWord("pratyaya", "pratyaya");
		sutra.addInflectedWord("ālambana", "ālambanā");
		sutra.addInflectedWord("tamas", "tamas");
		sutra.addInflectedWord("vṛtti", "vṛttiḥ");
		sutra.addInflectedWord("nidrā", "nidrā");

		sutra.setSyntaxTranslationDE("Wahrnehmungsabwesenheitsbasiert sind die verdunkelten Denktätigkeiten, der Schlaf.");
		sutra.setSemanticTranslationDE(
				"Die Abwesenheit von Wahrnehmungen, nicht sichtbare Gedanken, sind Schlaf. <br/>Die Gedanken beim Schlaf sind nicht wahrnehmbar, sie sind von Tamas-Qualität.");
		sutra.setCommentContentDE(
				"Mit Schlaf sind nicht Träume gemeint, sondern der traumlose Schlaf. Träume dürften mehr in den Bereich der Vorstellung vikalpa fallen. An anderer Stelle wird explizit zwischen Tiefschlaf (nidrā) und Traum (svapna) unterschieden.");
		sutra.setCommentStructureDE("");

		sutra.addDefinedTerm("nidrā");

		sutra.addUsedTerm("pratyaya");
		samadhiPada.add(sutra);

		// 11
		sutra = new Sutra("अनुभूतविषयासंप्रमोषः स्मृतिः", "", "anubhūtaviṣayāsaṃpramoṣaḥ smṛtiḥ", "", "anubhūta-viṣaya-asaṃpramoṣaḥ smṛtiḥ", "");

		sutra.addInflectedWord("anubhūta", "anubhūta");
		sutra.addInflectedWord("viṣaya", "viṣaya");
		sutra.addInflectedWord("asaṃpramoṣa", "asaṃpramoṣaḥ");
		sutra.addInflectedWord("smṛti", "smṛtiḥ");

		sutra.setSyntaxTranslationDE("Ein wahrgenommenes Objekt, nichtvergessen, ist eine Erinnerung.");
		sutra.setSemanticTranslationDE(
				"In der Vergangenheit Wahrgenommenes, das noch nicht völlig verblasst ist, ist Erinnerung. / Erinnerung sind in der Vergangenheit erlebte Dinge, deren Eindrücke noch nicht verblasst sind.");

		sutra.setCommentStructureDE("Damit endet der Abschnitt über die vṛtti und es geht mit dem zweiten neuen Begriff (nirodha) aus Sutra 2 weiter.");

		sutra.addDefinedTerm("smṛti");
		samadhiPada.add(sutra);

		// 12
		sutra = new Sutra("अभ्यासवैराग्याभ्यां तन्निरोधः", "", "abhyāsavairāgyābhyāṃ tannirodhaḥ", "", "abhyāsa-vairāgyābhyām tat-nirodhaḥ", "");

		sutra.addInflectedWord("abhyāsa", "abhyāsa");
		sutra.addInflectedWord("vairāgya", "vairāgyābhyām");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("nirodha", "nirodhaḥ");
		sutra.addInflectedWord("tat", "tat");

		sutra.setSyntaxTranslationDE("Durch Übung und Gleichmut, dann Nirodha.");
		sutra.setSemanticTranslationDE("Übung und Gleichmut bringt die Ruhe/Kontrolle der Gedanken.");
		sutra.setCommentContentDE(
				"Es sind also nicht Übung und Ehrgeiz wie man vielleicht erwarten könnte. Statt Ehrgeiz ist die Gelassenheit wichtig. Der Begriff des Übens verweist aber darauf, dass eine gewisse Anstrengung und Intensität nötig sind.");
		sutra.setCommentStructureDE(
				"Nachdem die 'vṛttis' behandelt wurden, geht es ab jetzt um den zweiten Begriff 'nirodha' aus [[Yogasutra-Analyse/ Samadhi Pada/ Sutra 2");

		sutra.addDefinedTerm("nirodha");

		sutra.addUsedTerm("abhyāsa");
		sutra.addUsedTerm("vairāgya");
		samadhiPada.add(sutra);

		// 13
		sutra = new Sutra("तत्र स्थितौ यत्नोऽभ्यासः", "", "tatra sthitau yatno'bhyāsaḥ", "", "tatra sthitau yatnaḥ abhyāsaḥ", "");

		sutra.addInflectedWord("sthiti", "sthitau");
		sutra.addInflectedWord("yatna", "yatnaḥ");
		sutra.addInflectedWord("abhyāsa", "abhyāsaḥ");
		sutra.addInflectedWord("tatra", "tatra");

		sutra.setSyntaxTranslationDE("Dort wo die Bemühung in der Beständigkeit ist, ist Übung.");
		sutra.setSemanticTranslationDE("Übung entsteht aus beständigen Bemühungen.");

		sutra.setCommentStructureDE("Hier erfolgt die Definition von abhyāsa. Im nächsten Sutra wird erläutert, wie abhyāsa erreicht werden kann.  ");

		sutra.addDefinedTerm("abhyāsa");
		samadhiPada.add(sutra);

		// 14
		sutra = new Sutra("स तु दीर्घकालनैरन्तर्यसत्कारादरासेवितोदृढभूमिः", "स तु दीर्घकालनैरन्तर्यसत्कारासेवितोदृढभूमिः",
				"saḥ tu dīrghakālanairantaryasatkārādarāsevitodṛḍhabhūmiḥ", "sa tu dīrghakālanairantaryasatkārāsevitodṛḍhabhūmiḥ",
				"saḥ tu dīrgha-kāla-nairantarya-satkāra-ādara-āsevitaḥ dṛḍha-bhūmiḥ", "");

		sutra.addInflectedWord("ta", "saḥ");
		sutra.addInflectedWord("tu", "tu");
		sutra.addInflectedWord("dīrgha", "dīrgha");
		sutra.addInflectedWord("kāla", "kāla");
		sutra.addInflectedWord("nairantarya", "nairantarya");
		sutra.addInflectedWord("satkāra", "satkāra");
		sutra.addInflectedWord("ādara", "ādara");
		sutra.addInflectedWord("āsevita", "āsevitaḥ");
		sutra.addInflectedWord("dṛḍha", "dṛḍha");
		sutra.addInflectedWord("bhūmi", "bhūmiḥ");
		sutra.addInflectedWord("tad", "tad");

		sutra.setSyntaxTranslationDE("Dies nun - lange Zeit, ununterbrochen, achtsam und sorgfältig angehäuft - ist eine feste Basis.");
		sutra.setSemanticTranslationDE("Nach langer Zeit ununterbrochener, achtsamer und sorgfältiger Wiederholungen bildet sich ein festes Fundament.");

		samadhiPada.add(sutra);

		// 15

		sutra = new Sutra("दृष्टानुश्रविकविषयवितृष्णस्य वशीकारसंज्ञा वैराग्यम्", "दृष्टानुश्रविकविषयवितृष्णस्य वशीकारसंज्णा वैराग्यम्",
				"dṛṣṭānuśravikaviṣayavitṛṣṇasya vaśīkārasaṃjñā vairāgyam", "dṛṣṭānuśravikaviṣayavitṛṣṇasya vaśīkārasaṃjṇā vairāgyam",
				"dṛṣṭa-ānuśravika-viṣaya-vitṛṣṇasya vaśīkāra-saṃjñā vairāgyam", "");

		sutra.addInflectedWord("dṛṣṭa", "dṛṣṭa");
		sutra.addInflectedWord("ānuśravika", "ānuśravika");
		sutra.addInflectedWord("viṣaya", "viṣaya");
		sutra.addInflectedWord("vitṛṣṇa", "vitṛṣṇasya");
		sutra.addInflectedWord("vaśīkāra", "vaśīkāra");
		sutra.addInflectedWord("saṃjñā", "saṃjñā");
		sutra.addInflectedWord("vairāgya", "vairāgyam");

		sutra.setSyntaxTranslationDE("Kontrollbewußtsein der Durstlosigkeit nach einem gesehenen, gehörten Ding, ist Gleichmut.");
		sutra.setSemanticTranslationDE("Gleichmut ist, sein Bewusstsein so zu kontrollien, dass es nicht nach weiteren Dingen verlangt.");
		sutra.setCommentContentDE("Gleichmut ist, wenn man mit dem zufrieden ist, was man hat (wo man steht) und nicht immer mehr will.");
		sutra.setCommentStructureDE("Nach der Definition von vairāgya wird im nächsten Sutra die höchste erreichbare Stufe angegeben. }}  ");

		sutra.addDefinedTerm("vairāgya");
		samadhiPada.add(sutra);

		// 16
		sutra = new Sutra("तत्परं पुरुषख्यातेः गुणवैतृष्ण्यम्", "", "tatparaṃ puruṣakhyāteḥ guṇavaitṛṣṇyam", "", "tat param puruṣa-khyāteḥ guṇa-vaitṛṣṇyam",
				"");

		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("para", "param");
		sutra.addInflectedWord("puruṣa", "puruṣa");
		sutra.addInflectedWord("khyāti", "khyāteḥ");
		sutra.addInflectedWord("guṇa", "guṇa");
		sutra.addInflectedWord("vaitṛṣṇya", "vaitṛṣṇyam");

		sutra.setSyntaxTranslationDE("Das höchste der Seelenerkenntnis ist die Guna-Durstlosigkeit.");
		sutra.setSemanticTranslationDE(
				"Die höchste Stufe der Erkenntnis der Seele ist erreicht, wenn völlige Begierdelosigkeit (nach beliebigen Eigenschaften) herrscht.");
		sutra.setCommentContentDE(
				"Dies ist noch einmal eine Steigerung zum vorherigen Sutra, bei dem es noch um konkrete Dinge, die man sieht oder von denen man hört, ging. Damit ist auch erläutert wohin vairāgya führen soll, so dass man nicht zu früh sagen kann, dass man es gemeistert hat.");
		sutra.setCommentStructureDE("Hiermit endet der in  Sutra 12 begonnen Abschnitt über 'abhyāsa' und 'vairāgya'.");
		samadhiPada.add(sutra);

		// 17
		sutra = new Sutra("वितर्कविचारानन्दास्मितारुपानुगमात् संप्रज्ञातः", "वितर्कविचारानन्दास्मितारुपानुगमात्संप्रज्ञातः",
				"vitarkavicārānandāsmitārūpānugamāt saṃprajñātaḥ", "", "vitarka-vicāra-ānanda-asmitā-rūpa-anugamāt saṃprajñātaḥ", "");

		sutra.addInflectedWord("vitarka", "vitarka");
		sutra.addInflectedWord("vicāra", "vicāra");
		sutra.addInflectedWord("ānanda", "ānanda");
		sutra.addInflectedWord("asmitā", "asmitā");
		sutra.addInflectedWord("rūpa", "rūpa");
		sutra.addInflectedWord("anugama", "anugamāt");
		sutra.addInflectedWord("saṃprajñāta", "saṃprajñātaḥ");

		sutra.setSyntaxTranslationDE("Vermutung, Untersuchung, Wonne, Ich-bin-diese Form, durch diese Abfolge entsteht Saṃprajñāta.");
		sutra.setSemanticTranslationDE(
				"Die Stufen zu Saṃprajñāta - der ersten Stufe des Samadhi - sind Vermutung, gründliche Untersuchung, Seligkeit und ein Bewusstsein des höheren Selbst.");
		sutra.setCommentContentDE(
				"Saṃprajñāta - 'vollkommenes Erkennen' ist die erste Stufe des Samadhi. Auf der Ebene von vitarka gibt es noch die Unterscheidung in savitarka und nirvitarka, bei vicāra gibt es savicāra und nirvicāra.");
		sutra.setCommentStructureDE(
				"Hier und im nächsten Sutra wird werden die beiden Stufen des Samadhi (saṃprajñāta und asaṃprajñāta) angesprochen die in den restlichen Sutras des Kapitels dann genauer erläutert werden. Ab Sutra 42 werden die verschiedenen Samdhi-Arten sa/nir-vitarka und sa/nir-vicara explizit erwähnt. ");

		sutra.addDefinedTerm("Saṃprajñāta");
		samadhiPada.add(sutra);

		// 18
		sutra = new Sutra("विरामप्रत्ययाभ्यासपूर्वः संस्कारशेषोऽन्यः", "", "virāmapratyayābhyāsapūrvaḥ saṃskāraśeṣo'nyaḥ", "",
				"virāma-pratyaya-abhyāsa-pūrvaḥ saṃskāra-śeṣaḥ anyaḥ", "");

		sutra.addInflectedWord("virāma", "virāma");
		sutra.addInflectedWord("pratyaya", "pratyaya");
		sutra.addInflectedWord("abhyāsa", "abhyāsam");
		sutra.addInflectedWord("pūrva", "pūrvaḥ");
		sutra.addInflectedWord("saṃskāra", "saṃskāra");// maybe saṃskāri ??
		sutra.addInflectedWord("śeṣa", "śeṣaḥ");
		sutra.addInflectedWord("anya", "anyaḥ");
		sutra.addInflectedWord("abhyāsa", "abhyāsa");
		sutra.addInflectedWord("saṃskāra", "saṃskāra");

		sutra.setSyntaxTranslationDE(
				"Ein Ursachenende aufgrund von Übung, ein (letzter) Rest geistiger Eindrücke, (dann herrscht) der andere (Bewußtseinszustand).");
		sutra.setSemanticTranslationDE(
				"Im zweiten Samadhi-Zustand hören durch Übung die Ursachen (Motive) auf, es sind nur noch Reste früherer Eindrücke vorhanden.");
		sutra.setCommentContentDE(
				"Der erste Bewußtseinszustand heißt saṃprajñāta, der zweite asaṃprajñāta. Interessant ist, dass für den zweiten Bewußtseinszustand kein eigener Name angegeben ist, sondern nur vom 'anderen' gesprochen wird. Im Gegensatz dazu werden sonst immer eigene Begriffe verwendet.");
		sutra.setCommentStructureDE("");

		sutra.addUsedTerm("pratyaya");
		samadhiPada.add(sutra);

		// 19
		sutra = new Sutra("भवप्रत्ययो विदेहप्रकृतिलयानाम्", "", "bhavapratyayo videhaprakṛtilayānām", "", "bhava-pratyayaḥ videha-prakṛti-layānām", "");

		sutra.addInflectedWord("bhava", "bhava");
		sutra.addInflectedWord("pratyaya", "pratyayaḥ");
		sutra.addInflectedWord("videha", "videha");
		sutra.addInflectedWord("prakṛti", "prakṛti");
		sutra.addInflectedWord("laya", "layānām");

		sutra.setSyntaxTranslationDE("Daseinsursache ist eine Geist(Körperlos)-Natur-Verbindung");
		sutra.setSemanticTranslationDE("Die Ursache des Daseins ist die Verschmelzung von Geist mit der Materie.");
		sutra.setCommentContentDE("Der Mensch besteht also aus den beiden Teilen Geist und Materie (Natur).");
		sutra.setCommentStructureDE("Die nächsten Sutras behandeln die unterschiedlichen Möglichkeiten die einem helfen, Samadhi zu erreichen.  ");

		sutra.addUsedTerm("pratyaya");
		samadhiPada.add(sutra);

		// 20
		sutra = new Sutra("श्रद्धावीर्यस्मृतिसमाधिप्रज्ञापूर्वक इतरेषाम्", "", "śraddhāvīryasmṛtisamādhiprajñāpūrvaka itareṣām", "",
				"śraddhā-vīrya-smṛti-samādhi-prajñā-pūrvaka itareṣām", "");

		sutra.addInflectedWord("śraddhā", "śraddhā");
		sutra.addInflectedWord("vīrya", "vīrya");
		sutra.addInflectedWord("smṛti", "smṛti");
		sutra.addInflectedWord("samādhi", "samādhi");
		sutra.addInflectedWord("prajñā", "prajñā");
		sutra.addInflectedWord("pūrvaka", "pūrvaka");
		sutra.addInflectedWord("itareṣā", "itareṣā");

		sutra.setSyntaxTranslationDE("Andere (benötigen) vorher Glaube, Energie, Erinnerung, Reflektion und Einsicht.");
		sutra.setSemanticTranslationDE("Bei Anderen gehen die Schritte Glaube, fester Wille, beständig daran Denken, Reflektion und Einsicht voraus.");
		sutra.setCommentContentDE(
				"Dies ist die Alternative, wenn man alles erst erwerben muss. Diese Aufzählung sind die fünf Fähigkeiten (indriyas) aus dem Buddhismus, wo sie zum Beispiel im Bodhipakkhiyadhamma erwähnt werden.");
		sutra.setCommentStructureDE("Damit ist der Abschnitt über die Veranlagungen beendet.");
		samadhiPada.add(sutra);

		// 21
		sutra = new Sutra("तीव्रसंवेगानामासन्नः", "", "tīvrasaṃvegānāmāsannaḥ", "", "tīvra-saṃvegānām āsannaḥ", "");

		sutra.addInflectedWord("tīvra", "tīvra");
		sutra.addInflectedWord("saṃvega", "saṃvegānām");
		sutra.addInflectedWord("āsanna", "āsannaḥ");

		sutra.setSyntaxTranslationDE("Tiefe (Stärke) der Intensität bringt Nähe.");
		sutra.setSemanticTranslationDE("Bei intensivem Antrieb bist Du dem Ziel nahe.");
		sutra.setCommentContentDE(
				"Hier also der Aufruf intensiv zu üben und die Übungen nicht schleifen zu lassen. Gleichzeitig ist es auch ein Versprechen, dass der Praktizierende etwas erreichen wird.");
		sutra.setCommentStructureDE(
				"Dieses und das nächste Sutra beschäftigen sich mit der Intensität der Übungen. Intensives Üben ist besser, darum steht dieses Sutra vermutlich am Anfang. Als Alternative wird in Sutra 23 die Gottesverehrung ins Spiel gebracht.");
		samadhiPada.add(sutra);

		// 22
		sutra = new Sutra("मृदुमध्याधिमात्रत्वात्ततोऽपि विशेषः", "", "mṛdumadhyādhimātratvāttato'pi viśeṣaḥ", "", "mṛdu-madhya-adhimātratvāt tataḥ api viśeṣaḥ",
				"");

		sutra.addInflectedWord("mṛdu", "mṛdu");
		sutra.addInflectedWord("madhya", "madhya");
		sutra.addInflectedWord("adhimātra", "adhimātratvāt");
		sutra.addInflectedWord("tata", "tataḥ");
		sutra.addInflectedWord("api", "api");
		sutra.addInflectedWord("viśeṣa", "viśeṣaḥ");
		sutra.addInflectedWord("vā", "vā");
		sutra.addInflectedWord("ta", "ta");

		sutra.setSyntaxTranslationDE("Mild,mittel, intensiv sind auch die Unterschiede.");
		sutra.setSemanticTranslationDE("Es gibt Abstufungen in mild, mittel oder stark.");
		sutra.setCommentContentDE("Auch wenn intensives Üben besser ist (siehe vorheriges Sutra), ist es möglich weniger intensiv zu praktizieren.");
		sutra.setCommentStructureDE("Hiermit endet der Abschnitt über die Veranlagungen und die Intensitäten.");
		samadhiPada.add(sutra);

		// 23
		sutra = new Sutra("ईश्वरप्रणिधानाद्वा", "", "īśvarapraṇidhānādvā", "", "īśvara-praṇidhānāt vā", "");

		sutra.addInflectedWord("īśvara", "īśvara");
		sutra.addInflectedWord("praṇidhāna", "praṇidhānāt");
		sutra.addInflectedWord("vā", "vā");

		sutra.setSyntaxTranslationDE("Oder durch Gebete zu Gott.");
		sutra.setSemanticTranslationDE("Oder durch Gottesverehrung.");
		sutra.setCommentContentDE("Die erste Möglichkeit, Samdhi zu erreichen, sind intensive Gebete.");
		sutra.setCommentStructureDE("Bis einschließlich Sutra 28 wird erläutert, wer īśvara ist und wie die Gebete auszusehen haben.");
		samadhiPada.add(sutra);

		// 24
		sutra = new Sutra("क्लेशकर्मविपाकाशयैरपरामृष्टः पुरुषविशेष ईश्वरः", "क्लेश कर्म विपाकाशयैःपरामृष्टः पुरुषविशेष ईश्वरः",
				"kleśakarmavipākāśayairaparāmṛṣṭaḥ puruṣaviśeṣa īśvaraḥ", "kleśa karma vipākāśayaiḥparāmṛṣṭaḥ puruṣaviśeṣa īśvaraḥ",
				"kleśa-karma-vipāka-āśayaiḥ aparāmṛṣṭaḥ puruṣa-viśeṣa īśvaraḥ", "");

		sutra.addInflectedWord("kleśa", "kleśa");
		sutra.addInflectedWord("karma", "karma");
		sutra.addInflectedWord("vipāka", "vipāka");
		sutra.addInflectedWord("āśaya", "āśayaiḥ");
		sutra.addInflectedWord("aparāmṛṣṭa", "aparāmṛṣṭaḥ");
		sutra.addInflectedWord("puruṣa", "puruṣa");
		sutra.addInflectedWord("viśeṣa", "viśeṣa");
		sutra.addInflectedWord("īśvara", "īśvaraḥ");

		sutra.setSyntaxTranslationDE("Von Leid, Handlungen, Folgen, Absichten unberührt, eine besondere Seele, ist Gott.");
		sutra.setSemanticTranslationDE(
				"Gott ist eine besondere Seele, die völlig unberührt ist von Leid, Handlungen, Folgen und Absichten.");
		samadhiPada.add(sutra);

		// 25
		sutra = new Sutra("तत्र निरतिशयं सर्वज्ञबीजम्", "", "tatra niratiśayaṃ sarvajñabījam", "", "tatra niratiśayam sarva-jña-bījam", "");

		sutra.addInflectedWord("niratiśaya", "niratiśayam");
		sutra.addInflectedWord("sarva", "sarva");
		sutra.addInflectedWord("jñā", "jñā");
		sutra.addInflectedWord("bīja", "bījam");
		sutra.addInflectedWord("tatra", "tatra");

		sutra.setSyntaxTranslationDE("Dort (findest Du) das Höchste, den Samen allen Wissens.");
		sutra.setSemanticTranslationDE("Darin liegt das Höchste, dort ist die Basis allen Wissens.");
		samadhiPada.add(sutra);

		// 26
		sutra = new Sutra("स एष पूर्वेषामपि गुरुः कालेनानवच्छेदात्", "स पूर्वेषाम् अपि गुरुः कालेनानवच्छेदात्", "sa eṣa pūrveṣāmapi guruḥ kālenānavacchedāt",
				"sa pūrveṣām api guruḥ kālenānavacchedāt", "sa eṣa pūrv-eṣām api guruḥ kālena anavacchedāt", "");

		sutra.addInflectedWord("guru", "guruḥ");
		sutra.addInflectedWord("kāla", "kālena");
		sutra.addInflectedWord("anavaccheda", "anavacchedāt");
		sutra.addInflectedWord("pūrva", "pūrva");
		sutra.addInflectedWord("sa", "sa");
		sutra.addInflectedWord("guru", "guru");
		sutra.addInflectedWord("api", "api");
		sutra.addInflectedWord("eṣa", "eṣa");

		sutra.setSemanticTranslationDE("Er ist der Lehrer der früheren Generationen, er ist zeitlich unbegrenzt.");
		samadhiPada.add(sutra);

		// 27
		sutra = new Sutra("तस्य वाचकः प्रणवः", "", "tasya vācakaḥ praṇavaḥ", "", "tasya vācakaḥ praṇavaḥ", "");

		sutra.addInflectedWord("ta", "tasya");
		sutra.addInflectedWord("vācaka", "vācakaḥ");
		sutra.addInflectedWord("praṇava", "praṇavaḥ");

		sutra.setSyntaxTranslationDE("Dessen Wort ist Aum.");
		sutra.setSemanticTranslationDE("Das Wort, das ihn repäsentiert ist Aum. ");
		samadhiPada.add(sutra);

		// 28
		sutra = new Sutra("तज्जपस्तदर्थभावनम्", "", "tajjapastadarthabhāvanam", "", "tat-japaḥ tat-artha-bhāvanam", "");

		sutra.addInflectedWord("japa", "japaḥ");
		sutra.addInflectedWord("artha", "artha");
		sutra.addInflectedWord("bhāvana", "bhāvanam");
		sutra.addInflectedWord("ta", "ta");
		sutra.addInflectedWord("tad", "tad");

		sutra.setSyntaxTranslationDE("Das gebetet bewirkt, es zu verstehen.");
		sutra.setSemanticTranslationDE("Wird es wiederholt, kommt seine Bedeutung zum Vorschein.");

		sutra.setCommentStructureDE("Damit ist der in Sutra 23 begonnene Abschnitt über īśvara beendet.");
		samadhiPada.add(sutra);

		// 29
		sutra = new Sutra("ततः प्रत्यक्चेतनाधिगमोऽप्यन्तरायाभावश्च", "", "tataḥ pratyakcetanādhigamo'pyantarāyābhāvaśca", "",
				"tataḥ pratyakcetana-adhigamaḥ api antarāya-abhāvaḥ ca", "");

		sutra.addInflectedWord("tatas", "tataḥ");
		sutra.addInflectedWord("pratyac", "pratyak");
		sutra.addInflectedWord("cetana", "cetana");
		sutra.addInflectedWord("adhigama", "adhigamaḥ");
		sutra.addInflectedWord("antarāya", "antarāya");
		sutra.addInflectedWord("abhāva", "abhāvaḥ");
		sutra.addInflectedWord("ca", "ca");
		sutra.addInflectedWord("api", "api");
		// sutra.addInflectedWord("pratyakcetana", "pratyakcetana");

		sutra.setSyntaxTranslationDE("Daraus wird die Wahrnehmung des Inneren erreicht und auch Hindernisse hören auf zu existieren.");
		sutra.setSemanticTranslationDE("Dadurch erreichst Du Innenschau und Hindernisse werden beseitigt.");

		sutra.setCommentStructureDE("In den folgenden beiden Sutras werden die Hindernisse genauer erläutert.");
		samadhiPada.add(sutra);

		// 30
		sutra = new Sutra("व्याधिस्त्यानसंशयप्रमादालस्याविरतिभ्रान्तिदर्शनालब्धभूमिकत्वानवस्थितत्वानि चित्तविक्षेपास्तेऽन्तरायाः", "",
				"vyādhistyānasaṃśayapramādālasyāviratibhrāntidarśanālabdhabhūmikatvānavasthitatvāni cittavikṣepāste'ntarāyāḥ", "",
				"vyādhi-styāna-saṃśaya-pramāda-ālasya-avirati bhrānti-darśana-alabdha-bhūmikatva-anavasthitatvāni citta-vikṣepāḥ te antarāyāḥ", "");

		sutra.addInflectedWord("vyādhi", "vyādhi");
		sutra.addInflectedWord("styāna", "styāna");
		sutra.addInflectedWord("saṃśaya", "saṃśaya");
		sutra.addInflectedWord("pramāda", "pramāda");
		sutra.addInflectedWord("ālasya", "ālasya");
		sutra.addInflectedWord("avirati", "avirati");
		// sutra.addInflectedWord("bhrāntidarśana", "bhrāntidarśana");//bhrāntidarśana bhrAnti
		sutra.addInflectedWord("bhrānti", "bhrānti");
		sutra.addInflectedWord("darśana", "darśana");
		sutra.addInflectedWord("alabdha", "alabdha");
		sutra.addInflectedWord("bhūmikatva", "bhūmikatva");
		sutra.addInflectedWord("anavasthitatvāni", "anavasthitatvāni");
		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("vikṣepa", "vikṣepāḥ");
		sutra.addInflectedWord("ta", "te");
		sutra.addInflectedWord("antarāya", "antarāyāḥ");

		sutra.setSyntaxTranslationDE(
				"Krankheit, Apathie, Unentschlossenheit, Nachlässigkeit; Schlaffheit, Unenthaltsamkeit, Verblendetheit, Nicht-Erreichen von Zielen, Unbeständigkeit, bewirken ein Sich-Gehenlassen des Geistes und sind Hindernisse.");
		sutra.setSemanticTranslationDE(
				"Krankheit, Apathie, Unentschlossenheit, Nachlässigkeit, Schlaffheit, Hängen an Objekten, Verblendetheit, mangelnde Zielstrebigkeit, Unbeständigkeit sind Hindernisse und führen zum sich gehen lassen des Geistes.");
		samadhiPada.add(sutra);

		// 31
		sutra = new Sutra("दुःखदौर्मनस्याङ्गमेजयत्वश्वासप्रश्वासाः विक्षेपसहभुवः", "", "duḥkhadaurmanasyāṅgamejayatvaśvāsapraśvāsāḥ vikṣepasahabhuvaḥ", "",
				"duḥkha-daurmanasya-aṅgamejayatva-śvāsa-praśvāsāḥ vikṣepa-sahabhuvaḥ", "");

		sutra.addInflectedWord("duḥkha", "duḥkha");
		sutra.addInflectedWord("daurmanasya", "daurmanasya");
		sutra.addInflectedWord("aṅgamejayatva", "aṅgamejayatva");
		sutra.addInflectedWord("śvāsa", "śvāsa");
		sutra.addInflectedWord("praśvāsa", "praśvāsāḥ");
		sutra.addInflectedWord("vikṣepa", "vikṣepa");
		sutra.addInflectedWord("sahabhuva", "sahabhuvaḥ");

		sutra.setSyntaxTranslationDE("Schmerz, Niedergeschlagenheit, Gliederzittern, schnaufender Atem sind Begleiterscheinungen von vikṣepa.");
		sutra.setSemanticTranslationDE(
				"Schmerz, Niedergeschlagenheit, Nervosität, unruhige Atmung sind Begleiterscheinungen des abgelenkten Geistes.");
		samadhiPada.add(sutra);

		// 32
		sutra = new Sutra("तत्प्रतिषेधार्थमेकतत्त्वाभ्यासः", "", "tatpratiṣedhārthamekatattvābhyāsaḥ", "", "tat-pratiṣedha-ārtham eka-tattva-abhyāsaḥ", "");

		sutra.addInflectedWord("pratiṣedha", "pratiṣedha");
		sutra.addInflectedWord("ārtha", "ārtham");
		sutra.addInflectedWord("tattva", "tattva");
		sutra.addInflectedWord("abhyāsa", "abhyāsaḥ");
		sutra.addInflectedWord("eka", "eka");
		sutra.addInflectedWord("ta", "ta");

		sutra.setSyntaxTranslationDE("Um die Beziehung dazu zu vermindern ist ein Prinzip zu wiederholen");
		sutra.setSemanticTranslationDE("Um dies zu beherrschen reicht es, ein einziges Prinzip zu üben.");
		sutra.setCommentContentDE(
				"Dabei ist nicht gemeint, dass es nur eine einzige Möglichkeit gibt. Vielmehr reicht es aus, sich unter den verschiedenen Möglichkeiten eine auszusuchen.");
		sutra.setCommentStructureDE("In den folgenden sieben Sutras bis Sutra 39 werden verschiedene Alternativen beschrieben.");
		samadhiPada.add(sutra);

		// 33
		sutra = new Sutra("मैत्रीकरुणामुदितोपेक्षाणां सुखदुःखपुण्यापुण्यविषयाणां भावनातश्चित्तप्रसादनम्", "",
				"maitrīkaruṇāmuditopekṣāṇāṃ sukhaduḥkhapuṇyāpuṇyaviṣayāṇāṃ bhāvanātaścittaprasādanam", "",
				"maitrī-karuṇā-muditā-upekṣāṇāṃ sukha-duḥkha-puṇya-apuṇya-viṣayāṇāṃ bhāvanātaḥ citta-prasādanam", "");

		sutra.addInflectedWord("maitrī", "maitrī");
		sutra.addInflectedWord("karuṇa", "karuṇā");
		sutra.addInflectedWord("mudita", "mudita");
		sutra.addInflectedWord("upekṣ", "upekṣāṇāṃ");
		sutra.addInflectedWord("sukha", "sukha");
		sutra.addInflectedWord("duḥkha", "duḥkha");
		sutra.addInflectedWord("puṇya", "puṇya");
		sutra.addInflectedWord("apuṇya", "apuṇya");
		sutra.addInflectedWord("viṣaya", "viṣayāṇāṃ");
		sutra.addInflectedWord("bhāvanāta", "bhāvanātaḥ");
		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("prasādana", "prasādanam");
		sutra.addInflectedWord("viṣayāna", "viṣayāna");

		sutra.setSyntaxTranslationDE(
				"Freundlichkeit, Mitleid, Fröhlichkeit, Geduld in angenehmen und unangenehmen, günstigen und ungünstigen Situationen entwickeln einen klaren Geist.");
		sutra.setSemanticTranslationDE(
				"Freundlichkeit, Mitleid, Fröhlichkeit und Geduld in jeder Situation, ob günstig oder leidvollen, erfolgreichen oder erfolglos, entwickeln einen klaren Geist.");
		samadhiPada.add(sutra);

		// 34
		sutra = new Sutra("प्रच्छर्दनविधारणाभ्यां वा प्राणस्य", "", "pracchardanavidhāraṇābhyāṃ vā prāṇasya", "", "pracchardana-vidhāraṇābhyāṃ vā prāṇasya",
				"");

		sutra.addInflectedWord("pracchardana", "pracchardana");
		sutra.addInflectedWord("vidhāraṇa", "vidhāraṇābhyāṃ");
		sutra.addInflectedWord("prāṇa", "prāṇasya");
		sutra.addInflectedWord("vā", "vā");

		sutra.setSyntaxTranslationDE("Oder durch das Ausstoßen und Anhalten des Atmens");
		sutra.setSemanticTranslationDE("Oder durch Ausatmen und anschließendes Anhalten des Atems.");
		sutra.setCommentContentDE("Nach dem Ausatmen ist zu warten, bis wieder eingeatmet wird.");
		samadhiPada.add(sutra);

		// 35
		sutra = new Sutra("विषयवती वा प्रवृत्तिरुत्पन्ना मनसः स्थिति स्थितिनिबन्धनी", "विषयवती वा प्रवृत्तिरुत्पन्ना मनसः निबन्धिनी",
				"viṣayavatī vā pravṛttirutpannā manasaḥ sthitinibandhanī", "viṣayavatī vā pravṛttirutpannā manasaḥ sthitinibandhinī",
				"viṣayavatī vā pravṛttiḥ utpannā manasaḥ sthiti-nibandhanī", "");

		sutra.addInflectedWord("viṣaya", "viṣayavatī");
		sutra.addInflectedWord("pravṛtti", "pravṛttiḥ");
		sutra.addInflectedWord("utpanna", "utpannā");
		sutra.addInflectedWord("manas", "manasaḥ");
		sutra.addInflectedWord("sthiti", "sthiti");
		sutra.addInflectedWord("nibandhana", "nibandhanī");
		sutra.addInflectedWord("vā", "vā");

		sutra.setSyntaxTranslationDE("Oder Objekte der Sinneswahrnehmung; Ist Fortschritt gekommen herrscht Standhaftigkeit und Bindung des Geistes");
		sutra.setSemanticTranslationDE(
				"Oder durch Objekte der Sinneswahrnehmung. Kontrollierte Wahrnehmung erzeugt Stabilität und Kontrolle des Geistes.");
		samadhiPada.add(sutra);

		// 36
		sutra = new Sutra("विशोका वा ज्योतिष्मती", "", "viśokā vā jyotiṣmatī", "", "viśokā vā jyotiṣmatī", "");

		sutra.addInflectedWord("viśoka", "viśokā");
		sutra.addInflectedWord("jyotiṣmatī", "jyotiṣmatī");
		sutra.addInflectedWord("vā", "vā");

		sutra.setSyntaxTranslationDE("Oder durch kummerloses, strahlendes Licht");
		sutra.setSemanticTranslationDE("Oder durch Konzentration auf ein kummerloses, himmlisches Licht.");
		samadhiPada.add(sutra);

		// 37
		sutra = new Sutra("वीतरागविषयं वा चित्तम्", "", "vītarāgaviṣayaṃ vā cittam", "", "vītarāga-viṣayam vā cittam", "");

		sutra.addInflectedWord("vīta", "vīta");
		sutra.addInflectedWord("rāga", "rāga");
		sutra.addInflectedWord("viṣaya", "viṣayam");
		sutra.addInflectedWord("citta", "cittam");
		sutra.addInflectedWord("vā", "vā");
		sutra.addInflectedWord("vītarāga", "vītarāga");

		sutra.setSyntaxTranslationDE("Oder den Geist dahin zu richten, das Verlangen vergehen zu lassen");
		sutra.setSemanticTranslationDE("Oder den Versuch, sein Verlangen zu vermindern.");
		samadhiPada.add(sutra);

		// 38
		sutra = new Sutra("स्वप्ननिद्राज्ञानालम्बनं वा", "", "svapnanidrājñānālambanaṃ vā", "", "svapna-nidrā-jñāna-ālambanam vā", "");

		sutra.addInflectedWord("svapna", "svapna");
		sutra.addInflectedWord("nidrā", "nidrā");
		sutra.addInflectedWord("jñāna", "jñāna");
		sutra.addInflectedWord("ālambana", "ālambanam");
		sutra.addInflectedWord("vā", "vā");

		sutra.setSyntaxTranslationDE("Oder über Traum und Schlaf als Wissensgrundlage.");
		sutra.setSemanticTranslationDE("Oder über aus Traum und Tiefschlaf erlangtes Wissen.");
		samadhiPada.add(sutra);

		// 39
		sutra = new Sutra("यथाभिमतध्यानाद्वा", "", "yathābhimatadhyānādvā", "", "yathā-abhimata-dhyānāt vā", "");

		sutra.addInflectedWord("abhimata", "abhimata");
		sutra.addInflectedWord("dhyāna", "dhyānāt");
		sutra.addInflectedWord("vā", "vā");
		sutra.addInflectedWord("yathā", "yathā");

		sutra.setSyntaxTranslationDE("Oder durch eine Meditation wie gewünscht.");
		sutra.setSemanticTranslationDE("Oder durch eine andere geeignete Meditation.");
		sutra.setCommentContentDE("Die Vorgaben sind also nicht dogmatisch. Jede geeignete Variante ist erlaubt.");
		sutra.setCommentStructureDE("Damit enden die ab Sutra 33 vorgestellten Alternativen.");
		samadhiPada.add(sutra);

		// 40
		sutra = new Sutra("परमाणु परममहत्त्वान्तोऽस्य वशीकारः", "", "paramāṇu paramamahattvānto'sya vaśīkāraḥ", "",
				"parama-aṇu-parama-mahattva-antaḥ asya vaśīkāraḥ", "");

		sutra.addInflectedWord("parama", "parama");
		sutra.addInflectedWord("aṇu", "aṇu");
		sutra.addInflectedWord("mahattva", "mahattva");
		sutra.addInflectedWord("anta", "antaḥ");
		sutra.addInflectedWord("as", "asya");
		sutra.addInflectedWord("vaśīkāra", "vaśīkāraḥ");

		sutra.setSyntaxTranslationDE("Gemeistert werden kann jedes Objekt vom Allerkleinsten bis zum Allergrößten");
		sutra.setSemanticTranslationDE("Das Meditationsobjekt kann vom Kleinsten bis zum Größten reichen");

		sutra.setCommentStructureDE(
				"In den folgenden Sutras bis zum Ende des Kapitels werden die Stufen der Meisterschaft aufgezählt und beschrieben.");
		samadhiPada.add(sutra);

		// 41
		sutra = new Sutra("क्षीणवृत्तेरभिजातस्येव मणेर्ग्रहीतृग्रहणग्राह्येषु तत्स्थतदञ्जनता समापत्तिः", "",
				"kṣīṇavṛtterabhijātasyeva maṇergrahītṛgrahaṇagrāhyeṣu tatsthatadañjanatā samāpattiḥ", "",
				"kṣīṇa-vṛtteḥ abhijātasya iva maṇeḥ grahītṛ-grahaṇa-grāhyeṣu tatstha-tadañjanatā samāpattiḥ", "");

		sutra.addInflectedWord("kṣi", "kṣīṇa");
		sutra.addInflectedWord("vṛtti", "vṛtteḥ");
		sutra.addInflectedWord("abhijāta", "abhijātasya");
		sutra.addInflectedWord("maṇi", "maṇeḥ");
		sutra.addInflectedWord("grahītṛ", "grahītṛ");
		sutra.addInflectedWord("grahaṇa", "grahaṇa");
		sutra.addInflectedWord("grāhya", "grāhyeṣu");
		sutra.addInflectedWord("tatstha", "tatstha");
		sutra.addInflectedWord("añjana", "añjanatā");
		sutra.addInflectedWord("samāpatti", "samāpattiḥ");
		sutra.addInflectedWord("iva", "iva");
		sutra.addInflectedWord("tad", "tad");

		sutra.setSyntaxTranslationDE(
				"Durch verminderte Gedanken, gleichwie ein edler Kristall ist der Erfassende, das Erfassen, das Erfasste aufeinander gestützt und überdeckt und die Vollendung ist erreicht.");
		sutra.setSemanticTranslationDE(
				"Sind die eigenen Gedanken reduziert und - wie bei einem Kristall, der seinen Hintergrund reflektiert - Wahrnehmender, Wahrnehmung und Wahrgenommenes zusammenhängend und nehmen die gleichen Eigenschaften an, so ist das die Verschmelzung.");
		sutra.setCommentContentDE("Die Unterscheidung zwischen Subjekt und Objekt löst sich auf.");
		samadhiPada.add(sutra);

		// 42
		sutra = new Sutra("तत्र शब्दार्थज्ञानविकल्पैः संकीर्णा सवितर्का समापत्तिः", "", "tatra śabdārthajñānavikalpaiḥ saṃkīrṇā savitarkā samāpattiḥ", "",
				"tatra śabda-ārtha-jñāna-vikalpaiḥ saṃkīrṇā savitarkā samāpattiḥ", "");

		sutra.addInflectedWord("śabda", "śabda");
		sutra.addInflectedWord("ārtha", "ārtha");
		sutra.addInflectedWord("jñāna", "jñāna");
		sutra.addInflectedWord("vikalpa", "vikalpaiḥ");
		sutra.addInflectedWord("saṃkīrṇa", "saṃkīrṇā");
		sutra.addInflectedWord("savitarka", "savitarkā");
		sutra.addInflectedWord("samāpatti", "samāpattiḥ");
		sutra.addInflectedWord("tatra", "tatra");

		sutra.setSyntaxTranslationDE("Dort wo Wissen auf Worten beruht und Unschlüssigkeit herrscht, spricht man von vom Nachdenken begleiteter Vollendung.");
		sutra.setSemanticTranslationDE(
				"Solange Gehörtes, Schlussfolgerungen, Wissen und Vorstellung gemischt sind, spricht man von Verschmelzung mit Nachdenken");

		sutra.setCommentStructureDE(
				"Ab hier werden die Begriffe, die in Sutra 17 angesprochen wurden (vitarkā und vicāra) wieder aufgegriffen.");
		samadhiPada.add(sutra);

		// 43
		sutra = new Sutra("स्मृतिपरिशुद्धौ स्वरूपशून्येवार्थमात्रनिर्भासा निर्वितर्का", "", "smṛtipariśuddhau svarūpaśūnyevārthamātranirbhāsā nirvitarkā", "",
				"smṛti-pariśuddhau svarūpa-śūnya iva artha-mātra-nirbhāsā nirvitarkā", "");

		sutra.addInflectedWord("smṛti", "smṛti");
		sutra.addInflectedWord("pariśudh", "pariśuddhau");
		sutra.addInflectedWord("svarūpa", "svarūpa");
		sutra.addInflectedWord("śūnya", "śūnya");
		sutra.addInflectedWord("artha", "artha");
		sutra.addInflectedWord("mātra", "mātra");
		sutra.addInflectedWord("nirbhāsa", "nirbhāsā");
		sutra.addInflectedWord("nirvitarka", "nirvitarkā");
		sutra.addInflectedWord("iva", "iva");
		sutra.addInflectedWord("pariśudh", "pariśudh");

		sutra.setSyntaxTranslationDE("Ist das Gedächtnis gereinigt, die eigene Form wie leer, das Ziel erscheint, dann herrscht Nirvitarka.");
		sutra.setSemanticTranslationDE(
				"Sind alte Erinnerungen beseitigt, und die eigene Form vergessen, erscheint nur noch das Meditationsobjekt. Es ist die Stufe 'Ohne Nachdenken'(Nirvitarka) erreicht.");
		sutra.setCommentContentDE("Die nächste Stufe nach Savitarka is Nirvitarka.");
		samadhiPada.add(sutra);

		// 44
		sutra = new Sutra("एतयैव सविचारा निर्विचारा च सूक्ष्मविषया व्याख्याता", "", "etayaiva savicārā nirvicārā ca sūkṣmaviṣayā vyākhyātā", "",
				"etayā eva savicārā nirvicārā ca sūkṣma-viṣayā vyākhyātā", "");

		sutra.addInflectedWord("etayā", "etayā");
		sutra.addInflectedWord("savicāra", "savicārā");
		sutra.addInflectedWord("nirvicāra", "nirvicārā");
		sutra.addInflectedWord("sūkṣma", "sūkṣma");
		sutra.addInflectedWord("viṣaya", "viṣayā");
		sutra.addInflectedWord("vyākhyā", "vyākhyātā");
		sutra.addInflectedWord("ca", "ca");
		sutra.addInflectedWord("eva", "eva");

		sutra.setSyntaxTranslationDE(
				"So erfolgt auch die Erklärung der mit bzw. ohne Erwägung begleiteten Überlegung auf auf verfeinertes Objekt der Sinneswahrnehmung.");
		sutra.setSemanticTranslationDE(
				"Handelt es sich bei den Meditationsgegenständen um subtile Objekte werden genauso die Zustände 'Mit Überlegung' und 'Ohne Überlegung' definiert.");
		samadhiPada.add(sutra);

		// 45
		sutra = new Sutra("सूक्ष्मविषयत्वं चालिङ्ग पर्यवसानम्", "", "sūkṣmaviṣayatvaṃ cāliṅga paryavasānam", "", "sūkṣma-viṣayatvam ca aliṅga-paryavasānam",
				"");

		sutra.addInflectedWord("sūkṣma", "sūkṣma");
		sutra.addInflectedWord("viṣayatva", "viṣayatvam");
		sutra.addInflectedWord("aliṅga", "aliṅga");
		sutra.addInflectedWord("paryavasāna", "paryavasānam");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Das Objekt kann ganz fein sein und ist am Schluß ein Objekt ohne Bezeichnung.");
		sutra.setSemanticTranslationDE(
				"Die Meditation kann sich auf subtile Objekte und sogar das Undefinierbare erstrecken. ");
		samadhiPada.add(sutra);

		// 46
		sutra = new Sutra("ता एव सबीजस्समाधिः", "", "tā eva sabījassamādhiḥ", "", "tā eva sabījaḥ samādhiḥ", "");

		sutra.addInflectedWord("sabīja", "sabījaḥ");
		sutra.addInflectedWord("samādhi", "samādhiḥ");
		sutra.addInflectedWord("eva", "eva");
		sutra.addInflectedWord("ta", "ta");

		sutra.setSyntaxTranslationDE("Das allerdings ist ein Keime enthaltender, meditativer Bewußtseinszustand.");
		sutra.setSemanticTranslationDE("Das ist allerdings nur Samadhi, das noch Keime enthält.");
		samadhiPada.add(sutra);

		// 47
		sutra = new Sutra("निर्विचारवैशारद्येऽध्यात्मप्रसादः", "", "nirvicāravaiśāradye'dhyātmaprasādaḥ", "", "nirvicāra-vaiśāradye adhyātma-prasādaḥ", "");

		sutra.addInflectedWord("nirvicāra", "nirvicāra");
		sutra.addInflectedWord("vaiśāradya", "vaiśāradye");
		sutra.addInflectedWord("adhyātma", "adhyātma");
		sutra.addInflectedWord("prasāda", "prasādaḥ");

		sutra.setSyntaxTranslationDE("Wissen ohne Nachdenken ist Klarheit im höchsten Geist.");
		sutra.setSemanticTranslationDE(
				"Die Erfahrung des Samadhi ohne Überlegung ist Klarheit auf höchster Ebene.");
		samadhiPada.add(sutra);

		// 48
		sutra = new Sutra("ऋतम्भरा तत्र प्रज्ञा", "", "ṛtambharā tatra prajñā", "", "ṛtambharā tatra prajñā", "");

		sutra.addInflectedWord("ṛta", "ṛtam");
		sutra.addInflectedWord("bhara", "bharā");
		sutra.addInflectedWord("prajñā", "prajñā");
		sutra.addInflectedWord("tatra", "tatra");

		sutra.setSyntaxTranslationDE("Wahrheitsträchtig ist dieses Wissen.");
		sutra.setSemanticTranslationDE("Der Verstand ist von Wahrheit erfüllt. ");
		samadhiPada.add(sutra);

		// 49
		sutra = new Sutra("श्रुतानुमानप्रज्ञाभ्यामन्यविषया विशेषार्थत्वात्", "", "śrutānumānaprajñābhyāmanyaviṣayā viśeṣārthatvāt", "",
				"śruta-anumāna-prajñābhyām anya-viṣayā viśeṣa-arthatvāt", "");

		sutra.addInflectedWord("śruta", "śruta");
		sutra.addInflectedWord("anumāna", "anumāna");
		sutra.addInflectedWord("prajñā", "prajñābhyām");
		sutra.addInflectedWord("anya", "anya");
		sutra.addInflectedWord("viṣaya", "viṣayā");
		sutra.addInflectedWord("viśeṣa", "viśeṣa");
		sutra.addInflectedWord("artha", "arthatvāt");

		sutra.setSyntaxTranslationDE("Gehörtes und geschlussfolgertes Wissen ist ein anderes, nämlich auf ein Objekt gerichtet.");
		sutra.setSemanticTranslationDE(
				"Man erlangt eine besondere Beziehung zum Objekt, anders als gehörtes Wissen und Wissen aus Schlussfolgerungen.");
		samadhiPada.add(sutra);

		// 50
		sutra = new Sutra("तज्जस्संस्कारोऽन्यसंस्कारप्रतिबन्धी", "", "tajjassaṃskāro'nyasaṃskārapratibandhī", "", "tat jaḥ saṃskāraḥ anya-saṃskāra-pratibandhī",
				"");

		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("ja", "jaḥ");
		sutra.addInflectedWord("saṃskāra", "saṃskāraḥ");
		sutra.addInflectedWord("saṃskāra", "saṃskāra");
		sutra.addInflectedWord("pratibandhi", "pratibandhī");
		sutra.addInflectedWord("anya", "anya");

		sutra.setSyntaxTranslationDE("Der so geborene Eindruck ersetzt die anderen Eindrücke.");
		sutra.setSemanticTranslationDE("Die so entstandenen Eindrücke ersetzen die bisherigen Eindrücke.");
		samadhiPada.add(sutra);

		// 51
		sutra = new Sutra("तस्यापि निरोधे सर्वनिरोधान्निर्बीजः समाधिः", "", "tasyāpi nirodhe sarvanirodhānnirbījaḥ samādhiḥ", "",
				"tasya api nirodhe sarva-nirodhāt nirbījaḥ samādhiḥ", "");

		sutra.addInflectedWord("ta", "tasya");
		sutra.addInflectedWord("nirodha", "nirodhe");
		sutra.addInflectedWord("sarva", "sarva");
		sutra.addInflectedWord("nirodha", "nirodhāt");
		sutra.addInflectedWord("nirbīja", "nirbījaḥ");
		sutra.addInflectedWord("samādhi", "samādhiḥ");
		sutra.addInflectedWord("api", "api");

		sutra.setSyntaxTranslationDE("Mit der Beherrschung auch dessen, durch die Beherrschung von allem, ist ein Bewußtseinszustand ohne Samen erreicht.");
		sutra.setSemanticTranslationDE("Sind sogar diese beherrscht, sind alle beherrscht und der Samādhi ohne Samen erreicht.");

		sutra.setCommentStructureDE(
				"Damit hört dieses Kapitel, das mit samādhi in der Überschrift begonnen hat, auch mit dem Wort samādhi auf.");
		samadhiPada.add(sutra);

		// --------------------------------------------
		// sadhana pada
		// --------------------------------------------

		sutra = new Sutra("साधनपाद", "", "sādhanapāda", "", "sādhana-pāda", "");

		sutra.addInflectedWord("sādhana", "sādhana");
		sutra.addInflectedWord("pāda", "pāda");

		sutra.setSyntaxTranslationDE("Praxis-Kapitel");
		sutra.setSemanticTranslationDE("Erstes Kapitel: (Spirituelle) Praxis");

		sadhanaPada.add(sutra);

		// 1
		sutra = new Sutra("तपः स्वाध्यायेश्वरप्रणिधानानि क्रियायोगः", "", "tapaḥ svādhyāyeśvarapraṇidhānāni kriyāyogaḥ", "",
				"tapaḥ svādhyāya-iśvara-praṇidhānāni kriyā-yogaḥ", "");

		sutra.addInflectedWord("tapas", "tapaḥ");
		sutra.addInflectedWord("svādhyāya", "svādhyāya");
		sutra.addInflectedWord("iśvara", "iśvara");
		sutra.addInflectedWord("praṇidhāna", "praṇidhānāni");
		sutra.addInflectedWord("kriyā", "kriyā");
		sutra.addInflectedWord("yoga", "yogaḥ");

		sutra.setSyntaxTranslationDE("Askese, Studiums- und Gottes-Bemühungen (sind) der Handlungsyoga.");
		sutra.setSemanticTranslationDE("Askese, Schriftenstudium und Gottesverehrung bilden den Yoga der Handlungen.");
		sadhanaPada.add(sutra);

		// 2
		sutra = new Sutra("समाधिभावनार्थः क्लेशतनूकरणार्थश्च", "", "samādhibhāvanārthaḥ kleśatanūkaraṇārthaśca", "",
				"samādhi-bhāvana-arthaḥ kleśa-tanū-karaṇa-arthaḥ ca", "");

		sutra.addInflectedWord("samādhi", "samādhi");
		sutra.addInflectedWord("bhāvana", "bhāvana");
		sutra.addInflectedWord("artha", "arthaḥ");
		sutra.addInflectedWord("kleśa", "kleśa");
		sutra.addInflectedWord("tanu", "tanū");
		sutra.addInflectedWord("karaṇa", "karaṇa");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Es gibt das Samadhi-Erreichungs-Ziel und das leidensverdünnungsmachende Ziel.");
		sutra.setSemanticTranslationDE("Ziel ist den meditativen Bewusstseinszustand (Samadhi) zu erreichen und Leid zu vermindern.");

		sadhanaPada.add(sutra);

		// 3
		sutra = new Sutra("अविद्यास्मितारागद्वेषाभिनिवेशः (पञ्च) क्लेशाः", "", "avidyāsmitārāgadveṣābhiniveśaḥ (pañca) kleśāḥ", "",
				"avidyā-asmitā-rāga-dveṣa-abhiniveśaḥ (pañca) kleśāḥ", "");

		sutra.addInflectedWord("avidyā", "avidyā");
		sutra.addInflectedWord("asmitā", "asmitā");
		sutra.addInflectedWord("rāga", "rāga");
		sutra.addInflectedWord("dveṣa", "dveṣa");
		sutra.addInflectedWord("abhiniveśa", "abhiniveśaḥ");
		sutra.addInflectedWord("kleśa", "kleśāḥ");
		sutra.addInflectedWord("pañca", "pañca");

		sutra.setSyntaxTranslationDE("Unwissenheit, Selbstsucht, Verlangen, Abneigung, Verhaftung sind (fünf) Leiden.");
		sadhanaPada.add(sutra);

		// 4
		sutra = new Sutra("अविद्या क्षेत्रमुत्तरेषाम् प्रसुप्ततनुविच्छिन्नोदाराणाम्", "", "avidyā kṣetramuttareṣām prasuptatanuvicchinnodārāṇām", "",
				"avidyā kṣetram-uttareṣām prasupta-tanu-vicchinna-udārāṇām", "");

		sutra.addInflectedWord("avidyā", "avidyā");
		sutra.addInflectedWord("kṣetra", "kṣetram");
		sutra.addInflectedWord("prasupta", "prasupta");
		sutra.addInflectedWord("tanu", "tanu");
		sutra.addInflectedWord("vicchinna", "vicchinna");
		sutra.addInflectedWord("udāra", "udārāṇām");
		sutra.addInflectedWord("uttara", "uttara");

		sutra.setSemanticTranslationDE("Unwissenheit ist der Ursprung der nachfolgenden.Sie sind schlafend, gering, unterbrochen (oder) aktiv.");
		sadhanaPada.add(sutra);

		// 5
		sutra = new Sutra("अनित्याशुचिदुःखानात्मसु नित्यशुचिसुखात्मख्यातिरविद्या", "", "anityāśuciduḥkhānātmasu nityaśucisukhātmakhyātiravidyā", "",
				"anitya-aśuci-duḥkha-anātmasu nitya-śuci-sukha-ātma-khyātiḥ-avidyā", "");

		sutra.addInflectedWord("anitya", "anitya");
		sutra.addInflectedWord("aśuci", "aśuci");
		sutra.addInflectedWord("duḥkha", "duḥkha");
		sutra.addInflectedWord("ātma", "ātmasu");
		sutra.addInflectedWord("nitya", "nitya");
		sutra.addInflectedWord("śuci", "śuci");
		sutra.addInflectedWord("sukha", "sukha");
		sutra.addInflectedWord("ātma", "ātma");
		sutra.addInflectedWord("khyāti", "khyātiḥ");
		sutra.addInflectedWord("avidyā", "avidyā");
		sutra.addInflectedWord("an", "an");

		sutra.setSyntaxTranslationDE(
				"Unbeständiges, Unreines, Schmerzliches, das Nicht-Selbst als Beständiges, Reines, Angenehmes, das Selbst anzusehen, ist Unwissenheit");

		sadhanaPada.add(sutra);

		// 6
		sutra = new Sutra("दृग्दर्शनशक्त्योरेकात्मतेवास्मिता", "", "dṛgdarśanaśaktyorekātmataivāsmitā", "", "dṛś-darśana-śaktyoḥ-ekātmatā eva asmitā", "");

		sutra.addInflectedWord("darśana", "darśana");
		sutra.addInflectedWord("śakti", "śaktyoḥ");
		sutra.addInflectedWord("ekātmatā", "ekātmatā");
		sutra.addInflectedWord("asmitā", "asmitā");
		sutra.addInflectedWord("dṛg", "dṛg");
		sutra.addInflectedWord("eva", "eva");

		sutra.setSyntaxTranslationDE("Wird das zu Sehende mit der eigenen Sehfähigkeit gleichgesetzt, so ist das Ich-Bezogenheit.");
		sadhanaPada.add(sutra);

		// 7
		sutra = new Sutra("सुखानुशयी रागः", "", "sukhānuśayī rāgaḥ", "", "sukha-anuśayī rāgaḥ", "");

		sutra.addInflectedWord("sukha", "sukha");
		sutra.addInflectedWord("anuśayin", "anuśayī");
		sutra.addInflectedWord("rāga", "rāgaḥ");

		sutra.setSyntaxTranslationDE("Genußverbundenheit ist Mögen.");
		sutra.setSemanticTranslationDE("Mögen (rāga) ist, was mit Genuß verbunden ist.");

		sadhanaPada.add(sutra);

		// 8
		sutra = new Sutra("दुःखानुशयी द्वेषः", "", "duḥkhānuśayī dveṣaḥ", "", "duḥkha-anuśayī dveṣaḥ", "");

		sutra.addInflectedWord("duḥkha", "duḥkha");
		sutra.addInflectedWord("anuśayin", "anuśayī");
		sutra.addInflectedWord("dveṣa", "dveṣaḥ");

		sutra.setSyntaxTranslationDE("Unbehagensverbundenheit ist Abneigung.");
		sutra.setSemanticTranslationDE("Abneigung (dveṣa) ist, was mit Unbehagen verbunden ist.");

		sadhanaPada.add(sutra);

		// 9
		sutra = new Sutra("स्वरसवाहि विदुषोऽपि (समा oder) तथा रूढोऽभिनिवेशः", "", "svarasavāhi viduṣo'pi (samā- oder) tathā-rūḍho'bhiniveśaḥ", "",
				"sva-rasa-vāhi viduṣo api (samā/)tathā-rūḍhaḥ abhiniveśaḥ", "");

		sutra.addInflectedWord("sva", "sva");
		sutra.addInflectedWord("rasa", "rasa");
		sutra.addInflectedWord("vāhin", "vāhi");
		sutra.addInflectedWord("vidus", "viduṣo");
		sutra.addInflectedWord("rūḍha", "rūḍhaḥ");
		sutra.addInflectedWord("abhiniveśa", "abhiniveśaḥ");
		sutra.addInflectedWord("api", "api");
		sutra.addInflectedWord("samā", "samā");
		sutra.addInflectedWord("tathā", "tathā");

		sutra.setSyntaxTranslationDE("Die Eigenessenzerfahrung (zu machen), auch der Weise ist damit beladen, ist die Verhaftung.");
		sutra.setSemanticTranslationDE("Verhaftung ist, an der eigenen Persönlichkeit zu hängen. Auch Weise sind davon betroffen.");

		sadhanaPada.add(sutra);

		// 10
		sutra = new Sutra("ते प्रतिप्रसवहेयाः सूक्ष्माः", "", "te pratiprasavaheyāḥ sūkṣmāḥ", "", "te prati-prasava-heyāḥ sūkṣmāḥ", "");

		sutra.addInflectedWord("ta", "te");
		sutra.addInflectedWord("prati", "prati");
		sutra.addInflectedWord("prasava", "prasava");
		sutra.addInflectedWord("heya", "heyāḥ");
		sutra.addInflectedWord("sūkṣma", "sūkṣmāḥ");
		sutra.addInflectedWord("te", "te");

		sutra.setSyntaxTranslationDE("Sie, ursprungsnah vermieden, bleiben fein");
		sutra.setSemanticTranslationDE("Werden sie (die Kleshas) gemieden, sobald sie beginnen aufzutreten, so bleibt ihr Einfluß gering.");
		sadhanaPada.add(sutra);

		// 11
		sutra = new Sutra("ध्यानहेयास्तद्वृत्तयः", "", "dhyānaheyāstadvṛttayaḥ", "", "dhyāna-heyāḥ tat-vṛttayaḥ", "");

		sutra.addInflectedWord("dhyāna", "dhyāna");
		sutra.addInflectedWord("heya", "heyāḥ");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("vṛtti", "vṛttayaḥ");

		sutra.setSyntaxTranslationDE("Meditationsvermieden sind diese Gedankenfunktionen.");
		sutra.setSemanticTranslationDE("Durch Meditation werden diese (Kleshas) Verhaltensweisen vermieden.");

		sadhanaPada.add(sutra);

		// 12
		sutra = new Sutra("क्लेशमूलः कर्माशयो दृष्टादृष्टजन्मवेदनीयः", "", "kleśamūlaḥ karmāśayo dṛṣṭādṛṣṭajanmavedanīyaḥ", "",
				"kleśa-mūlaḥ karma-āśayaḥ dṛṣṭa-adṛṣṭa-janma-vedanīyaḥ", "");

		sutra.addInflectedWord("kleśa", "kleśa");
		sutra.addInflectedWord("mūla", "mūlaḥ");
		sutra.addInflectedWord("karma", "karma");
		sutra.addInflectedWord("āśaya", "āśayaḥ");
		sutra.addInflectedWord("dṛṣṭa", "dṛṣṭa");
		sutra.addInflectedWord("adṛṣṭa", "adṛṣṭa");
		sutra.addInflectedWord("janma", "janma");
		sutra.addInflectedWord("vedanīya", "vedanīyaḥ");

		sutra.setSyntaxTranslationDE("Leidensgrundlage ist das Karmalager, in der sichtbaren oder unsichtbaren Geburt empfunden.");
		sutra.setSemanticTranslationDE(
				"Grundlage des Leidens ist der Vorrat an Karma, der im aktuellen (sichtbaren) oder zukünftigen (noch nicht sichtbaren) Leben erfahren wird.");

		sadhanaPada.add(sutra);

		// 13
		sutra = new Sutra("सति मूले तद्विपाको जात्यायुर्भोगाः", "", "sati mūle tadvipāko jātyāyurbhogāḥ", "", "sati mūle tat-vipākaḥ jāti-āyuḥ-bhogāḥ", "");

		sutra.addInflectedWord("mūla", "mūle");
		sutra.addInflectedWord("vipāka", "vipākaḥ");
		sutra.addInflectedWord("jāti", "jāti");
		sutra.addInflectedWord("āyu", "āyuḥ");
		sutra.addInflectedWord("bhoga", "bhogāḥ");
		sutra.addInflectedWord("tat", "tat");
		sutra.addInflectedWord("sat", "sat");

		sutra.setSyntaxTranslationDE("Sind Wurzeln existent, deren Reifung ist Kaste, Lebenszeit und Erfahrungen.");
		sutra.setSemanticTranslationDE(
				"Solange noch Karmagrundlagen vorhanden sind, prägen sie sich als Kaste, Lebensspanne und (zu machende) Erfahrungen aus.");

		sadhanaPada.add(sutra);

		// 14
		sutra = new Sutra("ते ह्लादपरितापफलाः पुण्यापुण्यहेतुत्वात्", "", "te hlādaparitāpaphalāḥ puṇyāpuṇyahetutvāt", "",
				"te hlāda-paritāpa-phalāḥ puṇya-apuṇya-hetu-tvāt }}", "");

		sutra.addInflectedWord("ta", "te");
		sutra.addInflectedWord("hlāda", "hlāda");
		sutra.addInflectedWord("paritāpa", "paritāpa");
		sutra.addInflectedWord("puṇya", "puṇya");
		sutra.addInflectedWord("apuṇya", "apuṇya");
		sutra.addInflectedWord("hetu", "hetu");
		sutra.addInflectedWord("te", "te");
		sutra.addInflectedWord("phala", "phala");
		sutra.addInflectedWord("tva", "tva");

		sutra.setSyntaxTranslationDE("Diese ist Erquickungs- (oder) Betrübnisfrucht, (wenn) deren Ursache günstig oder schlecht.");
		sutra.setSemanticTranslationDE("Je nachdem ob die Ursache günstig oder schlecht war, ist das Ergebnis erquicklich oder betrüblich.");

		sadhanaPada.add(sutra);

		// 15
		sutra = new Sutra("परिणामतापसंस्कार दुःखैर्गुणवृत्तिविरोधाच्च दुःखमेव सर्वं विवेकिनः", "",
				"pariṇāmatāpasaṃskāraduḥkhairguṇavṛttivirodhācca duḥkhameva sarvaṃ vivekinaḥ", "",
				"pariṇāma-tāpa-saṃskāra-duḥkhaiḥ guṇa-vṛtti-virodhāt ca duḥkham eva sarvam vivekinaḥ }}", "");

		sutra.addInflectedWord("pariṇāma", "pariṇāma");
		sutra.addInflectedWord("tāpa", "tāpa");
		sutra.addInflectedWord("saṃskāra", "saṃskāra");
		sutra.addInflectedWord("duḥkha", "duḥkhaiḥ");
		sutra.addInflectedWord("guṇa", "guṇa");
		sutra.addInflectedWord("vṛtti", "vṛtti");
		sutra.addInflectedWord("virodha", "virodhāt");
		sutra.addInflectedWord("duḥkha", "duḥkham");
		sutra.addInflectedWord("sarva", "sarvam");
		sutra.addInflectedWord("vivekin", "vivekinaḥ");
		sutra.addInflectedWord("eva", "eva");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE(
				"Mit Veränderung, Schmerz (und) neuen Eindrücken gibt es Leiden, und durch den Eigenschafts-Wesen-Konflikt. Leiden ist wirklich alles. Das wissen Kluge.");
		sutra.setSemanticTranslationDE(
				"Kluge Menschen wissen, dass im Leben durch Veränderungen, Schmerzen und neue Erfahrungen Leid entsteht; dass es einen Grundkonflikt zwischen (den Eigenschaften) der Natur und dem eigenen Wesen gibt; dass letztendlich alles mit Leid versehen ist.");

		sadhanaPada.add(sutra);

		// 16
		sutra = new Sutra("हेयं दुःखमनागतम्", "", "heyaṃ duḥkhamanāgatam", "", "heyam duḥkham anāgatam }}", "");

		sutra.addInflectedWord("heya", "heyam");
		sutra.addInflectedWord("duḥkha", "duḥkham");
		sutra.addInflectedWord("anāgata", "anāgatam");

		sutra.setSyntaxTranslationDE("Vermeidendes zukünftiges Leiden.");
		sutra.setSemanticTranslationDE("Zukünftiges Leiden ist zu vermeiden.");

		sadhanaPada.add(sutra);

		// 17
		sutra = new Sutra("द्रष्टृदृश्ययोः संयोगो हेयहेतुः", "", "draṣṭṛdṛśyayoḥ saṃyogo heyahetuḥ", "", "draṣṭṛ-dṛśyayoḥ saṃyogaḥ heya-hetuḥ }}", "");

		sutra.addInflectedWord("draṣṭṛ", "draṣṭṛ");
		sutra.addInflectedWord("dṛśya", "dṛśyayoḥ");
		sutra.addInflectedWord("saṃyoga", "saṃyogaḥ");
		sutra.addInflectedWord("heya", "heya");
		sutra.addInflectedWord("hetu", "hetuḥ");

		sutra.setSyntaxTranslationDE("Die Verbindung des Sehenden (mit dem) Gesehenen ist die zu vermeidende Ursache.");
		sutra.setSemanticTranslationDE("Die zu vermeidende Ursache ist die Identifikation des Subjekts mit dem Objekt.");

		sadhanaPada.add(sutra);

		// 18
		sutra = new Sutra("प्रकाशक्रियास्थितिशीलं भूतेन्द्रियात्मकं भोगापवर्गार्थं दृश्यम्", "",
				"prakāśakriyāsthitiśīlaṃ bhūtendriyātmakaṃ bhogāpavargārthaṃ dṛśyam", "",
				"prakāśa-kriyā-sthiti-śīlam bhūta-indriya-ātmakam bhoga-apavarga-artham dṛśyam }}", "");

		sutra.addInflectedWord("prakāśa", "prakāśa");
		sutra.addInflectedWord("kriyā", "kriyā");
		sutra.addInflectedWord("sthiti", "sthiti");
		sutra.addInflectedWord("śīla", "śīlam");
		sutra.addInflectedWord("bhūta", "bhūta");
		sutra.addInflectedWord("indriya", "indriya");
		sutra.addInflectedWord("ātmaka", "ātmakam");
		sutra.addInflectedWord("bhoga", "bhoga");
		sutra.addInflectedWord("apavarga", "apavarga");
		sutra.addInflectedWord("artha", "artham");
		sutra.addInflectedWord("dṛśya", "dṛśyam");

		sutra.setSyntaxTranslationDE(
				"Die Licht-, Handlungs- und Stillstandsnatur, vom Wesen Element und Sinnesorgan, ist Erfahrungs- und Befreiungszweck, ist das Sichtbare.");
		sutra.setSemanticTranslationDE(
				"Die Natur, die aus Licht, Bewegung und Stillstand besteht, die durch die Elemente und Sinnesorgane erfahren wird und dem Zweck der Erfahrung und Befreiung dient, bildet die Objekte.");

		sadhanaPada.add(sutra);

		// 19
		sutra = new Sutra("विशेषाविशेषलिङ्गमात्रालिङ्गानि गुणपर्वाणि", "", "viśeṣāviśeṣaliṅgamātrāliṅgāni guṇaparvāṇi", "",
				"viśeṣa-aviśeṣa-liṅga-mātra-aliṅgāni guṇa-parvāṇi }}", "");

		sutra.addInflectedWord("viśeṣa", "viśeṣa");
		sutra.addInflectedWord("aviśeṣa", "aviśeṣa");
		sutra.addInflectedWord("liṅga", "liṅga");
		sutra.addInflectedWord("mātra", "mātra");
		sutra.addInflectedWord("aliṅga", "aliṅgāni");
		sutra.addInflectedWord("guṇa", "guṇa");
		sutra.addInflectedWord("parvan", "parvan");

		sutra.setSyntaxTranslationDE("Spezifisch, unspezifisch, merkmalsmäßig, bezeichnungslos, das sind die Grundeigenschaftsabschnitte.");
		sutra.setSemanticTranslationDE("Die Grundeigenschaften haben jeweils die Stufen 'spezifisch', 'unspezifisch', 'benennbar', und 'unbenennbar'.");

		sadhanaPada.add(sutra);

		// 20
		sutra = new Sutra("द्रष्टा दृशिमात्रः शुद्धोऽपि प्रत्ययानुपश्यः", "", "draṣṭā dṛśimātraḥ śuddho'pi pratyayānupaśyaḥ", "",
				"draṣṭā dṛśi-mātraḥ śuddhaḥ api pratyaya-anupaśyaḥ }}", "");

		sutra.addInflectedWord("draṣṭṛ", "draṣṭā");
		sutra.addInflectedWord("dṛśi", "dṛśi");
		sutra.addInflectedWord("mātra", "mātraḥ");
		sutra.addInflectedWord("śuddha", "śuddhaḥ");
		sutra.addInflectedWord("pratyaya", "pratyaya");
		sutra.addInflectedWord("anupaśya", "anupaśyaḥ");
		sutra.addInflectedWord("api", "api");

		sutra.setSyntaxTranslationDE("Der Sehende ist, Sehen als Maßstab, vollständig sogar wahrnehmungsschauend.");
		sutra.setSemanticTranslationDE("Der Sehende (Das Subjekt), nimmt das zu Sehende vollständig wahr, obwohl er durch die Wahrnehmungsorgane schaut.");

		sadhanaPada.add(sutra);

		// 21
		sutra = new Sutra("तदर्थ एव दृश्यस्यात्मा", "", "tadartha eva dṛśyasyātmā", "", "tad-arthaḥ eva dṛśyasya ātmā", "");

		sutra.addInflectedWord("ta", "tad");
		sutra.addInflectedWord("artha", "arthaḥ");
		sutra.addInflectedWord("dṛśya", "dṛśyasya");
		sutra.addInflectedWord("eva", "eva");
		sutra.addInflectedWord("tad", "tad");
		sutra.addInflectedWord("ātman", "ātman");

		sutra.setSyntaxTranslationDE("Deren eigentliches Ziel des Sehens ist die Seele.");
		sutra.setSemanticTranslationDE("Sie dienen nur dazu, von der Seele gesehen zu werden.");

		sadhanaPada.add(sutra);

		// 22
		sutra = new Sutra("कृतार्थं प्रति नष्टमप्यनष्टं तदन्यसाधारणत्वात्", "", "kṛtārthaṃ prati naṣṭamapyanaṣṭaṃ tadanyasādhāraṇatvāt", "",
				"kṛta-artham prati naṣṭam api anaṣṭam tad-anya-sādhāraṇa-tvāt", "");

		sutra.addInflectedWord("kṛta", "kṛta");
		sutra.addInflectedWord("artha", "artham");
		sutra.addInflectedWord("prati", "prati");
		sutra.addInflectedWord("naṣṭa", "naṣṭam");
		sutra.addInflectedWord("anaṣṭa", "anaṣṭam");
		sutra.addInflectedWord("ta", "tad");
		sutra.addInflectedWord("sādhāraṇa", "sādhāraṇa");
		sutra.addInflectedWord("tad", "tad");
		sutra.addInflectedWord("anya", "anya");
		sutra.addInflectedWord("api", "api");
		sutra.addInflectedWord("tva", "tva");

		sutra.setSyntaxTranslationDE("Den Zweck getan, ist es gleichsam wie zerstört, (aber) auch nicht zerstört, es ist für andere gemeinsam da.");
		sutra.setSemanticTranslationDE(
				"Ist der Zweck (des Gesehenen) erreicht, ist es für den Sehenden überflüssig, aber noch vorhanden, da es auch für andere noch einen Zweck zu erfüllen hat.");

		sadhanaPada.add(sutra);

		// 23
		sutra = new Sutra("स्वस्वामिशक्त्योः स्वरूपोपलब्धिहेतुः संयोगः", "", "svasvāmiśaktyoḥ svarūpopalabdhihetuḥ saṃyogaḥ", "",
				"sva-svāmi-śaktyoḥ svarūpa-upalabdhi-hetuḥ saṃyogaḥ", "");

		sutra.addInflectedWord("sva", "sva");
		sutra.addInflectedWord("svāmin", "svāmi");
		sutra.addInflectedWord("śakti", "śaktyoḥ");
		sutra.addInflectedWord("svarūpa", "svarūpa");
		sutra.addInflectedWord("upalabdhi", "upalabdhi");
		sutra.addInflectedWord("hetu", "hetuḥ");
		sutra.addInflectedWord("saṃyoga", "saṃyogaḥ");

		sutra.setSyntaxTranslationDE("Eigener Eigentümer der Kraft, Eigenformerfahrungsmittel ist die Vereinigung.");
		sutra.setSemanticTranslationDE("Die Vereinigung dient dazu, zu erkennen, dass man selbst die Kräfte beherrscht und das eigene Wesen erfährt.");

		sadhanaPada.add(sutra);

		// 24
		sutra = new Sutra("तस्य हेतुरविद्या", "", "tasya heturavidyā", "", "tasya hetuḥ avidyā", "");

		sutra.addInflectedWord("hetu", "hetuḥ");
		sutra.addInflectedWord("avidyā", "avidyā");
		sutra.addInflectedWord("ta", "ta");

		sutra.setSyntaxTranslationDE("Dessen Ursache ist die Unwissenheit.");

		sadhanaPada.add(sutra);

		// 25
		sutra = new Sutra("तदभावात्संयोगाभावो हानं तद्दृशेः कैवल्यम्", "", "tadabhāvātsaṃyogābhāvo hānaṃ taddṛśeḥ kaivalyam", "",
				"tad-abhāvāt saṃyoga-abhāvaḥ hānam tat-dṛśeḥ kaivalyam", "");

		sutra.addInflectedWord("ta", "tad");
		sutra.addInflectedWord("abhāva", "abhāvāt");
		sutra.addInflectedWord("saṃyoga", "saṃyoga");
		sutra.addInflectedWord("abhāva", "abhāvaḥ");
		sutra.addInflectedWord("hāna", "hānam");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("dṛśi", "dṛśeḥ");
		sutra.addInflectedWord("kaivalya", "kaivalyam");
		sutra.addInflectedWord("tad", "tad");
		sutra.addInflectedWord("tat", "tat");

		sutra.setSyntaxTranslationDE(
				"Durch ihre (avidya, Unwissenheit) Vernichtung (erfolgt) die Vereinigungsvernichtung. Die Aufgabe des Sehens ist der Zustand absoluter Glückseligkeit.");
		sutra.setSemanticTranslationDE(
				"Durch ihre (Unwissenheit) Überwindung wird saṃyoga überwunden. Die Aufgabe dieser Sichtweise führt zum Zustand absoluter Glückseligkeit.");

		sadhanaPada.add(sutra);

		// 26
		sutra = new Sutra("विवेकख्यातिरविप्लवा हानोपायः", "", "vivekakhyātiraviplavā hānopāyaḥ", "", "viveka-khyātiḥ aviplavā hāna-upāyaḥ", "");

		sutra.addInflectedWord("viveka", "viveka");
		sutra.addInflectedWord("khyāti", "khyātiḥ");
		sutra.addInflectedWord("aviplava", "aviplavā");
		sutra.addInflectedWord("hāna", "hāna");
		sutra.addInflectedWord("upāya", "upāyaḥ");

		sutra.setSyntaxTranslationDE("Ununterbrochenes Unterscheidungsvermögen ist das Befreiungsmittel.");

		sadhanaPada.add(sutra);

		// 27
		sutra = new Sutra("तस्य सप्तधा प्रान्तभूमिः प्रज्ञा", "", "tasya saptadhā prāntabhūmiḥ prajñā", "", "tasya saptadhā prānta-bhūmiḥ prajñā", "");

		sutra.addInflectedWord("ta", "tasya");
		sutra.addInflectedWord("saptadhā", "saptadhā");
		sutra.addInflectedWord("prānta", "prānta");
		sutra.addInflectedWord("bhūmi", "bhūmiḥ");
		sutra.addInflectedWord("prajñā", "prajñā");
		sutra.addInflectedWord("tasya", "tasya");

		sutra.setSyntaxTranslationDE("Sieben Stufenenden bringen Einsicht darin.");
		sutra.setSemanticTranslationDE("Die Einsicht erreicht man über sieben Stufen.");

		sadhanaPada.add(sutra);

		// 28
		sutra = new Sutra("योगाङ्गानुष्ठानादशुद्धिक्षये ज्ञानदीप्तिराविवेकख्यातेः", "", "yogāṅgānuṣṭhānādaśuddhikṣaye jñānadīptirāvivekakhyāteḥ", "",
				"yoga-aṅga-anuṣṭhānāt aśuddhi-kṣaye jñāna-dīptiḥ ā viveka-khyāteḥ", "");

		sutra.addInflectedWord("yoga", "yoga");
		sutra.addInflectedWord("aṅga", "aṅga");
		sutra.addInflectedWord("anuṣṭhāna", "anuṣṭhānāt");
		sutra.addInflectedWord("aśuddhi", "aśuddhi");
		sutra.addInflectedWord("kṣaya", "kṣaye");
		sutra.addInflectedWord("jñāna", "jñāna");
		sutra.addInflectedWord("dīpti", "dīptiḥ");
		sutra.addInflectedWord("viveka", "viveka");
		sutra.addInflectedWord("khyāti", "khyāteḥ");
		sutra.addInflectedWord("ā", "ā");

		sutra.setSyntaxTranslationDE("Durch die Yogagliederausführung erfolgt Unreinheitenverminderung, Wissensglanz bis Unterscheidungsvermögen.");
		sutra.setSemanticTranslationDE(
				"Durch das Ausführen der einzelnen Yogateile werden Unreinheiten reduziert, Wissen leuchtet auf bis hin zum Unterscheidungsvermögen.");

		sadhanaPada.add(sutra);

		// 29
		sutra = new Sutra("यमनियमासनप्राणायामप्रत्याहारधारणाध्यानसमाधयोऽष्टावङ्गानि", "", "yamaniyamāsanaprāṇāyāmapratyāhāradhāraṇādhyānasamādhayo'ṣṭāvaṅgāni",
				"", "yama-niyama-āsana-prāṇāyāma-pratyāhāra-dhāraṇā-dhyāna-samādhayaḥ aṣṭau aṅgāni", "");

		sutra.addInflectedWord("yama", "yama");
		sutra.addInflectedWord("niyama", "niyama");
		sutra.addInflectedWord("āsana", "āsana");
		sutra.addInflectedWord("prāṇāyāma", "prāṇāyāma");
		sutra.addInflectedWord("pratyāhāra", "pratyāhāra");
		sutra.addInflectedWord("dhāraṇā", "dhāraṇā");
		sutra.addInflectedWord("dhyāna", "dhyāna");
		sutra.addInflectedWord("samādhi", "samādhayaḥ");
		sutra.addInflectedWord("aṣṭa", "aṣṭau");
		sutra.addInflectedWord("aṅga", "aṅgāni");

		sutra.setSyntaxTranslationDE(
				"Sittengesetze, Beschränkungen,  Sitzen, Atemanhalten, Sinnesrückzug, Konzentration, tiefe Meditation, Bewusstseinszustände sind die acht Teile.");
		sutra.setSemanticTranslationDE(
				"Sittengesetze, eigene Beschränkungen,  Stellungen, Atemübungen, Sinnesrückzug, Konzentration, tiefe Meditation und höhere Bewusstseinszustände bilden die acht Teile des Yoga.");

		sadhanaPada.add(sutra);

		// 30
		sutra = new Sutra("अहिंसासत्यास्तेय ब्रह्मचर्यापरिग्रहा यमाः", "", "ahiṃsāsatyāsteyabrahmacaryāparigrahā yamāḥ", "",
				"ahiṃsā-satya-asteya-brahmacarya-aparigrahāḥ yamāḥ", "");

		sutra.addInflectedWord("ahiṃsā", "ahiṃsā");
		sutra.addInflectedWord("satya", "satya");
		sutra.addInflectedWord("asteya", "asteya");
		sutra.addInflectedWord("brahmacarya", "brahmacarya");
		sutra.addInflectedWord("aparigraha", "aparigrahāḥ");
		sutra.addInflectedWord("yama", "yamāḥ");

		sutra.setSyntaxTranslationDE("Nicht-Verletzen, Wahrhaftigkeit, Nicht-Stehlen, Enthaltsamkeit, Besitzlosigkeit sind die Sittengesetze.");

		sadhanaPada.add(sutra);

		// 31
		sutra = new Sutra("(एते तु) जातिदेशकालसमयानवच्छिन्नाः सार्वभौमा महाव्रतम्", "", "(ete tu) jātideśakālasamayānavacchinnāḥ sārvabhaumā mahāvratam", "",
				"(ete tu) jāti-deśa-kāla-samaya-anavacchinnāḥ sārvabhaumāḥ mahāvratam", "");

		sutra.addInflectedWord("jāti", "jāti");
		sutra.addInflectedWord("deśa", "deśa");
		sutra.addInflectedWord("kāla", "kāla");
		sutra.addInflectedWord("samaya", "samaya");
		sutra.addInflectedWord("anavacchinnā", "anavacchinnāḥ");
		sutra.addInflectedWord("sārvabhauma", "sārvabhaumāḥ");
		sutra.addInflectedWord("mahāvrata", "mahāvratam");
		sutra.addInflectedWord("tu", "tu");
		sutra.addInflectedWord("etad", "etad");

		sutra.setSyntaxTranslationDE("Sodann sind sie Geburt-, Ort-, Zeit-, Umstandsungestört, auf der ganzen Welt verbreitete Grundpflichten");
		sutra.setSemanticTranslationDE("Sie sind unabhängig von sozialer Schicht, Ort, Zeit und Umständen. Es sind allgemeingültige Grundpflichten.");

		sadhanaPada.add(sutra);

		// 32
		sutra = new Sutra("शौचसंतोषतपःस्वाध्यायेश्वरप्रणिधानानि नियमाः", "", "śaucasaṃtoṣatapaḥsvādhyāyeśvarapraṇidhānāni niyamāḥ", "",
				"śauca-saṃtoṣa-tapaḥ-svādhyāya-iśvara-praṇidhānāni niyamāḥ", "");

		sutra.addInflectedWord("śauca", "śauca");
		sutra.addInflectedWord("saṃtoṣa", "saṃtoṣa");
		sutra.addInflectedWord("tapas", "tapaḥ");
		sutra.addInflectedWord("svādhyāya", "svādhyāya");
		sutra.addInflectedWord("īśvara", "īśvara");
		sutra.addInflectedWord("praṇidhāna", "praṇidhānāni");
		sutra.addInflectedWord("niyama", "niyamāḥ");

		sutra.setSyntaxTranslationDE("Reinheit, Genügsamkeit, Askese, Studium, Gottesverehrung sind die Beschränkungen.");

		sutra.setCommentContentDE("Die Beschränkungen, die man sich selbst auferlegen muss ");
		sadhanaPada.add(sutra);

		// 33
		sutra = new Sutra("वितर्कबाधने प्रतिपक्षभावनम्", "", "vitarkabādhane pratipakṣabhāvanam", "", "vitarka-bādhane pratipakṣa-bhāvanam", "");

		sutra.addInflectedWord("vitarka", "vitarka");
		sutra.addInflectedWord("bādhana", "bādhane");
		sutra.addInflectedWord("pratipakṣa", "pratipakṣa");
		sutra.addInflectedWord("bhāvana", "bhāvanam");

		sutra.setSyntaxTranslationDE("Zweifel und Pein, Gegenteilsförderung.");
		sutra.setSemanticTranslationDE("Bei Zweifel und Pein ist das Gegenteil zu fördern.");
		sutra.setCommentContentDE("Damit sie überwunden werden. ");
		sadhanaPada.add(sutra);

		// 34
		sutra = new Sutra("वितर्का हिंसादयः कृतकारितानुमोदिता लोभक्रोधमोहपूर्वका मृदुमध्य अधिमात्रा दुःखाज्ञानानन्तफला इति प्रतिपक्षभावनम्", "",
				"vitarkā hiṃsādayaḥ kṛtakāritānumoditā lobhakrodhamohapūrvakā mṛdumadhyādhimātrā duḥkhājñānānantaphalā iti pratipakṣabhāvanam", "",
				"vitarkāḥ hiṃsā-ādayaḥ kṛta-kārita-anumoditā lobha-krodha-moha-pūrvakā mṛdu-madhya-adhimātrā duḥkha-ajñāna-ananta-phalāḥ iti pratipakṣa-bhāvanam",
				"");

		sutra.addInflectedWord("vitarka", "vitarkāḥ");
		sutra.addInflectedWord("hiṃsā", "hiṃsā");
		sutra.addInflectedWord("ādi", "ādayaḥ");
		sutra.addInflectedWord("kṛta", "kṛta");
		sutra.addInflectedWord("kārita", "kārita");
		sutra.addInflectedWord("anumodita", "anumoditā");
		sutra.addInflectedWord("lobha", "lobha");
		sutra.addInflectedWord("krodha", "krodha");
		sutra.addInflectedWord("moha", "moha");
		sutra.addInflectedWord("pūrvaka", "pūrvakā");
		sutra.addInflectedWord("mṛdu", "mṛdu");
		sutra.addInflectedWord("madhya", "madhya");
		sutra.addInflectedWord("adhimātra", "adhimātrā");
		sutra.addInflectedWord("duḥkha", "duḥkha");
		sutra.addInflectedWord("ajñāna", "ajñāna");
		sutra.addInflectedWord("ananta", "ananta");
		sutra.addInflectedWord("phala", "phalā");
		sutra.addInflectedWord("pratipakṣa", "pratipakṣa");
		sutra.addInflectedWord("bhāvana", "bhāvanam");
		sutra.addInflectedWord("iti", "iti");

		sutra.setSyntaxTranslationDE(
				"Zweifel, Leidzufügensbeginn - gemacht, veranlasst, gebilligt - verbunden mit Gier, Zorn, Irrtum - leicht, mittel, stark; Schmerz, Unwissenheit ist endlose Frucht. Deshalb die Gegenteilsförderung.");
		sutra.setSemanticTranslationDE(
				"Zweifel und Gewalt, egal ob gemacht, veranlasst oder nur gebilligt, ob aus Gier, Zorn oder Irrtum, ob gering, mittel oder stark haben endlosen Schmerz und Unwissenheit zur Folge. Deshalb fördere das Gegenteil.");

		sadhanaPada.add(sutra);

		// 35
		sutra = new Sutra("अहिंसाप्रतिष्ठायां तत्सन्निधौ वैरत्यागः", "", "ahiṃsāpratiṣṭhāyāṃ tatsannidhau vairatyāgaḥ", "",
				"ahiṃsā-pratiṣṭhāyām tat-sannidhau vaira-tyāgaḥ", "");

		sutra.addInflectedWord("ahiṃsā", "ahiṃsā");
		sutra.addInflectedWord("pratiṣṭhā", "pratiṣṭhāyām");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("saṃnidhi", "sannidhau");
		sutra.addInflectedWord("vaira", "vaira");
		sutra.addInflectedWord("tyāga", "tyāgaḥ");
		sutra.addInflectedWord("tat", "tat");
		sutra.addInflectedWord("saṃnidhi", "saṃnidhi");

		sutra.setSyntaxTranslationDE("Im Gewaltlosigkeitszustand, in seiner Gegenwart ist Feindschaftsende.");
		sutra.setSemanticTranslationDE("Jemand, der in Gewaltlosigkeit lebt, beendet Feindschaften, die in seiner Umgebung stattfinden.");

		sadhanaPada.add(sutra);

		// 36
		sutra = new Sutra("सत्यप्रतिष्ठायां क्रियाफलाश्रयत्वम्", "", "satyapratiṣṭhāyāṃ kriyāphalāśrayatvam", "", "satya-pratiṣṭhāyām kriyā-phala-āśraya-tvam",
				"");

		sutra.addInflectedWord("satya", "satya");
		sutra.addInflectedWord("pratiṣṭhā", "pratiṣṭhāyām");
		sutra.addInflectedWord("kriyā", "kriyā");
		sutra.addInflectedWord("phala", "phala");
		sutra.addInflectedWord("āśraya", "āśraya");
		sutra.addInflectedWord("tva", "tva");

		sutra.setSyntaxTranslationDE("Im Wahrhaftigkeitszustand ist eine Handlung-Frucht-Verbindung");
		sutra.setSemanticTranslationDE("Im Zustand der Wahrhaftigkeit besteht eine Verbindung zwischen Handlung und Ergebnis.");
		sutra.setCommentContentDE("Man handelt also nicht verdeckt, sondern Handlung und Ergebnis sind deckungsgleich. ");
		sadhanaPada.add(sutra);

		// 37
		sutra = new Sutra("अस्तेयप्रतिष्ठायां सर्वरत्नोपस्थानम्", "", "asteyapratiṣṭhāyāṃ sarvaratnopasthānam", "",
				"asteya-pratiṣṭhāyām sarva-ratna-upasthānam", "");

		sutra.addInflectedWord("asteya", "asteya");
		sutra.addInflectedWord("pratiṣṭhā", "pratiṣṭhāyām");
		sutra.addInflectedWord("ratna", "ratna");
		sutra.addInflectedWord("upasthāna", "upasthānam");
		sutra.addInflectedWord("sarva", "sarva");

		sutra.setSyntaxTranslationDE("Im Nichtstehlenszustand erscheint aller Besitz.");
		sutra.setSemanticTranslationDE("Wer nicht stiehlt, erhält allen (nötigen) Besitz.");

		sadhanaPada.add(sutra);

		// 38
		sutra = new Sutra("ब्रह्मचर्य प्रतिष्ठायां वीर्यलाभः", "", "brahmacaryapratiṣṭhāyāṃ vīryalābhaḥ", "", "brahmacarya-pratiṣṭhāyām vīrya-lābhaḥ", "");

		sutra.addInflectedWord("brahmacarya", "brahmacarya");
		sutra.addInflectedWord("pratiṣṭhā", "pratiṣṭhāyām");
		sutra.addInflectedWord("vīrya", "vīrya");
		sutra.addInflectedWord("lābha", "lābhaḥ");

		sutra.setSyntaxTranslationDE("Im Enthaltsamkeitszustand ist Energiegewinn.");
		sutra.setSemanticTranslationDE("Wer enthaltsam lebt, ist voller Energie.");

		sadhanaPada.add(sutra);

		// 39
		sutra = new Sutra("अपरिग्रहस्थैर्ये जन्मकथंतासंबोधः", "", "aparigrahasthairye janmakathaṃtāsaṃbodhaḥ", "",
				"aparigraha-sthairye janma-kathaṃtā-saṃbodhaḥ", "");

		sutra.addInflectedWord("aparigraha", "aparigraha");
		sutra.addInflectedWord("sthairya", "sthairye");
		sutra.addInflectedWord("janma", "janma");
		sutra.addInflectedWord("kathaṃtā", "kathaṃtā");
		sutra.addInflectedWord("saṃbodha", "saṃbodhaḥ");

		sutra.setSyntaxTranslationDE("In Besitzlosigkeitsfestigkeit ist Existenz-Wieso-Erkenntnis.");
		sutra.setSemanticTranslationDE("Bei Besitzlosigkeit erlangt man Lebenserfahrung.");

		sadhanaPada.add(sutra);

		// 40
		sutra = new Sutra("शौचात् स्वाङ्गजुगुप्सा परैरसंसर्गः", "", "śaucātsvāṅgajugupsā parairasaṃsargaḥ", "", "śaucāt sva-aṅga-jugupsā paraiḥ asaṃsargaḥ",
				"");

		sutra.addInflectedWord("śauca", "śaucāt");
		sutra.addInflectedWord("sva", "sva");
		sutra.addInflectedWord("aṅga", "aṅga");
		sutra.addInflectedWord("jugupsā", "jugupsā");
		sutra.addInflectedWord("para", "paraiḥ");
		sutra.addInflectedWord("asaṃsarga", "asaṃsargaḥ");

		sutra.setSyntaxTranslationDE("Durch Reinheit ist eigener Glieder Abscheu (vorhanden) und mit anderen keine Berührung.");
		sutra.setSemanticTranslationDE("Durch (das Bestreben nach) Reinheit verabscheut man den eigenen Körper und vermeidet Berührungen mit anderen.");
		sutra.setCommentContentDE("Wer rein sein will, wird am eigenen Körper und an anderen immer etwas unreines entdecken und verabscheuen. ");
		sadhanaPada.add(sutra);

		// 41
		sutra = new Sutra("सत्त्वशुद्धिः सौमनस्यैकाग्र्येन्द्रियजयात्मदर्शनयोग्यत्वानि च", "",
				"sattvaśuddhiḥ saumanasyaikāgryendriyajayātmadarśanayogyatvāni ca", "",
				"sattva-śuddhiḥ saumanasya-ekāgrya-indriya-jaya-ātmadarśana-yogya-tvāni ca", "");

		sutra.addInflectedWord("sattva", "sattva");
		sutra.addInflectedWord("śuddhi", "śuddhiḥ");
		sutra.addInflectedWord("saumanasya", "saumanasya");
		sutra.addInflectedWord("ekāgrya", "ekāgrya");
		sutra.addInflectedWord("indriya", "indriya");
		sutra.addInflectedWord("jaya", "jaya");
		sutra.addInflectedWord("ātmadarśana", "ātmadarśana");
		sutra.addInflectedWord("yogya", "yogya");
		sutra.addInflectedWord("tva", "tvāni");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Wesenskenntnis bringt Frohsinn, Einpünktigkeit, Sinnesorgansbesiegung und Sich-Selbst-Sehenseignung");
		sutra.setSemanticTranslationDE(
				"Durch Wesenskenntnis wird Frohsinn, Konzentrationsfähigkeit, Beherrschung der Sinne und die Fähigkeit sich selbst zu erkennen erreicht.");

		sadhanaPada.add(sutra);

		// 42
		sutra = new Sutra("संतोषादनुत्तमः स्सुखलाभः", "", "saṃtoṣādanuttamaḥ sukhalābhaḥ", "", "saṃtoṣāt anuttamaḥ sukha-lābhaḥ", "");

		sutra.addInflectedWord("saṃtoṣa", "saṃtoṣāt");
		sutra.addInflectedWord("anuttama", "anuttamaḥ");
		sutra.addInflectedWord("sukha", "sukha");
		sutra.addInflectedWord("lābha", "lābhaḥ");

		sutra.setSyntaxTranslationDE("Durch Genügsamkeit ist der höchste Wohlbefindensgewinn.");
		sutra.setSemanticTranslationDE("Durch Genügsamkeit erreicht man größtes Wohlbefinden.");

		sadhanaPada.add(sutra);

		// 43
		sutra = new Sutra("कायेन्द्रियसिद्धिरशुद्धिक्षयात्तपसः", "", "kāyendriyasiddhiraśuddhikṣayāttapasaḥ", "", "kāya-indriya-siddhiḥ aśuddhi-kṣayāt tapasaḥ",
				"");

		sutra.addInflectedWord("kāya", "kāya");
		sutra.addInflectedWord("indriya", "indriya");
		sutra.addInflectedWord("siddhi", "siddhiḥ");
		sutra.addInflectedWord("aśuddhi", "aśuddhi");
		sutra.addInflectedWord("kṣaya", "kṣayāt");
		sutra.addInflectedWord("tapas", "tapas");

		sutra.setSyntaxTranslationDE("Körper und Sinnesorgankraft durch die Abnahme von Unreinheit (bewirkt) Askese.");
		sutra.setSemanticTranslationDE("Durch Askese nehmen Unreinheiten ab, der Körper und die Sinnesorgane werden gekräftigt.");

		sadhanaPada.add(sutra);

		// 44
		sutra = new Sutra("स्वाध्यायादिष्टदेवतासंप्रयोगः", "", "svādhyāyādiṣṭadevatāsaṃprayogaḥ", "", "svādhyāyāt iṣṭadevatā-saṃprayogaḥ", "");

		sutra.addInflectedWord("svādhyāya", "svādhyāyāt");
		sutra.addInflectedWord("iṣṭadevatā", "iṣṭadevatā");
		sutra.addInflectedWord("saṃprayoga", "saṃprayogaḥ");

		sutra.setSyntaxTranslationDE("Durch Studium erfolgt eine Lieblingsgottheitsverbindung.");
		sutra.setSemanticTranslationDE("Durch Studien verbindet man sich mit seiner Lieblingsgottheit.");
		sutra.setCommentContentDE("Wenn man die Schriften zur Gottheit studiert. ");
		sadhanaPada.add(sutra);

		// 45
		sutra = new Sutra("समाधिसिद्धिरीश्वरप्रणिधानात्", "", "samādhisiddhirīśvarapraṇidhānāt", "", "samādhi-siddhiḥ īśvara-praṇidhānāt", "");

		sutra.addInflectedWord("samādhi", "samādhi");
		sutra.addInflectedWord("siddhi", "siddhiḥ");
		sutra.addInflectedWord("īśvara", "īśvara");
		sutra.addInflectedWord("praṇidhāna", "praṇidhānāt");

		sutra.setSyntaxTranslationDE("Der Bewusstseinszustandserfolg kommt durch Gottesverehrung.");
		sutra.setSemanticTranslationDE("Durch Gottesverehrung erreicht man den meditativen Bewusstseinszustand.");

		sadhanaPada.add(sutra);

		// 46
		sutra = new Sutra("स्थिरसुखमासनम्", "", "sthirasukhamāsanam", "", "sthira-sukham āsanam", "");

		sutra.addInflectedWord("sthira", "sthira");
		sutra.addInflectedWord("sukha", "sukham");
		sutra.addInflectedWord("āsana", "āsanam");

		sutra.setSyntaxTranslationDE("Feste Freude ist der Sitz.");
		sutra.setSemanticTranslationDE("Die Sitzhaltung ist gleichzeitig fest und angenehm.");

		sadhanaPada.add(sutra);

		// 47
		sutra = new Sutra("प्रयत्नशैथिल्यानन्त्यसमापत्तिभ्याम्", "", "prayatnaśaithilyānantyasamāpattibhyām", "", "prayatna-śaithilya-anantya-samāpattibhyām",
				"");

		sutra.addInflectedWord("prayatna", "prayatna");
		sutra.addInflectedWord("śaithilya", "śaithilya");
		sutra.addInflectedWord("anantya", "anantya");
		sutra.addInflectedWord("samāpatti", "samāpattibhyām");

		sutra.setSyntaxTranslationDE("Durch das Zusammentreffen von Bemühung und Lockerheit wird die Unendlichkeit erreicht.");

		sadhanaPada.add(sutra);

		// 48
		sutra = new Sutra("ततो द्वंद्वानभिघातः", "", "tato dvaṃdvānabhighātaḥ", "", "tataḥ dvaṃdva-anabhighātaḥ", "");

		sutra.addInflectedWord("dvaṃdva", "dvaṃdva");
		sutra.addInflectedWord("anabhighāta", "anabhighātaḥ");
		sutra.addInflectedWord("tatas", "tatas");

		sutra.setSyntaxTranslationDE("Dadurch ist ein Gegensatzpaar-Nichtangriff.");
		sutra.setSemanticTranslationDE("Dadurch überwindet man die Gegensätze.");
		sutra.setCommentContentDE("Die Gegensätze zwischen fest und locker. ");
		sadhanaPada.add(sutra);

		// 49
		sutra = new Sutra("तस्मिन् सति श्वासप्रश्वास्योर्गतिविच्छेदः प्राणायामः", "", "tasmin sati śvāsapraśvāsyorgativicchedaḥ prāṇāyāmaḥ", "",
				"tasmin sati śvāsa-praśvāsyoḥ gati-vicchedaḥ prāṇāyāmaḥ", "");

		sutra.addInflectedWord("śvāsa", "śvāsa");
		sutra.addInflectedWord("praśvāsa", "praśvāsyoḥ");
		sutra.addInflectedWord("gati", "gati");
		sutra.addInflectedWord("viccheda", "vicchedaḥ");
		sutra.addInflectedWord("prāṇāyāma", "prāṇāyāmaḥ");
		sutra.addInflectedWord("tasmin", "tasmin");
		sutra.addInflectedWord("sati", "sati");

		sutra.setSyntaxTranslationDE("Ist das geschehen, des Atems und Einatmes Bewegungsausrottung ist Atemanhalten.");
		sutra.setSemanticTranslationDE("Danach kommt man über unmerkliches Aus- und Einatmen zur Atemausdehnung.");

		sadhanaPada.add(sutra);

		// 50
		sutra = new Sutra("बाह्याभ्यन्तरस्थम्भवृत्तिः देशकालसंख्याभिः परिदृष्टो दीर्घसूक्ष्मः", "",
				"bāhyābhyantarasthambhavṛttiḥ deśakālasaṃkhyābhiḥ paridṛṣṭo dīrghasūkṣmaḥ", "",
				"bāhya-abhyantara-sthambha-vṛttiḥ deśa-kāla-saṃkhyābhiḥ paridṛṣṭaḥ dīrgha-sūkṣmaḥ", "");

		sutra.addInflectedWord("bāhya", "bāhya");
		sutra.addInflectedWord("abhyantara", "abhyantara");
		sutra.addInflectedWord("stambha", "sthambha");
		sutra.addInflectedWord("vṛtti", "vṛttiḥ");
		sutra.addInflectedWord("deśa", "deśa");
		sutra.addInflectedWord("kāla", "kāla");
		sutra.addInflectedWord("saṃkhyā", "saṃkhyābhiḥ");
		sutra.addInflectedWord("dīrgha", "dīrgha");
		sutra.addInflectedWord("sūkṣma", "sūkṣmaḥ");
		sutra.addInflectedWord("paridṛś", "paridṛṣṭaḥ");

		sutra.setSyntaxTranslationDE("Äußere, innere und Erstarrungstätigkeit mit Ort, Zeit und Anzahl bringt Sichtbarwerdung von Länge und Feinheit.");
		sutra.setSemanticTranslationDE(
				"Ausatmen, Einatmen und Atemanhalten mit Kontrolle von Atemheftigkeit, Atmungsdauer und der Anzahl an Wiederholungen verlängert und verfeinert den Atem.");
		sutra.setCommentContentDE(
				"Ort des Atems ist der Ort bis zu dem der Atem spürbar ist. Dessen Abstand zur Nase kann wie die Zeit gemessen werden und bestimmt die Heftigkeit der Atmung. ");
		sadhanaPada.add(sutra);
		// 51
		sutra = new Sutra("बाह्याभ्यन्तरविषयाक्षेपी चतुर्थः", "", "bāhyābhyantaraviṣayākṣepī caturthaḥ", "", "bāhya-abhyantara-viṣaya-ākṣepī caturthaḥ", "");

		sutra.addInflectedWord("bāhya", "bāhya");
		sutra.addInflectedWord("abhyantara", "abhyantara");
		sutra.addInflectedWord("viṣaya", "viṣaya");
		sutra.addInflectedWord("caturtha", "caturthaḥ");
		sutra.addInflectedWord("ākṣepin", "ākṣepin");

		sutra.setSyntaxTranslationDE("Außen und Innen als Objekt der Wahrnehmung betreffend, gibt es ein viertes.");
		sutra.setSemanticTranslationDE("Es gibt noch einen vierten Teil.");

		sadhanaPada.add(sutra);

		// 52
		sutra = new Sutra("ततः क्षीयते प्रकाशावरणम्", "", "tataḥ kṣīyate prakāśāvaraṇam", "", "tataḥ kṣīyate prakāśa-āvaraṇam", "");

		sutra.addInflectedWord("prakāśa", "prakāśa");
		sutra.addInflectedWord("āvaraṇa", "āvaraṇam");
		sutra.addInflectedWord("kṣī", "kṣīyate");
		sutra.addInflectedWord("tatas", "tatas");

		sutra.setSyntaxTranslationDE("Dann wird zerstört die Helligkeitsverhüllung.");
		sutra.setSemanticTranslationDE("Dann wird die Ummantelung des Lichts zerstört.");

		sadhanaPada.add(sutra);

		// 53
		sutra = new Sutra("धारणासु च योग्यता मनसः", "", "dhāraṇāsu ca yogyatā manasaḥ", "", "dhāraṇāsu ca yogyatā manasaḥ", "");

		sutra.addInflectedWord("dhāraṇā", "dhāraṇāsu");
		sutra.addInflectedWord("yogyatā", "yogyatā");
		sutra.addInflectedWord("manas", "manasaḥ");
		sutra.addInflectedWord("dhāraṇa", "dhāraṇa");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Und die Befähigung des Geistes in der Konzentration.");
		sutra.setSemanticTranslationDE("Und der Geist wird zur Konzentration fähig.");

		sadhanaPada.add(sutra);

		// 54
		sutra = new Sutra("स्वविषयासंप्रयोगे चित्त(स्य)स्वरूपानुकार इवेन्द्रियाणां प्रत्याहारः", "",
				"svaviṣayāsaṃprayoge citta(sya)svarūpānukāra ivendriyāṇāṃ pratyāhāraḥ", "",
				"sva-viṣaya-asaṃprayoge citta(sya)-svarūpa-anukāraḥ iva indriyāṇām pratyāhāraḥ", "");

		sutra.addInflectedWord("viṣaya", "viṣaya");
		sutra.addInflectedWord("asaṃprayoga", "asaṃprayoge");
		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("svarūpa", "svarūpa");
		sutra.addInflectedWord("anukāra", "anukāraḥ");
		sutra.addInflectedWord("indriya", "indriyāṇām");
		sutra.addInflectedWord("pratyāhāra", "pratyāhāraḥ");
		sutra.addInflectedWord("iva", "iva");
		sutra.addInflectedWord("sva", "sva");

		sutra.setSyntaxTranslationDE(
				"Herrscht eine Selbst-Objekt-Nicht-Verbindung, gleicht sich der Geist der wahren Natur an. Es ist gleichsam ein Zurückziehen der Sinne.");
		sutra.setSemanticTranslationDE(
				"Ist das Selbst nicht mehr mit den Objekten verbunden, so gleicht sich der Geist seiner wahren Natur an, es ist wie ein Zurückziehen der Sinne.");

		sadhanaPada.add(sutra);

		// 55
		sutra = new Sutra("ततः परमा वश्यतेन्द्रियाणाम्", "", "tataḥ paramā vaśyatendriyāṇām", "", "tataḥ paramā vaśya-tā indriyāṇām", "");

		sutra.addInflectedWord("parama", "paramā");
		sutra.addInflectedWord("vaśya", "vaśya");
		sutra.addInflectedWord("indriya", "indriyāṇām");
		sutra.addInflectedWord("tatas", "tataḥ");
		sutra.addInflectedWord("ta", "tā");

		sutra.setSyntaxTranslationDE("Daraus (ergibt sich) die höchste Gewalt der Sinne.");
		sutra.setSemanticTranslationDE("Dann hat man die höchste Meisterschaft über die Sinne erlangt.");

		sadhanaPada.add(sutra);

		// Vibhūti Pāda

		// 0
		sutra = new Sutra("विभूतिपाद", "", "vibhūtipāda", "", "vibhūti-pāda", "");

		sutra.addInflectedWord("vibhūti", "vibhūti");
		sutra.addInflectedWord("pāda", "pāda");

		sutra.setSyntaxTranslationDE("Entfaltungskapitel");
		sutra.setSemanticTranslationDE("Drittes Kapitel: Ergebnisse");

		vibhutiPada.add(sutra);
		// 1
		sutra = new Sutra("देशबन्धश्चित्तस्य धारणा", "", "deśabandhaścittasya dhāraṇā", "", "deśa-bandhaḥ cittasya dhāraṇā", "");

		sutra.addInflectedWord("deśa", "deśa");
		sutra.addInflectedWord("bandha", "bandhaḥ");
		sutra.addInflectedWord("citta", "cittasya");
		sutra.addInflectedWord("dhāraṇā", "dhāraṇā");

		sutra.setSyntaxTranslationDE("Ortsbindung des Geistes ist Konzentration.");
		sutra.setSemanticTranslationDE("Konzentration ist, wenn der Geist auf ein Thema fixiert ist.");

		vibhutiPada.add(sutra);

		// 2
		sutra = new Sutra("तत्र प्रत्ययैकतानता ध्यानम्", "", "tatra pratyayaikatānatā dhyānam", "", "tatra pratyaya-eka-tāna-tā dhyānam", "");

		sutra.addInflectedWord("pratyaya", "pratyaya");
		sutra.addInflectedWord("eka", "eka");
		sutra.addInflectedWord("tāna", "tāna");
		sutra.addInflectedWord("ta", "tā");
		sutra.addInflectedWord("dhyāna", "dhyānam");
		sutra.addInflectedWord("tatra", "tatra");

		sutra.setSyntaxTranslationDE("Dort wo Wahrnehmungseinfädigkeit ist, ist tiefe Meditation");
		sutra.setSemanticTranslationDE("Gibt es nur einen einzigen Gedankenstrom, ist tiefe  Meditation erreicht.");

		vibhutiPada.add(sutra);

		// 3
		sutra = new Sutra("तद् एवार्थमात्रनिर्भासं स्वरूपशून्यम् इव समाधिः", "", "tad evārthamātranirbhāsaṃ svarūpaśūnyam iva samādhiḥ", "",
				"tad eva-artha-mātra-nirbhāsam svarūpa-śūnyam iva samādhiḥ", "");

		sutra.addInflectedWord("ta", "tad");
		sutra.addInflectedWord("eva", "eva");
		sutra.addInflectedWord("artha", "artha");
		sutra.addInflectedWord("mātra", "mātra");
		sutra.addInflectedWord("nirbhāsa", "nirbhāsam");
		sutra.addInflectedWord("svarūpa", "svarūpa");
		sutra.addInflectedWord("śūnya", "śūnyam");
		sutra.addInflectedWord("samādhi", "samādhiḥ");
		sutra.addInflectedWord("iva", "iva");

		sutra.setSyntaxTranslationDE("Dies, die wirkliche Objektmaßerscheinung, gleichwie mit Eigennaturleere, ist die Vereinigung.");
		sutra.setSemanticTranslationDE(
				"Erscheint, wie ohne eigene subjektive Natur, die objektive Form (Maß) des Objekts, ist der Zustand des Samādhi erreicht.");
		sutra.setCommentContentDE(
				"Man filtert also das eigentliche Objekt nicht mehr durch sein Bewußtsein, sondern vereinigt sich so, dass man das wahre Objekt erkennt. ");
		vibhutiPada.add(sutra);

		// 4
		sutra = new Sutra("त्रयम् एकत्र संयमः", "", "trayam ekatra saṃyamaḥ", "", "trayam ekatra saṃyamaḥ", "");

		sutra.addInflectedWord("traya", "trayam");
		sutra.addInflectedWord("ekatra", "ekatra");
		sutra.addInflectedWord("saṃyama", "saṃyamaḥ");

		sutra.setSyntaxTranslationDE("Die drei an einem Ort sind die Bändigung der Sinne.");
		sutra.setSemanticTranslationDE("Treten diese drei Zustände zusammen auf, sind die Sinne gebändigt.");
		sutra.setCommentContentDE(
				"Die drei sind Dharana, Dhyana und Samadhi. Die Gedanken müssen also auf ein einziges Objekt ausgerichtet sein, es darf keine Ablenkung herrschen und das wahre (vom eigenen Geist ungefilterte) Objekt muss sichtbar werden.");
		vibhutiPada.add(sutra);

		// 5
		sutra = new Sutra("तज्जयात् प्रज्ञालोकः", "", "tajjayāt prajñālokaḥ", "", "tat-jayāt prajñā-ālokaḥ", "");

		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("jaya", "jayāt");
		sutra.addInflectedWord("prajñā", "prajñā");
		sutra.addInflectedWord("āloka", "ālokaḥ");

		sutra.setSyntaxTranslationDE("Durch den Sieg ist Einsichtslicht.");
		sutra.setSemanticTranslationDE("Ist dies erreicht, ist Einsicht erlangt.");

		vibhutiPada.add(sutra);

		// 6
		sutra = new Sutra("तस्य भूमिषु विनियोगः", "", "tasya bhūmiṣu viniyogaḥ", "", "tasya bhūmiṣu viniyogaḥ", "");

		sutra.addInflectedWord("ta", "tasya");
		sutra.addInflectedWord("bhūmi", "bhūmiṣu");
		sutra.addInflectedWord("viniyoga", "viniyogaḥ");

		sutra.setSyntaxTranslationDE("In Stufen ist die dessen Anwendung.");
		sutra.setSemanticTranslationDE("Seine Anwendung erfolgt stufenweise.");

		vibhutiPada.add(sutra);

		// 7
		sutra = new Sutra("त्रयम् अन्तरण्गं पूर्वेभ्यः", "", "trayam antaraṅgaṃ pūrvebhyaḥ", "", "trayam antar-aṅgam pūrvebhyaḥ", "");

		sutra.addInflectedWord("traya", "trayam");
		sutra.addInflectedWord("aṅga", "aṅgam");
		sutra.addInflectedWord("pūrva", "pūrvebhyaḥ");
		sutra.addInflectedWord("antar", "antar");

		sutra.setSyntaxTranslationDE("Dreifach sind die inneren Glieder verglichen mit den früheren.");
		sutra.setSemanticTranslationDE("Diese drei bilden die tieferen Glieder, nach den vorausgegangenen.");
		sutra.setCommentContentDE("Vorausgegangen sind die Stufen von Yama bis Pratyahara.  ");
		vibhutiPada.add(sutra);

		// 8
		sutra = new Sutra("तद् अपि बहिरङ्गं निर्बीजस्य", "", "tad api bahiraṅgaṃ nirbījasya", "", "tad api bahiraṅgam nirbījasya", "");

		sutra.addInflectedWord("ta", "tad");
		sutra.addInflectedWord("bahiraṅga", "bahiraṅgaṃ");
		sutra.addInflectedWord("nirbīja", "nirbījasya");
		sutra.addInflectedWord("api", "api");

		sutra.setSyntaxTranslationDE("Dies selbst ist ein unwesentliches Glied des Samenlosen.");
		sutra.setSemanticTranslationDE("Sie sind jedoch nur unwesentliche Teile des Nirbīja-Samadhi.");

		vibhutiPada.add(sutra);

		// 9
		sutra = new Sutra("व्युत्थाननिरोधसṃस्कारयोर् अभिभवप्रादुर्भावौ निरोधक्षणचित्तान्वयो निरोधपरिणामः", "",
				"vyutthānanirodhasaṃskārayor abhibhavaprādurbhāvau nirodhakṣaṇacittānvayo nirodhapariṇāmaḥ", "",
				"vyutthāna-nirodha-saṃskārayoḥ abhibhava-prādurbhāvau nirodha-kṣaṇa-citta-anvayaḥ nirodha-pariṇāmaḥ", "");

		sutra.addInflectedWord("vyutthāna", "vyutthāna");
		sutra.addInflectedWord("nirodha", "nirodha");
		sutra.addInflectedWord("saṃskāra", "saṃskārayoḥ");
		sutra.addInflectedWord("abhibhava", "abhibhava");
		sutra.addInflectedWord("prādurbhāva", "prādurbhāvau");
		sutra.addInflectedWord("kṣaṇa", "kṣaṇa");
		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("anvaya", "anvayaḥ");
		sutra.addInflectedWord("pariṇāma", "pariṇāmaḥ");

		sutra.setSyntaxTranslationDE(
				"Wachsende Kontrolle der Eindrücke, die Verschwinden und Erscheinen, ein Beherrschungaugenblick-Geist-Verbindung ist Beherrschungsentwicklung");
		sutra.setSemanticTranslationDE(
				"Erst wächst die Kontrolle über das Verschwinden und Erscheinen von Eindrücken. Dann kommen Augenblicke der Beherrschung des Geistes. So entwickelt sich Geisteskontrolle.");

		vibhutiPada.add(sutra);

		// 10
		sutra = new Sutra("तस्य प्रशान्तवाहिता संस्कारात्", "", "tasya praśāntavāhitā saṃskārāt", "", "tasya praśānta-vāhitā saṃskārāt", "");

		sutra.addInflectedWord("ta", "tasya");
		sutra.addInflectedWord("praśānta", "praśānta");
		sutra.addInflectedWord("vāhitā", "vāhitā");
		sutra.addInflectedWord("saṃskāra", "saṃskārāt");

		sutra.setSyntaxTranslationDE("Dessen ruhiger Fluß (kommt) durch Training.");
		sutra.setSemanticTranslationDE("Durch Training stellt sich ein ruhiger Fluss ein.");

		vibhutiPada.add(sutra);

		// 11
		sutra = new Sutra("सर्वार्थतैकाग्रतयोः क्षयोदयौ चित्तस्य समाधिपरिणामः", "", "sarvārthataikāgratayoḥ kṣayodayau cittasya samādhipariṇāmaḥ", "",
				"sarva-artha-ta-ekāgratayoḥ kṣayo-udayau cittasya samādhi-pariṇāmaḥ", "");

		sutra.addInflectedWord("artha", "artha");
		sutra.addInflectedWord("ekāgratā", "ekāgratayoḥ");
		sutra.addInflectedWord("kṣaya", "kṣayo");
		sutra.addInflectedWord("udaya", "udayau");
		sutra.addInflectedWord("citta", "cittasya");
		sutra.addInflectedWord("samādhi", "samādhi");
		sutra.addInflectedWord("pariṇāma", "pariṇāmaḥ");
		sutra.addInflectedWord("sarva", "sarva");
		sutra.addInflectedWord("ta", "ta");

		sutra.setSyntaxTranslationDE("Aller Objekten bzw. Einpünktigkeit , Verminderung bzw. Auftreten des Denkens ist Bewußtseinszustandsentwicklung.");
		sutra.setSemanticTranslationDE(
				"Verminderung des Denkens an viele Objekte und Erhöhen des zielgerichteten Denkens auf einen Punkt entwickelt das Bewußtsein zum Samadhi.");
		sutra.setCommentContentDE("Jeweils das erste bzw. zweite Wort der Duale gehört zusammen, also sarva-artha-ta zu kṣaya und ekāgratā zu udaya .");
		vibhutiPada.add(sutra);

		// 12
		sutra = new Sutra("ततः पुनः शान्तोदितौ तुल्यप्रत्ययश् चित्तस्यैकाग्रतापरिणामः", "", "tataḥ punaḥ  śāntoditau tulyapratyayaś cittasyaikāgratāpariṇāmaḥ",
				"", "tataḥ punaḥ śānta-uditau tulya-pratyayaḥ cittasya-ekāgratā-pariṇāmaḥ", "");

		sutra.addInflectedWord("ta", "tataḥ");
		sutra.addInflectedWord("punar", "punaḥ");
		sutra.addInflectedWord("śānta", "śānta");
		sutra.addInflectedWord("udita", "uditau");
		sutra.addInflectedWord("tulya", "tulya");
		sutra.addInflectedWord("pratyaya", "pratyayaḥ");
		sutra.addInflectedWord("citta", "cittasya");
		sutra.addInflectedWord("ekāgratā", "ekāgratā");
		sutra.addInflectedWord("pariṇāma", "pariṇāmaḥ");

		sutra.setSyntaxTranslationDE(
				"An der Stelle wo sich von neuem aufkommende beruhigt haben, gleiche Wahrnehmung ist, ist Entwicklung der Einpünktigkeit der Gedanken.");
		sutra.setSemanticTranslationDE(
				"Sobald neu aufkommende Gedanken ruhig sind, gleiche Wahrnehmung der Gedanken vorliegt, hat man Einpünktigkeit der Gedanken entwickelt.");

		vibhutiPada.add(sutra);

		// 13
		sutra = new Sutra("एतेन भूतेन्द्रियेषु धर्मलक्षणावस्थापरिणामा व्याख्याताः", "", "etena bhūtendriyeṣu dharmalakṣaṇāvasthāpariṇāmā vyākhyātāḥ", "",
				"etena bhūta-indriyeṣu dharma-lakṣaṇa-avasthā-pariṇāmāḥ vyākhyā-tāḥ", "");

		sutra.addInflectedWord("bhūta", "bhūta");
		sutra.addInflectedWord("indriya", "indriyeṣu");
		sutra.addInflectedWord("dharma", "dharma");
		sutra.addInflectedWord("lakṣaṇa", "lakṣaṇa");
		sutra.addInflectedWord("avasthā", "avasthā");
		sutra.addInflectedWord("pariṇāma", "pariṇāmāḥ");
		sutra.addInflectedWord("vyākhyā", "vyākhyātāḥ");
		sutra.addInflectedWord("etad", "etad");
		// sutra.addInflectedWord("ta", "tāḥ");

		sutra.setSyntaxTranslationDE("Auf diese Weise sind Natur-, Merkmals- und  Zustandsentwicklungen  in den Elementen und Sinnesorganen  erklärt.");
		sutra.setSemanticTranslationDE(
				"Dies sind die Erklärungen für Entwicklungen im Wesen, den Merkmalen und Zuständen von Objekten und Sinneswahrnehmungen.");

		vibhutiPada.add(sutra);

		// 14
		sutra = new Sutra("शान्तोदिताव्यपदेश्यधर्मानुपाती धर्मी", "", "śāntoditāvyapadeśyadharmānupātī dharmī", "",
				"śānta-udita-avyapadeśya-dharma-anupātī dharmī", "");

		sutra.addInflectedWord("śānta", "śānta");
		sutra.addInflectedWord("udita", "udita");
		sutra.addInflectedWord("avyapadeśya", "avyapadeśya");
		sutra.addInflectedWord("dharma", "dharma");
		sutra.addInflectedWord("anupātin", "anupātī");
		sutra.addInflectedWord("dharmin", "dharmī");

		sutra.setSyntaxTranslationDE("Erloschene, aufgekommene, undefinierbare Natur (eines Objekts) folgend ihrer Art und Weise");
		sutra.setSemanticTranslationDE("Vergangen, gegenwärtig oder zukünftig, die Natur eines Objekts bleibt gleich.");

		vibhutiPada.add(sutra);

		// 15
		sutra = new Sutra("क्रमान्यत्वं परिणामान्यत्वे हेतुः", "", "kramānyatvaṃ pariṇāmānyatve hetuḥ", "", "krama-anyatvam pariṇāma-anyatve hetuḥ", "");

		sutra.addInflectedWord("krama", "krama");
		sutra.addInflectedWord("anyatva", "anyatvam");
		sutra.addInflectedWord("pariṇāma", "pariṇāma");
		sutra.addInflectedWord("anyatva", "anyatve");
		sutra.addInflectedWord("hetu", "hetuḥ");

		sutra.setSyntaxTranslationDE("Ein unterschiedlicher Schritt ist für unterschiedliche Umwandlungen die Ursache.");
		sutra.setSemanticTranslationDE("Aus einer kleinen Veränderung entwickeln sich größere Unterschiede.");

		vibhutiPada.add(sutra);

		// 16
		sutra = new Sutra("परिणामत्रयसंयमाद् अतीतानागतज्ञानम्", "", "pariṇāmatrayasaṃyamād atītānāgatajñānam", "",
				"pariṇāma-traya-saṃyamāt atīta-anāgata-jñānam", "");

		sutra.addInflectedWord("pariṇāma", "pariṇāma");
		sutra.addInflectedWord("traya", "traya");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");
		sutra.addInflectedWord("atīta", "atīta");
		sutra.addInflectedWord("anāgata", "anāgata");
		sutra.addInflectedWord("jñāna", "jñānam");

		sutra.setSyntaxTranslationDE("Durch Bändigung der drei Umwandlungen entsteht Vergangenheits- und Zukunftswissen.");
		sutra.setSemanticTranslationDE(
				"Durch die Bändigung der drei Wandlungen (erlöschen[Vergangen], entstanden[gegenwärtig], undefinierbar[zukünftig]) entsteht Wissen über Vergangenheit und Zukunft.");

		vibhutiPada.add(sutra);

		// 17
		sutra = new Sutra("शब्दार्थप्रत्ययानाम् इतरेतराध्यासात् संकरस् तत्प्रविभागसंयमात् सर्वभूतरुतज्ञानम्", "",
				"śabdārthapratyayānām itaretarādhyāsāt saṃkaras tatpravibhāgasaṃyamāt sarvabhūtarutajñānam", "",
				"śabda-artha-pratyayānām itaretara-adhyāsāt saṃkaraḥ tat-pravibhāga-saṃyamāt sarva-bhūta-ruta-jñānam", "");

		sutra.addInflectedWord("śabda", "śabda");
		sutra.addInflectedWord("artha", "artha");
		sutra.addInflectedWord("pratyaya", "pratyayānām");
		sutra.addInflectedWord("itaretara", "itaretara");
		sutra.addInflectedWord("adhyāsa", "adhyāsāt");
		sutra.addInflectedWord("saṃkara", "saṃkaraḥ");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("pravibhāga", "pravibhāga");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");
		sutra.addInflectedWord("sarva", "sarva");
		sutra.addInflectedWord("bhūta", "bhūta");
		sutra.addInflectedWord("ruta", "ruta");
		sutra.addInflectedWord("jñāna", "jñānam");
		sutra.addInflectedWord("tat", "tat");

		sutra.setSyntaxTranslationDE(
				"Es gibt Vermischung von Klang, Objekt und Wahrnehmung durch gegenseitige Übertragung. Durch Bändigung der Teile ist Wissen aller seienden Töne.");
		sutra.setSemanticTranslationDE(
				"Klang, Objekt und Wahrnehmung beeinflussen sich gegenseitig und vermischen sich. Durch Bändigung der einzelnen Teile kommt die wahre Erkenntnis aller Töne.");

		vibhutiPada.add(sutra);

		// 18
		sutra = new Sutra("संस्कारसाक्षात्करणात् पूर्वजातिज्ञानम्", "", "saṃskārasākṣātkaraṇāt pūrvajātijñānam", "", "saṃskāra-sākṣātkaraṇāt pūrvajāti-jñānam",
				"");

		sutra.addInflectedWord("saṃskāra", "saṃskāra");
		sutra.addInflectedWord("sākṣātkaraṇa", "sākṣātkaraṇāt");
		sutra.addInflectedWord("pūrvajāti", "pūrvajāti");
		sutra.addInflectedWord("jñāna", "jñānam");

		sutra.setSyntaxTranslationDE("Durch die Eindrucksschau entsteht Wissen über das frühere Leben.");
		sutra.setSemanticTranslationDE("Durch die Schau der Eindrücke erkennt man sein früheres Leben.");

		vibhutiPada.add(sutra);

		// 19
		sutra = new Sutra("प्रत्ययस्य परचित्तज्ञानम्", "", "pratyayasya paracittajñānam", "", "pratyayasya para-citta-jñānam", "");

		sutra.addInflectedWord("pratyaya", "pratyayasya");
		sutra.addInflectedWord("para", "para");
		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("jñāna", "jñānam");

		sutra.setSyntaxTranslationDE("(Samyama)der Wahrnehmungen gibt Wissen eines anderen Bewusstseins");
		sutra.setSemanticTranslationDE("Durch Samyama auf die Wahrnehmungen eines anderen erreicht man Wissen über seinen Geist.");

		vibhutiPada.add(sutra);

		// 20
		sutra = new Sutra("न च तत्सालम्बनं तस्याविषयीभूतत्वात्", "", "na ca tatsālambanaṃ tasyāviṣayībhūtatvāt", "",
				"na ca tat-sālambanam tasya-aviṣayībhūta-tvāt", "");

		sutra.addInflectedWord("sālambana", "sālambanam");
		sutra.addInflectedWord("tat", "tasya");
		sutra.addInflectedWord("aviṣayībhūta", "aviṣayībhūta");
		sutra.addInflectedWord("tva", "tvāt");
		sutra.addInflectedWord("na", "na");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Auch ist keine (Verbindung zwischen) dieser geistige Übung und der Herrschaft über dessen Gegenstand.");
		sutra.setSemanticTranslationDE("Es besteht keine Verbindung zwischen der Übung und der Beherrschung des Objekts.");

		vibhutiPada.add(sutra);

		// 21
		sutra = new Sutra("कायरूपसंयमात् तद्ग्राह्यशक्तिस्तम्भे चक्षुःप्रकाशासंप्रयोगे ऽन्तर्धानम्", "",
				"kāyarūpasaṃyamāt tadgrāhyaśaktistambhe cakṣuḥprakāśāsaṃ(pra)yoge 'ntardhānam", "",
				"kāya-rūpa-saṃyamāt tat-grāhya-śakti-stambhe cakṣuḥ-prakāśa-asaṃ(pra)yoge antardhānam", "");

		sutra.addInflectedWord("kāya", "kāya");
		sutra.addInflectedWord("rūpa", "rūpa");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("grāhya", "grāhya");
		sutra.addInflectedWord("śakti", "śakti");
		sutra.addInflectedWord("stambha", "stambhe");
		sutra.addInflectedWord("cakṣu", "cakṣuḥ");
		sutra.addInflectedWord("prakāśa", "prakāśa");
		sutra.addInflectedWord("asaṃprayoga", "asaṃprayoge");
		sutra.addInflectedWord("antardhāna", "antardhānam");
		sutra.addInflectedWord("tad", "tad");

		sutra.setSyntaxTranslationDE(
				"Durch Leibesformbeherrschung wird die dies begreifende Kraft gehemmt. Die Licht-Auge-Nichtverbindung ist Unsichtbarkeit.");
		sutra.setSemanticTranslationDE(
				"Durch Beherrschung der Körperform wird die ihn wahrnehmende Kraft gehemmt. Es gibt keine Verbindung zwischen Licht und Auge. Unsichtbarkeit ist erreicht.");

		vibhutiPada.add(sutra);

		// 22
		sutra = new Sutra("सोपक्रमं निरुपक्रमं च कर्म तत्संयमाद् अपरान्तज्ञानम् अरिष्टेभ्यो वा", "",
				"sopakramaṃ nirupakramaṃ ca karma tatsaṃyamād aparāntajñānam ariṣṭebhyo vā", "",
				"sopakramam nirupakramam ca karma tat-saṃyamāt aparānta-jñānam ariṣṭebhyaḥ vā", "");

		sutra.addInflectedWord("sopakrama", "sopakramam");
		sutra.addInflectedWord("nirupakrama", "nirupakramam");
		sutra.addInflectedWord("karma", "karma");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");
		sutra.addInflectedWord("aparānta", "aparānta");
		sutra.addInflectedWord("jñāna", "jñānam");
		sutra.addInflectedWord("ariṣṭa", "ariṣṭebhyaḥ");
		sutra.addInflectedWord("vā", "vā");
		sutra.addInflectedWord("karman", "karman");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE(
				"Handlung wozu man etwas tut und wozu man nichts tut, durch Bändigung darauf erfolgt Todeswissen oder durch Todessymbole.");
		sutra.setSemanticTranslationDE("Durch Samyama auf aktive und passive Taten oder durch Todessymbole erhält man Wissen über seinen zukünftigen Tod.");

		vibhutiPada.add(sutra);

		// 23
		sutra = new Sutra("मैत्र्यादिषु बलानि", "", "maitryādiṣu balāni", "", "maitrī-ādiṣu balāni", "");

		sutra.addInflectedWord("maitrī", "maitrī");
		sutra.addInflectedWord("ādi", "ādiṣu");
		sutra.addInflectedWord("bala", "balāni");

		sutra.setSyntaxTranslationDE("Freundlichkeitsbeginn bringt Kraft");
		sutra.setSemanticTranslationDE("(Durch Samyama auf) die Ursache von Freudlichkeit wird sie gekräftigt.");

		vibhutiPada.add(sutra);

		// 24
		sutra = new Sutra("बलेषु हस्तिबलादीनि", "", "baleṣu hastibalādīni", "", "baleṣu hasti-bala-ādīni", "");

		sutra.addInflectedWord("bala", "baleṣu");
		sutra.addInflectedWord("hastin", "hasti");
		sutra.addInflectedWord("bala", "bala");
		sutra.addInflectedWord("ādi", "ādīni");

		sutra.setSyntaxTranslationDE("Die Elefantenkraft bei Kraftbeginn");
		sutra.setSemanticTranslationDE("Große Kraft erreicht man bei Samyama auf die Ursache der Kraft.");

		vibhutiPada.add(sutra);

		// 25
		sutra = new Sutra("प्रवृत्त्यालोकन्यासात् सूक्ष्मव्यवहितविप्रकृष्टज्ञानम्", "", "pravṛttyālokanyāsāt sūkṣmavyavahitaviprakṛṣṭajñānam", "",
				"pravṛtti-āloka-nyāsāt sūkṣma-vyavahita-viprakṛṣṭa-jñānam", "");

		sutra.addInflectedWord("pravṛtti", "pravṛtti");
		sutra.addInflectedWord("āloka", "āloka");
		sutra.addInflectedWord("nyāsa", "nyāsāt");
		sutra.addInflectedWord("sūkṣma", "sūkṣma");
		sutra.addInflectedWord("vyavahita", "vyavahita");
		sutra.addInflectedWord("viprakṛṣṭa", "viprakṛṣṭa");
		sutra.addInflectedWord("jñāna", "jñānam");

		sutra.setSyntaxTranslationDE("Aus Entsagung hervorkommenden Lichts wird Wissen über Feines, Verborgenes, Entferntes.");
		sutra.setSemanticTranslationDE("Bei Samyama auf den Ursprung von Licht erhält man Wissen über Feines, Verborgenes, Entferntes.");

		vibhutiPada.add(sutra);

		// 26
		sutra = new Sutra("भुवनज्ञानं सूर्यसंयमात्", "", "bhuvanajñānaṃ sūryasaṃyamāt", "", "bhuvana-jñānam sūrya-saṃyamāt", "");

		sutra.addInflectedWord("bhuvana", "bhuvana");
		sutra.addInflectedWord("jñāna", "jñānam");
		sutra.addInflectedWord("sūrya", "sūrya");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");

		sutra.setSyntaxTranslationDE("Weltwissen durch Sonnensamyama.");
		sutra.setSemanticTranslationDE("Durch Samyama auf die Sonne erhält man Wissen über die Welt (die Dinge).");

		vibhutiPada.add(sutra);

		// 27
		sutra = new Sutra("चन्द्रे ताराव्यूहज्ञानम्", "", "candre tārāvyūhajñānam", "", "candre tārā-vyūha-jñānam", "");

		sutra.addInflectedWord("candra", "candre");
		sutra.addInflectedWord("tāra", "tārā");
		sutra.addInflectedWord("vyūha", "vyūha");
		sutra.addInflectedWord("jñāna", "jñānam");

		sutra.setSyntaxTranslationDE("Auf den Mond (gerichtet), Sternverteilungswissen.");
		sutra.setSemanticTranslationDE("Samyama auf den Mond bringt astrologisches (astronomisches) Wissen.");

		vibhutiPada.add(sutra);

		// 28
		sutra = new Sutra("ध्रुवे तद्गतिज्ञानम्", "", "dhruve tadgatijñānam", "", "dhruve tad-gati-jñānam", "");

		sutra.addInflectedWord("dhruva", "dhruve");
		sutra.addInflectedWord("gati", "gati");
		sutra.addInflectedWord("jñāna", "jñānam");
		sutra.addInflectedWord("tad", "tad");

		sutra.setSyntaxTranslationDE("Auf den Polarstern, Wissen über seinen Weg.");
		sutra.setSemanticTranslationDE("Samyama auf den Polarstern bring Wissen über die Sternenbewegung.");

		vibhutiPada.add(sutra);

		// 29
		sutra = new Sutra("नाभिचक्रे कायव्यूहज्ञानम्", "", "nābhicakre kāyavyūhajñānam", "", "nābhicakre kāya-vyūha-jñānam", "");

		sutra.addInflectedWord("nābhicakra", "nābhicakre");
		sutra.addInflectedWord("kāya", "kāya");
		sutra.addInflectedWord("vyūha", "vyūha");
		sutra.addInflectedWord("jñāna", "jñānam");

		sutra.setSyntaxTranslationDE("Auf den Nabel, Körperverteilungswissen.");
		sutra.setSemanticTranslationDE("Durch Samyama auf den Nabel erhält man Wissen über den Aufbau des Körpers.");

		vibhutiPada.add(sutra);

		// 30
		sutra = new Sutra("कण्ठकूपे क्षुत्पिपासानिवृत्तिः", "", "kaṇṭhakūpe kṣutpipāsānivṛttiḥ", "", "kaṇṭha-kūpe kṣut-pipāsā-nivṛttiḥ", "");

		sutra.addInflectedWord("kaṇṭha", "kaṇṭha");
		sutra.addInflectedWord("kūpa", "kūpe");
		sutra.addInflectedWord("kṣudh", "kṣut");
		sutra.addInflectedWord("pipāsā", "pipāsā");
		sutra.addInflectedWord("nivṛtti", "nivṛttiḥ");

		sutra.setSyntaxTranslationDE("Auf die Kehlgrube, Hunger und Durst verschwinden.");
		sutra.setSemanticTranslationDE("Durch Samyama auf die Kehlgrube verschwinden Hunger und Durst.");

		vibhutiPada.add(sutra);

		// 31
		sutra = new Sutra("कूर्मनाड्यां स्थैर्यम्", "", "kūrmanāḍyāṃ sthairyam", "", "kūrma-nāḍyām sthairyam", "");

		sutra.addInflectedWord("kūrma", "kūrma");
		sutra.addInflectedWord("nāḍī", "nāḍyām");
		sutra.addInflectedWord("sthairya", "sthairyam");

		sutra.setSyntaxTranslationDE("Auf den Schildkrötenkanal, Festigkeit");
		sutra.setSemanticTranslationDE("Samyama auf den Kurma-Nadi (feinstofflicher Rückenmarkskanal im Brustbereich) bringt Festigkeit.");

		vibhutiPada.add(sutra);

		// 32
		sutra = new Sutra("मूर्धज्योतिषि सिद्धदर्शनम्", "", "mūrdhajyotiṣi siddhadarśanam", "", "mūrdha-jyotiṣi siddha-darśanam", "");

		sutra.addInflectedWord("mūrdhan", "mūrdha");
		sutra.addInflectedWord("jyotis", "jyotiṣi");
		sutra.addInflectedWord("siddha", "siddha");
		sutra.addInflectedWord("darśana", "darśanam");

		sutra.setSyntaxTranslationDE("Auf das Schädellicht, Meistersicht");
		sutra.setSemanticTranslationDE("Samyama auf das Licht in der Schädeldecke bringt Visionen der bisherigen Meister.");

		vibhutiPada.add(sutra);

		// 33
		sutra = new Sutra("प्रातिभाद् वा सर्वम्", "", "prātibhād vā sarvam", "", "prātibhāt vā sarvam", "");

		sutra.addInflectedWord("prātibha", "prātibhāt");
		sutra.addInflectedWord("sarva", "sarvam");
		sutra.addInflectedWord("vā", "vā");

		sutra.setSyntaxTranslationDE("Oder auf das Göttliche, Alles.");
		sutra.setSemanticTranslationDE("Durch Samyama auf das Göttliche kommt alles Wissen.");

		vibhutiPada.add(sutra);

		// 34
		sutra = new Sutra("हृदये चित्तसंवित्", "", "hṛdaye cittasaṃvit", "", "hṛdaye citta-saṃvit }}", "");

		sutra.addInflectedWord("hṛdaya", "hṛdaye");
		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("saṃvid", "saṃvit");

		sutra.setSyntaxTranslationDE("Auf das Herz, Bewußtseinserkenntnis");
		sutra.setSemanticTranslationDE("Samyama auf das Herz bring Erkenntnis über das eigene Bewußtsein.");

		vibhutiPada.add(sutra);

		// 35
		sutra = new Sutra("सत्त्वपुरुषयोर् अत्यन्तासंकीर्णयोः प्रत्ययाविशेषः भोगः परार्थत्वात् स्वार्थसंयमात् पुरुषज्ञानम्", "",
				"sattvapuruṣayor atyantāsaṃkīrṇayoḥ pratyayāviśeṣaḥ bhogaḥ parārthatvāt svārthasaṃyamāt puruṣajñānam", "",
				"sattva-puruṣayoḥ atyanta-asaṃkīrṇayoḥ pratyaya-aviśeṣaḥ bhogaḥ para-artha-tvāt sva-artha-saṃyamāt puruṣa-jñānam", "");

		sutra.addInflectedWord("sattva", "sattva");
		sutra.addInflectedWord("puruṣa", "puruṣayoḥ");
		sutra.addInflectedWord("atyanta", "atyanta");
		sutra.addInflectedWord("asaṃkīrṇa", "asaṃkīrṇayoḥ");
		sutra.addInflectedWord("pratyaya", "pratyaya");
		sutra.addInflectedWord("aviśeṣa", "aviśeṣaḥ");
		sutra.addInflectedWord("bhoga", "bhogaḥ");
		sutra.addInflectedWord("para", "para");
		sutra.addInflectedWord("artha", "artha");
		sutra.addInflectedWord("tva", "tvāt");
		sutra.addInflectedWord("sva", "sva");
		sutra.addInflectedWord("artha", "artha");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");
		sutra.addInflectedWord("puruṣa", "puruṣa");
		sutra.addInflectedWord("jñāna", "jñānam");

		sutra.setSyntaxTranslationDE(
				"Rohfassung: der guten Seelen, der beständig nicht Vermischten (der drei Gunas Sattva, Rajas, Tamas?), deren Ununterschiedenheitswahrnehmung, diese Erfahrung (oder Genuß) als höchstes Ziel, durch Bindung des eigenen Ziels darauf (erhält man) Seelenwissen");

		vibhutiPada.add(sutra);

		// 36
		sutra = new Sutra("ततः प्रातिभश्रावणवेदनादर्शास्वादवार्त्ता जायन्ते", "", "tataḥ prātibhaśrāvaṇavedanādarśāsvādavārttā jāyante", "",
				"tataḥ prātibha-śrāvaṇa-vedana-ādarśa-āsvāda-vārttā jāyante", "");

		sutra.addInflectedWord("tatas", "tataḥ");
		sutra.addInflectedWord("prātibha", "prātibha");
		sutra.addInflectedWord("śrāvaṇa", "śrāvaṇa");
		sutra.addInflectedWord("vedana", "vedana");
		sutra.addInflectedWord("ādarśa", "ādarśa");
		sutra.addInflectedWord("āsvāda", "āsvāda");
		sutra.addInflectedWord("vārttā", "vārttā");
		sutra.addInflectedWord("jan", "jāyante");

		sutra.setSyntaxTranslationDE("Daraus entsteht göttliches Hören, Fühlen, Sehen, Geschmack und Geruch.");

		vibhutiPada.add(sutra);

		// 37
		sutra = new Sutra("ते समाधाव् उपसर्गा व्युत्थाने सिद्धयः", "", "te samādhāv upasargā vyutthāne siddhayaḥ", "",
				"te samādhāu upasargā vyutthāne siddhayaḥ", "");

		sutra.addInflectedWord("tad", "te");
		sutra.addInflectedWord("samādhi", "samādhāu");
		sutra.addInflectedWord("upasarga", "upasargā");
		sutra.addInflectedWord("vyutthāna", "vyutthāne");
		sutra.addInflectedWord("siddhi", "siddhayaḥ");

		sutra.setSyntaxTranslationDE("Diese sind die Vereinigung störende Erscheinungen, es sind wachsende Zauberkräfte.");
		sutra.setSemanticTranslationDE("Diese wachsenden Kräfte sind störend für das Erreichen des meditativen Bewusstseinszustands.");

		vibhutiPada.add(sutra);

		// 38
		sutra = new Sutra("बन्धकारणशैथिल्यात् प्रचारसंवेदनाच् च चित्तस्य परशरीरावेशः", "",
				"bandhakāraṇaśaithilyāt pracārasaṃvedanāc ca cittasya paraśarīrāveśaḥ", "",
				"bandha-kāraṇa-śaithilyāt pracāra-saṃvedanāt ca cittasya para-śarīra-āveśaḥ", "");

		sutra.addInflectedWord("bandha", "bandha");
		sutra.addInflectedWord("kāraṇa", "kāraṇa");
		sutra.addInflectedWord("śaithilya", "śaithilyāt");
		sutra.addInflectedWord("pracāra", "pracāra");
		sutra.addInflectedWord("saṃvedana", "saṃvedanāt");
		sutra.addInflectedWord("citta", "cittasya");
		sutra.addInflectedWord("para", "para");
		sutra.addInflectedWord("śarīra", "śarīra");
		sutra.addInflectedWord("āveśa", "āveśaḥ");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE(
				"Durch Lockerung der Bindungsursachen und Bewußtwerdung des Heraustretens des Geistes (kann man) in einen anderen Körper eindringen.");
		sutra.setSemanticTranslationDE(
				"Durch Lockern der Bindungen des Geistes zum eigenen Körper und Erkennen, wie der Geist den Körper verlassen kann, kann man in einen anderen Körper eindringen.");

		vibhutiPada.add(sutra);

		// 39
		sutra = new Sutra("उदानजयाज् जलपङ्ककण्टकादिष्व् असङ्ग उत्क्रान्तिश् च", "", "udānajayāj jalapaṅkakaṇṭakādiṣv asaṅga utkrāntiś ca", "",
				"udāna-jayāt jala-paṅka-kaṇṭakā-ādiṣu asaṅga utkrāntiḥ ca", "");

		sutra.addInflectedWord("udāna", "udāna");
		sutra.addInflectedWord("jaya", "jayāt");
		sutra.addInflectedWord("jala", "jala");
		sutra.addInflectedWord("paṅka", "paṅka");
		sutra.addInflectedWord("kaṇṭaka", "kaṇṭakā");
		sutra.addInflectedWord("ādi", "ādiṣu");
		sutra.addInflectedWord("asaṅga", "asaṅga");
		sutra.addInflectedWord("utkrānti", "utkrāntiḥ");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Durch Udāna-Besiegung ist ein Nichthängenbleiben und Heraustreten, wo Wasser, Schlamm und Dornen beginnen.");
		sutra.setSemanticTranslationDE(
				"Beherrscht man das Udana-Prana, haften Wasser, Schlamm und Dornen nicht an einem und man kann aus ihnen unbeschadet wieder herauskommen.");

		vibhutiPada.add(sutra);

		// 40
		sutra = new Sutra("समानजयात् प्रज्वलनम्", "समानजयाज् ज्वलनम्", "samānajayāt prajvalanam", "samānajayāj jvalanam", "samāna-jayāt prajvalanam",
				"samāna-jayāt jvalanam");

		sutra.addInflectedWord("samāna", "samāna");
		sutra.addInflectedWord("jaya", "jayāt");
		sutra.addInflectedWord("prajvalana", "prajvalanam");

		sutra.setSyntaxTranslationDE("Durch Samāna-Besiegung Auflodern.");

		vibhutiPada.add(sutra);

		// 41
		sutra = new Sutra("श्रोत्राकाशयोः सम्बन्धसंयमाद् दिव्यं श्रोत्रम्", "", "śrotrākāśayoḥ sambandhasaṃyamād divyaṃ śrotram", "",
				"śrotra-ākāśayoḥ sambandha-saṃyamāt divyam śrotram", "");

		sutra.addInflectedWord("śrotra", "śrotra");
		sutra.addInflectedWord("ākāśa", "ākāśayoḥ");
		sutra.addInflectedWord("sambandha", "sambandha");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");
		sutra.addInflectedWord("divya", "divyam");
		sutra.addInflectedWord("śrotra", "śrotram");

		sutra.setSyntaxTranslationDE("Durch Bändigung der Verbindung der beiden Ohrräume (entsteht) himmliches Gehör.");

		vibhutiPada.add(sutra);

		// 42
		sutra = new Sutra("कायाकाशयोः संबन्धसंयमाल्लघुतूलसमापत्तेश्चाकाशगमनम्", "", "kāyākāśayoḥ saṃbandhasaṃyamāllaghutūlasamāpatteścākāśagamanam", "",
				"kāya-ākāśayoḥ saṃbandha-saṃyamāt-laghu-tūla-samāpatteḥ-ca-ākāśa-gamanam", "");

		sutra.addInflectedWord("kāya", "kāya");
		sutra.addInflectedWord("ākāśa", "ākāśayoḥ");
		sutra.addInflectedWord("saṃbandha", "saṃbandha");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");
		sutra.addInflectedWord("laghu", "laghu");
		sutra.addInflectedWord("tūla", "tūla");
		sutra.addInflectedWord("samāpatti", "samāpatteḥ");
		sutra.addInflectedWord("ākāśa", "ākāśa");
		sutra.addInflectedWord("gamana", "gamanam");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Durch Samyama auf die Verbindung der Körperräume und durch Meditation auf leichte Baumwolle, Raumbewegung.");

		vibhutiPada.add(sutra);

		// 43
		sutra = new Sutra("बहिरकल्पिता वृत्तिर्महाविदेहा ततः प्रकाशावरणक्षयः", "", "bahirakalpitā vṛttirmahāvidehā tataḥ prakāśāvaraṇakṣayaḥ", "",
				"bahiḥ-akalpitā vṛttiḥ-mahā-videhā tataḥ prakāśa-āvaraṇa-kṣayaḥ", "");

		sutra.addInflectedWord("bahis", "bahiḥ");
		sutra.addInflectedWord("akalpita", "akalpitā");
		sutra.addInflectedWord("vṛtti", "vṛttiḥ");
		sutra.addInflectedWord("mahā", "mahā");
		sutra.addInflectedWord("videha", "videhā");
		sutra.addInflectedWord("ta", "tataḥ");
		sutra.addInflectedWord("prakāśa", "prakāśa");
		sutra.addInflectedWord("āvaraṇa", "āvaraṇa");
		sutra.addInflectedWord("kṣaya", "kṣayaḥ");

		sutra.setSyntaxTranslationDE("Der von außen, nicht (selbst) gemachte Gedanke, große Körperlosigkeit, dies ist Lichtverhüllungsverlust.");
		sutra.setSemanticTranslationDE(
				"Erreichen einen von außen kommende, nicht eigene Gedanken, hat man die große Körperlosigkeit erreicht und die Verhüllung des Lichts ist verschwunden.");

		vibhutiPada.add(sutra);

		// 44
		sutra = new Sutra("स्थूलस्वरूपसूक्ष्मान्वयार्थवत्त्वसंयमाद्भूतजयः", "", "sthūlasvarūpasūkṣmānvayārthavattvasaṃyamādbhūtajayaḥ", "",
				"sthūla-svarūpa-sūkṣma-anvaya-arthavattva-saṃyamāt-bhūta-jayaḥ", "");

		sutra.addInflectedWord("sthūla", "sthūla");
		sutra.addInflectedWord("svarūpa", "svarūpa");
		sutra.addInflectedWord("sūkṣma", "sūkṣma");
		sutra.addInflectedWord("anvaya", "anvaya");
		sutra.addInflectedWord("arthavattva", "arthavattva");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");
		sutra.addInflectedWord("bhūta", "bhūta");
		sutra.addInflectedWord("jaya", "jayaḥ");

		sutra.setSyntaxTranslationDE("Durch Samyama auf die Bedeutsamkeit der groben eigene Form, der feinen Verbindungen kommt Elementbesiegung");
		sutra.setSemanticTranslationDE("Durch Samyama auf die grobstofflichen Dinge und feinen Zusammenhänge beherrscht man die Elemente.");

		vibhutiPada.add(sutra);

		// 45
		sutra = new Sutra("ततो ऽणिमादिप्रादुर्भावः कायसंपद् तद्धर्मानभिघातश् च", "", "tato 'ṇimādiprādurbhāvaḥ kāyasaṃpad taddharmānabhighātaś ca", "",
				"tataḥ aṇima-ādi-prādurbhāvaḥ kāya-saṃpad tad-dharma-anabhighātaḥ ca", "");

		sutra.addInflectedWord("tatas", "tataḥ");
		sutra.addInflectedWord("aṇiman", "aṇima");
		sutra.addInflectedWord("ādi", "ādi");
		sutra.addInflectedWord("prādurbhāva", "prādurbhāvaḥ");
		sutra.addInflectedWord("kāya", "kāya");
		sutra.addInflectedWord("saṃpad", "saṃpad");
		sutra.addInflectedWord("tad", "tad");
		sutra.addInflectedWord("dharma", "dharma");
		sutra.addInflectedWord("anabhighāta", "anabhighātaḥ");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Dadurch kommt Feinheitsbeginn zum Vorschein, Körpererfolg und der Nichtangriff dieser Gesetze.");

		vibhutiPada.add(sutra);

		// 46
		sutra = new Sutra("रूपलावण्यबलवज्रसंहननत्वानि कायसम्पत्", "", "rūpalāvaṇyabalavajrasaṃhananatvāni kāyasampat", "",
				"rūpa-lāvaṇya-bala-vajra-saṃhanana-tvāni kāya-sampat", "");

		sutra.addInflectedWord("rūpa", "rūpa");
		sutra.addInflectedWord("lāvaṇya", "lāvaṇya");
		sutra.addInflectedWord("bala", "bala");
		sutra.addInflectedWord("vajra", "vajra");
		sutra.addInflectedWord("saṃhanana", "saṃhanana");
		sutra.addInflectedWord("tva", "tvāni");
		sutra.addInflectedWord("kāya", "kāya");
		sutra.addInflectedWord("saṃpad", "sampat");

		sutra.setSyntaxTranslationDE("Gestaltsschönheit, harte Donnerkeilskraft ist Körpererfolg.");

		sutra.setCommentContentDE("Hier die Erklärung des 'Körpererfolgs' aus dem vorhergehenden Sutra ");
		vibhutiPada.add(sutra);

		// 47
		sutra = new Sutra("ग्रहणस्वरूपास्मितान्वयार्थवत्त्वसंयमाद् इन्द्रियजयः", "", "grahaṇasvarūpāsmitānvayārthavattvasaṃyamād indriyajayaḥ", "",
				"grahaṇa-sva-rūpa-asmitā-anvaya-arthavattva-saṃyamāt indriya-jayaḥ", "");

		sutra.addInflectedWord("grahaṇa", "grahaṇa");
		sutra.addInflectedWord("sva", "sva");
		sutra.addInflectedWord("rūpa", "rūpa");
		sutra.addInflectedWord("asmitā", "asmitā");
		sutra.addInflectedWord("anvaya", "anvaya");
		sutra.addInflectedWord("arthavattva", "arthavattva");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");
		sutra.addInflectedWord("indriya", "indriya");
		sutra.addInflectedWord("jaya", "jayaḥ");

		sutra.setSyntaxTranslationDE(
				"Durch Samyama auf die Bedeutsamkeit der Verbindung der Wahrnehmung der eigenen Form und des Ich-Bewußtseins (kommt) Sinnesbesiegung");
		sutra.setSemanticTranslationDE(
				"Durch Samyama auf den Zusammenhang zwischen der Wahrnehmung von sich selbst und dem Ich-Bewußtsein beherrscht man die Sinne.");

		vibhutiPada.add(sutra);

		// 48
		sutra = new Sutra("ततो मनोजवित्वं विकरणभावः प्रधानजयश् च", "", "tato manojavitvaṃ vikaraṇabhāvaḥ pradhānajayaś ca", "",
				"tataḥ manojavitvam vikaraṇa-bhāvaḥ pradhāna-jayaḥ ca", "");

		sutra.addInflectedWord("tatas", "tataḥ");
		sutra.addInflectedWord("manojavitva", "manojavitvam");
		sutra.addInflectedWord("vikaraṇa", "vikaraṇa");
		sutra.addInflectedWord("bhāva", "bhāvaḥ");
		sutra.addInflectedWord("pradhāna", "pradhāna");
		sutra.addInflectedWord("jaya", "jayaḥ");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Dadurch Geistesschnelligkeit, veränderte Existenz und Verstandsbesiegung.");
		sutra.setSemanticTranslationDE("Dadurch erhält man einen flinken Geist, eine geänderte Existenz und beherrscht den Verstand.");

		vibhutiPada.add(sutra);

		// 49
		sutra = new Sutra("सत्त्वपुरुषान्यताख्यातिमात्रस्य सर्वभावाधिष्ठातृत्वं सर्वज्ञातृत्वं च", "",
				"sattvapuruṣānyatākhyātimātrasya sarvabhāvādhiṣṭhātṛtvaṃ sarvajñātṛtvaṃ ca", "",
				"sattva-puruṣa-anyatā-khyāti-mātrasya sarva-bhāva-adhiṣṭhātṛ-tvam sarva-jñātṛ-tvam ca", "");

		sutra.addInflectedWord("sattva", "sattva");
		sutra.addInflectedWord("puruṣa", "puruṣa");
		sutra.addInflectedWord("anyatā", "anyatā");
		sutra.addInflectedWord("khyāti", "khyāti");
		sutra.addInflectedWord("mātra", "mātrasya");
		sutra.addInflectedWord("sarva", "sarva");
		sutra.addInflectedWord("bhāva", "bhāva");
		sutra.addInflectedWord("adhiṣṭhātṛ", "adhiṣṭhātṛ");
		sutra.addInflectedWord("tva", "tvam");
		sutra.addInflectedWord("sarva", "sarva");
		sutra.addInflectedWord("jñātṛ", "jñātṛ");
		sutra.addInflectedWord("tva", "tvam");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE(
				"Die Erkenntnis des Unterschiedsausmaßes zwischen (reinem) Wesen und Seele bringt Herrschaft über alles Existierende und allen Wissens.");

		vibhutiPada.add(sutra);

		// 50
		sutra = new Sutra("तद्वैराग्याद् अपि दोषबीजक्षये कैवल्यम्", "", "tadvairāgyād api doṣabījakṣaye kaivalyam", "",
				"tat-vairāgyāt api doṣa-bīja-kṣaye kaivalyam", "");

		sutra.addInflectedWord("tad", "tat");
		sutra.addInflectedWord("vairāgya", "vairāgyāt");
		sutra.addInflectedWord("doṣa", "doṣa");
		sutra.addInflectedWord("bīja", "bīja");
		sutra.addInflectedWord("kṣaya", "kṣaye");
		sutra.addInflectedWord("kaivalya", "kaivalyam");
		sutra.addInflectedWord("api", "api");

		sutra.setSyntaxTranslationDE("Durch Gleichmut diesem gegenüber sogar da wo Sündensamensverminderung, Glückseligkeit.");
		sutra.setSemanticTranslationDE("Durch Gleichmut diesem gegenüber und wo Sündenquellen verringert sind erreicht man Glückseligkeit.");

		vibhutiPada.add(sutra);

		// 51
		sutra = new Sutra("स्थान्युपनिमन्त्रणे सङ्गस्मयाकरणं पुनर् अनिष्टप्रसङ्गात्", "", "sthānyupanimantraṇe saṅgasmayākaraṇaṃ punar aniṣṭaprasaṅgāt", "",
				"sthāni-upanimantraṇe saṅga-smaya-akaraṇam punar aniṣṭa-prasaṅgāt", "");

		sutra.addInflectedWord("sthānin", "sthāni");
		sutra.addInflectedWord("upanimantraṇa", "upanimantraṇe");
		sutra.addInflectedWord("saṅga", "saṅga");
		sutra.addInflectedWord("smaya", "smaya");
		sutra.addInflectedWord("akaraṇa", "akaraṇam");
		sutra.addInflectedWord("punar", "punar");
		sutra.addInflectedWord("aniṣṭa", "aniṣṭa");
		sutra.addInflectedWord("prasaṅga", "prasaṅgāt");

		sutra.setSyntaxTranslationDE("Wo das Primitive einlädt, ist es natürlich das Hochmut haften bleibt, von neuem durch die schädliche Neigung.");

		vibhutiPada.add(sutra);

		// 52
		sutra = new Sutra("क्षणतत्क्रमयोः संयमाद् विवेकजं ज्ञानम्", "", "kṣaṇatatkramayoḥ saṃyamād vivekajaṃ jñānam", "",
				"kṣaṇa-tat-kramayoḥ saṃyamāt viveka-jam jñānam", "");

		sutra.addInflectedWord("kṣaṇa", "kṣaṇa");
		sutra.addInflectedWord("tad", "tat");
		sutra.addInflectedWord("krama", "kramayoḥ");
		sutra.addInflectedWord("saṃyama", "saṃyamāt");
		sutra.addInflectedWord("viveka", "viveka");
		sutra.addInflectedWord("ja", "jam");
		sutra.addInflectedWord("jñāna", "jñānam");

		sutra.setSyntaxTranslationDE("Durch Samyama dieser Augenblicksabfolge erreicht man Unterscheidungsgeburt und Wissen");

		vibhutiPada.add(sutra);

		// 53
		sutra = new Sutra("जातिलक्षणदेशैर् अन्यतानवच्छेदात् तुल्ययोस् ततः प्रतिपत्तिः", "", "jātilakṣaṇadeśair anyatānavacchedāt tulyayos tataḥ pratipattiḥ",
				"", "jāti-lakṣaṇa-deśaiḥ anyatā-anavacchedāt tulyayoḥ tataḥ pratipattiḥ", "");

		sutra.addInflectedWord("jāti", "jāti");
		sutra.addInflectedWord("lakṣaṇa", "lakṣaṇa");
		sutra.addInflectedWord("deśa", "deśaiḥ");
		sutra.addInflectedWord("anyatā", "anyatā");
		sutra.addInflectedWord("anavaccheda", "anavacchedāt");
		sutra.addInflectedWord("tulya", "tulyayoḥ");
		sutra.addInflectedWord("tatas", "tataḥ");
		sutra.addInflectedWord("pratipatti", "pratipattiḥ");

		sutra.setSyntaxTranslationDE(
				"Durch Nichtbestimmtsein von Unterschieden aufgrund von Geburt, Merkmal oder Ort von gleichartigen Dingen, daraus (kommt) Einsicht.");

		vibhutiPada.add(sutra);

		// 54
		sutra = new Sutra("तारकं सर्वविषयं सर्वथाविषयम् अक्रमं चेति विवेकजं ज्ञानम्", "", "tārakaṃ sarvaviṣayaṃ sarvathāviṣayam akramaṃ ceti vivekajaṃ jñānam",
				"", "tārakam sarva-viṣayam sarvathāviṣayam akramam ca-iti viveka-jam jñānam", "");

		sutra.addInflectedWord("tāraka", "tārakam");
		sutra.addInflectedWord("sarva", "sarva");
		sutra.addInflectedWord("viṣaya", "viṣayam");
		sutra.addInflectedWord("sarvathāviṣaya", "sarvathāviṣayam");
		sutra.addInflectedWord("akrama", "akramam");
		sutra.addInflectedWord("viveka", "viveka");
		sutra.addInflectedWord("ja", "jam");
		sutra.addInflectedWord("jñāna", "jñānam");
		sutra.addInflectedWord("ca", "ca");
		sutra.addInflectedWord("iti", "iti");

		sutra.setSyntaxTranslationDE(
				"Transzendiere alles Wahrnehmbare, auf jegliche Weise wahrnehmbares und verwirrendes, solche Unterscheidungsgeburt ist Wissen.");

		vibhutiPada.add(sutra);

		// 55
		sutra = new Sutra("सत्त्वपुरुषयोः शुद्धिसाम्ये कैवल्यम्", "", "sattvapuruṣayoḥ śuddhisāmye kaivalyam", "", "sattva-puruṣayoḥ śuddhi-sāmye kaivalyam",
				"");

		sutra.addInflectedWord("sattva", "sattva");
		sutra.addInflectedWord("puruṣa", "puruṣayoḥ");
		sutra.addInflectedWord("śuddhi", "śuddhi");
		sutra.addInflectedWord("sāmya", "sāmye");
		sutra.addInflectedWord("kaivalya", "kaivalyam");

		sutra.setSyntaxTranslationDE("Wo Läuterungsgleichheit von Wesen und Seele (herrscht) ist Glückseligkeit.");
		sutra.setSemanticTranslationDE("Wo durch Läuterung Gleichheit von Wesen und Seele eingetreten ist, ist Glückseligkeit.");

		vibhutiPada.add(sutra);

		// 56
		sutra = new Sutra("", "", "Ein zusätzliches Sutra ist in einigen Ausgaben vorhanden.", "", "Dies muss noch nachgetragen werden", "");

		sutra.setSyntaxTranslationDE("");

		vibhutiPada.add(sutra);

		// ---------------------
		// Kaivalya Pada
		// ---------------------

		// 0
		sutra = new Sutra("कैवल्य", "", "kaivalyapāda", "", "kaivalya-pāda", "");

		sutra.addInflectedWord("kaivalya", "kaivalya");
		sutra.addInflectedWord("pāda", "pāda");

		sutra.setSyntaxTranslationDE("Glückseligkeitskapitel");
		sutra.setSemanticTranslationDE("Drittes Kapitel: Glückseligkeit");

		kaivalyaPada.add(sutra);

		// 1
		sutra = new Sutra("जन्मौषधिमन्त्रतपःसमाधिजाः सिद्धयः", "", "janmauṣadhimantratapaḥsamādhijāḥ siddhayaḥ", "",
				"janma-oṣadhi-mantra-tapaḥ-samādhi-jāḥ siddhayaḥ", "");

		sutra.addInflectedWord("janma", "janma");
		sutra.addInflectedWord("oṣadhi", "oṣadhi");
		sutra.addInflectedWord("mantra", "mantra");
		sutra.addInflectedWord("tapas", "tapaḥ");
		sutra.addInflectedWord("samādhi", "samādhi");
		sutra.addInflectedWord("ja", "jāḥ");
		sutra.addInflectedWord("siddhi", "siddhayaḥ");

		sutra.setSyntaxTranslationDE("Geburt, Pflanzen, Mantras, Askese (bringen) Bewusstseinszustandsgeburt, Zauberkräfte");
		sutra.setSemanticTranslationDE(
				"Von Geburt aus oder durch Verwendung bestimmter Pflanzen, Mantras und Askese kann man einem veränderten Bewußtseinszustand und besondere Kräfte erhalten.");

		kaivalyaPada.add(sutra);

		// 2
		sutra = new Sutra("जात्यन्तरपरिणामः प्रकृत्यापूरात्", "", "jātyantarapariṇāmaḥ prakṛtyāpūrāt", "", "jāti-antara-pariṇāmaḥ prakṛti-āpūrāt", "");

		sutra.addInflectedWord("jāti", "jāti");
		sutra.addInflectedWord("antara", "antara");
		sutra.addInflectedWord("pariṇāma", "pariṇāmaḥ");
		sutra.addInflectedWord("prakṛti", "prakṛti");
		sutra.addInflectedWord("āpūra", "āpūrāt");

		sutra.setSyntaxTranslationDE("Geburtsverschiedene Entwicklung (entsteht) durch Formüberflutung.");
		sutra.setSemanticTranslationDE("Durch Überfluten seiner Form entwickelt man sich weiter.");
		sutra.setCommentContentDE(
				"Man füllt seine gegebenen Fähigkeiten aus, geht noch weiter, 'überflutet' und bricht damit den Damm zur nächsten Entwicklungsstufe.");
		sutra.setCommentStructureDE(
				"Das Überfluten wird im folgenden Vers weiter erläutert, daher auch die Übersetzung mit 'fluten' und nicht mit 'füllen'. }}  {{:Yogasutra-Analyse/ Vorlage:Seitenende}}");
		kaivalyaPada.add(sutra);

		// 3
		sutra = new Sutra("निमित्तमप्रयोजकं प्रकृतीनां वरणभेदस्तु ततः क्षेत्रिकवत्", "", "nimittamaprayojakaṃ prakṛtīnāṃ varaṇabhedastu tataḥ kṣetrikavat", "",
				"nimittam-aprayojakam prakṛtīnām varaṇa-bhedaḥ-tu tataḥ kṣetrika-vat", "");

		sutra.addInflectedWord("nimitta", "nimittam");
		sutra.addInflectedWord("aprayojaka", "aprayojakam");
		sutra.addInflectedWord("prakṛti", "prakṛtīnām");
		sutra.addInflectedWord("varaṇa", "varaṇa");
		sutra.addInflectedWord("bheda", "bhedaḥ");
		sutra.addInflectedWord("tatas", "tataḥ");
		sutra.addInflectedWord("kṣetrika", "kṣetrika");
		sutra.addInflectedWord("tu", "tu");
		sutra.addInflectedWord("vat", "vat");

		sutra.setSyntaxTranslationDE("Eine nicht hingehörende Bestimmung, der Naturen wallzerbrechende Stärke, wie ein Feldbesitzer.");
		sutra.setSemanticTranslationDE(
				"Steht etwas im Wege erfährt es die wallzerbrechende Stärke der Natur, wie auch ein Feldbesitzer (wenn seine Bewässerungsdämme überlaufen).");

		kaivalyaPada.add(sutra);

		// 4
		sutra = new Sutra("निर्माणचित्तान्यस्मितामात्रात्", "", "nirmāṇacittānyasmitāmātrāt", "", "nirmāṇa-cittāni-asmitā-mātrāt", "");

		sutra.addInflectedWord("nirmāṇa", "nirmāṇa");
		sutra.addInflectedWord("citta", "cittāni");
		sutra.addInflectedWord("asmitā", "asmitā");
		sutra.addInflectedWord("mātra", "mātrāt");

		sutra.setSyntaxTranslationDE("Geistesschaffung durch Ichbewußtseinssausmaß.");
		sutra.setSemanticTranslationDE("Der Geist wird durch das Ausmaß an Ichbewußtsein geschaffen.");

		kaivalyaPada.add(sutra);

		// 5
		sutra = new Sutra("प्रवृत्तिभेदे प्रयोजकं चित्तमेकमनेकेषाम्", "", "pravṛttibhede prayojakaṃ cittamekamanekeṣām", "",
				"pravṛtti-bhede prayojakam cittam-ekam-aneke-eṣām", "");

		sutra.addInflectedWord("pravṛtti", "pravṛtti");
		sutra.addInflectedWord("bheda", "bhede");
		sutra.addInflectedWord("prayojaka", "prayojakam");
		sutra.addInflectedWord("citta", "cittam");
		sutra.addInflectedWord("eka", "ekam");
		sutra.addInflectedWord("aneka", "aneke");
		sutra.addInflectedWord("eṣa", "eṣām");

		sutra.setSyntaxTranslationDE("Wo eine verschiedenen Tätigkeiten sind, der Urheber eines oder mehrerer Gedanken ist dieser.");

		sutra.setCommentContentDE("(Übersetzung überarbeiten) ");
		kaivalyaPada.add(sutra);

		// 6
		sutra = new Sutra("तत्र ध्यानजमनाशयम्", "", "tatra dhyānajamanāśayam", "", "tatra dhyāna-jam an-āśayam", "");

		sutra.addInflectedWord("dhyāna", "dhyāna");
		sutra.addInflectedWord("ja", "jam");
		sutra.addInflectedWord("āśaya", "āśayam");
		sutra.addInflectedWord("tatra", "tatra");
		sutra.addInflectedWord("an", "an");

		sutra.setSyntaxTranslationDE("Dort Meditationsgeborenen, ohne Gedanken.");

		kaivalyaPada.add(sutra);

		// 7
		sutra = new Sutra("कर्माशुक्लाकृष्णं योगिनस्त्रिविधमितरेषाम्", "", "karmāśuklākṛṣṇaṃ yoginastrividhamitareṣām", "",
				"karma-a-śukla-a-kṛṣṇam yoginaḥ-trividham-itareṣām", "");

		sutra.addInflectedWord("karman", "karma");
		sutra.addInflectedWord("śukla", "śukla");
		sutra.addInflectedWord("kṛṣṇa", "kṛṣṇam");
		sutra.addInflectedWord("yogin", "yoginaḥ");
		sutra.addInflectedWord("trividha", "trividham");
		sutra.addInflectedWord("itara", "itareṣām");
		sutra.addInflectedWord("a", "a");

		sutra.setSyntaxTranslationDE("Tat des Yogi ist nicht hell, nicht dunkel. (Tat) eines Anderen von drei Arten");
		sutra.setSemanticTranslationDE("Für einen Yogi sind alle Taten gleich, für andere haben sie eine von drei Qualitäten.");

		kaivalyaPada.add(sutra);

		// 8
		sutra = new Sutra("ततस्तद्विपाकानुगुणानामेवाभिव्यक्तिर्वासनानाम्", "", "tatastadvipākānuguṇānāmevābhivyaktirvāsanānām", "",
				"tataḥ-tad-vipāka-anuguṇānām-eva-abhivyaktiḥ-vāsanānām", "");

		sutra.addInflectedWord("ta", "tataḥ");
		sutra.addInflectedWord("vipāka", "vipāka");
		sutra.addInflectedWord("anuguṇa", "anuguṇānām");
		sutra.addInflectedWord("abhivyakti", "abhivyaktiḥ");
		sutra.addInflectedWord("vāsanā", "vāsanānām");
		sutra.addInflectedWord("eva", "eva");
		sutra.addInflectedWord("tad", "tad");
		sutra.addInflectedWord("tatas", "tatas");

		sutra.setSyntaxTranslationDE("Daraus die der reifenden Eigenschaften, wirklich die Offenbarwerdung der Neigungen");
		sutra.setSemanticTranslationDE("Mit der Zeit (der Reifung der Eigenschaften) werden so die eigenen Neigungen offenbar.");

		kaivalyaPada.add(sutra);

		// 9
		sutra = new Sutra("जातिदेशकालव्यवहितानामप्यानन्तर्यं स्मृतिसṃस्कारयोरेकरूपत्वात्", "",
				"jātideśakālavyavahitānāmapyānantaryaṃ smṛtisaṃskārayorekarūpatvāt", "",
				"jāti-deśa-kāla-vyavahitānām-api-ānantaryam smṛti-saṃskārayoḥ-eka-rūpa-tvāt", "");

		sutra.addInflectedWord("jāti", "jāti");
		sutra.addInflectedWord("deśa", "deśa");
		sutra.addInflectedWord("kāla", "kāla");
		sutra.addInflectedWord("vyavahita", "vyavahitānām");
		sutra.addInflectedWord("ānantarya", "ānantaryam");
		sutra.addInflectedWord("smṛti", "smṛti");
		sutra.addInflectedWord("saṃskāra", "saṃskārayoḥ");
		sutra.addInflectedWord("eka", "eka");
		sutra.addInflectedWord("rūpa", "rūpa");
		sutra.addInflectedWord("tva", "tvāt");
		sutra.addInflectedWord("api", "api");

		sutra.setSyntaxTranslationDE(
				"Der Geburtsrang-, Ort-, Zeitverhüllungen (zum Trotz bleibt) die unmittelbare Folge der Gedächtniseindrücke durch eine Wesenheit.");
		sutra.setSemanticTranslationDE(
				"Durch die eine Wesenheit hat man eine unmittelbare Folge von Gedächtniseindrücken, sogar bei Rang-, Ort- und Zeitänderungen.");

		kaivalyaPada.add(sutra);

		// 10
		sutra = new Sutra("तासामनादित्वं चाशिषो नित्यत्वात्", "", "tāsāmanāditvaṃ cāśiṣo nityatvāt", "", "tāsām-anādi-tvam ca-āśiṣo nitya-tvāt", "");

		sutra.addInflectedWord("ta", "tāsām");
		sutra.addInflectedWord("anādi", "anādi");
		sutra.addInflectedWord("tva", "tvam");
		sutra.addInflectedWord("āśis", "āśiṣo");
		sutra.addInflectedWord("nitya", "nitya");
		sutra.addInflectedWord("tva", "tvāt");
		sutra.addInflectedWord("tad", "tad");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Deren Anfangslosigkeit und durch Wunsch-Ewigkeit.");
		sutra.setSemanticTranslationDE("Sie sind anfangslos und durch (weitere) Wünsche ewig.");

		kaivalyaPada.add(sutra);

		// 11
		sutra = new Sutra("हेतुफलाश्रयालम्बनैः संगृहीतत्वादेषामभावे तदभावः", "", "hetuphalāśrayālambanaiḥ saṃgṛhītatvādeṣāmabhāve tadabhāvaḥ", "",
				"hetu-phala-āśraya-ālambanaiḥ saṃgṛhīta-tvāt-eṣām-abhāve tat-abhāvaḥ", "");

		sutra.addInflectedWord("hetu", "hetu");
		sutra.addInflectedWord("phala", "phala");
		sutra.addInflectedWord("āśraya", "āśraya");
		sutra.addInflectedWord("ālambana", "ālambanaiḥ");
		sutra.addInflectedWord("saṃgṛhīta", "saṃgṛhīta");
		sutra.addInflectedWord("tva", "tvāt");
		sutra.addInflectedWord("eṣa", "eṣām");
		sutra.addInflectedWord("abhāva", "abhāve");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("abhāva", "abhāvaḥ");
		sutra.addInflectedWord("tad", "tad");

		sutra.setSyntaxTranslationDE(
				"Durch Zusammenhalt mittels Ursache, Frucht, Basis und Unterstützung hat mein einen Wunsch, wo Abwesenheit (des Zusammenhalt ) das ist Abhāva.");
		sutra.setSemanticTranslationDE(
				"Wünsche werden durch Ursache, Ergebnis, Basis und Unterstützung zusammengehalten. Fehlt dieser spricht man von Abhāva, der Abwesenheit.");

		kaivalyaPada.add(sutra);

		// 12
		sutra = new Sutra("अतीतानागतं स्वरूपतोऽस्त्यध्वभेदाद्धर्माणाम्", "", "atītānāgataṃ svarūpato'styadhvabhedāddharmāṇām", "",
				"atīta-ānāgatam sva-rūpataḥ-asti-adhva-bhedāt-dharmāṇām", "");

		sutra.addInflectedWord("atīta", "atīta");
		sutra.addInflectedWord("anāgata", "ānāgatam");
		sutra.addInflectedWord("rūpa", "rūpataḥ");
		sutra.addInflectedWord("as", "asti");
		sutra.addInflectedWord("adhvan", "adhva");
		sutra.addInflectedWord("bheda", "bhedāt");
		sutra.addInflectedWord("dharma", "dharmāṇām");
		sutra.addInflectedWord("sva", "sva");

		sutra.setSyntaxTranslationDE("Vergangenheit, Zukunft , es ist die eigene Form in der Zeitverschiedenheit der Naturen.");
		sutra.setSemanticTranslationDE(
				"Die eigene Form bleibt konstant in Vergangenheit und Zukunft, auch wenn sie im Lauf der Zeit unterschiedliche Naturen annimmt.");

		kaivalyaPada.add(sutra);

		// 13
		sutra = new Sutra("ते व्यक्तसूक्ष्मा गुणात्मानः", "", "te vyaktasūkṣmā guṇātmānaḥ", "", "te vyakta-sūkṣmā guṇa-ātmānaḥ", "");

		sutra.addInflectedWord("ta", "te");
		sutra.addInflectedWord("vyakta", "vyakta");
		sutra.addInflectedWord("sūkṣma", "sūkṣmā");
		sutra.addInflectedWord("guṇa", "guṇa");
		sutra.addInflectedWord("ātman", "ātmānaḥ");

		sutra.setSyntaxTranslationDE("Diese wahrnehmbar (oder) unfassbar sind Guna-Essenz.");
		sutra.setSemanticTranslationDE("Sie sind die Essenz der Gunas, ob wahrnehmbar oder unfassbar.");

		kaivalyaPada.add(sutra);

		// 14
		sutra = new Sutra("परिणामैकत्वाद्वस्तुतत्त्वम्", "", "pariṇāmaikatvādvastutattvam", "", "pariṇāma-eka-tvāt-vastu-tattvam", "");

		sutra.addInflectedWord("pariṇāma", "pariṇāma");
		sutra.addInflectedWord("eka", "eka");
		sutra.addInflectedWord("tva", "tvāt");
		sutra.addInflectedWord("vastu", "vastu");
		sutra.addInflectedWord("tattva", "tattvam");

		sutra.setSyntaxTranslationDE("Durch die Einheitsentwicklung die Gegenstandsnatur.");
		sutra.setSemanticTranslationDE("Durch die Entwicklung zur Einheit erkennt man die wahre Natur eines Gegenstands.");

		kaivalyaPada.add(sutra);

		// 15
		sutra = new Sutra("वस्तुसाम्ये चित्तभेदात्तयोर्विविक्तः पन्थाः", "वस्तुसाम्ये चित्तभेदात्तयोर्विभक्तः पन्थाः",
				"vastusāmye cittabhedāttayorviviktaḥ panthāḥ (Alternativ vibhaktaḥ statt viviktaḥ", "", "vastu-sāmye citta-bhedāt-tayoḥ-viviktaḥ panthāḥ", "");

		sutra.addInflectedWord("vastu", "vastu");
		sutra.addInflectedWord("sāmya", "sāmye");
		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("bheda", "bhedāt");
		sutra.addInflectedWord("ta", "tayoḥ");
		sutra.addInflectedWord("vivic", "viviktaḥ");
		sutra.addInflectedWord("vibhakta", "vibhaktaḥ");
		sutra.addInflectedWord("path", "panthāḥ");

		sutra.setSyntaxTranslationDE("Wo Gegenstandsgleichheit durch Bewußtseinsverschiedenheit deren Unterschiede, die Pfade.");
		sutra.setSemanticTranslationDE("Durch die unterschiedlichen Bewußtseine werden Unterschiede, Pfade gesehen, obwohl der Gegendstand gleich ist.");

		kaivalyaPada.add(sutra);

		// 16
		sutra = new Sutra("न चैकचित्ततन्त्रं चेद्वस्तु तदप्रमाणकं तदा किं स्यात्", "", "na caikacittatantraṃ cedvastu tadapramāṇakaṃ tadā kiṃ syāt", "",
				"na ca-eka-citta-tantram ced-vastu tat-apramāṇa-kam tadā kim syāt", "");

		sutra.addInflectedWord("eka", "eka");
		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("tantra", "tantram");
		sutra.addInflectedWord("vastu", "vastu");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("apramāṇa", "apramāṇa");
		sutra.addInflectedWord("ka", "kam");
		sutra.addInflectedWord("ka", "kim");
		sutra.addInflectedWord("as", "syāt");
		sutra.addInflectedWord("na", "na");
		sutra.addInflectedWord("ced", "ced");
		sutra.addInflectedWord("tadā", "tadā");
		sutra.addInflectedWord("ca", "ca");
		sutra.addInflectedWord("syāt", "syāt");

		sutra.setSyntaxTranslationDE("Nicht auch eine (einzige) Geistesgrundlage, auch ein Gegenstand welcher so ohne Maß, was könnte es dann sein?");
		sutra.setSemanticTranslationDE("Was ist die Natur eines Gegenstands, der unvermessen und von keinem Bewußtsein bewertet ist?");

		kaivalyaPada.add(sutra);

		// 17
		sutra = new Sutra("तदुपरागापेक्षित्वाच्चित्तस्य वस्तु ज्ञाताज्ञातम्", "", "taduparāgāpekṣitvāccittasya vastu jñātājñātam", "",
				"tat-uparāga-apekṣi-tvāt-cittasya vastu jñāta-ajñātam", "");

		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("uparāga", "uparāga");
		sutra.addInflectedWord("apekṣin", "apekṣi");
		sutra.addInflectedWord("tva", "tvāt");
		sutra.addInflectedWord("citta", "cittasya");
		sutra.addInflectedWord("vastu", "vastu");
		sutra.addInflectedWord("jñāta", "jñāta");
		sutra.addInflectedWord("ajñāta", "ajñātam");

		sutra.setSyntaxTranslationDE("Durch die Verfärbungsberücksichtigung des Bewußtseins ist das Ding bekannt oder unbekannt");
		sutra.setSemanticTranslationDE("Je nachdem wie stark des Bewußtsein ein Ding wahrnimmt (verfärbt ist), ist es bekannt oder unbekannt.");

		kaivalyaPada.add(sutra);

		// 18
		sutra = new Sutra("सदाज्ञाताश्चित्तवृत्तयस्तत्प्रभोः पुरुषस्यापरिणामित्वात्", "", "sadājñātāścittavṛttayastatprabhoḥ puruṣasyāpariṇāmitvāt", "",
				"sadā-jñātāḥ-citta-vṛttayaḥ-tat-prabhoḥ puruṣasya-apariṇāmi-tvāt", "");

		sutra.addInflectedWord("sadā", "sadā");
		sutra.addInflectedWord("jñāta", "jñātāḥ");
		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("vṛtti", "vṛttayaḥ");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("prabhu", "prabhoḥ");
		sutra.addInflectedWord("puruṣa", "puruṣasya");
		sutra.addInflectedWord("apariṇāmin", "apariṇāmi");
		sutra.addInflectedWord("tva", "tvāt");

		sutra.setSyntaxTranslationDE("Alle Erkenntnis, das (erlangen) die Bewußtseinstätigkeiten durch Beherrschung, die Seele durch Wechsellosigkeit");
		sutra.setSemanticTranslationDE("Zur Erkenntnis gelangt das Bewußtseins durch Beherrschung, die Seele durch durch Konstanz.");

		kaivalyaPada.add(sutra);

		// 19
		sutra = new Sutra("न तत्स्वाभासं दृश्यत्वात्", "", "na tatsvābhāsaṃ dṛśyatvāt", "", "na tat-sva-ābhāsam dṛśya-tvāt", "");

		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("sva", "sva");
		sutra.addInflectedWord("ābhāsa", "ābhāsam");
		sutra.addInflectedWord("dṛśya", "dṛśya");
		sutra.addInflectedWord("tva", "tvāt");
		sutra.addInflectedWord("na", "na");

		sutra.setSyntaxTranslationDE("Nicht ist dies das eigene Licht, durch Sichtbarkeit.");
		sutra.setSemanticTranslationDE("Dies geschieht nicht durch das eigene Licht, sondern durch Sichtbarkeit.");

		kaivalyaPada.add(sutra);

		// 20
		sutra = new Sutra("एकसमये चोभयानवधारणम्", "", "ekasamaye cobhayānavadhāraṇam", "", "eka-samaye ca-ubhaya-an-avadhāraṇam", "");

		sutra.addInflectedWord("eka", "eka");
		sutra.addInflectedWord("samaya", "samaye");
		sutra.addInflectedWord("ubhaya", "ubhaya");
		sutra.addInflectedWord("avadhāraṇa", "avadhāraṇam");
		sutra.addInflectedWord("an", "an");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Wo eines ein Zusammentreffen und beide Nichtbestimmung sind.");

		kaivalyaPada.add(sutra);

		// 21
		sutra = new Sutra("चित्तान्तरदृश्ये बुद्धिबुद्धेरतिप्रसङ्गः स्मृतिसंकरश्च", "", "cittāntaradṛśye buddhibuddheratiprasaṅgaḥ smṛtisaṃkaraśca", "",
				"citta-antara-dṛśye buddhi-buddheḥ-atiprasaṅgaḥ smṛti-saṃkaraḥ-ca", "");

		sutra.addInflectedWord("citta", "citta");
		sutra.addInflectedWord("antara", "antara");
		sutra.addInflectedWord("dṛśya", "dṛśye");
		sutra.addInflectedWord("buddhi", "buddhi");
		sutra.addInflectedWord("buddhi", "buddheḥ");
		sutra.addInflectedWord("atiprasaṅga", "atiprasaṅgaḥ");
		sutra.addInflectedWord("smṛti", "smṛti");
		sutra.addInflectedWord("saṃkara", "saṃkaraḥ");
		sutra.addInflectedWord("ca", "ca");

		sutra.setSyntaxTranslationDE("Ein Bewußtseinsverschiedener Anblick ist Verstand-Verstandsabsurdität und Erinnerungsvermischung");
		sutra.setSemanticTranslationDE(
				"Ein vom Bewußtsein getrennte Wahrnehmung ist so absurd, wie einen Verstand durch einen anderen Verstand zu definieren und ist eine geistige Verwirrung.");

		kaivalyaPada.add(sutra);

		// 22
		sutra = new Sutra("चितेरप्रतिसंक्रमायास्तदाकारापत्तौ स्वबुद्धिसंवेदनम्", "", "citerapratisaṃkramāyāstadākārāpattau svabuddhisaṃvedanam", "",
				"citeḥ-aprati-saṃkramāyāḥ-tat-ākāra-āpattau sva-buddhi-saṃvedanam", "");

		sutra.addInflectedWord("cit", "citeḥ");
		sutra.addInflectedWord("aprati", "aprati");
		sutra.addInflectedWord("saṃkrama", "saṃkramāyāḥ");
		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("ākāra", "ākāra");
		sutra.addInflectedWord("āpatti", "āpattau");
		sutra.addInflectedWord("sva", "sva");
		sutra.addInflectedWord("buddhi", "buddhi");
		sutra.addInflectedWord("saṃveda", "saṃvedanam");

		sutra.setSyntaxTranslationDE("Der Wahrnehmung unwiderstehlicher Gang, diese Formumwandlung ist eigene Verstandsempfindung.");
		sutra.setSemanticTranslationDE("Geht die Wahrnehmung weiter, wandelt sich ihre Form, man nimmt den eigenen Verstand wahr.");

		kaivalyaPada.add(sutra);

		// 23
		sutra = new Sutra("द्रष्टृदृश्योपरक्तं चित्तं सर्वार्थम्", "", "draṣṭṛdṛśyoparaktaṃ cittaṃ sarvārtham", "",
				"draṣṭṛ-dṛśya-upa-raktam cittam sarva-artham", "");

		sutra.addInflectedWord("draṣṭṛ", "draṣṭṛ");
		sutra.addInflectedWord("dṛśya", "dṛśya");
		sutra.addInflectedWord("upa", "upa");
		sutra.addInflectedWord("rakta", "raktam");
		sutra.addInflectedWord("citta", "cittam");
		sutra.addInflectedWord("sarva", "sarva");
		sutra.addInflectedWord("artha", "artham");

		sutra.setSyntaxTranslationDE("Ein Seher der dem Sichtbaren nahe steht (erfährt) Abfärbung. Das Bewußtsein erkennt alle Sachen.");
		sutra.setSemanticTranslationDE("Steht der Wahrnehmende dem Objekt sehr nahe, erkennt es es genau und das Bewußtsein weiß alle Dinge.");

		kaivalyaPada.add(sutra);

		// 24
		sutra = new Sutra("तदसंख्येयवासनाभिश्चित्रमपि परार्थं संहत्यकारित्वात्", "", "tadasaṃkhyeyavāsanābhiścitramapi parārthaṃ saṃhatyakāritvāt", "",
				"tat-asaṃkhyeya-vāsanābhiḥ-citram-api para-artham saṃhatya-kāritvāt", "");

		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("asaṃkhya", "asaṃkhyeya");
		sutra.addInflectedWord("vāsana", "vāsanābhiḥ");
		sutra.addInflectedWord("citra", "citram");
		sutra.addInflectedWord("para", "para");
		sutra.addInflectedWord("artha", "artham");
		sutra.addInflectedWord("saṃhan", "saṃhatya");
		sutra.addInflectedWord("kārita", "kāritvāt");
		sutra.addInflectedWord("api", "api");
		sutra.addInflectedWord("tva", "tva");

		sutra.setSyntaxTranslationDE("Dies (macht) auch sichtbar die unzählbaren Hüllen und ein weiter hinausgehendes Objekt durch Verbindungsveranlassung");
		sutra.setSemanticTranslationDE(
				"Da so auch die unzählbaren Hüllen sichtbar werden, erkennt man durch Herstellen von Verbindungen auch komplexere Dinge.");

		kaivalyaPada.add(sutra);

		// 25
		sutra = new Sutra("विशेषदर्शिन आत्मभावभावनानिवृत्तिः", "", "viśeṣadarśina ātmabhāvabhāvanānivṛttiḥ", "", "viśeṣa-darśina ātmabhāva-bhāvanā-nivṛttiḥ",
				"");

		sutra.addInflectedWord("viśeṣa", "viśeṣa");
		sutra.addInflectedWord("darśin", "darśina");
		sutra.addInflectedWord("ātmabhāva", "ātmabhāva");
		sutra.addInflectedWord("bhāvana", "bhāvanā");
		sutra.addInflectedWord("nivṛtti", "nivṛttiḥ");

		sutra.setSyntaxTranslationDE("Unterschiedseinsicht hat Selbstwirkung, das Verschwinden.");
		sutra.setSemanticTranslationDE("Erkennt man diesen Unterschied, hat es Auswirkung auf das eigene Selbst, es veschwindet.");

		kaivalyaPada.add(sutra);

		// 26
		sutra = new Sutra("तदा विवेकनिम्नं कैवल्यप्राग्भारं चित्तम्", "", "tadā vivekanimnaṃ kaivalyaprāgbhāraṃ cittam", "",
				"tadā viveka-nimnam kaivalya-prāgbhāram cittam", "");

		sutra.addInflectedWord("viveka", "viveka");
		sutra.addInflectedWord("nimna", "nimnam");
		sutra.addInflectedWord("kaivalya", "kaivalya");
		sutra.addInflectedWord("prāgbhāra", "prāgbhāram");
		sutra.addInflectedWord("citta", "cittam");
		sutra.addInflectedWord("tadā", "tadā");

		sutra.setSyntaxTranslationDE("Dann hat das Bewußtsein Unterscheidungstiefe, den Glückseeligkeitsgipfel erreicht.");

		kaivalyaPada.add(sutra);

		// 27
		sutra = new Sutra("तच्छिद्रेषु प्रत्ययान्तराणि संस्कारेभ्यः", "", "tacchidreṣu pratyayāntarāṇi saṃskārebhyaḥ", "",
				"tat-chidreṣu pratyaya-antarāṇi saṃskārebhyaḥ", "");

		sutra.addInflectedWord("ta", "tat");
		sutra.addInflectedWord("chidra", "chidreṣu");
		sutra.addInflectedWord("pratyaya", "pratyaya");
		sutra.addInflectedWord("antara", "antarāṇi");
		sutra.addInflectedWord("saṃskāra", "saṃskārebhyaḥ");

		sutra.setSyntaxTranslationDE("Da sind Schwächen,wo Wahrnehmungsverschiedenheit durch Eindrücke");
		sutra.setSemanticTranslationDE("Schwächen darin sind noch da, wo durch vergangene Eindrücke fehlerhafte Wahrnehmungen sind.");

		kaivalyaPada.add(sutra);

		// 28
		sutra = new Sutra("हानमेषां क्लेशवदुक्तम्", "", "hānameṣāṃ kleśavaduktam", "", "hānam-eṣāṃ kleśa-vat-uktam", "");

		sutra.addInflectedWord("hāna", "hānam");
		sutra.addInflectedWord("eṣāḥ", "eṣāṃ");
		sutra.addInflectedWord("kleśa", "kleśa");
		sutra.addInflectedWord("ukta", "uktam");
		sutra.addInflectedWord("vat", "vat");

		sutra.setSyntaxTranslationDE("Deren Befreiung wie bei den kleśa gesagt.");
		sutra.setSemanticTranslationDE("Wie man davon frei wird, wurde bereits bei den Kleśa gesagt.");

		kaivalyaPada.add(sutra);

		// 29
		sutra = new Sutra("प्रसंख्यानेऽप्यकुसीदस्य सर्वथा विवेकख्यातेर्धर्ममेघः समाधिः", "",
				"prasaṃkhyāne'pyakusīdasya sarvathā vivekakhyāterdharmameghaḥ samādhiḥ", "",
				"prasaṃkhyāne api-akusīdasya sarvathā viveka-khyāteḥ-dharma-meghaḥ samādhiḥ", "");

		sutra.addInflectedWord("prasaṃkhyāna", "prasaṃkhyāne");
		sutra.addInflectedWord("akusīda", "akusīdasya");
		sutra.addInflectedWord("sarvathā", "sarvathā");
		sutra.addInflectedWord("viveka", "viveka");
		sutra.addInflectedWord("khyāti", "khyāteḥ");
		sutra.addInflectedWord("dharma", "dharma");
		sutra.addInflectedWord("megha", "meghaḥ");
		sutra.addInflectedWord("samādhi", "samādhiḥ");
		sutra.addInflectedWord("api", "api");

		sutra.setSyntaxTranslationDE("Nachdenken sogar, (ist man) vollständig ohne Interesse (dann) Unterscheidungseinsicht, Dharmawolke, Samadhi.");
		sutra.setSemanticTranslationDE(
				"Ist auch bei der Meditation kein Eigeninteresse mehr vorhanden, kommt Unterscheidungskraft, man erreicht die Dharmawolke und ist im Samadhi.");

		kaivalyaPada.add(sutra);

		// 30
		sutra = new Sutra("ततः क्लेशकर्मनिवृत्तिः", "", "tataḥ kleśakarmanivṛttiḥ", "", "tataḥ kleśa-karma-nivṛttiḥ", "");

		sutra.addInflectedWord("ta", "tataḥ");
		sutra.addInflectedWord("kleśa", "kleśa");
		sutra.addInflectedWord("karma", "karma");
		sutra.addInflectedWord("nivṛtti", "nivṛttiḥ");
		sutra.addInflectedWord("tatas", "tatas");

		sutra.setSyntaxTranslationDE("Daraus Leid-, Handlungsverschwinden.");
		sutra.setSemanticTranslationDE("Dann verschwinden Leid und karmische Handlungen.");

		kaivalyaPada.add(sutra);

		// 31
		sutra = new Sutra("तदा सर्वावरणमलापेतस्य ज्ञानस्यानन्त्याज्ज्ञेयम् अल्पम्", "", "tadā sarvāvaraṇamalāpetasya jñānasyānantyājjñeyam alpam", "",
				"tadā sarva-āvaraṇa-mala-apetasya jñānasya-ānantyāt-jñeyam alpam", "");

		sutra.addInflectedWord("sarva", "sarva");
		sutra.addInflectedWord("āvaraṇa", "āvaraṇa");
		sutra.addInflectedWord("mala", "mala");
		sutra.addInflectedWord("apeta", "apetasya");
		sutra.addInflectedWord("jñāna", "jñānasya");
		sutra.addInflectedWord("ānantya", "ānantyāt");
		sutra.addInflectedWord("jñeya", "jñeyam");
		sutra.addInflectedWord("alpa", "alpam");
		sutra.addInflectedWord("tadā", "tadā");

		sutra.setSyntaxTranslationDE("Dann von allen Verhüllungen und Schmutz befreiheit, (sieht man) durch Wissensendlosigkeit die geringe Erforschbarkeit.");
		sutra.setSemanticTranslationDE("Ist man von allen Illusionen befreit, erkennt man die geringe Erforschbarkeit, da das Wissen unendlich groß ist.");

		kaivalyaPada.add(sutra);

		// 32
		sutra = new Sutra("ततः कृतार्थानां परिणामक्रमसमाप्तिर्गुणानाम्", "", "tataḥ kṛtārthānāṃ pariṇāmakramasamāptirguṇānām", "",
				"tataḥ kṛtārthānām pariṇāma-krama-samāptiḥ-guṇānām", "");

		sutra.addInflectedWord("ta", "tataḥ");
		sutra.addInflectedWord("kṛtārtha", "kṛtārthānām");
		sutra.addInflectedWord("pariṇāma", "pariṇāma");
		sutra.addInflectedWord("krama", "krama");
		sutra.addInflectedWord("samāpti", "samāptiḥ");
		sutra.addInflectedWord("guṇa", "guṇānām");
		sutra.addInflectedWord("tatas", "tatas");

		sutra.setSyntaxTranslationDE("Diese Zielerreichung, Entwicklungsschrittende der Grundeigenschaften.");
		sutra.setSemanticTranslationDE("Ist dieses, das Ziel erreicht, ist man am Ende der Entwicklungschritte der Eigenschaften.");

		kaivalyaPada.add(sutra);

		// 33
		sutra = new Sutra("क्षणप्रतियोगी परिणामापरान्तनिर्ग्राह्यः क्रमः", "", "kṣaṇapratiyogī pariṇāmāparāntanirgrāhyaḥ kramaḥ", "",
				"kṣaṇa-pratiyogī pariṇāma-aparānta-nirgrāhyaḥ kramaḥ", "");

		sutra.addInflectedWord("kṣaṇa", "kṣaṇa");
		sutra.addInflectedWord("pratiyogin", "pratiyogī");
		sutra.addInflectedWord("pariṇāma", "pariṇāma");
		sutra.addInflectedWord("aparānta", "aparānta");
		sutra.addInflectedWord("nirgrāhya", "nirgrāhyaḥ");
		sutra.addInflectedWord("krama", "kramaḥ");

		sutra.setSyntaxTranslationDE("In Beziehung stehende Momente, Todesentwicklungserkenntnis, Abfolge.");
		sutra.setSemanticTranslationDE("Dann erkennt man wie einzelne Momente in Beziehung zueinander stehen, die Entwicklung zum Tod, denn Ablauf der Dinge.");

		kaivalyaPada.add(sutra);

		// 34
		sutra = new Sutra("पुरुषार्थशून्यानां गुणानां प्रतिप्रसवः कैवल्यं स्वरूपप्रतिष्ठा वा चितिशक्तिरिति", "",
				"puruṣārthaśūnyānāṃ guṇānāṃ pratiprasavaḥ kaivalyaṃ svarūpapratiṣṭhā vā citiśaktiriti", "",
				"puruṣārtha-śūnyānām guṇānām pratiprasavaḥ kaivalyam svarūpa-pratiṣṭhā vā citi-śaktiḥ-iti", "");

		sutra.addInflectedWord("puruṣārtha", "puruṣārtha");
		sutra.addInflectedWord("śūnya", "śūnyānām");
		sutra.addInflectedWord("guṇa", "guṇānām");
		sutra.addInflectedWord("pratiprasava", "pratiprasavaḥ");
		sutra.addInflectedWord("kaivalya", "kaivalyam");
		sutra.addInflectedWord("svarūpa", "svarūpa");
		sutra.addInflectedWord("pratiṣṭhā", "pratiṣṭhā");
		sutra.addInflectedWord("citi", "citi");
		sutra.addInflectedWord("śakti", "śaktiḥ");
		sutra.addInflectedWord("vā", "vā");
		sutra.addInflectedWord("iti", "iti");

		sutra.setSyntaxTranslationDE(
				"Die Aufhebung der Seelenleere,  der Grundeigenschaften ist der Zustand höchster Glückseligkeit oder der Ruhezustand der eigenen Natur. So ist die Geisteskraft.");

		kaivalyaPada.add(sutra);

	}

	public String plainText() throws Exception {
		StringBuilder result = new StringBuilder();
		result.append("\n\n");
		result.append("\n\n");
		TextBoostUtils.appendLine(result, "------------");
		result.append("\n\n");
		result.append("\n\n");
		TextBoostUtils.appendLine(result, "Samadhi Pada");
		TextBoostUtils.appendLine(result, "------------");
		plainText(result, samadhiPada);
		result.append("\n\n");
		TextBoostUtils.appendLine(result, "Sadhana Pada");
		TextBoostUtils.appendLine(result, "------------");
		plainText(result, sadhanaPada);
		result.append("\n\n");
		TextBoostUtils.appendLine(result, "Vibhuti Pada");
		TextBoostUtils.appendLine(result, "------------");
		plainText(result, vibhutiPada);
		result.append("\n\n");
		TextBoostUtils.appendLine(result, "Kaivalya Pada");
		TextBoostUtils.appendLine(result, "------------");
		plainText(result, kaivalyaPada);
		result.append("\n\n");
		return result.toString();
	}

	/**
	 * make non-null.
	 * 
	 * @param text
	 * @return
	 */
	private String nn(String text) {
		if (text == null) {
			return "";
		} else {
			return text;
		}
	}

	public void plainText(StringBuilder result, List<Sutra> chapter) throws Exception {
		List<String> strings;
		result.append("--------------------\n");
		int i = 0;
		for (final Sutra sutra : chapter) {
			result.append("Sutra ").append(i++).append("\n");
			TextBoostUtils.appendLineIfNotNull(result, null, sutra.getDevanagari());
			TextBoostUtils.appendLineIfNotNull(result, null, sutra.getWithSandhi());
			TextBoostUtils.appendLineIfNotNull(result, null, sutra.getWithoutSandhi() + " (without Sandhi)");
			
			List<Pair<String, String>> wordAndInflections = sutra.getUsedWordAndInflectionUnicode();

			TextBoostUtils.appendLine(result, "\nVocabulary");
			for (SanskritWord word : sutra.getUsedWords(true, sutra.toString())) {
				TextBoostUtils.appendIfNotNull(result, word.isEmphasized() ? "" : "   ", word.getDevanagari(), " ", word.getUnicode(), " ", word.getType(), " ",
						word.getGermanBasic(), " ",
						word.getGermanExtended(), " ", word.getGermanComment(), TextBoostUtils.NEW_LINE);
				// TextBoostUtils.appendLineIfNotNull(result, null, "");

			}


			// List<String> words = sutra.getUsedWords();

			TextBoostUtils.appendLine(result, "\nVocabulary analysis");
			for (Pair<String, String> wordAndInflection : wordAndInflections) {
				StringBuilder analysis = new StringBuilder();
				for (String entry : Sanskrit.SINGLETON.analysis(wordAndInflection)) {
					analysis.append(entry).append("; ");
				}

				TextBoostUtils.appendIfNotNull(result, null, wordAndInflection.getRight(), ": ", analysis,
						TextBoostUtils.NEW_LINE);
			}

			// TextBoostUtils.appendLineIfNotNull(result, null, wordAndInflections);
			
			TextBoostUtils.appendLine(result, "\n");
			
			
			
			TextBoostUtils.appendLineIfNotNull(result, "Syntxtranslation: ", sutra.getSyntaxTranslationDE());
			TextBoostUtils.appendLineIfNotNull(result, "Semantictranslation: ", sutra.getSemanticTranslationDE());
			TextBoostUtils.appendLineIfNotNull(result, "Coment content: ", sutra.getCommentContentDE());
			TextBoostUtils.appendLineIfNotNull(result, "Comment structure: ", sutra.getCommentStructureDE());
			TextBoostUtils.appendLineIfNotEmpty(result, "Defined terms: ", sutra.getDefinedTerms());
			TextBoostUtils.appendLineIfNotEmpty(result, "Used terms: ", sutra.getUsedTerms());
			result.append("--------------------\n");

		}

	}

	// public void plainTextWord(StringBuilder result, String unicodeTransliteration, String errorHint) throws Exception {
	//
	// SanskritWord word = Sanskrit.SINGLETON.getWordForUnicode(unicodeTransliteration, errorHint);
	//
	// TextBoostUtils.appendIfNotNull(result, " ",word.getDevanagari(), " ",word.getUnicode(), " ",word.getType(), " ",word.getGermanBasic(), "
	// ",word.getGermanExtended(), " ",word.getGermanComment());
	// TextBoostUtils.appendLineIfNotNull(result, null, "");
	//
	// }

	// create tree with sutras
	// click displays the sutra text

	public static void main(String[] ignored) throws Exception {

		System.out.println(new YogaSutras().plainText());

		// Sutra sutra = new Sutra("समाधिपाद", "samādhipāda", "samādhi pāda", "Bewußtseinszustand-Kapitel", "Erstes Kapitel: Bewußtseinszustände", null, null);
		//
		// sutra = new Sutra("अथ योगानुशासनम्", "atha yogānuśāsanam", "atha yoga-anuśāsanam", "Jetzt eine Yogabelehrung.", "Es folgen Instruktionen im Yoga.",
		// "Die Einleitung für die restlichen Sutras des Kapitels.",
		// "Mit diesem Sutra wird klar gestellt, worum es geht, um Yoga; im nächsten wird die Frage beantwortet, was Yoga ist.");
		// sutra.addInflectedWord("atha", "atha");
		// sutra.addInflectedWord("anuśāsana", "anuśāsanam");
		//
		// sutra = new Sutra("योगश्चित्तवृत्तिनिरोधः", "yogaścittavṛttinirodhaḥ", "yogaḥ cittavṛtti-nirodhaḥ", "Yoga, die Denktätigkeitshemmung.",
		// "Yoga ist die Hemmung der eigenen Gedanken.",
		// "Die Übersetzung des Wortes nirodha ist die schwierigste. Die aktive Bedeutung 'Kontrolle/Beherrschung' scheint im Rahmen der letzten Sutras des
		// Kapitels nicht zu passen. Die 'Vernichtung' passt wiederum nicht zu Sutra 12. Die Übersetzung 'Hemmung' liegt zwischen diesen beiden Extremen und
		// macht an beiden Stellen Sinn.",
		// "Hiermit ist Yoga definiert. Selbst wenn man den Rest des Kapitels nicht mehr liest, bzw. wenn ein Erzähler den Rest vergessen hat, hat man mit
		// diesem Sutra bereits die Essenz des Buches erfahren. Mit diesem Sutra beginnt der große Bogen des ersten Kapitels. Erst wird das Ziel von Yoga
		// vorgestellt, dann kommen die Instruktionen wie es zu erreichen ist. Im letzten Sutra werden die Leitwörter nirodha und samadhi (aus der
		// Kapitelüberschrift) wieder aufgegriffen und so umformuliert, dass man (endlich) am Ziel angekommen ist.");
		// sutra = new Sutra("तदा द्रष्टुः स्वरूपेऽवस्थानम्", "tadā draṣṭuḥ svarūpe'vasthānam", "tadā draṣṭuḥ svarūpe avasthānam",
		// "Dann ist des Sehenden Befinden in der eigenen Form.", "Dann befindet sich der Wahrnehmende in der Realität.",
		// "Erst dann ist man also in der Wirklichkeit angekommen. Vorher nimmt man die Dinge und sich selbst zwar wahr, ist aber noch nicht bis zum
		// eigentlichen Kern vorgedrungen.",
		// "Die Sutren 2 bis 4 bilden eine Einheit. In Sutra 2 wird definiert, was für ein Bewusstseinszustand im Yoga vorliegt, hier erfolgt die Begründung
		// warum der Zustand anzustreben ist, im nächsten Sutra wird erläutert, was ansonsten in einem vorgeht.");
		// sutra = new Sutra("वृत्तिसारूप्यमितरत्र", "vṛttisārūpyamitaratra", "vṛtti-sārūpyam itaratra", "Sonst eine vṛtti-Verwechslung.",
		// "Sonst liegt eine Verwechslung mit den vṛtti vor.",
		// "Andernfalls gibt es (nur) eine Identifikation (des Sehers) mit den vṛttis, den Gedankentätigkeiten. Man leidet also unter einer
		// 'Wahrnehmungsstörung' und verwechselt die Realität mit den eigenen Gedanken darüber.",
		// "Nachdem der Begriff vṛtti mehrmals aufgetaucht ist, hier noch mal zu Beginn des Sutra, geht es ab dem nächsten Sutra mit der Erklärung dieses
		// Begriffes weiter. Zum leichteren Auswendiglernen beginnt auch das folgende Sutra ebenfalls mit diesem Wort.");
		// sutra = new Sutra("वृत्तयः पञ्चतय्यः क्लिष्टाक्लिष्टाः", "vṛttayaḥ pañcatayyaḥ kliṣṭākliṣṭāḥ", "vṛttayaḥ pañcatayyaḥ kliṣṭa-akliṣṭāḥ",
		// "(Denk-)Tätigkeiten sind fünfteilig, mit Leid verbunden(oder) nicht mit Leid verbunden.",
		// "Es gibt fünf Arten (von Gedanken). Jeweils entweder schmerzhaft oder nicht.",
		// "Der unspezifische Begriff eines Gedanken/einer Denktätigkeit wird genauer unterteilt. Die für das eigene, subjektive Empfinden wichtige
		// Unterscheidung in schmerzliche und freudige Gedanken liegt jedoch außerhalb dieser Kategorisierung. Gedanken jeder Kategorie können schmerzhaft oder
		// freudig sein.",
		// "In den nächsten 6 Sutras werden die Arten aufgezählt und pro Sutra wird eine davon beschrieben. Die Sutras 5 bis 11 bilden somit den nächsten
		// zusammengehörigen Abschnitt. Didaktisch ist es auch geschickt, die Anzahl an vṛttis explizit zu erwähnen. Dadurch muss man auf die Frage, wieviele es
		// gibt, nicht erst überlegen und durchzählen, sondern kann direkt dieses Sutra zitieren. Ob es wohl Absicht war, im fünften Sutra die Zahl fünf
		// vorkommen zu lassen?");
		// sutra = new Sutra("प्रमाणविपर्ययविकल्पनिद्रास्मृतयः", "pramāṇaviparyayavikalpanidrāsmṛtayaḥ", "pramāṇa-viparyaya-vikalpa-nidrā-smṛtayaḥ",
		// "Mittel zu richtigem Wissen, falsche Auffassung, Vorstellung, Schlaf (und) Erinnerung.",
		// "Es sind Denktätigkeiten, die zu richtigem Wissen führen oder zu falschen Auffassungen, zu Vorstellungen, Schlaf oder Erinnerung.",
		// "Eine sehr differenzierte Unterscheidung.",
		// "Aufzählung der fünf vṛtti. Durch dieses Sutra lernt man die ganze Aufzählung am Stück und kann sie somit bei Bedarf - ohne zu überlegen -
		// wiedergeben. In jedem der folgenden Sutras wird ein Begriff dieser Aufzählung erläutert.");
		// sutra = new Sutra("प्रत्यक्षानुमानागमाः प्रमाणानि", "pratyakṣānumānāgamāḥ pramāṇāni", "pratyakṣa-anumāna-āgamāḥ pramāṇāni",
		// "Wahrnehmung, Schlußfolgerung (und) überlieferte Lehre (sind) Mittel zu richtiger Erkenntnis.", "",
		// "Damit sind alle Möglichkeiten genannt, wie man zu richtigen Ergebnissen kommen kann. Man kann sie entweder direkt wahrnehmen, sie mittels Logik aus
		// bekannten Tatsachen erschließen oder ist auf Lehrwerke angewiesen. Die Reihenfolge spiegelt auch den Zuverlässigkeitsgrad wieder. Am zuverlässigsten
		// ist, was sich direkt beobachten läßt. Bei Schlußfolgerungen kann man schon Fehler machen und in Lehrwerken können noch mehr Denkfehler verborgen
		// sein.",
		// "Die drei Begriffe pratyakṣa, anumāna, āgama werden nicht mehr genauer definiert.");
		// sutra = new Sutra("विपर्ययो मिथ्याज्ञानमतद्रूपप्रतिष्ठम्", "viparyayo mithyājñānamatadrūpapratiṣṭham", "viparyayaḥ mithyā-jñānam
		// atadrūpa-pratiṣṭham",
		// "Falsche Auffassung ist unrichtiges Wissen, nicht der Form nahestehend.",
		// "Falsche Auffassung ist unrichtiges Wissen, abweichend vom eigentlichen Tatbestand.", "", "");
		// sutra = new Sutra("शब्दज्ञानानुपाती वस्तुशून्यो विकल्पः", "śabdajñānānupātī vastuśūnyo vikalpaḥ", "śabda-jñāna-anupātī vastu-śūnyaḥ vikalpaḥ",
		// "Eine Wortwissensabfolge, gegenstandslos, ist Vorstellung.",
		// "Auf Worten beruhendes Wissen, frei von (konkreten) Dingen ist Vorstellung. Vorstellungen sind Gedankenspiele ohne Anspruch auf Realität.",
		// "Hierunter fallen zum Beispiel Tagträumereien oder 'Was wäre, wenn'-Überlegungen.",
		// "Im Gegensatz zu den beiden vorherigen Begriffen, die sich mit der Realität auseinandersetzen (sei es richtig oder falsch), ist bei der Vorstellung
		// kein Bezug zu realen Situationen mehr nötig.");
		// sutra = new Sutra("अभावप्रत्ययालम्बना तमोवृत्तिर्निद्रा Variante(n): अभावप्रत्ययालम्बना वृत्तिर्निद्रा",
		// "abhāvapratyayālambanā tamovṛttirnidrā Variante(n): abhāvapratyayālambanā vṛttirnidrā", "abhāva-pratyaya-ālambanā tamas-vṛttiḥ nidrā",
		// "Wahrnehmungsabwesenheitsbasiert sind die verdunkelten Denktätigkeiten, der Schlaf.",
		// "Die Abwesenheit von Wahrnehmungen, nicht sichtbare Gedanken, sind Schlaf. Die Gedanken beim Schlaf sind nicht wahrnehmbar, sie sind von
		// Tamas-Qualität.",
		// "Mit Schlaf sind nicht Träume gemeint, sondern der traumlose Schlaf. Träume dürften mehr in den Bereich der Vorstellung vikalpa fallen. An anderer
		// Stelle wird explizit zwischen Tiefschlaf (nidrā) und Traum (svapna) unterschieden.",
		// "");
		// sutra = new Sutra("अनुभूतविषयासंप्रमोषः स्मृतिः", "anubhūtaviṣayāsaṃpramoṣaḥ smṛtiḥ", "anubhūta-viṣaya-asaṃpramoṣaḥ smṛtiḥ",
		// "Ein wahrgenommenes Objekt, nichtvergessen, ist eine Erinnerung.",
		// "In der Vergangenheit Wahrgenommenes, das noch nicht völlig verblasst ist, ist Erinnerung. / Erinnerung sind in der Vergangenheit erlebte Dinge,
		// deren Eindrücke noch nicht verblasst sind.",
		// "", "Damit endet der Abschnitt über die vṛtti und es geht mit dem zweiten neuen Begriff (nirodha) aus Sutra 2 weiter.");
		// sutra = new Sutra("अभ्यासवैराग्याभ्यां तन्निरोधः", "abhyāsavairāgyābhyāṃ tannirodhaḥ", "abhyāsa-vairāgyābhyām tat-nirodhaḥ",
		// "Durch Übung und Gleichmut, dann Nirodha.", "Übung und Gleichmut bringt die Ruhe/Kontrolle der Gedanken.",
		// "Es sind also nicht Übung und Ehrgeiz wie man vielleicht erwarten könnte. Statt Ehrgeiz ist die Gelassenheit wichtig. Der Begriff des Übens verweist
		// aber darauf, dass eine gewisse Anstrengung und Intensität nötig sind.",
		// "Nachdem die 'vṛttis' behandelt wurden, geht es ab jetzt um den zweiten Begriff 'nirodha' aus Sutra 2. In den nächsten vier Sutras werden die neuen
		// Ausdrücke 'abhyāsa' und 'vairāgya' in jeweils zwei Sutras erklärt.");
		// sutra = new Sutra("तत्र स्थितौ यत्नोऽभ्यासः", "tatra sthitau yatno'bhyāsaḥ", "tatra sthitau yatnaḥ abhyāsaḥ",
		// "Dort wo die Bemühung in der Beständigkeit ist, ist Übung.", "Übung entsteht aus beständigen Bemühungen.", "",
		// "Hier erfolgt die Definition von abhyāsa. Im nächsten Sutra wird erläutert, wie abhyāsa erreicht werden kann.");
		// sutra = new Sutra("स तु दीर्घकालनैरन्तर्यसत्कारादरासेवितोदृढभूमिः Variante(n): स तु दीर्घकालनैरन्तर्यसत्कारासेवितोदृढभूमिः",
		// "saḥ tu dīrghakālanairantaryasatkārādarāsevitodṛḍhabhūmiḥ Variante(n): sa tu dīrghakālanairantaryasatkārāsevitodṛḍhabhūmiḥ",
		// "saḥ tu dīrgha-kāla-nairantarya-satkāra-ādara-āsevitaḥ dṛḍha-bhūmiḥ",
		// "Dies nun - lange Zeit, ununterbrochen, achtsam und sorgfältig angehäuft - ist eine feste Basis.",
		// "Nach langer Zeit ununterbrochener, achtsamer und sorgfältiger Wiederholungen bildet sich ein festes Fundament.", "", "");
		// sutra = new Sutra("दृष्टानुश्रविकविषयवितृष्णस्य वशीकारसंज्ञा वैराग्यम् Variante(n): दृष्टानुश्रविकविषयवितृष्णस्य वशीकारसंज्णा वैराग्यम्",
		// "dṛṣṭānuśravikaviṣayavitṛṣṇasya vaśīkārasaṃjñā vairāgyam Variante(n): dṛṣṭānuśravikaviṣayavitṛṣṇasya vaśīkārasaṃjṇā vairāgyam",
		// "dṛṣṭa-ānuśravika-viṣaya-vitṛṣṇasya vaśīkāra-saṃjñā vairāgyam",
		// "Kontrollbewußtsein der Durstlosigkeit nach einem gesehenen, gehörten Ding, ist Gleichmut.",
		// "Gleichmut ist, sein Bewusstsein so zu kontrollien, dass es nicht nach weiteren Dingen verlangt.",
		// "Gleichmut ist, wenn man mit dem zufrieden ist, was man hat (wo man steht) und nicht immer mehr will.",
		// "Nach der Definition von vairāgya wird im nächsten Sutra die höchste erreichbare Stufe angegeben.");
		// sutra = new Sutra("तत्परं पुरुषख्यातेः गुणवैतृष्ण्यम्", "tatparaṃ puruṣakhyāteḥ guṇavaitṛṣṇyam", "tat param puruṣa-khyāteḥ guṇa-vaitṛṣṇyam",
		// "Das höchste der Seelenerkenntnis ist die Guna-Durstlosigkeit.",
		// "Die höchste Stufe der Erkenntnis der Seele ist erreicht, wenn völlige Begierdelosigkeit (nach beliebigen Eigenschaften) herrscht.",
		// "Dies ist noch einmal eine Steigerung zum vorherigen Sutra, bei dem es noch um konkrete Dinge, die man sieht oder von denen man hört, ging. Damit ist
		// auch erläutert wohin vairāgya führen soll, so dass man nicht zu früh sagen kann, dass man es gemeistert hat.",
		// "Hiermit endet der in Sutra 12 begonnen Abschnitt über 'abhyāsa' und 'vairāgya'.");
		// sutra = new Sutra("वितर्कविचारानन्दास्मितारुपानुगमात् संप्रज्ञातः Variante(n): वितर्कविचारानन्दास्मितारुपानुगमात्संप्रज्ञातः",
		// "vitarkavicārānandāsmitārūpānugamāt saṃprajñātaḥ", "vitarka-vicāra-ānanda-asmitā-rūpa-anugamāt saṃprajñātaḥ ",
		// "Vermutung, Untersuchung, Wonne, Ich-bin-diese Form, durch diese Abfolge entsteht Saṃprajñāta.",
		// "Die Stufen zu Saṃprajñāta - der ersten Stufe des Samadhi - sind Vermutung, gründliche Untersuchung, Seligkeit und ein Bewusstsein des höheren
		// Selbst.",
		// "Saṃprajñāta - 'vollkommenes Erkennen' ist die erste Stufe des Samadhi. Auf der Ebene von vitarka gibt es noch die Unterscheidung in savitarka und
		// nirvitarka, bei vicāra gibt es savicāra und nirvicāra.",
		// "Hier und im nächsten Sutra wird werden die beiden Stufen des Samadhi (saṃprajñāta und asaṃprajñāta) angesprochen die in den restlichen Sutras des
		// Kapitels dann genauer erläutert werden. Ab Sutra 42 werden die verschiedenen Samdhi-Arten sa/nir-vitarka und sa/nir-vicara explizit erwähnt.");
		// sutra = new Sutra("विरामप्रत्ययाभ्यासपूर्वः संस्कारशेषोऽन्यः", "virāmapratyayābhyāsapūrvaḥ saṃskāraśeṣo'nyaḥ",
		// "virāma-pratyaya-abhyāsa-pūrvaḥ saṃskāra-śeṣaḥ anyaḥ",
		// "Ein Ursachenende aufgrund von Übung, ein (letzter) Rest geistiger Eindrücke, (dann herrscht) der andere (Bewußtseinszustand).",
		// "Im zweiten Samadhi-Zustand hören durch Übung die Ursachen (Motive) auf, es sind nur noch Reste früherer Eindrücke vorhanden.",
		// "Der erste Bewußtseinszustand heißt saṃprajñāta, der zweite asaṃprajñāta. Interessant ist, dass für den zweiten Bewußtseinszustand kein eigener Name
		// angegeben ist, sondern nur vom 'anderen' gesprochen wird. Im Gegensatz dazu werden sonst immer eigene Begriffe verwendet.",
		// "");
		// sutra = new Sutra("भवप्रत्ययो विदेहप्रकृतिलयानाम्", "bhavapratyayo videhaprakṛtilayānām", "bhava-pratyayaḥ videha-prakṛti-layānām",
		// "Daseinsursache ist eine Geist(Körperlos)-Natur-Verbindung", "Die Ursache des Daseins ist die Verschmelzung von Geist mit der Materie.",
		// "Der Mensch besteht also aus den beiden Teilen Geist und Materie (Natur).",
		// "Die nächsten Sutras behandeln die unterschiedlichen Möglichkeiten die einem helfen, Samadhi zu erreichen.");
		// // 20
		//
		// sutra = new Sutra("श्रद्धावीर्यस्मृतिसमाधिप्रज्ञापूर्वक इतरेषाम्", "śraddhāvīryasmṛtisamādhiprajñāpūrvaka itareṣām",
		// "śraddhā-vīrya-smṛti-samādhi-prajñā-pūrvaka itareṣām", "Andere (benötigen) vorher Glaube, Energie, Erinnerung, Reflektion und Einsicht.",
		// "Bei Anderen gehen die Schritte Glaube, fester Wille, beständig daran Denken, Reflektion und Einsicht voraus.",
		// "Dies ist die Alternative, wenn man alles erst erwerben muss. Diese Aufzählung sind die fünf Fähigkeiten (indriyas) aus dem Buddhismus, wo sie zum
		// Beispiel im Bodhipakkhiyadhamma erwähnt werden.",
		// "Damit ist der Abschnitt über die Veranlagungen beendet.");
		// sutra = new Sutra("तीव्रसंवेगानामासन्नः", "tīvrasaṃvegānāmāsannaḥ", "tīvra-saṃvegānām āsannaḥ", "Tiefe (Stärke) der Intensität bringt Nähe.",
		// "Bei intensivem Antrieb bist Du dem Ziel nahe.",
		// "Hier also der Aufruf intensiv zu üben und die Übungen nicht schleifen zu lassen. Gleichzeitig ist es auch ein Versprechen, dass der Praktizierende
		// etwas erreichen wird.",
		// "Dieses und das nächste Sutra beschäftigen sich mit der Intensität der Übungen. Intensives Üben ist besser, darum steht dieses Sutra vermutlich am
		// Anfang. Als Alternative wird in Sutra 23 die Gottesverehrung ins Spiel gebracht.");
		// sutra = new Sutra("मृदुमध्याधिमात्रत्वात्ततोऽपि विशेषः", "mṛdumadhyādhimātratvāttato'pi viśeṣaḥ", "mṛdu-madhya-adhimātratvāt tataḥ api viśeṣaḥ",
		// "Mild,mittel, intensiv sind auch die Unterschiede.", "Es gibt Abstufungen in mild, mittel oder stark.",
		// "Auch wenn intensives Üben besser ist (siehe vorheriges Sutra), ist es möglich weniger intensiv zu praktizieren.",
		// "Hiermit endet der Abschnitt über die Veranlagungen und die Intensitäten.");
		// sutra = new Sutra("ईश्वरप्रणिधानाद्वा", "īśvarapraṇidhānādvā", "īśvara-praṇidhānāt vā", "Oder durch Gebete zu Gott.", "Oder durch Gottesverehrung.",
		// "Die erste Möglichkeit, Samdhi zu erreichen, sind intensive Gebete.",
		// "Bis einschließlich Sutra 28 wird erläutert, wer īśvara ist und wie die Gebete auszusehen haben.");
		// sutra = new Sutra("क्लेशकर्मविपाकाशयैरपरामृष्टः पुरुषविशेष ईश्वरः Variante(n): क्लेश कर्म विपाकाशयैःपरामृष्टः पुरुषविशेष ईश्वरः",
		// "kleśakarmavipākāśayairaparāmṛṣṭaḥ puruṣaviśeṣa īśvaraḥ Variante(n): kleśa karma vipākāśayaiḥparāmṛṣṭaḥ puruṣaviśeṣa īśvaraḥ",
		// "kleśa-karma-vipāka-āśayaiḥ aparāmṛṣṭaḥ puruṣa-viśeṣa īśvaraḥ",
		// "Von Leid, Handlungen, Folgen, Absichten unberührt, eine besondere Seele, ist Gott.",
		// "Gott ist eine besondere Seele, die völlig unberührt ist von Leid, Handlungen, Folgen und Absichten.", "", "");
		// sutra = new Sutra("तत्र निरतिशयं सर्वज्ञबीजम्", "tatra niratiśayaṃ sarvajñabījam", "tatra niratiśayam sarva-jña-bījam",
		// "Dort (findest Du) das Höchste, den Samen allen Wissens.", "Darin liegt das Höchste, dort ist die Basis allen Wissens.", "", "");
		// sutra = new Sutra("स एष पूर्वेषामपि गुरुः कालेनानवच्छेदात् Variante(n): स पूर्वेषाम् अपि गुरुः कालेनानवच्छेदात्",
		// "sa eṣa pūrveṣāmapi guruḥ kālenānavacchedāt Variante(n): sa pūrveṣām api guruḥ kālenānavacchedāt",
		// "sa eṣa pūrv-eṣām api guruḥ kālena anavacchedāt", "", "Er ist der Lehrer der früheren Generationen, er ist zeitlich unbegrenzt.", "", "");
		// sutra = new Sutra("तस्य वाचकः प्रणवः", "tasya vācakaḥ praṇavaḥ", "tasya vācakaḥ praṇavaḥ", "Dessen Wort ist Aum.",
		// "Das Wort, das ihn repäsentiert ist Aum.", "", "");
		// sutra = new Sutra("तज्जपस्तदर्थभावनम्", "tajjapastadarthabhāvanam", "tat-japaḥ tat-artha-bhāvanam", "Das gebetet bewirkt, es zu verstehen.",
		// "Wird es wiederholt, kommt seine Bedeutung zum Vorschein.", "", "Damit ist der in Sutra 23 begonnene Abschnitt über īśvara beendet.");
		// sutra = new Sutra("ततः प्रत्यक्चेतनाधिगमोऽप्यन्तरायाभावश्च", "tataḥ pratyakcetanādhigamo'pyantarāyābhāvaśca",
		// "tataḥ pratyakcetana-adhigamaḥ api antarāya-abhāvaḥ ca",
		// "Daraus wird die Wahrnehmung des Inneren erreicht und auch Hindernisse hören auf zu existieren.",
		// "Dadurch erreichst Du Innenschau und Hindernisse werden beseitigt.", "",
		// "In den folgenden beiden Sutras werden die Hindernisse genauer erläutert.");
		// // 30
		// sutra = new Sutra("व्याधिस्त्यानसंशयप्रमादालस्याविरतिभ्रान्तिदर्शनालब्धभूमिकत्वानवस्थितत्वानि चित्तविक्षेपास्तेऽन्तरायाः",
		// "vyādhistyānasaṃśayapramādālasyāviratibhrāntidarśanālabdhabhūmikatvānavasthitatvāni cittavikṣepāste'ntarāyāḥ",
		// "vyādhi-styāna-saṃśaya-pramāda-ālasya-avirati bhrānti-darśana-alabdha-bhūmikatva-anavasthitatvāni citta-vikṣepāḥ te antarāyāḥ",
		// "Krankheit, Apathie, Unentschlossenheit, Nachlässigkeit; Schlaffheit, Unenthaltsamkeit, Verblendetheit, Nicht-Erreichen von Zielen, Unbeständigkeit,
		// bewirken ein Sich-Gehenlassen des Geistes und sind Hindernisse.",
		// "Krankheit, Apathie, Unentschlossenheit, Nachlässigkeit, Schlaffheit, Hängen an Objekten, Verblendetheit, mangelnde Zielstrebigkeit, Unbeständigkeit
		// sind Hindernisse und führen zum sich gehen lassen des Geistes",
		// "", "");
		// sutra = new Sutra("दुःखदौर्मनस्याङ्गमेजयत्वश्वासप्रश्वासाः विक्षेपसहभुवः", "duḥkhadaurmanasyāṅgamejayatvaśvāsapraśvāsāḥ vikṣepasahabhuvaḥ",
		// "duḥkha-daurmanasya-aṅgamejayatva-śvāsa-praśvāsāḥ vikṣepa-sahabhuvaḥ",
		// "Schmerz, Niedergeschlagenheit, Gliederzittern, schnaufender Atem sind Begleiterscheinungen von vikṣepa.",
		// "Schmerz, Niedergeschlagenheit, Nervosität, unruhige Atmung sind Begleiterscheinungen des abgelenkten Geistes.", "", "");
		// sutra = new Sutra("तत्प्रतिषेधार्थमेकतत्त्वाभ्यासः", "tatpratiṣedhārthamekatattvābhyāsaḥ", "tat-pratiṣedha-ārtham eka-tattva-abhyāsaḥ",
		// "Um die Beziehung dazu zu vermindern ist ein Prinzip zu wiederholen", "Um dies zu beherrschen reicht es, ein einziges Prinzip zu üben.",
		// "Dabei ist nicht gemeint, dass es nur eine einzige Möglichkeit gibt. Vielmehr reicht es aus, sich unter den verschiedenen Möglichkeiten eine
		// auszusuchen.",
		// "In den folgenden sieben Sutras bis Sutra 39 werden verschiedene Alternativen beschrieben.");
		// sutra = new Sutra("मैत्रीकरुणामुदितोपेक्षाणां सुखदुःखपुण्यापुण्यविषयाणां भावनातश्चित्तप्रसादनम्",
		// "maitrīkaruṇāmuditopekṣāṇāṃ sukhaduḥkhapuṇyāpuṇyaviṣayāṇāṃ bhāvanātaścittaprasādanam",
		// "maitrī-karuṇā-muditā-upekṣāṇāṃ sukha-duḥkha-puṇya-apuṇya-viṣayāṇāṃ bhāvanātaḥ citta-prasādanam",
		// "Freundlichkeit, Mitleid, Fröhlichkeit, Geduld in angenehmen und unangenehmen, günstigen und ungünstigen Situationen entwickeln einen klaren Geist.",
		// "Freundlichkeit, Mitleid, Fröhlichkeit und Geduld in jeder Situation, ob günstig oder leidvollen, erfolgreichen oder erfolglos, entwickeln einen
		// klaren Geist.",
		// "", "");
		// sutra = new Sutra("प्रच्छर्दनविधारणाभ्यां वा प्राणस्य", "pracchardanavidhāraṇābhyāṃ vā prāṇasya", "pracchardana-vidhāraṇābhyāṃ vā prāṇasya",
		// "Oder durch das Ausstoßen und Anhalten des Atmens", "Oder durch Ausatmen und anschließendes Anhalten des Atems.",
		// "Nach dem Ausatmen ist zu warten, bis wieder eingeatmet wird.", "");
		// sutra = new Sutra("विषयवती वा प्रवृत्तिरुत्पन्ना मनसः स्थिति स्थितिनिबन्धनी Variante(n): विषयवती वा प्रवृत्तिरुत्पन्ना मनसः निबन्धिनी",
		// "viṣayavatī vā pravṛttirutpannā manasaḥ sthitinibandhanī Variante(n): viṣayavatī vā pravṛttirutpannā manasaḥ sthitinibandhinī",
		// "viṣayavatī vā pravṛttiḥ utpannā manasaḥ sthiti-nibandhanī",
		// "Oder Objekte der Sinneswahrnehmung; Ist Fortschritt gekommen herrscht Standhaftigkeit und Bindung des Geistes",
		// "Oder durch Objekte der Sinneswahrnehmung. Kontrollierte Wahrnehmung erzeugt Stabilität und Kontrolle des Geistes.", "", "");
		// sutra = new Sutra("विशोका वा ज्योतिष्मती", "viśokā vā jyotiṣmatī", "viśokā vā jyotiṣmatī", "Oder durch kummerloses, strahlendes Licht",
		// "Oder durch Konzentration auf ein kummerloses, himmlisches Licht.", "", "");
		// sutra = new Sutra("वीतरागविषयं वा चित्तम्", "vītarāgaviṣayaṃ vā cittam", "vītarāga-viṣayam vā cittam",
		// "Oder den Geist dahin zu richten, das Verlangen vergehen zu lassen", "Oder den Versuch, sein Verlangen zu vermindern.", "", "");
		// sutra = new Sutra("स्वप्ननिद्राज्ञानालम्बनं वा", "svapnanidrājñānālambanaṃ vā", "svapna-nidrā-jñāna-ālambanam vā",
		// "Oder über Traum und Schlaf als Wissensgrundlage.", "Oder über aus Traum und Tiefschlaf erlangtes Wissen.", "", "");
		// sutra = new Sutra("यथाभिमतध्यानाद्वा", "yathābhimatadhyānādvā", "yathā-abhimata-dhyānāt vā", "Oder durch eine Meditation wie gewünscht.",
		// "Oder durch eine andere geeignete Meditation.", "Die Vorgaben sind also nicht dogmatisch. Jede geeignete Variante ist erlaubt.",
		// "Damit enden die ab Sutra 33 vorgestellten Alternativen.");
		// // 40
		// sutra = new Sutra("परमाणु परममहत्त्वान्तोऽस्य वशीकारः", "paramāṇu paramamahattvānto'sya vaśīkāraḥ", "parama-aṇu-parama-mahattva-antaḥ asya
		// vaśīkāraḥ",
		// "Gemeistert werden kann jedes Objekt vom Allerkleinsten bis zum Allergrößten",
		// "Das Meditationsobjekt kann vom Kleinsten bis zum Größten reichen", "",
		// "In den folgenden Sutras bis zum Ende des Kapitels werden die Stufen der Meisterschaft aufgezählt und beschrieben.");
		// sutra = new Sutra("क्षीणवृत्तेरभिजातस्येव मणेर्ग्रहीतृग्रहणग्राह्येषु तत्स्थतदञ्जनता समापत्तिः",
		// "kṣīṇavṛtterabhijātasyeva maṇergrahītṛgrahaṇagrāhyeṣu tatsthatadañjanatā samāpattiḥ",
		// "kṣīṇa-vṛtteḥ abhijātasya iva maṇeḥ grahītṛ-grahaṇa-grāhyeṣu tatstha-tadañjanatā samāpattiḥ",
		// "Durch verminderte Gedanken, gleichwie ein edler Kristall ist der Erfassende, das Erfassen, das Erfasste aufeinander gestützt und überdeckt und die
		// Vollendung ist erreicht.",
		// "Sind die eigenen Gedanken reduziert und - wie bei einem Kristall, der seinen Hintergrund reflektiert - Wahrnehmender, Wahrnehmung und Wahrgenommenes
		// zusammenhängend und nehmen die gleichen Eigenschaften an, so ist das die Verschmelzung.",
		// "Die Unterscheidung zwischen Subjekt und Objekt löst sich auf.", "");
		// sutra = new Sutra("तत्र शब्दार्थज्ञानविकल्पैः संकीर्णा सवितर्का समापत्तिः", "tatra śabdārthajñānavikalpaiḥ saṃkīrṇā savitarkā samāpattiḥ",
		// "tatra śabda-ārtha-jñāna-vikalpaiḥ saṃkīrṇā savitarkā samāpattiḥ",
		// "Dort wo Wissen auf Worten beruht und Unschlüssigkeit herrscht, spricht man von vom Nachdenken begleiteter Vollendung.",
		// "Solange Gehörtes, Schlussfolgerungen, Wissen und Vorstellung gemischt sind, spricht man von Verschmelzung mit Nachdenken", "",
		// "Ab hier werden die Begriffe, die in Sutra 17 angesprochen wurden (vitarkā und vicāra) wieder aufgegriffen.");
		// sutra = new Sutra("स्मृतिपरिशुद्धौ स्वरूपशून्येवार्थमात्रनिर्भासा निर्वितर्का", "smṛtipariśuddhau svarūpaśūnyevārthamātranirbhāsā nirvitarkā",
		// "smṛti-pariśuddhau svarūpa-śūnya iva artha-mātra-nirbhāsā nirvitarkā",
		// "Ist das Gedächtnis gereinigt, die eigene Form wie leer, das Ziel erscheint, dann herrscht Nirvitarka.",
		// "Sind alte Erinnerungen beseitigt, und die eigene Form vergessen, erscheint nur noch das Meditationsobjekt. Es ist die Stufe 'Ohne
		// Nachdenken'(Nirvitarka) erreicht.",
		// "Die nächste Stufe nach Savitarka is Nirvitarka.", "");
		// sutra = new Sutra("एतयैव सविचारा निर्विचारा च सूक्ष्मविषया व्याख्याता", "etayaiva savicārā nirvicārā ca sūkṣmaviṣayā vyākhyātā",
		// "etayā eva savicārā nirvicārā ca sūkṣma-viṣayā vyākhyātā",
		// "So erfolgt auch die Erklärung der mit bzw. ohne Erwägung begleiteten Überlegung auf auf verfeinertes Objekt der Sinneswahrnehmung.",
		// "Handelt es sich bei den Meditationsgegenständen um subtile Objekte werden genauso die Zustände 'Mit Überlegung' und 'Ohne Überlegung' definiert.",
		// "", "");
		// sutra = new Sutra("सूक्ष्मविषयत्वं चालिङ्ग पर्यवसानम्", "sūkṣmaviṣayatvaṃ cāliṅga paryavasānam", "sūkṣma-viṣayatvam ca aliṅga-paryavasānam",
		// "Das Objekt kann ganz fein sein und ist am Schluß ein Objekt ohne Bezeichnung.",
		// "Die Meditation kann sich auf subtile Objekte und sogar das Undefinierbare erstrecken.", "", "");
		// sutra = new Sutra("ता एव सबीजस्समाधिः", "tā eva sabījassamādhiḥ", "tā eva sabījaḥ samādhiḥ",
		// "Das allerdings ist ein Keime enthaltender, meditativer Bewußtseinszustand.", "Das ist allerdings nur Samadhi, das noch Keime enthält.", "",
		// "");
		// sutra = new Sutra("निर्विचारवैशारद्येऽध्यात्मप्रसादः", "nirvicāravaiśāradye'dhyātmaprasādaḥ", "nirvicāra-vaiśāradye adhyātma-prasādaḥ",
		// "Wissen ohne Nachdenken ist Klarheit im höchsten Geist.", "Die Erfahrung des Samadhi ohne Überlegung ist Klarheit auf höchster Ebene.", "", "");
		// sutra = new Sutra("ऋतम्भरा तत्र प्रज्ञा", "ṛtambharā tatra prajñā", "ṛtambharā tatra prajñā", "Wahrheitsträchtig ist dieses Wissen.",
		// "Der Verstand ist von Wahrheit erfüllt.", "", "");
		// sutra = new Sutra("श्रुतानुमानप्रज्ञाभ्यामन्यविषया विशेषार्थत्वात्", "śrutānumānaprajñābhyāmanyaviṣayā viśeṣārthatvāt",
		// "śruta-anumāna-prajñābhyām anya-viṣayā viśeṣa-arthatvāt",
		// "Gehörtes und geschlussfolgertes Wissen ist ein anderes, nämlich auf ein Objekt gerichtet.",
		// "Man erlangt eine besondere Beziehung zum Objekt, anders als gehörtes Wissen und Wissen aus Schlussfolgerungen.", "", "");
		// sutra = new Sutra("तज्जस्संस्कारोऽन्यसंस्कारप्रतिबन्धी", "tajjassaṃskāro'nyasaṃskārapratibandhī", "tat jaḥ saṃskāraḥ anya-saṃskāra-pratibandhī",
		// "Der so geborene Eindruck ersetzt die anderen Eindrücke.", "Die so entstandenen Eindrücke ersetzen die bisherigen Eindrücke.", "", "");
		// sutra = new Sutra("तस्यापि निरोधे सर्वनिरोधान्निर्बीजः समाधिः", "tasyāpi nirodhe sarvanirodhānnirbījaḥ samādhiḥ",
		// "tasya api nirodhe sarva-nirodhāt nirbījaḥ samādhiḥ",
		// "Mit der Beherrschung auch dessen, durch die Beherrschung von allem, ist ein Bewußtseinszustand ohne Samen erreicht.",
		// "Sind sogar diese beherrscht, sind alle beherrscht und der Samādhi ohne Samen erreicht.", "",
		// "Damit hört dieses Kapitel, das mit samādhi in der Überschrift begonnen hat, auch mit dem Wort samādhi auf.");
		// // ende kapitel
		// sutra = new Sutra("साधनपाद", "sādhanapāda", "sādhana-pāda", "Praxis-Kapitel", "Erstes Kapitel: (Spirituelle) Praxis", "", "");
		//
		// sutra = new Sutra("तपः स्वाध्यायेश्वरप्रणिधानानि क्रियायोगः", "tapaḥ svādhyāyeśvarapraṇidhānāni kriyāyogaḥ",
		// "tapaḥ svādhyāya-iśvara-praṇidhānāni kriyā-yogaḥ", "Askese, Studiums- und Gottes-Bemühungen (sind) der Handlungsyoga.",
		// "Askese, Schriftenstudium und Gottesverehrung bilden den Yoga der Handlungen.", "", "");
		// sutra = new Sutra("समाधिभावनार्थः क्लेशतनूकरणार्थश्च", "samādhibhāvanārthaḥ kleśatanūkaraṇārthaśca",
		// "samādhi-bhāvana-arthaḥ kleśa-tanū-karaṇa-arthaḥ ca", "Es gibt das Samadhi-Erreichungs-Ziel und das leidensverdünnungsmachende Ziel.",
		// "Ziel ist den meditativen Bewusstseinszustand (Samadhi) zu erreichen und Leid zu vermindern.", "", "");
		// sutra = new Sutra("अविद्यास्मितारागद्वेषाभिनिवेशः (पञ्च) क्लेशाः", "avidyāsmitārāgadveṣābhiniveśaḥ (pañca) kleśāḥ",
		// "avidyā-asmitā-rāga-dveṣa-abhiniveśaḥ (pañca) kleśāḥ", "Unwissenheit, Selbstsucht, Verlangen, Abneigung, Verhaftung sind (fünf) Leiden.", "",
		// "", "");
		// sutra = new Sutra("अविद्या क्षेत्रमुत्तरेषाम् प्रसुप्ततनुविच्छिन्नोदाराणाम्", "avidyā kṣetramuttareṣām prasuptatanuvicchinnodārāṇām",
		// "avidyā kṣetram-uttareṣām prasupta-tanu-vicchinna-udārāṇām ", "",
		// "Unwissenheit ist der Ursprung der nachfolgenden.Sie sind schlafend, gering, unterbrochen (oder) aktiv.", "", "");
		// sutra = new Sutra("अनित्याशुचिदुःखानात्मसु नित्यशुचिसुखात्मख्यातिरविद्या", "anityāśuciduḥkhānātmasu nityaśucisukhātmakhyātiravidyā",
		// "anitya-aśuci-duḥkha-anātmasu nitya-śuci-sukha-ātma-khyātiḥ-avidyā",
		// "Unbeständiges, Unreines, Schmerzliches, das Nicht-Selbst als Beständiges, Reines, Angenehmes, das Selbst anzusehen, ist Unwissenheit", "", "",
		// "");
		// sutra = new Sutra("दृग्दर्शनशक्त्योरेकात्मतेवास्मिता", "dṛgdarśanaśaktyorekātmataivāsmitā", "dṛś-darśana-śaktyoḥ-ekātmatā eva asmitā",
		// "Wird das zu Sehende mit der eigenen Sehfähigkeit gleichgesetzt, so ist das Ich-Bezogenheit.", "", "", "");
		// sutra = new Sutra("सुखानुशयी रागः", "sukhānuśayī rāgaḥ", "sukha-anuśayī rāgaḥ", "Genußverbundenheit ist Mögen.",
		// "Mögen (rāga) ist, was mit Genuß verbunden ist.", "", "");
		// sutra = new Sutra("दुःखानुशयी द्वेषः", "duḥkhānuśayī dveṣaḥ", "duḥkha-anuśayī dveṣaḥ", "Unbehagensverbundenheit ist Abneigung.",
		// "Abneigung (dveṣa) ist, was mit Unbehagen verbunden ist.", "", "");
		// sutra = new Sutra("स्वरसवाहि विदुषोऽपि (समा oder) तथा रूढोऽभिनिवेशः", "svarasavāhi viduṣo'pi (samā- oder) tathā-rūḍho'bhiniveśaḥ",
		// "sva-rasa-vāhi viduṣo api (samā/)tathā-rūḍhaḥ abhiniveśaḥ",
		// "Die Eigenessenzerfahrung (zu machen), auch der Weise ist damit beladen, ist die Verhaftung.",
		// "Verhaftung ist, an der eigenen Persönlichkeit zu hängen. Auch Weise sind davon betroffen.", "", "");
		// // 10
		// sutra = new Sutra("ते प्रतिप्रसवहेयाः सूक्ष्माः", "te pratiprasavaheyāḥ sūkṣmāḥ", "te prati-prasava-heyāḥ sūkṣmāḥ",
		// "Sie, ursprungsnah vermieden, bleiben fein",
		// "Werden sie (die Kleshas) gemieden, sobald sie beginnen aufzutreten, so bleibt ihr Einfluß gering.", "", "");
		// sutra = new Sutra("ध्यानहेयास्तद्वृत्तयः", "dhyānaheyāstadvṛttayaḥ", "dhyāna-heyāḥ tat-vṛttayaḥ", "Meditationsvermieden sind diese
		// Gedankenfunktionen.",
		// "Durch Meditation werden diese (Kleshas) Verhaltensweisen vermieden.", "", "");
		// sutra = new Sutra("क्लेशमूलः कर्माशयो दृष्टादृष्टजन्मवेदनीयः", "kleśamūlaḥ karmāśayo dṛṣṭādṛṣṭajanmavedanīyaḥ",
		// "kleśa-mūlaḥ karma-āśayaḥ dṛṣṭa-adṛṣṭa-janma-vedanīyaḥ",
		// "Leidensgrundlage ist das Karmalager, in der sichtbaren oder unsichtbaren Geburt empfunden.",
		// "Grundlage des Leidens ist der Vorrat an Karma, der im aktuellen (sichtbaren) oder zukünftigen (noch nicht sichtbaren) Leben erfahren wird.",
		// "", "");
		// sutra = new Sutra("सति मूले तद्विपाको जात्यायुर्भोगाः", "sati mūle tadvipāko jātyāyurbhogāḥ", "sati mūle tat-vipākaḥ jāti-āyuḥ-bhogāḥ",
		// "Sind Wurzeln existent, deren Reifung ist Kaste, Lebenszeit und Erfahrungen.",
		// "Solange noch Karmagrundlagen vorhanden sind, prägen sie sich als Kaste, Lebensspanne und (zu machende) Erfahrungen aus.", "", "");
		// sutra = new Sutra("ते ह्लादपरितापफलाः पुण्यापुण्यहेतुत्वात्", "te hlādaparitāpaphalāḥ puṇyāpuṇyahetutvāt",
		// "te hlāda-paritāpa-phalāḥ puṇya-apuṇya-hetu-tvāt", "Diese ist Erquickungs- (oder) Betrübnisfrucht, (wenn) deren Ursache günstig oder schlecht.",
		// "Je nachdem ob die Ursache günstig oder schlecht war, ist das Ergebnis erquicklich oder betrüblich.", "", "");
		// sutra = new Sutra("परिणामतापसंस्कार दुःखैर्गुणवृत्तिविरोधाच्च दुःखमेव सर्वं विवेकिनः",
		// "pariṇāmatāpasaṃskāraduḥkhairguṇavṛttivirodhācca duḥkhameva sarvaṃ vivekinaḥ",
		// "pariṇāma-tāpa-saṃskāra-duḥkhaiḥ guṇa-vṛtti-virodhāt ca duḥkham eva sarvam vivekinaḥ",
		// "Mit Veränderung, Schmerz (und) neuen Eindrücken gibt es Leiden, und durch den Eigenschafts-Wesen-Konflikt. Leiden ist wirklich alles. Das wissen
		// Kluge.",
		// "Kluge Menschen wissen, dass im Leben durch Veränderungen, Schmerzen und neue Erfahrungen Leid entsteht; dass es einen Grundkonflikt zwischen (den
		// Eigenschaften) der Natur und dem eigenen Wesen gibt; dass letztendlich alles mit Leid versehen ist.",
		// "", "");
		// sutra = new Sutra("हेयं दुःखमनागतम्", "heyaṃ duḥkhamanāgatam", "heyam duḥkham anāgatam", "Vermeidendes zukünftiges Leiden.",
		// "Zukünftiges Leiden ist zu vermeiden.", "", "");
		// sutra = new Sutra("द्रष्टृदृश्ययोः संयोगो हेयहेतुः", "draṣṭṛdṛśyayoḥ saṃyogo heyahetuḥ", "draṣṭṛ-dṛśyayoḥ saṃyogaḥ heya-hetuḥ",
		// "Die Verbindung des Sehenden (mit dem) Gesehenen ist die zu vermeidende Ursache.",
		// "Die zu vermeidende Ursache ist die Identifikation des Subjekts mit dem Objekt.", "", "");
		// sutra = new Sutra("प्रकाशक्रियास्थितिशीलं भूतेन्द्रियात्मकं भोगापवर्गार्थं दृश्यम्",
		// "prakāśakriyāsthitiśīlaṃ bhūtendriyātmakaṃ bhogāpavargārthaṃ dṛśyam",
		// "prakāśa-kriyā-sthiti-śīlam bhūta-indriya-ātmakam bhoga-apavarga-artham dṛśyam",
		// "Die Licht-, Handlungs- und Stillstandsnatur, vom Wesen Element und Sinnesorgan, ist Erfahrungs- und Befreiungszweck, ist das Sichtbare.",
		// "Die Natur, die aus Licht, Bewegung und Stillstand besteht, die durch die Elemente und Sinnesorgane erfahren wird und dem Zweck der Erfahrung und
		// Befreiung dient, bildet die Objekte.",
		// "", "");
		// sutra = new Sutra("विशेषाविशेषलिङ्गमात्रालिङ्गानि गुणपर्वाणि", "viśeṣāviśeṣaliṅgamātrāliṅgāni guṇaparvāṇi",
		// "viśeṣa-aviśeṣa-liṅga-mātra-aliṅgāni guṇa-parvāṇi",
		// "Spezifisch, unspezifisch, merkmalsmäßig, bezeichnungslos, das sind die Grundeigenschaftsabschnitte.",
		// "Die Grundeigenschaften haben jeweils die Stufen 'spezifisch', 'unspezifisch', 'benennbar', und 'unbenennbar'.", "", "");
		// // 20
		// sutra = new Sutra("द्रष्टा दृशिमात्रः शुद्धोऽपि प्रत्ययानुपश्यः", "draṣṭā dṛśimātraḥ śuddho'pi pratyayānupaśyaḥ",
		// "draṣṭā dṛśi-mātraḥ śuddhaḥ api pratyaya-anupaśyaḥ", "Der Sehende ist, Sehen als Maßstab, vollständig sogar wahrnehmungsschauend.",
		// "Der Sehende (Das Subjekt), nimmt das zu Sehende vollständig wahr, obwohl er durch die Wahrnehmungsorgane schaut.", "", "");
		// sutra = new Sutra("तदर्थ एव दृश्यस्यात्मा", "tadartha eva dṛśyasyātmā", "tad-arthaḥ eva dṛśyasya ātmā",
		// "Deren eigentliches Ziel des Sehens ist die Seele.", "Sie dienen nur dazu, von der Seele gesehen zu werden.", "", "");
		// sutra = new Sutra("कृतार्थं प्रति नष्टमप्यनष्टं तदन्यसाधारणत्वात्", "kṛtārthaṃ prati naṣṭamapyanaṣṭaṃ tadanyasādhāraṇatvāt",
		// "kṛta-artham prati naṣṭam api anaṣṭam tad-anya-sādhāraṇa-tvāt",
		// "Den Zweck getan, ist es gleichsam wie zerstört, (aber) auch nicht zerstört, es ist für andere gemeinsam da.",
		// "Ist der Zweck (des Gesehenen) erreicht, ist es für den Sehenden überflüssig, aber noch vorhanden, da es auch für andere noch einen Zweck zu erfüllen
		// hat.",
		// "", "");
		// sutra = new Sutra("स्वस्वामिशक्त्योः स्वरूपोपलब्धिहेतुः संयोगः", "svasvāmiśaktyoḥ svarūpopalabdhihetuḥ saṃyogaḥ",
		// "sva-svāmi-śaktyoḥ svarūpa-upalabdhi-hetuḥ saṃyogaḥ", "Eigener Eigentümer der Kraft, Eigenformerfahrungsmittel ist die Vereinigung.",
		// "Die Vereinigung dient dazu, zu erkennen, dass man selbst die Kräfte beherrscht und das eigene Wesen erfährt.", "", "");
		// sutra = new Sutra("तस्य हेतुरविद्या", "tasya heturavidyā", "tasya hetuḥ avidyā", "Dessen Ursache ist die Unwissenheit.", "", "", "");
		// sutra = new Sutra("तदभावात्संयोगाभावो हानं तद्दृशेः कैवल्यम्", "tadabhāvātsaṃyogābhāvo hānaṃ taddṛśeḥ kaivalyam",
		// "tad-abhāvāt saṃyoga-abhāvaḥ hānam tat-dṛśeḥ kaivalyam",
		// "Durch ihre (avidya, Unwissenheit) Vernichtung (erfolgt) die Vereinigungsvernichtung. Die Aufgabe des Sehens ist der Zustand absoluter
		// Glückseligkeit.",
		// "Durch ihre (Unwissenheit) Überwindung wird saṃyoga überwunden. Die Aufgabe dieser Sichtweise führt zum Zustand absoluter Glückseligkeit.", "",
		// "");
		// sutra = new Sutra("विवेकख्यातिरविप्लवा हानोपायः", "vivekakhyātiraviplavā hānopāyaḥ", "viveka-khyātiḥ aviplavā hāna-upāyaḥ",
		// "Ununterbrochenes Unterscheidungsvermögen ist das Befreiungsmittel.", "", "", "");
		// sutra = new Sutra("तस्य सप्तधा प्रान्तभूमिः प्रज्ञा", "tasya saptadhā prāntabhūmiḥ prajñā", "tasya saptadhā prānta-bhūmiḥ prajñā",
		// "Sieben Stufenenden bringen Einsicht darin.", "Die Einsicht erreicht man über sieben Stufen.", "", "");
		// sutra = new Sutra("योगाङ्गानुष्ठानादशुद्धिक्षये ज्ञानदीप्तिराविवेकख्यातेः", "yogāṅgānuṣṭhānādaśuddhikṣaye jñānadīptirāvivekakhyāteḥ",
		// "yoga-aṅga-anuṣṭhānāt aśuddhi-kṣaye jñāna-dīptiḥ ā viveka-khyāteḥ",
		// "Durch die Yogagliederausführung erfolgt Unreinheitenverminderung, Wissensglanz bis Unterscheidungsvermögen.",
		// "Durch das Ausführen der einzelnen Yogateile werden Unreinheiten reduziert, Wissen leuchtet auf bis hin zum Unterscheidungsvermögen.", "", "");
		// sutra = new Sutra("यमनियमासनप्राणायामप्रत्याहारधारणाध्यानसमाधयोऽष्टावङ्गानि", "yamaniyamāsanaprāṇāyāmapratyāhāradhāraṇādhyānasamādhayo'ṣṭāvaṅgāni",
		// "yama-niyama-āsana-prāṇāyāma-pratyāhāra-dhāraṇā-dhyāna-samādhayaḥ aṣṭau aṅgāni",
		// "Sittengesetze, Beschränkungen, Sitzen, Atemanhalten, Sinnesrückzug, Konzentration, tiefe Meditation, Bewusstseinszustände sind die acht Teile.",
		// "Sittengesetze, eigene Beschränkungen, Stellungen, Atemübungen, Sinnesrückzug, Konzentration, tiefe Meditation und höhere Bewusstseinszustände bilden
		// die acht Teile des Yoga.",
		// "", "");
		// // 30
		// sutra = new Sutra("अहिंसासत्यास्तेय ब्रह्मचर्यापरिग्रहा यमाः", "ahiṃsāsatyāsteyabrahmacaryāparigrahā yamāḥ",
		// "ahiṃsā-satya-asteya-brahmacarya-aparigrahāḥ yamāḥ",
		// "Nicht-Verletzen, Wahrhaftigkeit, Nicht-Stehlen, Enthaltsamkeit, Besitzlosigkeit sind die Sittengesetze.", "", "", "");
		// sutra = new Sutra("(एते तु) जातिदेशकालसमयानवच्छिन्नाः सार्वभौमा महाव्रतम्", "(ete tu) jātideśakālasamayānavacchinnāḥ sārvabhaumā mahāvratam",
		// "(ete tu) jāti-deśa-kāla-samaya-anavacchinnāḥ sārvabhaumāḥ mahāvratam (ohne Sandhi)",
		// "Sodann sind sie Geburt-, Ort-, Zeit-, Umstandsungestört, auf der ganzen Welt verbreitete Grundpflichten",
		// "Sie sind unabhängig von sozialer Schicht, Ort, Zeit und Umständen. Es sind allgemeingültige Grundpflichten.", "", "");
		// sutra = new Sutra("शौचसंतोषतपःस्वाध्यायेश्वरप्रणिधानानि नियमाः", "śaucasaṃtoṣatapaḥsvādhyāyeśvarapraṇidhānāni ",
		// "śauca-saṃtoṣa-tapaḥ-svādhyāya-iśvara-praṇidhānāni niyamāḥ",
		// "Reinheit, Genügsamkeit, Askese, Studium, Gottesverehrung sind die Beschränkungen.", "",
		// "Die Beschränkungen, die man sich selbst auferlegen muss", "");
		// sutra = new Sutra("वितर्कबाधने प्रतिपक्षभावनम्", "vitarkabādhane pratipakṣabhāvanam", "vitarka-bādhane pratipakṣa-bhāvanam",
		// "Zweifel und Pein, Gegenteilsförderung.", "Bei Zweifel und Pein ist das Gegenteil zu fördern.", "Damit sie überwunden werden.", "");
		// sutra = new Sutra("वितर्का हिंसादयः कृतकारितानुमोदिता लोभक्रोधमोहपूर्वका मृदुमध्य अधिमात्रा दुःखाज्ञानानन्तफला इति प्रतिपक्षभावनम्",
		// "vitarkā hiṃsādayaḥ kṛtakāritānumoditā lobhakrodhamohapūrvakā mṛdumadhyādhimātrā duḥkhājñānānantaphalā iti pratipakṣabhāvanam",
		// "vitarkāḥ hiṃsā-ādayaḥ kṛta-kārita-anumoditā lobha-krodha-moha-pūrvakā mṛdu-madhya-adhimātrā duḥkha-ajñāna-ananta-phalāḥ iti pratipakṣa-bhāvanam",
		// "Zweifel, Leidzufügensbeginn - gemacht, veranlasst, gebilligt - verbunden mit Gier, Zorn, Irrtum - leicht, mittel, stark; Schmerz, Unwissenheit ist
		// endlose Frucht. Deshalb die Gegenteilsförderung.",
		// "Zweifel und Gewalt, egal ob gemacht, veranlasst oder nur gebilligt, ob aus Gier, Zorn oder Irrtum, ob gering, mittel oder stark haben endlosen
		// Schmerz und Unwissenheit zur Folge. Deshalb fördere das Gegenteil.",
		// "", "");
		// sutra = new Sutra("अहिंसाप्रतिष्ठायां तत्सन्निधौ वैरत्यागः", "ahiṃsāpratiṣṭhāyāṃ tatsannidhau vairatyāgaḥ",
		// "ahiṃsā-pratiṣṭhāyām tat-sannidhau vaira-tyāgaḥ", "Im Gewaltlosigkeitszustand, in seiner Gegenwart ist Feindschaftsende.",
		// "Jemand, der in Gewaltlosigkeit lebt, beendet Feindschaften, die in seiner Umgebung stattfinden.", "", "");
		// sutra = new Sutra("सत्यप्रतिष्ठायां क्रियाफलाश्रयत्वम्", "satyapratiṣṭhāyāṃ kriyāphalāśrayatvam", "satya-pratiṣṭhāyām kriyā-phala-āśraya-tvam",
		// "Im Wahrhaftigkeitszustand ist eine Handlung-Frucht-Verbindung",
		// "Im Zustand der Wahrhaftigkeit besteht eine Verbindung zwischen Handlung und Ergebnis.",
		// "Man handelt also nicht verdeckt, sondern Handlung und Ergebnis sind deckungsgleich.", "");
		// sutra = new Sutra("अस्तेयप्रतिष्ठायां सर्वरत्नोपस्थानम्", "asteyapratiṣṭhāyāṃ sarvaratnopasthānam", "asteya-pratiṣṭhāyām sarva-ratna-upasthānam",
		// "Im Nichtstehlenszustand erscheint aller Besitz.", "Wer nicht stiehlt, erhält allen (nötigen) Besitz.", "", "");
		// sutra = new Sutra("ब्रह्मचर्य प्रतिष्ठायां वीर्यलाभः", "brahmacaryapratiṣṭhāyāṃ vīryalābhaḥ", "brahmacarya-pratiṣṭhāyām vīrya-lābhaḥ",
		// "Im Enthaltsamkeitszustand ist Energiegewinn.", "Wer enthaltsam lebt, ist voller Energie.", "", "");
		// sutra = new Sutra("अपरिग्रहस्थैर्ये जन्मकथंतासंबोधः", "aparigrahasthairye janmakathaṃtāsaṃbodhaḥ", "aparigraha-sthairye janma-kathaṃtā-saṃbodhaḥ",
		// "In Besitzlosigkeitsfestigkeit ist Existenz-Wieso-Erkenntnis.", "Bei Besitzlosigkeit erlangt man Lebenserfahrung.", "", "");
		// // 40
		// sutra = new Sutra("शौचात् स्वाङ्गजुगुप्सा परैरसंसर्गः", "śaucātsvāṅgajugupsā parairasaṃsargaḥ", "śaucāt sva-aṅga-jugupsā paraiḥ asaṃsargaḥ",
		// "Durch Reinheit ist eigener Glieder Abscheu (vorhanden) und mit anderen keine Berührung.",
		// "Durch (das Bestreben nach) Reinheit verabscheut man den eigenen Körper und vermeidet Berührungen mit anderen.",
		// "Wer rein sein will, wird am eigenen Körper und an anderen immer etwas unreines entdecken und verabscheuen.", "");
		// sutra = new Sutra("सत्त्वशुद्धिः सौमनस्यैकाग्र्येन्द्रियजयात्मदर्शनयोग्यत्वानि च", "sattvaśuddhiḥ saumanasyaikāgryendriyajayātmadarśanayogyatvāni
		// ca",
		// "sattva-śuddhiḥ saumanasya-ekāgrya-indriya-jaya-ātmadarśana-yogya-tvāni ca",
		// "Wesenskenntnis bringt Frohsinn, Einpünktigkeit, Sinnesorgansbesiegung und Sich-Selbst-Sehenseignung",
		// "Durch Wesenskenntnis wird Frohsinn, Konzentrationsfähigkeit, Beherrschung der Sinne und die Fähigkeit sich selbst zu erkennen erreicht.", "",
		// "");
		// sutra = new Sutra("संतोषादनुत्तमः स्सुखलाभः", "saṃtoṣādanuttamaḥ sukhalābhaḥ", "saṃtoṣāt anuttamaḥ sukha-lābhaḥ",
		// "Durch Genügsamkeit ist der höchste Wohlbefindensgewinn.", "Durch Genügsamkeit erreicht man größtes Wohlbefinden.", "", "");
		// sutra = new Sutra("कायेन्द्रियसिद्धिरशुद्धिक्षयात्तपसः", "kāyendriyasiddhiraśuddhikṣayāttapasaḥ", "kāya-indriya-siddhiḥ aśuddhi-kṣayāt tapasaḥ",
		// "Körper und Sinnesorgankraft durch die Abnahme von Unreinheit (bewirkt) Askese.",
		// "Durch Askese nehmen Unreinheiten ab, der Körper und die Sinnesorgane werden gekräftigt.", "", "");
		// sutra = new Sutra("स्वाध्यायादिष्टदेवतासंप्रयोगः", "svādhyāyādiṣṭadevatāsaṃprayogaḥ", "svādhyāyāt iṣṭadevatā-saṃprayogaḥ",
		// "Durch Studium erfolgt eine Lieblingsgottheitsverbindung.", "Durch Studien verbindet man sich mit seiner Lieblingsgottheit.",
		// "Wenn man die Schriften zur Gottheit studiert.", "");
		// sutra = new Sutra("समाधिसिद्धिरीश्वरप्रणिधानात्", "samādhisiddhirīśvarapraṇidhānāt", "samādhi-siddhiḥ īśvara-praṇidhānāt",
		// "Der Bewusstseinszustandserfolg kommt durch Gottesverehrung.", "Durch Gottesverehrung erreicht man den meditativen Bewusstseinszustand.", "",
		// "");
		// sutra = new Sutra("स्थिरसुखमासनम्", "sthirasukhamāsanam", "sthira-sukham āsanam", "Feste Freude ist der Sitz.",
		// "Die Sitzhaltung ist gleichzeitig fest und angenehm.", "", "");
		// sutra = new Sutra("प्रयत्नशैथिल्यानन्त्यसमापत्तिभ्याम्", "prayatnaśaithilyānantyasamāpattibhyām", "prayatna-śaithilya-anantya-samāpattibhyām",
		// "Durch das Zusammentreffen von Bemühung und Lockerheit wird die Unendlichkeit erreicht.", "", "", "");
		// sutra = new Sutra("ततो द्वंद्वानभिघातः", "tato dvaṃdvānabhighātaḥ", "tataḥ dvaṃdva-anabhighātaḥ", "Dadurch ist ein Gegensatzpaar-Nichtangriff.",
		// "Dadurch überwindet man die Gegensätze.", "Die Gegensätze zwischen fest und locker.", "");
		// sutra = new Sutra("तस्मिन् सति श्वासप्रश्वास्योर्गतिविच्छेदः प्राणायामः", "tasmin sati śvāsapraśvāsyorgativicchedaḥ prāṇāyāmaḥ",
		// "tasmin sati śvāsa-praśvāsyoḥ gati-vicchedaḥ prāṇāyāmaḥ", "Ist das geschehen, des Atems und Einatmes Bewegungsausrottung ist Atemanhalten.",
		// "Danach kommt man über unmerkliches Aus- und Einatmen zur Atemausdehnung.", "", "");
		// // 50
		// sutra = new Sutra("बाह्याभ्यन्तरस्थम्भवृत्तिः देशकालसंख्याभिः परिदृष्टो दीर्घसूक्ष्मः",
		// "bāhyābhyantarasthambhavṛttiḥ deśakālasaṃkhyābhiḥ paridṛṣṭo dīrghasūkṣmaḥ",
		// "bāhya-abhyantara-sthambha-vṛttiḥ deśa-kāla-saṃkhyābhiḥ paridṛṣṭaḥ dīrgha-sūkṣmaḥ",
		// "Äußere, innere und Erstarrungstätigkeit mit Ort, Zeit und Anzahl bringt Sichtbarwerdung von Länge und Feinheit.",
		// "Ausatmen, Einatmen und Atemanhalten mit Kontrolle von Atemheftigkeit, Atmungsdauer und der Anzahl an Wiederholungen verlängert und verfeinert den
		// Atem.",
		// "Ort des Atems ist der Ort bis zu dem der Atem spürbar ist. Dessen Abstand zur Nase kann wie die Zeit gemessen werden und bestimmt die Heftigkeit der
		// Atmung.",
		// "");
		// sutra = new Sutra("बाह्याभ्यन्तरविषयाक्षेपी चतुर्थः", "bāhyābhyantaraviṣayākṣepī caturthaḥ", "bāhya-abhyantara-viṣaya-ākṣepī caturthaḥ",
		// "Außen und Innen als Objekt der Wahrnehmung betreffend, gibt es ein viertes.", "Es gibt noch einen vierten Teil.", "", "");
		// sutra = new Sutra("ततः क्षीयते प्रकाशावरणम्", "tataḥ kṣīyate prakāśāvaraṇam", "tataḥ kṣīyate prakāśa-āvaraṇam",
		// "Dann wird zerstört die Helligkeitsverhüllung.", "Dann wird die Ummantelung des Lichts zerstört.", "", "");
		// sutra = new Sutra("धारणासु च योग्यता मनसः", "dhāraṇāsu ca yogyatā manasaḥ", "dhāraṇāsu ca yogyatā manasaḥ",
		// "Und die Befähigung des Geistes in der Konzentration.", "Und der Geist wird zur Konzentration fähig.", "", "");
		// sutra = new Sutra("स्वविषयासंप्रयोगे चित्त(स्य)स्वरूपानुकार इवेन्द्रियाणां प्रत्याहारः",
		// "svaviṣayāsaṃprayoge citta(sya)svarūpānukāra ivendriyāṇāṃ pratyāhāraḥ",
		// "sva-viṣaya-asaṃprayoge citta(sya)-svarūpa-anukāraḥ iva indriyāṇām pratyāhāraḥ",
		// "Herrscht eine Selbst-Objekt-Nicht-Verbindung, gleicht sich der Geist der wahren Natur an. Es ist gleichsam ein Zurückziehen der Sinne.",
		// "Ist das Selbst nicht mehr mit den Objekten verbunden, so gleicht sich der Geist seiner wahren Natur an, es ist wie ein Zurückziehen der Sinne.",
		// "", "");
		// sutra = new Sutra("ततः परमा वश्यतेन्द्रियाणाम्", "tataḥ paramā vaśyatendriyāṇām", "tataḥ paramā vaśya-tā indriyāṇām",
		// "Daraus (ergibt sich) die höchste Gewalt der Sinne.", "Dann hat man die höchste Meisterschaft über die Sinne erlangt.", "", "");
		// // Ende Kapitel
		// sutra = new Sutra("विभूतिपाद", "vibhūtipāda", "vibhūti-pāda", "Entfaltungskapitel", "Drittes Kapitel: Ergebnisse", "", "");
		// sutra = new Sutra("देशबन्धश्चित्तस्य धारणा", "deśabandhaścittasya dhāraṇā", "deśa-bandhaḥ cittasya dhāraṇā",
		// "Ortsbindung des Geistes ist Konzentration.", "Konzentration ist, wenn der Geist auf ein Thema fixiert ist.", "", "");
		// sutra = new Sutra("तत्र प्रत्ययैकतानता ध्यानम्", "tatra pratyayaikatānatā dhyānam", "tatra pratyaya-eka-tāna-tā dhyānam",
		// "Dort wo Wahrnehmungseinfädigkeit ist, ist tiefe Meditation", "Gibt es nur einen einzigen Gedankenstrom, ist tiefe Meditation erreicht.", "",
		// "");
		// sutra = new Sutra("तद् एवार्थमात्रनिर्भासं स्वरूपशून्यम् इव समाधिः", "tad evārthamātranirbhāsaṃ svarūpaśūnyam iva samādhiḥ",
		// "tad eva-artha-mātra-nirbhāsam svarūpa-śūnyam iva samādhiḥ",
		// "Dies, die wirkliche Objektmaßerscheinung, gleichwie mit Eigennaturleere, ist die Vereinigung.",
		// "Erscheint, wie ohne eigene subjektive Natur, die objektive Form (Maß) des Objekts, ist der Zustand des Samādhi erreicht.",
		// "Man filtert also das eigentliche Objekt nicht mehr durch sein Bewußtsein, sondern vereinigt sich so, dass man das wahre Objekt erkennt.", "");
		// sutra = new Sutra("त्रयम् एकत्र संयमः", "trayam ekatra saṃyamaḥ", "trayam ekatra saṃyamaḥ", "Die drei an einem Ort sind die Bändigung der Sinne.",
		// "Treten diese drei Zustände zusammen auf, sind die Sinne gebändigt.",
		// "Die drei sind Dharana, Dhyana und Samadhi. Die Gedanken müssen also auf ein einziges Objekt ausgerichtet sein, es darf keine Ablenkung herrschen und
		// das wahre (vom eigenen Geist ungefilterte) Objekt muss sichtbar werden.",
		// "");
		// sutra = new Sutra("तज्जयात् प्रज्ञालोकः", "tajjayāt prajñālokaḥ", "tat-jayāt prajñā-ālokaḥ", "Durch den Sieg ist Einsichtslicht.",
		// "Ist dies erreicht, ist Einsicht erlangt.", "", "");
		// sutra = new Sutra("तस्य भूमिषु विनियोगः", "tasya bhūmiṣu viniyogaḥ", "tasya bhūmiṣu viniyogaḥ", "In Stufen ist die dessen Anwendung.",
		// "Seine Anwendung erfolgt stufenweise.", "", "");
		// sutra = new Sutra("त्रयम् अन्तरण्गं पूर्वेभ्यः", "trayam antaraṅgaṃ pūrvebhyaḥ", "trayam antar-aṅgam pūrvebhyaḥ",
		// "Dreifach sind die inneren Glieder verglichen mit den früheren.", "Diese drei bilden die tieferen Glieder, nach den vorausgegangenen.",
		// "Vorausgegangen sind die Stufen von Yama bis Pratyahara.", "");
		// sutra = new Sutra("तद् अपि बहिरङ्गं निर्बीजस्य", "tad api bahiraṅgaṃ nirbījasya", "tad api bahiraṅgam nirbījasya",
		// "Dies selbst ist ein unwesentliches Glied des Samenlosen.", "Sie sind jedoch nur unwesentliche Teile des Nirbīja-Samadhi.", "", "");
		// sutra = new Sutra("व्युत्थाननिरोधसṃस्कारयोर् अभिभवप्रादुर्भावौ निरोधक्षणचित्तान्वयो निरोधपरिणामः",
		// "vyutthānanirodhasaṃskārayor abhibhavaprādurbhāvau nirodhakṣaṇacittānvayo nirodhapariṇāmaḥ",
		// "vyutthāna-nirodha-saṃskārayoḥ abhibhava-prādurbhāvau nirodha-kṣaṇa-citta-anvayaḥ nirodha-pariṇāmaḥ",
		// "Wachsende Kontrolle der Eindrücke, die Verschwinden und Erscheinen, ein Beherrschungaugenblick-Geist-Verbindung ist Beherrschungsentwicklung",
		// "Erst wächst die Kontrolle über das Verschwinden und Erscheinen von Eindrücken. Dann kommen Augenblicke der Beherrschung des Geistes. So entwickelt
		// sich Geisteskontrolle.",
		// "", "");
		// // 10
		// sutra = new Sutra("तस्य प्रशान्तवाहिता संस्कारात्", "tasya praśāntavāhitā saṃskārāt", "tasya praśānta-vāhitā saṃskārāt",
		// "Dessen ruhiger Fluß (kommt) durch Training.", "Durch Training stellt sich ein ruhiger Fluss ein.", "", "");
		// sutra = new Sutra("सर्वार्थतैकाग्रतयोः क्षयोदयौ चित्तस्य समाधिपरिणामः", "sarvārthataikāgratayoḥ kṣayodayau cittasya samādhipariṇāmaḥ",
		// "sarva-artha-ta-ekāgratayoḥ kṣayo-udayau cittasya samādhi-pariṇāmaḥ",
		// "Aller Objekten bzw. Einpünktigkeit , Verminderung bzw. Auftreten des Denkens ist Bewußtseinszustandsentwicklung.",
		// "Verminderung des Denkens an viele Objekte und Erhöhen des zielgerichteten Denkens auf einen Punkt entwickelt das Bewußtsein zum Samadhi.",
		// "Jeweils das erste bzw. zweite Wort der Duale gehört zusammen, also sarva-artha-ta zu kṣaya und ekāgratā zu udaya .", "");
		// sutra = new Sutra("ततः पुनः शान्तोदितौ तुल्यप्रत्ययश् चित्तस्यैकाग्रतापरिणामः", "tataḥ punaḥ śāntoditau tulyapratyayaś cittasyaikāgratāpariṇāmaḥ",
		// "tataḥ punaḥ śānta-uditau tulya-pratyayaḥ cittasya-ekāgratā-pariṇāmaḥ",
		// "An der Stelle wo sich von neuem aufkommende beruhigt haben, gleiche Wahrnehmung ist, ist Entwicklung der Einpünktigkeit der Gedanken.",
		// "Sobald neu aufkommende Gedanken ruhig sind, gleiche Wahrnehmung der Gedanken vorliegt, hat man Einpünktigkeit der Gedanken entwickelt.", "",
		// "");
		// sutra = new Sutra("एतेन भूतेन्द्रियेषु धर्मलक्षणावस्थापरिणामा व्याख्याताः", "etena bhūtendriyeṣu dharmalakṣaṇāvasthāpariṇāmā vyākhyātāḥ",
		// "etena bhūta-indriyeṣu dharma-lakṣaṇa-avasthā-pariṇāmāḥ vyākhyā-tāḥ",
		// "Auf diese Weise sind Natur-, Merkmals- und Zustandsentwicklungen in den Elementen und Sinnesorganen erklärt.",
		// "Dies sind die Erklärungen für Entwicklungen im Wesen, den Merkmalen und Zuständen von Objekten und Sinneswahrnehmungen.", "", "");
		// sutra = new Sutra("शान्तोदिताव्यपदेश्यधर्मानुपाती धर्मी", "śāntoditāvyapadeśyadharmānupātī dharmī", "śānta-udita-avyapadeśya-dharma-anupātī dharmī",
		// "Erloschene, aufgekommene, undefinierbare Natur (eines Objekts) folgend ihrer Art und Weise",
		// "Vergangen, gegenwärtig oder zukünftig, die Natur eines Objekts bleibt gleich.", "", "");
		// sutra = new Sutra("क्रमान्यत्वं परिणामान्यत्वे हेतुः", "kramānyatvaṃ pariṇāmānyatve hetuḥ", "krama-anyatvam pariṇāma-anyatve hetuḥ",
		// "Ein unterschiedlicher Schritt ist für unterschiedliche Umwandlungen die Ursache.",
		// "Aus einer kleinen Veränderung entwickeln sich größere Unterschiede.", "", "");
		// sutra = new Sutra("परिणामत्रयसंयमाद् अतीतानागतज्ञानम्", "pariṇāmatrayasaṃyamād atītānāgatajñānam", "pariṇāma-traya-saṃyamāt atīta-anāgata-jñānam",
		// "Durch Bändigung der drei Umwandlungen entsteht Vergangenheits- und Zukunftswissen.",
		// "Durch die Bändigung der drei Wandlungen (erlöschen[Vergangen], entstanden[gegenwärtig], undefinierbar[zukünftig]) entsteht Wissen über Vergangenheit
		// und Zukunft.",
		// "", "");
		// sutra = new Sutra("शब्दार्थप्रत्ययानाम् इतरेतराध्यासात् संकरस् तत्प्रविभागसंयमात् सर्वभूतरुतज्ञानम्",
		// "śabdārthapratyayānām itaretarādhyāsāt saṃkaras tatpravibhāgasaṃyamāt sarvabhūtarutajñānam",
		// "śabda-artha-pratyayānām itaretara-adhyāsāt saṃkaraḥ tat-pravibhāga-saṃyamāt sarva-bhūta-ruta-jñānam",
		// "Es gibt Vermischung von Klang, Objekt und Wahrnehmung durch gegenseitige Übertragung. Durch Bändigung der Teile ist Wissen aller seienden Töne.",
		// "Klang, Objekt und Wahrnehmung beeinflussen sich gegenseitig und vermischen sich. Durch Bändigung der einzelnen Teile kommt die wahre Erkenntnis
		// aller Töne.",
		// "", "");
		// sutra = new Sutra("संस्कारसाक्षात्करणात् पूर्वजातिज्ञानम्", "saṃskārasākṣātkaraṇāt pūrvajātijñānam", "saṃskāra-sākṣātkaraṇāt pūrvajāti-jñānam",
		// "Durch die Eindrucksschau entsteht Wissen über das frühere Leben.", "Durch die Schau der Eindrücke erkennt man sein früheres Leben.", "", "");
		// sutra = new Sutra("प्रत्ययस्य परचित्तज्ञानम्", "pratyayasya paracittajñānam", "pratyayasya para-citta-jñānam",
		// "(Samyama)der Wahrnehmungen gibt Wissen eines anderen Bewusstseins",
		// "Durch Samyama auf die Wahrnehmungen eines anderen erreicht man Wissen über seinen Geist.", "", "");
		// // 20
		// sutra = new Sutra("न च तत्सालम्बनं तस्याविषयीभूतत्वात्", "na ca tatsālambanaṃ tasyāviṣayībhūtatvāt", "na ca tat-sālambanam tasya-aviṣayībhūta-tvāt",
		// "Auch ist keine (Verbindung zwischen) dieser geistige Übung und der Herrschaft über dessen Gegenstand.",
		// "Es besteht keine Verbindung zwischen der Übung und der Beherrschung des Objekts.", "", "");
		// sutra = new Sutra("कायरूपसंयमात् तद्ग्राह्यशक्तिस्तम्भे चक्षुःप्रकाशासंप्रयोगे ऽन्तर्धानम्",
		// "kāyarūpasaṃyamāt tadgrāhyaśaktistambhe cakṣuḥprakāśāsaṃ(pra)yoge 'ntardhānam",
		// "kāya-rūpa-saṃyamāt tat-grāhya-śakti-stambhe cakṣuḥ-prakāśa-asaṃ(pra)yoge antardhānam",
		// "Durch Leibesformbeherrschung wird die dies begreifende Kraft gehemmt. Die Licht-Auge-Nichtverbindung ist Unsichtbarkeit.",
		// "Durch Beherrschung der Körperform wird die ihn wahrnehmende Kraft gehemmt. Es gibt keine Verbindung zwischen Licht und Auge. Unsichtbarkeit ist
		// erreicht.",
		// "", "");
		// sutra = new Sutra("सोपक्रमं निरुपक्रमं च कर्म तत्संयमाद् अपरान्तज्ञानम् अरिष्टेभ्यो वा",
		// "sopakramaṃ nirupakramaṃ ca karma tatsaṃyamād aparāntajñānam ariṣṭebhyo vā",
		// "sopakramam nirupakramam ca karma tat-saṃyamāt aparānta-jñānam ariṣṭebhyaḥ vā",
		// "Handlung wozu man etwas tut und wozu man nichts tut, durch Bändigung darauf erfolgt Todeswissen oder durch Todessymbole.",
		// "Durch Samyama auf aktive und passive Taten oder durch Todessymbole erhält man Wissen über seinen zukünftigen Tod.", "", "");
		// sutra = new Sutra("मैत्र्यादिषु बलानि", "maitryādiṣu balāni", "maitrī-ādiṣu balāni", "Freundlichkeitsbeginn bringt Kraft",
		// "(Durch Samyama auf) die Ursache von Freudlichkeit wird sie gekräftigt.", "", "");
		// sutra = new Sutra("बलेषु हस्तिबलादीनि", "baleṣu hastibalādīni", "baleṣu hasti-bala-ādīni", "Die Elefantenkraft bei Kraftbeginn",
		// "Große Kraft erreicht man bei Samyama auf die Ursache der Kraft.", "", "");
		// sutra = new Sutra("प्रवृत्त्यालोकन्यासात् सूक्ष्मव्यवहितविप्रकृष्टज्ञानम्", "pravṛttyālokanyāsāt sūkṣmavyavahitaviprakṛṣṭajñānam",
		// "pravṛtti-āloka-nyāsāt sūkṣma-vyavahita-viprakṛṣṭa-jñānam",
		// "Aus Entsagung hervorkommenden Lichts wird Wissen über Feines, Verborgenes, Entferntes.",
		// "Bei Samyama auf den Ursprung von Licht erhält man Wissen über Feines, Verborgenes, Entferntes.", "", "");
		// sutra = new Sutra("भुवनज्ञानं सूर्यसंयमात्", "bhuvanajñānaṃ sūryasaṃyamāt", "bhuvana-jñānam sūrya-saṃyamāt", "Weltwissen durch Sonnensamyama.",
		// "Durch Samyama auf die Sonne erhält man Wissen über die Welt (die Dinge).", "", "");
		// sutra = new Sutra("चन्द्रे ताराव्यूहज्ञानम्", "candre tārāvyūhajñānam", "candre tārā-vyūha-jñānam", "Auf den Mond (gerichtet),
		// Sternverteilungswissen.",
		// "Samyama auf den Mond bringt astrologisches (astronomisches) Wissen.", "", "");
		// sutra = new Sutra("ध्रुवे तद्गतिज्ञानम्", "dhruve tadgatijñānam", "dhruve tad-gati-jñānam", "Auf den Polarstern, Wissen über seinen Weg.",
		// "Samyama auf den Polarstern bring Wissen über die Sternenbewegung.", "", "");
		// sutra = new Sutra("नाभिचक्रे कायव्यूहज्ञानम्", "nābhicakre kāyavyūhajñānam", "nābhicakre kāya-vyūha-jñānam", "Auf den Nabel,
		// Körperverteilungswissen.",
		// "Durch Samyama auf den Nabel erhält man Wissen über den Aufbau des Körpers.", "", "");
		// // 30
		// sutra = new Sutra("कण्ठकूपे क्षुत्पिपासानिवृत्तिः", "kaṇṭhakūpe kṣutpipāsānivṛttiḥ", "kaṇṭha-kūpe kṣut-pipāsā-nivṛttiḥ",
		// "Auf die Kehlgrube, Hunger und Durst verschwinden.", "Durch Samyama auf die Kehlgrube verschwinden Hunger und Durst.", "", "");
		// sutra = new Sutra("कूर्मनाड्यां स्थैर्यम्", "kūrmanāḍyāṃ sthairyam", "kūrma-nāḍyām sthairyam", "Auf den Schildkrötenkanal, Festigkeit",
		// "Samyama auf den Kurma-Nadi (feinstofflicher Rückenmarkskanal im Brustbereich) bringt Festigkeit.", "", "");
		// sutra = new Sutra("मूर्धज्योतिषि सिद्धदर्शनम्", "mūrdhajyotiṣi siddhadarśanam", "mūrdha-jyotiṣi siddha-darśanam", "Auf das Schädellicht,
		// Meistersicht",
		// "Samyama auf das Licht in der Schädeldecke bringt Visionen der bisherigen Meister.", "", "");
		// sutra = new Sutra("प्रातिभाद् वा सर्वम्", "prātibhād vā sarvam", "prātibhāt vā sarvam", "Oder auf das Göttliche, Alles.",
		// "Durch Samyama auf das Göttliche kommt alles Wissen.", "", "");
		// sutra = new Sutra("हृदये चित्तसंवित्", "hṛdaye cittasaṃvit", "hṛdaye citta-saṃvit", "Auf das Herz, Bewußtseinserkenntnis",
		// "Samyama auf das Herz bring Erkenntnis über das eigene Bewußtsein.", "", "");
		// sutra = new Sutra("सत्त्वपुरुषयोर् अत्यन्तासंकीर्णयोः प्रत्ययाविशेषः भोगः परार्थत्वात् स्वार्थसंयमात् पुरुषज्ञानम्",
		// "sattvapuruṣayor atyantāsaṃkīrṇayoḥ pratyayāviśeṣaḥ bhogaḥ parārthatvāt svārthasaṃyamāt puruṣajñānam",
		// "sattva-puruṣayoḥ atyanta-asaṃkīrṇayoḥ pratyaya-aviśeṣaḥ bhogaḥ para-artha-tvāt sva-artha-saṃyamāt puruṣa-jñānam",
		// "Rohfassung: der guten Seelen, der beständig nicht Vermischten (der drei Gunas Sattva, Rajas, Tamas?), deren Ununterschiedenheitswahrnehmung, diese
		// Erfahrung (oder Genuß) als höchstes Ziel, durch Bindung des eigenen Ziels darauf (erhält man) Seelenwissen",
		// "", "", "");
		// sutra = new Sutra("ततः प्रातिभश्रावणवेदनादर्शास्वादवार्त्ता जायन्ते", "tataḥ prātibhaśrāvaṇavedanādarśāsvādavārttā jāyante",
		// "tataḥ prātibha-śrāvaṇa-vedana-ādarśa-āsvāda-vārttā jāyante", "Daraus entsteht göttliches Hören, Fühlen, Sehen, Geschmack und Geruch.", "", "",
		// "");
		// sutra = new Sutra("ते समाधाव् उपसर्गा व्युत्थाने सिद्धयः", "te samādhāv upasargā vyutthāne siddhayaḥ", "te samādhāu upasargā vyutthāne siddhayaḥ",
		// "Diese sind die Vereinigung störende Erscheinungen, es sind wachsende Zauberkräfte.",
		// "Diese wachsenden Kräfte sind störend für das Erreichen des meditativen Bewusstseinszustands.", "", "");
		// sutra = new Sutra("बन्धकारणशैथिल्यात् प्रचारसंवेदनाच् च चित्तस्य परशरीरावेशः", "bandhakāraṇaśaithilyāt pracārasaṃvedanāc ca cittasya
		// paraśarīrāveśaḥ",
		// "bandha-kāraṇa-śaithilyāt pracāra-saṃvedanāt ca cittasya para-śarīra-āveśaḥ",
		// "Durch Lockerung der Bindungsursachen und Bewußtwerdung des Heraustretens des Geistes (kann man) in einen anderen Körper eindringen.",
		// "Durch Lockern der Bindungen des Geistes zum eigenen Körper und Erkennen, wie der Geist den Körper verlassen kann, kann man in einen anderen Körper
		// eindringen.",
		// "", "");
		// sutra = new Sutra("उदानजयाज् जलपङ्ककण्टकादिष्व् असङ्ग उत्क्रान्तिश् च", "udānajayāj jalapaṅkakaṇṭakādiṣv asaṅga utkrāntiś ca",
		// "udāna-jayāt jala-paṅka-kaṇṭakā-ādiṣu asaṅga utkrāntiḥ ca",
		// "Durch Udāna-Besiegung ist ein Nichthängenbleiben und Heraustreten, wo Wasser, Schlamm und Dornen beginnen.",
		// "Beherrscht man das Udana-Prana, haften Wasser, Schlamm und Dornen nicht an einem und man kann aus ihnen unbeschadet wieder herauskommen.", "",
		// "");
		// // 40
		// sutra = new Sutra("समानजयात् प्रज्वलनम् Variante(n): समानजयाज् ज्वलनम्", "samānajayāt prajvalanam Variante(n): samānajayāj jvalanam",
		// "samāna-jayāt prajvalanam Variante(n): samāna-jayāt jvalanam", "Durch Samāna-Besiegung Auflodern.", "", "", "");
		// sutra = new Sutra("श्रोत्राकाशयोः सम्बन्धसंयमाद् दिव्यं श्रोत्रम्", "śrotrākāśayoḥ sambandhasaṃyamād divyaṃ śrotram",
		// "śrotra-ākāśayoḥ sambandha-saṃyamāt divyam śrotram", "Durch Bändigung der Verbindung der beiden Ohrräume (entsteht) himmliches Gehör.", "", "",
		// "");
		// sutra = new Sutra("कायाकाशयोः संबन्धसंयमाल्लघुतूलसमापत्तेश्चाकाशगमनम्", "kāyākāśayoḥ saṃbandhasaṃyamāllaghutūlasamāpatteścākāśagamanam",
		// "kāya-ākāśayoḥ saṃbandha-saṃyamāt-laghu-tūla-samāpatteḥ-ca-ākāśa-gamanam",
		// "Durch Samyama auf die Verbindung der Körperräume und durch Meditation auf leichte Baumwolle, Raumbewegung.", "", "", "");
		// sutra = new Sutra("बहिरकल्पिता वृत्तिर्महाविदेहा ततः प्रकाशावरणक्षयः", "bahirakalpitā vṛttirmahāvidehā tataḥ prakāśāvaraṇakṣayaḥ",
		// "bahiḥ-akalpitā vṛttiḥ-mahā-videhā tataḥ prakāśa-āvaraṇa-kṣayaḥ",
		// "Der von außen, nicht (selbst) gemachte Gedanke, große Körperlosigkeit, dies ist Lichtverhüllungsverlust.",
		// "Erreichen einen von außen kommende, nicht eigene Gedanken, hat man die große Körperlosigkeit erreicht und die Verhüllung des Lichts ist
		// verschwunden.",
		// "", "");
		// sutra = new Sutra("स्थूलस्वरूपसूक्ष्मान्वयार्थवत्त्वसंयमाद्भूतजयः", "sthūlasvarūpasūkṣmānvayārthavattvasaṃyamādbhūtajayaḥ",
		// "sthūla-svarūpa-sūkṣma-anvaya-arthavattva-saṃyamāt-bhūta-jayaḥ",
		// "Durch Samyama auf die Bedeutsamkeit der groben eigene Form, der feinen Verbindungen kommt Elementbesiegung",
		// "Durch Samyama auf die grobstofflichen Dinge und feinen Zusammenhänge beherrscht man die Elemente.", "", "");
		// sutra = new Sutra("ततो ऽणिमादिप्रादुर्भावः कायसंपद् तद्धर्मानभिघातश् च", "tato 'ṇimādiprādurbhāvaḥ kāyasaṃpad taddharmānabhighātaś ca",
		// "tataḥ aṇima-ādi-prādurbhāvaḥ kāya-saṃpad tad-dharma-anabhighātaḥ ca",
		// "Dadurch kommt Feinheitsbeginn zum Vorschein, Körpererfolg und der Nichtangriff dieser Gesetze.", "", "", "");
		// sutra = new Sutra("रूपलावण्यबलवज्रसंहननत्वानि कायसम्पत्", "rūpalāvaṇyabalavajrasaṃhananatvāni kāyasampat",
		// "rūpa-lāvaṇya-bala-vajra-saṃhanana-tvāni kāya-sampat", "Gestaltsschönheit, harte Donnerkeilskraft ist Körpererfolg.", "",
		// "Hier die Erklärung des 'Körpererfolgs' aus dem vorhergehenden Sutra", "");
		// sutra = new Sutra("ग्रहणस्वरूपास्मितान्वयार्थवत्त्वसंयमाद् इन्द्रियजयः", "grahaṇasvarūpāsmitānvayārthavattvasaṃyamād indriyajayaḥ",
		// "grahaṇa-sva-rūpa-asmitā-anvaya-arthavattva-saṃyamāt indriya-jayaḥ",
		// "Durch Samyama auf die Bedeutsamkeit der Verbindung der Wahrnehmung der eigenen Form und des Ich-Bewußtseins (kommt) Sinnesbesiegung",
		// "Durch Samyama auf den Zusammenhang zwischen der Wahrnehmung von sich selbst und dem Ich-Bewußtsein beherrscht man die Sinne.", "", "");
		// sutra = new Sutra("ततो मनोजवित्वं विकरणभावः प्रधानजयश् च", "tato manojavitvaṃ vikaraṇabhāvaḥ pradhānajayaś ca",
		// "tataḥ manojavitvam vikaraṇa-bhāvaḥ pradhāna-jayaḥ ca", "Dadurch Geistesschnelligkeit, veränderte Existenz und Verstandsbesiegung.",
		// "Dadurch erhält man einen flinken Geist, eine geänderte Existenz und beherrscht den Verstand.", "", "");
		// sutra = new Sutra("सत्त्वपुरुषान्यताख्यातिमात्रस्य सर्वभावाधिष्ठातृत्वं सर्वज्ञातृत्वं च",
		// "sattvapuruṣānyatākhyātimātrasya sarvabhāvādhiṣṭhātṛtvaṃ sarvajñātṛtvaṃ ca",
		// "sattva-puruṣa-anyatā-khyāti-mātrasya sarva-bhāva-adhiṣṭhātṛ-tvam sarva-jñātṛ-tvam ca",
		// "Die Erkenntnis des Unterschiedsausmaßes zwischen (reinem) Wesen und Seele bringt Herrschaft über alles Existierende und allen Wissens.", "",
		// "", "");
		// // 50
		// sutra = new Sutra("तद्वैराग्याद् अपि दोषबीजक्षये कैवल्यम्", "tadvairāgyād api doṣabījakṣaye kaivalyam", "tat-vairāgyāt api doṣa-bīja-kṣaye
		// kaivalyam",
		// "Durch Gleichmut diesem gegenüber sogar da wo Sündensamensverminderung, Glückseligkeit.",
		// "Durch Gleichmut diesem gegenüber und wo Sündenquellen verringert sind erreicht man Glückseligkeit.", "", "");
		// sutra = new Sutra("स्थान्युपनिमन्त्रणे सङ्गस्मयाकरणं पुनर् अनिष्टप्रसङ्गात्", "sthānyupanimantraṇe saṅgasmayākaraṇaṃ punar aniṣṭaprasaṅgāt",
		// "sthāni-upanimantraṇe saṅga-smaya-akaraṇam punar aniṣṭa-prasaṅgāt",
		// "Wo das Primitive einlädt, ist es natürlich das Hochmut haften bleibt, von neuem durch die schädliche Neigung.", "", "", "");
		// sutra = new Sutra("क्षणतत्क्रमयोः संयमाद् विवेकजं ज्ञानम्", "kṣaṇatatkramayoḥ saṃyamād vivekajaṃ jñānam",
		// "kṣaṇa-tat-kramayoḥ saṃyamāt viveka-jam jñānam", "Durch Samyama dieser Augenblicksabfolge erreicht man Unterscheidungsgeburt und Wissen", "",
		// "", "");
		// sutra = new Sutra("जातिलक्षणदेशैर् अन्यतानवच्छेदात् तुल्ययोस् ततः प्रतिपत्तिः", "jātilakṣaṇadeśair anyatānavacchedāt tulyayos tataḥ pratipattiḥ",
		// "jāti-lakṣaṇa-deśaiḥ anyatā-anavacchedāt tulyayoḥ tataḥ pratipattiḥ",
		// "Durch Nichtbestimmtsein von Unterschieden aufgrund von Geburt, Merkmal oder Ort von gleichartigen Dingen, daraus (kommt) Einsicht.", "", "",
		// "");
		// sutra = new Sutra("तारकं सर्वविषयं सर्वथाविषयम् अक्रमं चेति विवेकजं ज्ञानम्", "tārakaṃ sarvaviṣayaṃ sarvathāviṣayam akramaṃ ceti vivekajaṃ jñānam",
		// "tārakam sarva-viṣayam sarvathāviṣayam akramam ca-iti viveka-jam jñānam",
		// "Transzendiere alles Wahrnehmbare, auf jegliche Weise wahrnehmbares und verwirrendes, solche Unterscheidungsgeburt ist Wissen.", "", "", "");
		// sutra = new Sutra("सत्त्वपुरुषयोः शुद्धिसाम्ये कैवल्यम्", "sattvapuruṣayoḥ śuddhisāmye kaivalyam", "sattva-puruṣayoḥ śuddhi-sāmye kaivalyam",
		// "Wo Läuterungsgleichheit von Wesen und Seele (herrscht) ist Glückseligkeit.",
		// "Wo durch Läuterung Gleichheit von Wesen und Seele eingetreten ist, ist Glückseligkeit.", "", "");
		// // Ende Kapitel
		// sutra = new Sutra("कैवल्य", "kaivalyapāda", "kaivalya-pāda", "Glückseligkeitskapitel", "Drittes Kapitel: Glückseligkeit", "", "");
		// sutra = new Sutra("जन्मौषधिमन्त्रतपःसमाधिजाः सिद्धयः", "janmauṣadhimantratapaḥsamādhijāḥ siddhayaḥ", "janma-oṣadhi-mantra-tapaḥ-samādhi-jāḥ
		// siddhayaḥ", "Geburt, Pflanzen, Mantras, Askese (bringen) Bewusstseinszustandsgeburt, Zauberkräfte", "Von Geburt aus oder durch Verwendung bestimmter
		// Pflanzen, Mantras und Askese kann man einem veränderten Bewußtseinszustand und besondere Kräfte erhalten.", "", "");
		// sutra = new Sutra("जात्यन्तरपरिणामः प्रकृत्यापूरात्", "jātyantarapariṇāmaḥ prakṛtyāpūrāt", "jāti-antara-pariṇāmaḥ prakṛti-āpūrāt",
		// "Geburtsverschiedene Entwicklung (entsteht) durch Formüberflutung.", "Durch Überfluten seiner Form entwickelt man sich weiter.",
		// "Man füllt seine gegebenen Fähigkeiten aus, geht noch weiter, 'überflutet' und bricht damit den Damm zur nächsten Entwicklungsstufe.",
		// "Das Überfluten wird im folgenden Vers weiter erläutert, daher auch die Übersetzung mit 'fluten' und nicht mit 'füllen'.");
		// sutra = new Sutra("निमित्तमप्रयोजकं प्रकृतीनां वरणभेदस्तु ततः क्षेत्रिकवत्", "nimittamaprayojakaṃ prakṛtīnāṃ varaṇabhedastu tataḥ kṣetrikavat",
		// "nimittam-aprayojakam prakṛtīnām varaṇa-bhedaḥ-tu tataḥ kṣetrika-vat",
		// "Eine nicht hingehörende Bestimmung, der Naturen wallzerbrechende Stärke, wie ein Feldbesitzer.",
		// "Steht etwas im Wege erfährt es die wallzerbrechende Stärke der Natur, wie auch ein Feldbesitzer (wenn seine Bewässerungsdämme überlaufen).",
		// "", "");
		// sutra = new Sutra("निर्माणचित्तान्यस्मितामात्रात्", "nirmāṇacittānyasmitāmātrāt", "nirmāṇa-cittāni-asmitā-mātrāt",
		// "Geistesschaffung durch Ichbewußtseinssausmaß.", "Der Geist wird durch das Ausmaß an Ichbewußtsein geschaffen.", "", "");
		// sutra = new Sutra("प्रवृत्तिभेदे प्रयोजकं चित्तमेकमनेकेषाम्", "pravṛttibhede prayojakaṃ cittamekamanekeṣām",
		// "pravṛtti-bhede prayojakam cittam-ekam-aneke-eṣām",
		// "Wo eine verschiedenen Tätigkeiten sind, der Urheber eines oder mehrerer Gedanken ist dieser.", "", "(Übersetzung überarbeiten)", "");
		// sutra = new Sutra("तत्र ध्यानजमनाशयम्", "tatra dhyānajamanāśayam", "tatra dhyāna-jam an-āśayam", "Dort Meditationsgeborenen, ohne Gedanken.", "", "",
		// "");
		// sutra = new Sutra("कर्माशुक्लाकृष्णं योगिनस्त्रिविधमितरेषाम्", "karmāśuklākṛṣṇaṃ yoginastrividhamitareṣām",
		// "karma-a-śukla-a-kṛṣṇam yoginaḥ-trividham-itareṣām", "Tat des Yogi ist nicht hell, nicht dunkel. (Tat) eines Anderen von drei Arten",
		// "Für einen Yogi sind alle Taten gleich, für andere haben sie eine von drei Qualitäten.", "", "");
		// sutra = new Sutra("ततस्तद्विपाकानुगुणानामेवाभिव्यक्तिर्वासनानाम्", "tatastadvipākānuguṇānāmevābhivyaktirvāsanānām",
		// "tataḥ-tad-vipāka-anuguṇānām-eva-abhivyaktiḥ-vāsanānām", "Daraus die der reifenden Eigenschaften, wirklich die Offenbarwerdung der Neigungen",
		// "Mit der Zeit (der Reifung der Eigenschaften) werden so die eigenen Neigungen offenbar.", "", "");
		// sutra = new Sutra("जातिदेशकालव्यवहितानामप्यानन्तर्यं स्मृतिसṃस्कारयोरेकरूपत्वात्", "jātideśakālavyavahitānāmapyānantaryaṃ
		// smṛtisaṃskārayorekarūpatvāt",
		// "jāti-deśa-kāla-vyavahitānām-api-ānantaryam smṛti-saṃskārayoḥ-eka-rūpa-tvāt",
		// "Der Geburtsrang-, Ort-, Zeitverhüllungen (zum Trotz bleibt) die unmittelbare Folge der Gedächtniseindrücke durch eine Wesenheit.",
		// "Durch die eine Wesenheit hat man eine unmittelbare Folge von Gedächtniseindrücken, sogar bei Rang-, Ort- und Zeitänderungen.", "", "");
		// // 10
		// sutra = new Sutra("तासामनादित्वं चाशिषो नित्यत्वात्", "tāsāmanāditvaṃ cāśiṣo nityatvāt", "tāsām-anādi-tvam ca-āśiṣo nitya-tvāt",
		// "Deren Anfangslosigkeit und durch Wunsch-Ewigkeit.", "Sie sind anfangslos und durch (weitere) Wünsche ewig.", "", "");
		// sutra = new Sutra("हेतुफलाश्रयालम्बनैः संगृहीतत्वादेषामभावे तदभावः", "hetuphalāśrayālambanaiḥ saṃgṛhītatvādeṣāmabhāve tadabhāvaḥ",
		// "hetu-phala-āśraya-ālambanaiḥ saṃgṛhīta-tvāt-eṣām-abhāve tat-abhāvaḥ",
		// "Durch Zusammenhalt mittels Ursache, Frucht, Basis und Unterstützung hat mein einen Wunsch, wo Abwesenheit (des Zusammenhalt ) das ist Abhāva.",
		// "Wünsche werden durch Ursache, Ergebnis, Basis und Unterstützung zusammengehalten. Fehlt dieser spricht man von Abhāva, der Abwesenheit.", "",
		// "");
		// sutra = new Sutra("अतीतानागतं स्वरूपतोऽस्त्यध्वभेदाद्धर्माणाम्", "atītānāgataṃ svarūpato'styadhvabhedāddharmāṇām",
		// "atīta-ānāgatam sva-rūpataḥ-asti-adhva-bhedāt-dharmāṇām",
		// "Vergangenheit, Zukunft , es ist die eigene Form in der Zeitverschiedenheit der Naturen.",
		// "Die eigene Form bleibt konstant in Vergangenheit und Zukunft, auch wenn sie im Lauf der Zeit unterschiedliche Naturen annimmt.", "", "");
		// sutra = new Sutra("ते व्यक्तसूक्ष्मा गुणात्मानः", "te vyaktasūkṣmā guṇātmānaḥ", "te vyakta-sūkṣmā guṇa-ātmānaḥ",
		// "Diese wahrnehmbar (oder) unfassbar sind Guna-Essenz.", "Sie sind die Essenz der Gunas, ob wahrnehmbar oder unfassbar.", "", "");
		// sutra = new Sutra("परिणामैकत्वाद्वस्तुतत्त्वम्", "pariṇāmaikatvādvastutattvam", "pariṇāma-eka-tvāt-vastu-tattvam",
		// "Durch die Einheitsentwicklung die Gegenstandsnatur.", "Durch die Entwicklung zur Einheit erkennt man die wahre Natur eines Gegenstands.", "",
		// "");
		// sutra = new Sutra("वस्तुसाम्ये चित्तभेदात्तयोर्विविक्तः पन्थाः Variante(n): वस्तुसाम्ये चित्तभेदात्तयोर्विभक्तः पन्थाः",
		// "vastusāmye cittabhedāttayorviviktaḥ panthāḥ (Alternativ vibhaktaḥ statt viviktaḥ", "vastu-sāmye citta-bhedāt-tayoḥ-viviktaḥ panthāḥ",
		// "Wo Gegenstandsgleichheit durch Bewußtseinsverschiedenheit deren Unterschiede, die Pfade.",
		// "Durch die unterschiedlichen Bewußtseine werden Unterschiede, Pfade gesehen, obwohl der Gegendstand gleich ist.", "", "");
		// sutra = new Sutra("न चैकचित्ततन्त्रं चेद्वस्तु तदप्रमाणकं तदा किं स्यात्", "na caikacittatantraṃ cedvastu tadapramāṇakaṃ tadā kiṃ syāt",
		// "na ca-eka-citta-tantram ced-vastu tat-apramāṇa-kam tadā kim syāt",
		// "Nicht auch eine (einzige) Geistesgrundlage, auch ein Gegenstand welcher so ohne Maß, was könnte es dann sein?",
		// "Was ist die Natur eines Gegenstands, der unvermessen und von keinem Bewußtsein bewertet ist?", "", "");
		// sutra = new Sutra("तदुपरागापेक्षित्वाच्चित्तस्य वस्तु ज्ञाताज्ञातम्", "taduparāgāpekṣitvāccittasya vastu jñātājñātam",
		// "tat-uparāga-apekṣi-tvāt-cittasya vastu jñāta-ajñātam",
		// "Durch die Verfärbungsberücksichtigung des Bewußtseins ist das Ding bekannt oder unbekannt",
		// "Je nachdem wie stark des Bewußtsein ein Ding wahrnimmt (verfärbt ist), ist es bekannt oder unbekannt.", "", "");
		// sutra = new Sutra("सदाज्ञाताश्चित्तवृत्तयस्तत्प्रभोः पुरुषस्यापरिणामित्वात्", "sadājñātāścittavṛttayastatprabhoḥ puruṣasyāpariṇāmitvāt",
		// "sadā-jñātāḥ-citta-vṛttayaḥ-tat-prabhoḥ puruṣasya-apariṇāmi-tvāt",
		// "Alle Erkenntnis, das (erlangen) die Bewußtseinstätigkeiten durch Beherrschung, die Seele durch Wechsellosigkeit",
		// "Zur Erkenntnis gelangt das Bewußtseins durch Beherrschung, die Seele durch durch Konstanz.", "", "");
		// sutra = new Sutra("न तत्स्वाभासं दृश्यत्वात्", "na tatsvābhāsaṃ dṛśyatvāt", "na tat-sva-ābhāsam dṛśya-tvāt",
		// "Nicht ist dies das eigene Licht, durch Sichtbarkeit.", "Dies geschieht nicht durch das eigene Licht, sondern durch Sichtbarkeit.", "", "");
		// // 20
		// sutra = new Sutra("एकसमये चोभयानवधारणम्", "ekasamaye cobhayānavadhāraṇam", "eka-samaye ca-ubhaya-an-avadhāraṇam",
		// "Wo eines ein Zusammentreffen und beide Nichtbestimmung sind.", "", "", "");
		// sutra = new Sutra("चित्तान्तरदृश्ये बुद्धिबुद्धेरतिप्रसङ्गः स्मृतिसंकरश्च", "cittāntaradṛśye buddhibuddheratiprasaṅgaḥ smṛtisaṃkaraśca",
		// "citta-antara-dṛśye buddhi-buddheḥ-atiprasaṅgaḥ smṛti-saṃkaraḥ-ca",
		// "Ein Bewußtseinsverschiedener Anblick ist Verstand-Verstandsabsurdität und Erinnerungsvermischung",
		// "Ein vom Bewußtsein getrennte Wahrnehmung ist so absurd, wie einen Verstand durch einen anderen Verstand zu definieren und ist eine geistige
		// Verwirrung.",
		// "", "");
		// sutra = new Sutra("चितेरप्रतिसंक्रमायास्तदाकारापत्तौ स्वबुद्धिसंवेदनम्", "citerapratisaṃkramāyāstadākārāpattau svabuddhisaṃvedanam",
		// "citeḥ-aprati-saṃkramāyāḥ-tat-ākāra-āpattau sva-buddhi-saṃvedanam",
		// "Der Wahrnehmung unwiderstehlicher Gang, diese Formumwandlung ist eigene Verstandsempfindung.",
		// "Geht die Wahrnehmung weiter, wandelt sich ihre Form, man nimmt den eigenen Verstand wahr.", "", "");
		// sutra = new Sutra("द्रष्टृदृश्योपरक्तं चित्तं सर्वार्थम्", "draṣṭṛdṛśyoparaktaṃ cittaṃ sarvārtham", "draṣṭṛ-dṛśya-upa-raktam cittam sarva-artham",
		// "Ein Seher der dem Sichtbaren nahe steht (erfährt) Abfärbung. Das Bewußtsein erkennt alle Sachen.",
		// "Steht der Wahrnehmende dem Objekt sehr nahe, erkennt es es genau und das Bewußtsein weiß alle Dinge.", "", "");
		// sutra = new Sutra("तदसंख्येयवासनाभिश्चित्रमपि परार्थं संहत्यकारित्वात्", "tadasaṃkhyeyavāsanābhiścitramapi parārthaṃ saṃhatyakāritvāt",
		// "tat-asaṃkhyeya-vāsanābhiḥ-citram-api para-artham saṃhatya-kāritvāt",
		// "Dies (macht) auch sichtbar die unzählbaren Hüllen und ein weiter hinausgehendes Objekt durch Verbindungsveranlassung",
		// "Da so auch die unzählbaren Hüllen sichtbar werden, erkennt man durch Herstellen von Verbindungen auch komplexere Dinge.", "", "");
		// sutra = new Sutra("विशेषदर्शिन आत्मभावभावनानिवृत्तिः", "viśeṣadarśina ātmabhāvabhāvanānivṛttiḥ", "viśeṣa-darśina ātmabhāva-bhāvanā-nivṛttiḥ",
		// "Unterschiedseinsicht hat Selbstwirkung, das Verschwinden.",
		// "Erkennt man diesen Unterschied, hat es Auswirkung auf das eigene Selbst, es veschwindet.", "", "");
		// sutra = new Sutra("तदा विवेकनिम्नं कैवल्यप्राग्भारं चित्तम्", "tadā vivekanimnaṃ kaivalyaprāgbhāraṃ cittam",
		// "tadā viveka-nimnam kaivalya-prāgbhāram cittam", "Dann hat das Bewußtsein Unterscheidungstiefe, den Glückseeligkeitsgipfel erreicht.", "", "",
		// "");
		// sutra = new Sutra("तच्छिद्रेषु प्रत्ययान्तराणि संस्कारेभ्यः", "tacchidreṣu pratyayāntarāṇi saṃskārebhyaḥ",
		// "tat-chidreṣu pratyaya-antarāṇi saṃskārebhyaḥ", "Da sind Schwächen,wo Wahrnehmungsverschiedenheit durch Eindrücke",
		// "Schwächen darin sind noch da, wo durch vergangene Eindrücke fehlerhafte Wahrnehmungen sind.", "", "");
		// sutra = new Sutra("हानमेषां क्लेशवदुक्तम्", "hānameṣāṃ kleśavaduktam", "hānam-eṣāṃ kleśa-vat-uktam", "Deren Befreiung wie bei den kleśa gesagt.",
		// "Wie man davon frei wird, wurde bereits bei den Kleśa gesagt.", "", "");
		// sutra = new Sutra("प्रसंख्यानेऽप्यकुसीदस्य सर्वथा विवेकख्यातेर्धर्ममेघः समाधिः",
		// "prasaṃkhyāne'pyakusīdasya sarvathā vivekakhyāterdharmameghaḥ samādhiḥ",
		// "prasaṃkhyāne api-akusīdasya sarvathā viveka-khyāteḥ-dharma-meghaḥ samādhiḥ",
		// "Nachdenken sogar, (ist man) vollständig ohne Interesse (dann) Unterscheidungseinsicht, Dharmawolke, Samadhi.",
		// "Ist auch bei der Meditation kein Eigeninteresse mehr vorhanden, kommt Unterscheidungskraft, man erreicht die Dharmawolke und ist im Samadhi.",
		// "", "");
		// // 30
		// sutra = new Sutra("ततः क्लेशकर्मनिवृत्तिः", "tataḥ kleśakarmanivṛttiḥ", "tataḥ kleśa-karma-nivṛttiḥ", "Daraus Leid-, Handlungsverschwinden.",
		// "Dann verschwinden Leid und karmische Handlungen.", "", "");
		// sutra = new Sutra("तदा सर्वावरणमलापेतस्य ज्ञानस्यानन्त्याज्ज्ञेयम् अल्पम्", "tadā sarvāvaraṇamalāpetasya jñānasyānantyājjñeyam alpam",
		// "tadā sarva-āvaraṇa-mala-apetasya jñānasya-ānantyāt-jñeyam alpam",
		// "Dann von allen Verhüllungen und Schmutz befreiheit, (sieht man) durch Wissensendlosigkeit die geringe Erforschbarkeit.",
		// "Ist man von allen Illusionen befreit, erkennt man die geringe Erforschbarkeit, da das Wissen unendlich groß ist.", "", "");
		// sutra = new Sutra("ततः कृतार्थानां परिणामक्रमसमाप्तिर्गुणानाम्", "tataḥ kṛtārthānāṃ pariṇāmakramasamāptirguṇānām",
		// "tataḥ kṛtārthānām pariṇāma-krama-samāptiḥ-guṇānām", "Diese Zielerreichung, Entwicklungsschrittende der Grundeigenschaften.",
		// "Ist dieses, das Ziel erreicht, ist man am Ende der Entwicklungschritte der Eigenschaften.", "", "");
		// sutra = new Sutra("क्षणप्रतियोगी परिणामापरान्तनिर्ग्राह्यः क्रमः", "kṣaṇapratiyogī pariṇāmāparāntanirgrāhyaḥ kramaḥ",
		// "kṣaṇa-pratiyogī pariṇāma-aparānta-nirgrāhyaḥ kramaḥ", "In Beziehung stehende Momente, Todesentwicklungserkenntnis, Abfolge.",
		// "Dann erkennt man wie einzelne Momente in Beziehung zueinander stehen, die Entwicklung zum Tod, denn Ablauf der Dinge.", "", "");
		// sutra = new Sutra("पुरुषार्थशून्यानां गुणानां प्रतिप्रसवः कैवल्यं स्वरूपप्रतिष्ठा वा चितिशक्तिरिति",
		// "puruṣārthaśūnyānāṃ guṇānāṃ pratiprasavaḥ kaivalyaṃ svarūpapratiṣṭhā vā citiśaktiriti",
		// "puruṣārtha-śūnyānām guṇānām pratiprasavaḥ kaivalyam svarūpa-pratiṣṭhā vā citi-śaktiḥ-iti",
		// "Die Aufhebung der Seelenleere, der Grundeigenschaften ist der Zustand höchster Glückseligkeit oder der Ruhezustand der eigenen Natur. So ist die
		// Geisteskraft.",
		// "", "", "");
		//

		// ENDE


	}

}
