package net.sf.gluebooster.demos.pojo.learning;

/**
 * Description of an excercise.
 * 
 * @author cbauer
 *
 */
public class Excercise implements Cloneable {

	/**
	 * The name of this excercise.
	 */
	private String name;
	/**
	 * The theme (type) of the excercise
	 */
	private String theme;

	private boolean optional = false;

	public Excercise() {

	}

	/**
	 * Constructor from another excercise.
	 * 
	 * @param template
	 *            the original
	 */
	public Excercise(Excercise template) {
		setName(template.getName());
		setTheme(template.getTheme());
	}

	public Excercise(String name) {
		setName(name);
	}

	/**
	 * Constructor with name and type.
	 * 
	 * @param type
	 *            the type of the excercise
	 */
	public Excercise(String name, String type) {
		this(name);
		setTheme(type);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public String toString() {
		return name;
	}

	/**
	 * Adds the string representation to a builder.
	 * 
	 * @param text
	 *            the string representation will be added here.
	 * @param indentation
	 *            indentation of text
	 */
	protected void toString(StringBuilder text, String indentation) {
		text.append(indentation).append(name);
	}

	public String getTheme() {
		return theme;
	}

	public void setTheme(String type) {
		this.theme = type;
	}

	/**
	 * Default Implementation. Must be overwritten when necessary.
	 * 
	 * @param configuration
	 *            the configuration of the excercise
	 * @return the created excercise
	 */
	public Excercise createInstance(ExcerciseGroupConfiguration configuration) {
		return new Excercise(this);
	}

	public boolean isOptional() {
		return optional;
	}

	public void setOptional(boolean optional) {
		this.optional = optional;
	}

}
