package net.sf.gluebooster.demos.pojo.learning;

import java.util.ArrayList;
import java.util.List;

/**
 * A group of excercises.
 * 
 * @author CBauer
 *
 */
public class ExcerciseGroup extends Excercise {

	/**
	 * The excercises.
	 */
	private List<Excercise> excercises;

	public ExcerciseGroup() {

	}

	/**
	 * Constructor with name.
	 * 
	 * @param name
	 *            the name of this group.
	 */
	public ExcerciseGroup(String name) {
		super(name);
	}

	/**
	 * Constructor with name and type .
	 * 
	 * @param name
	 *            the name of this group.
	 * @param type
	 *            the type of this group.
	 */
	public ExcerciseGroup(String name, String type) {
		super(name, type);
	}

	public List<Excercise> getExcercises() {
		return excercises;
	}

	public void setExcercises(List<Excercise> excercises) {
		this.excercises = excercises;
	}

	/**
	 * Adds a new excercise to this group.
	 * 
	 * @param excercise
	 *            the new excercise
	 */
	public void addExcercise(Excercise excercise) {
		if (excercises == null)
			excercises = new ArrayList<Excercise>();

		excercises.add(excercise);
	}

	@Override
	protected void toString(StringBuilder text, String indentation) {
		if (indentation == null)
			indentation = "";

		text.append(indentation).append(getName());
		if (excercises != null) {
			for (Excercise excercise : excercises) {
				text.append("\n");
				excercise.toString(text, indentation + "  ");
			}
		}
	}

	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		toString(result, "");
		return result.toString();
	}

	@Override
	public Excercise createInstance(
			ExcerciseGroupConfiguration configuration) {
		ExcerciseGroup result = new ExcerciseGroup(getName());
		if (excercises != null && ! excercises.isEmpty()){
			if (excercises.size() == 1){
				// if only 1 excercise, then do it
				result.addExcercise(excercises.get(0).createInstance(
						configuration));
			} else {

				for (Excercise excercise : excercises) {
					result.addExcercise(excercise.createInstance(configuration));

				}
				// TODO handle optional parts, interdependened (duration)
				// System.out.println(
				// "could not handle multiple excercises yet");
			}

		}
		// Excercise dummy = new Excercise(
		// "ExcerciseGroup.createInstance needs more implementation");
		// result.addExcercise(dummy);
		return result;
	}
}
